/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.party.MemOrgBillInfo;
import com.kingdee.eas.hr.party.client.AbstractMemberCollectFilterUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.MemOrgPromptBox;
import com.kingdee.eas.hr.party.client.util.PartyPermissionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class MemberCollectFilterUI
extends AbstractMemberCollectFilterUI {
    private static final String RES = "com.kingdee.eas.hr.party.PartyResource";

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtmemOrg.getValue() != null) {
            MemOrgBillInfo memOrg = (MemOrgBillInfo)this.prmtmemOrg.getValue();
            cp.addCustomerParam("memOrgId", memOrg.getId().toString());
        }
        cp.putBoolean("showCancel", this.cbxShowCancel.isSelected());
        cp.putDate("beginDate", (Date)this.dpkBeginDate.getValue());
        cp.putDate("endDate", (Date)this.dpkEndDate.getValue());
        return cp;
    }

    public void clear() {
        super.clear();
        this.prmtmemOrg.setValue(null);
        this.cbxShowCancel.setSelected(false);
        Calendar beginDate = Calendar.getInstance();
        beginDate.set(2, 0);
        beginDate.set(5, 1);
        this.dpkBeginDate.setValue((Object)beginDate.getTime());
        Calendar endDate = Calendar.getInstance();
        endDate.set(2, 11);
        endDate.set(5, 31);
        this.dpkEndDate.setValue((Object)endDate.getTime());
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (this.prmtmemOrg.getValue() != null) {
            MemOrgBillInfo memOrg = (MemOrgBillInfo)this.prmtmemOrg.getValue();
            cp.addCustomerParam("memOrgId", memOrg.getId().toString());
        }
        this.cbxShowCancel.setSelected(cp.getBoolean("showCancel"));
        this.dpkBeginDate.setValue((Object)cp.getDate("beginDate"));
        this.dpkEndDate.setValue((Object)cp.getDate("endDate"));
    }

    public boolean verify() {
        if (this.prmtmemOrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"memOrgNotNull"));
            return false;
        }
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.dpkBeginDate);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.dpkEndDate);
        if (this.dpkBeginDate.getValue() != null && this.dpkEndDate.getValue() != null) {
            Date beginDate = DateTimeUtils.truncateDate((Date)((Date)this.dpkBeginDate.getValue()));
            Date endDate = DateTimeUtils.truncateDate((Date)((Date)this.dpkEndDate.getValue()));
            if (endDate.before(beginDate)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"StartDateBeforeEndDate"));
                SysUtil.abort();
            }
        }
        return true;
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        AdminByOrgRangePromptBox adminOrgF7 = new AdminByOrgRangePromptBox();
        this.prmtAdminOrg.setEditFormat("$number$");
        this.prmtAdminOrg.setDisplayFormat("$name$");
        this.prmtAdminOrg.setCommitFormat("$number$");
        this.prmtAdminOrg.setSelector((KDPromptSelector)adminOrgF7);
        this.prmtAdminOrg.setEditable(false);
        MemOrgPromptBox memOrgF7 = new MemOrgPromptBox();
        memOrgF7.setIsUsePermission(true);
        memOrgF7.setIsSingleSelected(true);
        this.prmtmemOrg.setSelector((KDPromptSelector)memOrgF7);
        this.prmtmemOrg.setEditable(false);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        MemOrgBillInfo memOrg = null;
        if (this.prmtmemOrg.getValue() != null) {
            memOrg = (MemOrgBillInfo)this.prmtmemOrg.getValue();
            this.filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.number", (Object)memOrg.getNumber(), CompareType.EQUALS));
            this.filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.longNumber", (Object)(memOrg.getLongNumber() + "!%"), CompareType.LIKE));
            this.filterInfo.setMaskString("#0 or #1");
            try {
                this.filterInfo.getFilterItems().add(PartyPermissionUtil.getPermissionFilter(1, "memOrg").getFilterItems().get(0));
                this.filterInfo.setMaskString("(#0 or #1) and #2");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (!this.cbxShowCancel.isSelected()) {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.iscancel", (Object)Boolean.FALSE, CompareType.EQUALS));
                this.filterInfo.setMaskString("(#0 or #1) and #2 and #3");
            }
        }
        return filter;
    }

    public HashMap getStatusMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.prmtmemOrg.getValue() != null) {
            MemOrgBillInfo memOrg = (MemOrgBillInfo)this.prmtmemOrg.getValue();
            map.put("memOrgId", memOrg.getId().toString());
            map.put("number", memOrg.getNumber());
            map.put("longNumber", memOrg.getLongNumber());
        }
        map.put("showCancel", new Boolean(this.cbxShowCancel.isSelected()));
        map.put("beginDate", this.dpkBeginDate.getValue());
        map.put("endDate", this.dpkEndDate.getValue());
        return map;
    }
}

