/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.party.MemOrgBillFactory;
import com.kingdee.eas.hr.party.MemOrgBillInfo;
import com.kingdee.eas.hr.party.client.AbstractMemberDetailFilterUI;
import com.kingdee.eas.hr.party.client.HRPartyGroupReportUtil;
import com.kingdee.eas.hr.party.client.MemOrgPromptBox;
import com.kingdee.eas.hr.party.client.util.PartyPermissionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MemberDetailFilterUI
extends AbstractMemberDetailFilterUI {
    public static final String NOTVIEW = "notView";
    public static final String VIEWNLEVEL = "viewNlevel";
    public static final String VIEWALL = "viewAll";
    private static final String resClassName = "com.kingdee.eas.hr.party.PartyResource";
    private int levelLimited = -1;

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        AdminByOrgRangePromptBox adminOrgF7 = new AdminByOrgRangePromptBox();
        this.prmtAdminOrg.setEditFormat("$number$");
        this.prmtAdminOrg.setDisplayFormat("$name$");
        this.prmtAdminOrg.setCommitFormat("$number$");
        this.prmtAdminOrg.setSelector((KDPromptSelector)adminOrgF7);
        this.prmtAdminOrg.setEditable(false);
        MemOrgPromptBox memOrgF7 = new MemOrgPromptBox();
        memOrgF7.setIsUsePermission(true);
        memOrgF7.setIsUsePermission(true);
        this.prmtmemOrg.setSelector((KDPromptSelector)memOrgF7);
        this.prmtmemOrg.setEditable(false);
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.cbIsSealUp.setEnabled(true);
    }

    protected void prmtAdminOrg_dataChanged(DataChangeEvent e) throws Exception {
        if (this.btViewNLevelAdmin.isSelected()) {
            this.resetLevel();
            this.levelLimited = HRPartyGroupReportUtil.getAdminChildMaxLevel((AdminOrgUnitInfo)this.prmtAdminOrg.getValue());
            this.setCBox();
        }
    }

    protected void btNoViewLowerAdmin_actionPerformed(ActionEvent e) throws Exception {
        this.resetLevel();
    }

    protected void btViewNLevelAdmin_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtAdminOrg.getValue() != null) {
            this.resetLevel();
            this.levelLimited = HRPartyGroupReportUtil.getAdminChildMaxLevel((AdminOrgUnitInfo)this.prmtAdminOrg.getValue());
            this.setCBox();
        }
    }

    private void setCBox() {
        if (this.levelLimited != -1) {
            for (int i = 0; i < this.levelLimited; ++i) {
                this.cbLevel.addItem((Object)new Integer(i + 1));
            }
            this.cbLevel.setSelectedIndex(0);
        }
    }

    protected void btViewAllLowerAdmin_actionPerformed(ActionEvent e) throws Exception {
        this.resetLevel();
    }

    private void resetLevel() {
        if (this.cbLevel.getItemCount() != 0) {
            this.cbLevel.removeAllItems();
        }
        this.levelLimited = -1;
    }

    private void initAllEditor() {
        this.kDButtonGroup1.add((AbstractButton)this.btNoViewLowerAdmin);
        this.kDButtonGroup1.add((AbstractButton)this.btViewNLevelAdmin);
        this.kDButtonGroup1.add((AbstractButton)this.btViewAllLowerAdmin);
        this.btNoViewLowerAdmin.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent e) {
                try {
                    MemberDetailFilterUI.this.setSelect(MemberDetailFilterUI.NOTVIEW);
                }
                catch (Exception exc) {
                    MemberDetailFilterUI.this.handUIException(exc);
                }
            }
        });
        this.btViewNLevelAdmin.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent e) {
                try {
                    MemberDetailFilterUI.this.setSelect(MemberDetailFilterUI.VIEWNLEVEL);
                }
                catch (Exception exc) {
                    MemberDetailFilterUI.this.handUIException(exc);
                }
            }
        });
        this.btViewAllLowerAdmin.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent e) {
                try {
                    MemberDetailFilterUI.this.setSelect(MemberDetailFilterUI.VIEWALL);
                }
                catch (Exception exc) {
                    MemberDetailFilterUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void setSelect(String selectType) {
        if (selectType.equals(NOTVIEW) && this.btNoViewLowerAdmin.isSelected()) {
            this.cbIsSealUp.setEnabled(false);
            this.cbIsSealUp.setSelected(false);
            this.cbLevel.setEnabled(false);
            this.cbLevel.setSelectedItem(null);
        } else if (selectType.equals(VIEWNLEVEL) && this.btViewNLevelAdmin.isSelected()) {
            this.cbIsSealUp.setEnabled(true);
            this.cbIsSealUp.setSelected(false);
            this.cbLevel.setEnabled(true);
        } else if (selectType.equals(VIEWALL) && this.btViewAllLowerAdmin.isSelected()) {
            this.cbIsSealUp.setEnabled(true);
            this.cbIsSealUp.setSelected(false);
            this.cbLevel.setEnabled(false);
            this.cbLevel.setSelectedItem(null);
        }
    }

    public void clear() {
        super.clear();
        this.cbIsSealUp.setEnabled(true);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        MemOrgBillInfo memOrg = null;
        if (this.prmtmemOrg.getValue() != null) {
            memOrg = (MemOrgBillInfo)this.prmtmemOrg.getValue();
            filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.number", (Object)memOrg.getNumber(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.longNumber", (Object)(memOrg.getLongNumber() + "!%"), CompareType.LIKE));
            filterInfo.setMaskString("#0 or #1");
            try {
                filterInfo.getFilterItems().add(PartyPermissionUtil.getPermissionFilter(1, "memOrg").getFilterItems().get(0));
                filterInfo.setMaskString("(#0 or #1) and #2");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (!this.cbIsSealUp.isSelected()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.isCancel", (Object)Boolean.FALSE, CompareType.EQUALS));
                filterInfo.setMaskString("(#0 or #1) and #2 and #3)");
            }
        }
        return filterInfo;
    }

    public boolean verify() {
        if (this.prmtmemOrg.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"memOrgNotNull"));
            return false;
        }
        return true;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtmemOrg.getValue() != null) {
            MemOrgBillInfo memOrg = (MemOrgBillInfo)this.prmtmemOrg.getValue();
            cp.addCustomerParam("memOrgId", memOrg.getId().toString());
        }
        cp.putBoolean("isSealedUp", this.cbIsSealUp.isSelected());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp.getCustomerParam("memOrgId") != null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("memOrgId")));
            try {
                this.prmtmemOrg.setValue((Object)MemOrgBillFactory.getRemoteInstance().getMemOrgBillInfo((IObjectPK)pk));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        this.cbIsSealUp.setSelected(cp.getBoolean("isSealedUp"));
    }

    private void mergeUserOrgRangeFilter(FilterInfo filter) {
        if (filter != null) {
            FilterInfo orgRangeFilter = new FilterInfo();
            orgRangeFilter.getFilterItems().add(new FilterItemInfo("orgRange.type", (Object)new Integer(20), CompareType.EQUALS));
            orgRangeFilter.getFilterItems().add(new FilterItemInfo("orgRange.user.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), CompareType.EQUALS));
            try {
                filter.mergeFilter(orgRangeFilter, "and");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }
}

