/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.party.MemOrgBillFactory;
import com.kingdee.eas.hr.party.MemOrgBillInfo;
import com.kingdee.eas.hr.party.client.AbstractMemberFeeStatFilterUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.MemOrgPromptBox;
import com.kingdee.eas.hr.party.client.util.PartyPermissionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class MemberFeeStatFilterUI
extends AbstractMemberFeeStatFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(MemberFeeStatFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.party.PartyResource";

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
    }

    public void clear() {
        super.clear();
        this.prmtmemOrg.setValue(null);
        this.cbxShowCancel.setSelected(false);
        Calendar beginDate = Calendar.getInstance();
        beginDate.set(2, 0);
        beginDate.set(5, 1);
        this.dpkBeginDate.setValue((Object)beginDate.getTime());
        Calendar endDate = Calendar.getInstance();
        endDate.set(2, 11);
        endDate.set(5, 31);
        this.dpkEndDate.setValue((Object)endDate.getTime());
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtmemOrg.getValue() != null) {
            cp.addCustomerParam("memOrgId", ((MemOrgBillInfo)this.prmtmemOrg.getValue()).getId().toString());
        }
        cp.putBoolean("showCancel", this.cbxShowCancel.isSelected());
        cp.putDate("beginDate", (Date)this.dpkBeginDate.getValue());
        cp.putDate("endDate", (Date)this.dpkEndDate.getValue());
        return cp;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("memOrg.longNumber", (Object)(((MemOrgBillInfo)this.prmtmemOrg.getValue()).getLongNumber() + "%"), CompareType.LIKE));
        try {
            if (PartyPermissionUtil.getPermissionFilter(1, "memOrg") != null) {
                this.filterInfo.getFilterItems().add(PartyPermissionUtil.getPermissionFilter(1, "memOrg").getFilterItems().get(0));
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (!this.cbxShowCancel.isSelected()) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("memOrg.isCancel", (Object)Boolean.FALSE, CompareType.EQUALS));
        }
        return filter;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp.getCustomerParam("memOrgId") != null) {
            String memOrgId = cp.getCustomerParam("memOrgId");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)memOrgId));
            MemOrgBillInfo memOrg = null;
            try {
                memOrg = MemOrgBillFactory.getRemoteInstance().getMemOrgBillInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtAdminOrg.setValue((Object)memOrg);
        }
        this.cbxShowCancel.setSelected(cp.getBoolean("showCancel"));
        this.dpkBeginDate.setValue((Object)cp.getDate("beginDate"));
        this.dpkEndDate.setValue((Object)cp.getDate("endDate"));
    }

    public boolean verify() {
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.prmtmemOrg);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.dpkBeginDate);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.dpkEndDate);
        if (this.dpkBeginDate.getValue() != null && this.dpkEndDate.getValue() != null) {
            Date beginDate = DateTimeUtils.truncateDate((Date)((Date)this.dpkBeginDate.getValue()));
            Date endDate = DateTimeUtils.truncateDate((Date)((Date)this.dpkEndDate.getValue()));
            if (endDate.before(beginDate)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"StartDateBeforeEndDate"));
                SysUtil.abort();
            }
        }
        return true;
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        this.prmtAdminOrg.setSelector((KDPromptSelector)new AdminByOrgRangePromptBox());
        this.prmtAdminOrg.setEditable(false);
        MemOrgPromptBox memOrgF7 = new MemOrgPromptBox();
        memOrgF7.setIsSingleSelected(true);
        memOrgF7.setIsUsePermission(true);
        this.prmtmemOrg.setSelector((KDPromptSelector)memOrgF7);
        this.prmtmemOrg.setEditable(false);
    }

    public HashMap getStatusMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memOrgId", ((MemOrgBillInfo)this.prmtmemOrg.getValue()).getId().toString());
        map.put("number", ((MemOrgBillInfo)this.prmtmemOrg.getValue()).getNumber());
        map.put("longNumber", ((MemOrgBillInfo)this.prmtmemOrg.getValue()).getLongNumber());
        map.put("showCancel", new Boolean(this.cbxShowCancel.isSelected()));
        map.put("beginDate", this.dpkBeginDate.getValue());
        map.put("endDate", this.dpkEndDate.getValue());
        return map;
    }
}

