/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.party.MemberInforCollection;
import com.kingdee.eas.hr.party.MemberInforFactory;
import com.kingdee.eas.hr.party.MemberInforInfo;
import com.kingdee.eas.hr.party.PartyFeeModeEnum;
import com.kingdee.eas.hr.party.PartyJobInfo;
import com.kingdee.eas.hr.party.PartyPayPerInfo;
import com.kingdee.eas.hr.party.client.AbstractMemberInforEditUI;
import com.kingdee.eas.hr.party.client.MemOrgPromptBox;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class MemberInforEditUI
extends AbstractMemberInforEditUI {
    protected MemOrgPromptBox memOrgF7 = null;
    private String RESCLASS = "com.kingdee.eas.hr.party.PartyResource";
    private EmployeeTreeEditUI treeEditUI = null;

    public MemberInforEditUI() throws Exception {
        this.initMemOrgF7();
    }

    protected void initMemOrgF7() {
        if (this.memOrgF7 == null) {
            this.memOrgF7 = new MemOrgPromptBox();
            this.memOrgF7.setIsSingleSelected(true);
            this.memOrgF7.setIsUsePermission(false);
        }
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.treeEditUI = (EmployeeTreeEditUI)this.getUIContext().get("GroupListEditUI");
        this.prmtOutMemberType.setMaxLength(80);
        this.txtOutMemberAge.setPrecision(2);
        this.txtOutMemberAge.setMaximumValue((Comparable)new BigDecimal(999.99));
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.actionAttachment.setVisible(true);
        this.actionAttachment.setEnabled(true);
        this.btnAttachment.setVisible(true);
        this.MenuItemAttachment.setVisible(true);
        this.txtmemjob.setEnabled(false);
        this.txtPayPer.setFocusable(false);
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        String recordId = null;
        if (this.getUIContext().get("CUR_OBJ_ID") != null) {
            recordId = this.getUIContext().get("CUR_OBJ_ID").toString();
        }
        if (recordId != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)recordId));
            view.put("selector", (Object)this.getMergedSelector());
            view.setFilter(filter);
            MemberInforCollection pcmCol = MemberInforFactory.getRemoteInstance().getMemberInforCollection(view);
            this.editData = pcmCol.size() <= 0 ? (MemberInforInfo)this.createNewData() : pcmCol.get(0);
            this.setDataObject((IObjectValue)this.editData);
            this.editData.copyNewToOld();
        }
        return this.editData;
    }

    public void loadFields() {
        this.prmtMemOrg.setSelector((KDPromptSelector)this.memOrgF7);
        this.prmtMemOrg.setEditable(false);
        this.prmtPayPer.setEditable(false);
        this.prmtPayPer.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                MemberInforEditUI.this.prmtPayPer_dataChanged();
            }
        });
        this.btnAttachment.setVisible(true);
        this.MenuItemAttachment.setVisible(true);
        try {
            this.getValue(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
    }

    public void prmtPayPer_dataChanged() {
        PartyPayPerInfo PayperInfo = (PartyPayPerInfo)this.prmtPayPer.getData();
        if (PayperInfo != null) {
            String payPer;
            String partyPayPerName = PayperInfo.getName();
            PartyFeeModeEnum feeMode = PayperInfo.getPartyfeemode();
            String partyFeeMode = feeMode.toString();
            if (feeMode.equals((Object)PartyFeeModeEnum.RATION)) {
                BigDecimal decPayPer = PayperInfo.getPayper();
                DecimalFormat format = new DecimalFormat("0.00");
                payPer = format.format(decPayPer);
            } else {
                BigDecimal decPayPer = PayperInfo.getPayper();
                DecimalFormat format = new DecimalFormat("0.00%");
                payPer = format.format(decPayPer);
            }
            partyPayPerName = partyPayPerName + "," + partyFeeMode + "," + payPer;
            this.txtPayPer.setText(partyPayPerName);
        } else {
            this.txtPayPer.setText(null);
        }
    }

    protected IObjectValue createNewData() {
        MemberInforInfo info = new MemberInforInfo();
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.getUIContext().get("CUR_OBJ_ID").toString()));
        pInfo.setName(this.treeEditUI.personName);
        pInfo.setNumber(this.treeEditUI.personNumber);
        info.setPerson(pInfo);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MemberInforFactory.getRemoteInstance();
    }

    protected void prmtmemJob_dataChanged(DataChangeEvent e) throws Exception {
        String memJobDisplay = null;
        memJobDisplay = this.prmtmemJob.getValue() != null ? ((PartyJobInfo)this.prmtmemJob.getValue()).getName() : this.txtDuty.getText();
        this.txtmemjob.setText(memJobDisplay);
        super.prmtmemJob_dataChanged(e);
    }
}

