/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.hr.party.IParterAgent;
import com.kingdee.eas.hr.party.ParterAgentCollection;
import com.kingdee.eas.hr.party.ParterAgentFactory;
import com.kingdee.eas.hr.party.ParterAgentInfo;
import com.kingdee.eas.hr.party.PartyCommonException;
import com.kingdee.eas.hr.party.PartyOrgInfo;
import com.kingdee.eas.hr.party.client.AbstractParterAgentInfoUI;
import com.kingdee.eas.hr.party.client.IPartyOrgEditUI;
import com.kingdee.eas.hr.party.client.PartyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ParterAgentInfoUI
extends AbstractParterAgentInfoUI
implements IPartyOrgEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ParterAgentInfoUI.class);
    private String curPartyOrgId = null;
    private ArrayList delPaIds = new ArrayList();
    private ParterAgentCollection oldPaCol = null;
    private ParterAgentCollection newPaCol = null;
    private IParterAgent iPa = ParterAgentFactory.getRemoteInstance();
    protected KDTSortManager sm = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setTableCellEditor();
        if (!this.getOprtState().equals("ADDNEW")) {
            this.loadParterAgentInfo();
        }
        this.oldPaCol = this.getParterAgentCol();
        this.setTableHeadSortNotNeedSortManager();
    }

    private void loadParterAgentInfo() throws BOSException, EASBizException {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        if (this.curPartyOrgId == null) {
            this.curPartyOrgId = (String)this.getUIContext().get("ID");
        }
        String oql = "select id, parterName, partyApplyDate, beRustlerDate, beDevelopmentDate, passPoliticalDate, bePreParterDate, beParterDate, remark where partyOrg = '" + this.curPartyOrgId + "'";
        ParterAgentCollection paCol = this.iPa.getParterAgentCollection(oql);
        ParterAgentInfo paInfo = null;
        IRow row = null;
        int size = paCol.size();
        for (int i = 0; i < size; ++i) {
            paInfo = paCol.get(i);
            row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)paInfo.getId().toString());
            row.getCell("parterName").setValue((Object)paInfo.getParterName());
            row.getCell("partyApplyDate").setValue((Object)paInfo.getPartyApplyDate());
            row.getCell("beRustlerDate").setValue((Object)paInfo.getBeRustlerDate());
            row.getCell("beDevelopmentDate").setValue((Object)paInfo.getBeDevelopmentDate());
            row.getCell("passPoliticalDate").setValue((Object)paInfo.getPassPoliticalDate());
            row.getCell("bePreParterDate").setValue((Object)paInfo.getBePreParterDate());
            row.getCell("beParterDate").setValue((Object)paInfo.getBeParterDate());
            row.getCell("remark").setValue((Object)paInfo.getRemark());
        }
    }

    private ParterAgentCollection getParterAgentCol() {
        ParterAgentCollection paCol = new ParterAgentCollection();
        ParterAgentInfo paInfo = null;
        PartyOrgInfo poInfo = new PartyOrgInfo();
        if (this.curPartyOrgId != null) {
            poInfo.setId(BOSUuid.read((String)this.curPartyOrgId));
        }
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            paInfo = new ParterAgentInfo();
            if (row.getCell("id").getValue() != null) {
                paInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            }
            paInfo.setPartyOrg(poInfo);
            if (row.getCell("parterName").getValue() != null) {
                paInfo.setParterName(row.getCell("parterName").getValue().toString());
            } else {
                paInfo.setParterName(null);
            }
            if (row.getCell("partyApplyDate").getValue() != null) {
                paInfo.setPartyApplyDate((Date)row.getCell("partyApplyDate").getValue());
            } else {
                paInfo.setPartyApplyDate(null);
            }
            if (row.getCell("beRustlerDate").getValue() != null) {
                paInfo.setBeRustlerDate((Date)row.getCell("beRustlerDate").getValue());
            } else {
                paInfo.setBeRustlerDate(null);
            }
            if (row.getCell("beDevelopmentDate").getValue() != null) {
                paInfo.setBeDevelopmentDate((Date)row.getCell("beDevelopmentDate").getValue());
            } else {
                paInfo.setBeDevelopmentDate(null);
            }
            if (row.getCell("passPoliticalDate").getValue() != null) {
                paInfo.setPassPoliticalDate((Date)row.getCell("passPoliticalDate").getValue());
            } else {
                paInfo.setPassPoliticalDate(null);
            }
            if (row.getCell("bePreParterDate").getValue() != null) {
                paInfo.setBePreParterDate((Date)row.getCell("bePreParterDate").getValue());
            } else {
                paInfo.setBePreParterDate(null);
            }
            if (row.getCell("beParterDate").getValue() != null) {
                paInfo.setBeParterDate((Date)row.getCell("beParterDate").getValue());
            } else {
                paInfo.setBeParterDate(null);
            }
            if (row.getCell("remark").getValue() != null) {
                paInfo.setRemark(row.getCell("remark").getValue().toString());
            } else {
                paInfo.setRemark(null);
            }
            paCol.add(paInfo);
        }
        return paCol;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsert.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblMain.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.tblMain.getStyleAttributes().setLocked(true);
            this.btnAdd.setEnabled(false);
            this.btnInsert.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
    }

    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.addRow();
        this.setTableHeadSortNotNeedSortManager();
    }

    public void actionInsert_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() > 0) {
            int top = this.tblMain.getSelectManager().get().getTop();
            this.tblMain.addRow(top + 1);
            this.setTableHeadSortNotNeedSortManager();
        } else {
            this.actionAdd_actionPerformed(e);
        }
    }

    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (rowIndex < 0 || rowIndex >= this.tblMain.getRowCount()) {
            return;
        }
        ICell cell = this.tblMain.getRow(rowIndex).getCell("id");
        if (cell.getValue() != null) {
            this.delPaIds.add(cell.getValue().toString());
        }
        this.tblMain.removeRow(rowIndex);
        this.setTableHeadSortNotNeedSortManager();
    }

    public boolean isModify() {
        this.newPaCol = this.getParterAgentCol();
        return this.oldPaCol == null && this.newPaCol != null || this.oldPaCol != null && this.newPaCol == null || this.oldPaCol != null && this.newPaCol != null && !this.oldPaCol.equals((Object)this.newPaCol);
    }

    public void saveInfo() throws Exception {
        this.checkInput();
        this.iPa.updateBatchParterAgent(this.getParterAgentCol(), this.delPaIds);
        this.loadParterAgentInfo();
        this.delPaIds = new ArrayList();
        this.oldPaCol = this.getParterAgentCol();
    }

    public void checkInput() throws Exception {
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("parterName").getValue() == null) {
                throw new PartyCommonException(PartyCommonException.PARTERNAME_ISNULL, new Object[]{new Integer(i + 1)});
            }
            Date partyApplyDate = (Date)row.getCell("partyApplyDate").getValue();
            Date beRustlerDate = (Date)row.getCell("beRustlerDate").getValue();
            Date beDevelopmentDate = (Date)row.getCell("beDevelopmentDate").getValue();
            Date passPoliticalDate = (Date)row.getCell("passPoliticalDate").getValue();
            Date bePreParterDate = (Date)row.getCell("bePreParterDate").getValue();
            Date beParterDate = (Date)row.getCell("beParterDate").getValue();
            if (partyApplyDate != null && beRustlerDate != null && partyApplyDate.after(beRustlerDate)) {
                throw new PartyCommonException(PartyCommonException.PARTYAPPLYDATE_AFTER_BERUSTLERDATE, new Object[]{new Integer(i + 1)});
            }
            if (partyApplyDate != null && beDevelopmentDate != null && partyApplyDate.after(beDevelopmentDate)) {
                throw new PartyCommonException(PartyCommonException.PARTYAPPLYDATE_AFTER_BEDEVELOPMENTDATE, new Object[]{new Integer(i + 1)});
            }
            if (partyApplyDate != null && passPoliticalDate != null && partyApplyDate.after(passPoliticalDate)) {
                throw new PartyCommonException(PartyCommonException.PARTYAPPLYDATE_AFTER_PASSPOLITICALDATE, new Object[]{new Integer(i + 1)});
            }
            if (partyApplyDate != null && bePreParterDate != null && partyApplyDate.after(bePreParterDate)) {
                throw new PartyCommonException(PartyCommonException.PARTYAPPLYDATE_AFTER_BEPREPARTERDATE, new Object[]{new Integer(i + 1)});
            }
            if (partyApplyDate != null && beParterDate != null && partyApplyDate.after(beParterDate)) {
                throw new PartyCommonException(PartyCommonException.PARTYAPPLYDATE_AFTER_BEPARTERDATE, new Object[]{new Integer(i + 1)});
            }
            if (beRustlerDate != null && beDevelopmentDate != null && beRustlerDate.after(beDevelopmentDate)) {
                throw new PartyCommonException(PartyCommonException.BERUSTLERDATE_AFTER_BEDEVELOPMENTDATE, new Object[]{new Integer(i + 1)});
            }
            if (beRustlerDate != null && passPoliticalDate != null && beRustlerDate.after(passPoliticalDate)) {
                throw new PartyCommonException(PartyCommonException.BERUSTLERDATE_AFTER_PASSPOLITICALDATE, new Object[]{new Integer(i + 1)});
            }
            if (beRustlerDate != null && bePreParterDate != null && beRustlerDate.after(bePreParterDate)) {
                throw new PartyCommonException(PartyCommonException.BERUSTLERDATE_AFTER_BEPREPARTERDATE, new Object[]{new Integer(i + 1)});
            }
            if (beRustlerDate != null && beParterDate != null && beRustlerDate.after(beParterDate)) {
                throw new PartyCommonException(PartyCommonException.BERUSTLERDATE_AFTER_BEPARTERDATE, new Object[]{new Integer(i + 1)});
            }
            if (beDevelopmentDate != null && passPoliticalDate != null && beDevelopmentDate.after(passPoliticalDate)) {
                throw new PartyCommonException(PartyCommonException.BEDEVELOPMENTDATE_AFTER_PASSPOLITICALDATE, new Object[]{new Integer(i + 1)});
            }
            if (beDevelopmentDate != null && bePreParterDate != null && beDevelopmentDate.after(bePreParterDate)) {
                throw new PartyCommonException(PartyCommonException.BEDEVELOPMENTDATE_AFTER_BEPREPARTERDATE, new Object[]{new Integer(i + 1)});
            }
            if (beDevelopmentDate != null && beParterDate != null && beDevelopmentDate.after(beParterDate)) {
                throw new PartyCommonException(PartyCommonException.BEDEVELOPMENTDATE_AFTER_BEPARTERDATE, new Object[]{new Integer(i + 1)});
            }
            if (passPoliticalDate != null && bePreParterDate != null && passPoliticalDate.after(bePreParterDate)) {
                throw new PartyCommonException(PartyCommonException.PASSPOLITICALDATE_AFTER_BEPREPARTERDATE, new Object[]{new Integer(i + 1)});
            }
            if (passPoliticalDate != null && beParterDate != null && passPoliticalDate.after(beParterDate)) {
                throw new PartyCommonException(PartyCommonException.PASSPOLITICALDATE_AFTER_BEPARTERDATE, new Object[]{new Integer(i + 1)});
            }
            if (bePreParterDate == null || beParterDate == null || !bePreParterDate.after(beParterDate)) continue;
            throw new PartyCommonException(PartyCommonException.BEPREPARTERDATE_AFTER_BEPARTERDATE, new Object[]{new Integer(i + 1)});
        }
    }

    public void setPartyOrgId(String partyOrgId) throws Exception {
        this.curPartyOrgId = partyOrgId;
    }

    private void setTableCellEditor() {
        this.tblMain.checkParsed();
        KDTextField txtParterName = new KDTextField();
        txtParterName.setMaxLength(80);
        this.tblMain.getColumn("parterName").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtParterName));
        KDDatePicker partyApplyDate = new KDDatePicker();
        partyApplyDate.setValue((Object)new Date());
        this.tblMain.getColumn("partyApplyDate").setEditor((ICellEditor)new KDTDefaultCellEditor(partyApplyDate));
        this.tblMain.getColumn("partyApplyDate").getStyleAttributes().setNumberFormat("%r{yyyy-MM-dd}t");
        KDDatePicker beRustlerDate = new KDDatePicker();
        beRustlerDate.setValue((Object)new Date());
        this.tblMain.getColumn("beRustlerDate").setEditor((ICellEditor)new KDTDefaultCellEditor(beRustlerDate));
        this.tblMain.getColumn("beRustlerDate").getStyleAttributes().setNumberFormat("%r{yyyy-MM-dd}t");
        KDDatePicker beDevelopmentDate = new KDDatePicker();
        beDevelopmentDate.setValue((Object)new Date());
        this.tblMain.getColumn("beDevelopmentDate").setEditor((ICellEditor)new KDTDefaultCellEditor(beDevelopmentDate));
        this.tblMain.getColumn("beDevelopmentDate").getStyleAttributes().setNumberFormat("%r{yyyy-MM-dd}t");
        KDDatePicker passPoliticalDate = new KDDatePicker();
        passPoliticalDate.setValue((Object)new Date());
        this.tblMain.getColumn("passPoliticalDate").setEditor((ICellEditor)new KDTDefaultCellEditor(passPoliticalDate));
        this.tblMain.getColumn("passPoliticalDate").getStyleAttributes().setNumberFormat("%r{yyyy-MM-dd}t");
        KDDatePicker bePreParterDate = new KDDatePicker();
        bePreParterDate.setValue((Object)new Date());
        this.tblMain.getColumn("bePreParterDate").setEditor((ICellEditor)new KDTDefaultCellEditor(bePreParterDate));
        this.tblMain.getColumn("bePreParterDate").getStyleAttributes().setNumberFormat("%r{yyyy-MM-dd}t");
        KDDatePicker beParterDate = new KDDatePicker();
        beParterDate.setValue((Object)new Date());
        this.tblMain.getColumn("beParterDate").setEditor((ICellEditor)new KDTDefaultCellEditor(beParterDate));
        this.tblMain.getColumn("beParterDate").getStyleAttributes().setNumberFormat("%r{yyyy-MM-dd}t");
        KDTextField txtRemark = new KDTextField();
        txtRemark.setMaxLength(200);
        this.tblMain.getColumn("remark").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtRemark));
    }

    public void clear() {
        this.tblMain.removeRows();
        this.oldPaCol = this.getParterAgentCol();
        this.newPaCol = this.getParterAgentCol();
    }

    public void changeOperate(String operateStr) {
        this.setOprtState(operateStr);
        this.tblMain.getStyleAttributes().setLocked(false);
        this.btnAdd.setEnabled(true);
        this.btnInsert.setEnabled(true);
        this.btnDelete.setEnabled(true);
    }

    protected KDTSortManager getKDSortManger() {
        if (this.sm == null) {
            this.sm = new KDTSortManager(this.tblMain);
        }
        return this.sm;
    }

    protected void setTableHeadSortNotNeedSortManager() {
        if (this.tblMain.getRowCount() > 0) {
            PartyUtils.enableTableHeadSortNotNeedSortManager(this.tblMain, 0, this.tblMain.getRowCount() - 1, this.getKDSortManger());
        } else {
            int count = this.tblMain.getColumnCount();
            for (int i = 0; i < count; ++i) {
                this.tblMain.getColumn(i).setSortable(false);
            }
        }
    }
}

