/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.client.IHRBillListUIBiz;
import com.kingdee.eas.hr.party.client.AbstractPartyChangeBillListUI;
import com.kingdee.eas.hr.party.client.PartyChangeBillListBiz;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class PartyChangeBillListUI
extends AbstractPartyChangeBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(PartyChangeBillListUI.class);

    protected IHRBillListUIBiz getBillBiz() {
        return new PartyChangeBillListBiz();
    }

    protected void setSelectedActionState() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        if (selectRows.length > 0 && (row = this.tblMain.getRow(selectRows[0])) != null) {
            super.setSelectedActionState();
        }
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.btnAttachment.setVisible(false);
        this.btnQueryScheme.setVisible(true);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"person.number", "person.name"};
        return locateNames;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.setButton(e);
    }

    private void setButton(KDTSelectEvent e) {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rows.length > 1 || e.getSelectBlock().getMode() == 8 && rows[0] == 0 || rows[0] == -1) {
            this.btnAuditResult.setEnabled(false);
            this.btnWorkFlowG.setEnabled(false);
            this.menuItemAuditResult.setEnabled(false);
            this.menuItemWorkFlowG.setEnabled(false);
        } else {
            IRow row = this.tblMain.getRow(rows[0]);
            String strItem = row.getCell("approveType").getValue().toString();
            if (strItem.equals(ApproveTypeEnum.DIRECT.toString())) {
                this.btnAuditResult.setEnabled(false);
                this.btnWorkFlowG.setEnabled(false);
                this.menuItemAuditResult.setEnabled(false);
                this.menuItemWorkFlowG.setEnabled(false);
            } else {
                this.btnAuditResult.setEnabled(true);
                this.menuItemAuditResult.setEnabled(true);
                String billState = row.getCell("billState").getValue().toString();
                if (billState.equals(HRBillStateEnum.SUBMITED.toString()) || billState.equals(HRBillStateEnum.AUDITING.toString())) {
                    this.btnWorkFlowG.setEnabled(true);
                    this.menuItemWorkFlowG.setEnabled(true);
                }
            }
        }
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    protected boolean isUseStandardPermission() {
        return true;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        String msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ShowListDataCount");
        int i = super.getBillCount();
        Object[] obj = new Object[]{new Integer(this.tblMain.getRowCount()), new Integer(i)};
        String next = MessageFormat.format(msg, obj);
        this.setMessageBarText(next);
    }
}

