/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.hr.emp.PersonCommunistFactory;
import com.kingdee.eas.hr.party.client.AbstractPartyCollectListUI;
import com.kingdee.eas.hr.party.client.HRPartyGroupReportUtil;
import com.kingdee.eas.hr.party.client.PartyCollectFilterManager;
import com.kingdee.eas.hr.party.client.PartyCollectFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class PartyCollectListUI
extends AbstractPartyCollectListUI {
    private static final Logger logger = CoreUIObject.getLogger(PartyCollectListUI.class);
    private static final String resClassName = "com.kingdee.eas.hr.party.client.PartyCollectResource";
    private static final String excClassName = "com.kingdee.eas.hr.party.PartyCommonException";
    private PartyCollectFilterManager filterManager;
    private static final String PANEL_CLASSNAME = "com.kingdee.eas.hr.party.client.PartyCollectFilterUI";
    private static final String[] item = new String[]{"label0", "label1", "label2", "label3", "label4", "label5", "label6", "label7", "label8", "label9", "label10", "label11", "label12", "label13", "label14", "label15"};
    private static final String[][] keyFiled = new String[][]{{"", ""}, {"", "leftDate"}, {"beRustlerDate", "partyStopDate"}, {"beCandidateDate", ""}, {"joinDate", ""}, {"transDate", ""}, {"partyResumeDate", ""}, {"", ""}};
    private static final String[][] sumFiled = new String[][]{{"", ""}, {"", "decreaseInyear"}, {"", "decreaseInyear"}, {"", ""}, {"increaseInyear", ""}, {"", ""}, {"increaseInyear", ""}, {"", ""}};
    private static int sumInLastYear = 0;
    private static int increaseCount = 0;
    private static int decreaseCount = 0;
    private static int expectCount = 0;
    private static int[] changeCount = new int[]{0, 0};

    protected ICoreBase getBizInterface() throws Exception {
        return PersonCommunistFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            return new PartyCollectFilterUI();
        }
        catch (Exception e) {
            MsgBox.showError((String)EASResource.getString((String)excClassName, (String)"SETFILTERUIERROR"));
            SysUtil.abort();
            return null;
        }
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.setAutoscrolls(true);
        this.btnQueryScheme.setVisible(false);
        this.enableExportExcel(this.tblMain);
        this.refreshData();
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.refreshData();
    }

    private void refreshData() throws Exception {
        this.initTable();
        this.initData();
        this.tblMain.getColumn("item2").setWidth(140);
    }

    private void initData() throws Exception {
        this.initPerson();
        this.initInOutPerson();
        this.initTableSum();
    }

    private void initTableSum() throws Exception {
        this.increaseInyear();
        this.decreaseInyear();
        this.sumInLastYear();
        this.expectCount();
    }

    private void sumInLastYear() throws Exception {
        sumInLastYear = 0;
        sumInLastYear = this.getIncDecCount("increaseInyear", false) - this.getIncDecCount("decreaseInyear", false);
        this.tblMain.getRow(0).getCell(1).setValue((Object)new Integer(sumInLastYear));
    }

    private void expectCount() {
        expectCount = 0;
        expectCount = sumInLastYear + increaseCount - decreaseCount;
        this.tblMain.getRow(5).getCell(3).setValue((Object)new Integer(expectCount));
    }

    private void increaseInyear() throws Exception {
        increaseCount = 0;
        increaseCount = this.getIncDecCount("increaseInyear", true);
        this.tblMain.getRow(1).getCell(1).setValue((Object)new Integer(increaseCount += changeCount[0]));
    }

    private void decreaseInyear() throws Exception {
        decreaseCount = 0;
        decreaseCount = this.getIncDecCount("decreaseInyear", true);
        this.tblMain.getRow(0).getCell(3).setValue((Object)new Integer(decreaseCount += changeCount[1]));
    }

    private int getIncDecCount(String keyType, boolean isThisYear) throws Exception {
        int temp = 0;
        for (int x = 1; x <= 3; x += 2) {
            for (int y = 0; y < 8; ++y) {
                if (sumFiled[y][x / 2] != keyType) continue;
                temp += this.countByKey(keyFiled[y][x / 2], "PartyCollectQuery", isThisYear);
            }
        }
        return temp;
    }

    private void initInOutPerson() throws Exception {
        for (int i = 0; i < 2; ++i) {
            PartyCollectListUI.changeCount[i] = this.getChangeCount(i, true);
            int[][] cellXY = new int[][]{{7, 1}, {4, 3}};
            this.tblMain.getRow(cellXY[i][0]).getCell(cellXY[i][1]).setValue((Object)new Integer(changeCount[i]));
        }
    }

    private int getChangeCount(int i, boolean isThisYear) throws Exception {
        String[] changeType = new String[]{"1", "2"};
        int countChange = 0;
        FilterInfo filterOld = new FilterInfo();
        filterOld = this.mainQuery.getFilter();
        IRowSet dataRow = null;
        String oql = "";
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("changeType", (Object)changeType[i], CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("changeDate", null, CompareType.NOTEQUALS));
        this.setDateFilter(filter, "changeDate", isThisYear);
        filter.mergeFilter(filterOld, "and");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        oql = HRPartyGroupReportUtil.metaQueryToSQL(view, "com.kingdee.eas.hr.party.app", "PartyChangeCountQuery");
        String countSQL = "SELECT Count(*) AS COUNTPERSONS from ((" + oql + ") AS TBL)";
        dataRow = HRPartyGroupReportUtil.query(countSQL);
        while (dataRow.next()) {
            if (dataRow.getString("COUNTPERSONS") == null) continue;
            countChange = dataRow.getInt("COUNTPERSONS");
        }
        return countChange;
    }

    private void initPerson() throws Exception {
        for (int x = 1; x <= 3; x += 2) {
            for (int y = 0; y < 8; ++y) {
                if (StringUtils.isEmpty((String)keyFiled[y][x / 2])) continue;
                this.tblMain.getRow(y).getCell(x).setValue((Object)new Integer(this.countByKey(keyFiled[y][x / 2], "PartyCollectQuery", true)));
            }
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.getDialog() != null) {
            if (this.filterManager == null) {
                this.filterManager = new PartyCollectFilterManager(this.getDialog());
            } else {
                this.filterManager.reloadData(this.getDialog());
            }
            this.initTable();
            this.initData();
        } else {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            PartyCollectFilterUI filterUI = new PartyCollectFilterUI();
            QuerySolutionInfo solution = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), this.mainQueryPK.getFullName());
            CustomerParams params = CustomerParams.getCustomerParams2((String)this.getCustomerParamsStr(solution));
            if (params != null) {
                filterUI.setCustomerParams(params);
                if (this.filterManager == null) {
                    this.filterManager = new PartyCollectFilterManager(filterUI);
                } else {
                    this.filterManager.reloadData(filterUI);
                }
                this.initTable();
                this.initData();
            }
        }
    }

    private String getCustomerParamsStr(QuerySolutionInfo solution) {
        if (null != solution && null != solution.getQueryPanelInfo() && solution.getQueryPanelInfo().size() > 0) {
            int len = solution.getQueryPanelInfo().size();
            for (int i = 0; i < len; ++i) {
                if (null == solution.getQueryPanelInfo().get(i) || !PANEL_CLASSNAME.equals(solution.getQueryPanelInfo().get(i).getPanelClassName())) continue;
                return solution.getQueryPanelInfo().get(i).getCustomerParams();
            }
        }
        return null;
    }

    private int countByKey(String queryKey, String queryName, boolean isThisYear) throws Exception {
        int countChange = 0;
        IRowSet dataRow = null;
        String oql = "";
        FilterInfo filter = new FilterInfo();
        this.setDateFilter(filter, queryKey, isThisYear);
        filter.mergeFilter(this.mainQuery.getFilter(), "and");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        oql = HRPartyGroupReportUtil.metaQueryToSQL(view, "com.kingdee.eas.hr.party.app", queryName);
        dataRow = HRPartyGroupReportUtil.query(oql);
        while (dataRow.next()) {
            if (dataRow.getString("PERSONCOUNT") == null) continue;
            countChange = dataRow.getInt("PERSONCOUNT");
        }
        return countChange;
    }

    private void setDateFilter(FilterInfo filterInfo, String queryKey, boolean isThisYear) {
        Date startDate = DateTimeUtils.truncateDate((Date)((Date)this.filterManager.getStartDate()));
        if (startDate != null) {
            if (isThisYear) {
                filterInfo.getFilterItems().add(new FilterItemInfo(queryKey, (Object)startDate, CompareType.GREATER_EQUALS));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo(queryKey, (Object)startDate, CompareType.LESS));
            }
        }
        Calendar endDate = Calendar.getInstance();
        if (this.filterManager.getEndDate() != null && isThisYear) {
            endDate.setTime(DateTimeUtils.truncateDate((Date)((Date)this.filterManager.getEndDate())));
            endDate.add(5, 1);
            filterInfo.getFilterItems().add(new FilterItemInfo(queryKey, (Object)endDate.getTime(), CompareType.LESS_EQUALS));
        }
    }

    private void initTable() {
        this.tblMain.removeRows();
        for (int x = 0; x < 16; ++x) {
            int rowIndex = x % 8;
            int colIndex = x / 8 * 2;
            if (colIndex == 0) {
                this.tblMain.addRow();
            }
            this.tblMain.getRow(rowIndex).getCell(colIndex).setValue((Object)EASResource.getString((String)resClassName, (String)item[x]));
        }
        this.tblMain.setRowCount(this.tblMain.getBody().size());
    }

    protected void handleQueryDialog(CommonQueryDialog dialog) throws Exception {
        dialog.setUiObject(null);
        dialog.setShowFilter(false);
        dialog.setShowSorter(false);
        dialog.setMaxReturnCountVisible(false);
    }

    protected boolean isUseStandardPermission() {
        return true;
    }

    protected String getKeyFieldName() {
        return "item1";
    }
}

