/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.party.PartyOrgInfo;
import com.kingdee.eas.hr.party.client.AbstractPartyDetailFilterUI;
import com.kingdee.eas.hr.party.client.PartyOrgPromptBox;
import com.kingdee.eas.hr.party.client.util.PartyPermissionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import org.apache.log4j.Logger;

public class PartyDetailFilterUI
extends AbstractPartyDetailFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PartyDetailFilterUI.class);
    private final String strResource = "com.kingdee.eas.hr.party.PartyResource.";

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        PartyOrgPromptBox prmtPo = new PartyOrgPromptBox();
        prmtPo.setIsUsePermission(true);
        this.prmtPartyOrg.setSelector((KDPromptSelector)prmtPo);
        this.prmtPartyOrg.setEditable(false);
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
    }

    public void clear() {
        super.clear();
        this.prmtPartyOrg.setValue(null);
        this.cbIsCancel.setSelected(false);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.prmtPartyOrg.getData() != null) {
            PartyOrgInfo partyOrg = (PartyOrgInfo)this.prmtPartyOrg.getData();
            filterInfo.getFilterItems().add(new FilterItemInfo("partyOrg.number", (Object)partyOrg.getNumber(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("partyOrg.longNumber", (Object)(partyOrg.getLongNumber() + "!%"), CompareType.LIKE));
            filterInfo.setMaskString("#0 or #1");
            if (!this.cbIsCancel.isSelected()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("partyOrg.isCancel", (Object)new Boolean(false), CompareType.EQUALS));
                filterInfo.setMaskString("#0 or (#1 and #2)");
                try {
                    filterInfo.mergeFilter(PartyPermissionUtil.getPermissionFilter(0, "partyOrg"), "and");
                    filterInfo.setMaskString("(#0 or (#1 and #2)) and #3");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                try {
                    filterInfo.mergeFilter(PartyPermissionUtil.getPermissionFilter(0, "partyOrg"), "and");
                    filterInfo.setMaskString("(#0 or #1) and #2");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
        return filterInfo;
    }

    public boolean verify() {
        if (this.prmtPartyOrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.partyOrgNotNull"));
            return false;
        }
        return true;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtPartyOrg.getValue() != null) {
            cp.addCustomerParam("adminId", ((AdminOrgUnitInfo)this.prmtPartyOrg.getValue()).getId().toString());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (this.prmtPartyOrg.getValue() != null) {
            PartyOrgInfo info = (PartyOrgInfo)this.prmtPartyOrg.getValue();
            cp.addCustomerParam("partyOrgID", info.getId().toString());
        }
        cp.putBoolean("isIncludeChild", true);
        cp.putBoolean("isCancel", this.cbIsCancel.isSelected());
    }

    private void mergeUserOrgRangeFilter(FilterInfo filter) {
        if (filter != null) {
            FilterInfo orgRangeFilter = new FilterInfo();
            orgRangeFilter.getFilterItems().add(new FilterItemInfo("orgRange.type", (Object)new Integer(20), CompareType.EQUALS));
            orgRangeFilter.getFilterItems().add(new FilterItemInfo("orgRange.user.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), CompareType.EQUALS));
            try {
                filter.mergeFilter(orgRangeFilter, "and");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }
}

