/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.party.PartyOrgFactory;
import com.kingdee.eas.hr.party.PartyOrgInfo;
import com.kingdee.eas.hr.party.client.AbstractPartyDevelopBillFilterUI;
import com.kingdee.eas.hr.party.client.PartyOrgPromptBox;
import com.kingdee.eas.hr.party.client.util.PartyPermissionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import org.apache.log4j.Logger;

public class PartyDevelopBillFilterUI
extends AbstractPartyDevelopBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PartyDevelopBillFilterUI.class);
    private static final String strResource = "com.kingdee.eas.hr.party.PartyResource.";
    private IMetaDataPK metaDataPKForPemmission;

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        PartyOrgPromptBox prmtPo = new PartyOrgPromptBox();
        prmtPo.setIsUsePermission(true);
        this.prmtPartyOrg.setSelector((KDPromptSelector)prmtPo);
        this.prmtPartyOrg.setEditable(false);
    }

    public void clear() {
        super.clear();
        this.prmtPartyOrg.setValue(null);
    }

    public void setMetaDataPKForPemmissionByPath(String metaDataPath) {
        if (!StringUtils.isEmpty((String)metaDataPath)) {
            this.metaDataPKForPemmission = new MetaDataPK(metaDataPath);
        }
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.prmtPartyOrg.getData() != null) {
            PartyOrgInfo partyOrg = (PartyOrgInfo)this.prmtPartyOrg.getData();
            filterInfo.getFilterItems().add(new FilterItemInfo("partyOrg.id", (Object)partyOrg.getId(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("partyOrg.longNumber", (Object)(partyOrg.getLongNumber() + "!%"), CompareType.LIKE));
            filterInfo.setMaskString("#0 or #1");
            filterInfo.getFilterItems().add(new FilterItemInfo("partyOrg.isCancel", (Object)new Boolean(false), CompareType.EQUALS));
            filterInfo.setMaskString("(#0 or (#1 and #2))");
            try {
                filterInfo.mergeFilter(PartyPermissionUtil.getPermissionFilter(0, "partyOrg"), "and");
                filterInfo.setMaskString("(#0 or (#1 and #2)) and #3");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return filterInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtPartyOrg.getValue() != null) {
            AdminOrgUnitInfo info = (AdminOrgUnitInfo)this.prmtPartyOrg.getValue();
            cp.addCustomerParam("partyOrgId", info.getId().toString());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp.getCustomerParam("partyOrgId") != null) {
            String adminId = cp.getCustomerParam("partyOrgId");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)adminId));
            PartyOrgInfo partyOrg = null;
            try {
                partyOrg = PartyOrgFactory.getRemoteInstance().getPartyOrgInfo("select id, name where id ='" + pk + "'");
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtPartyOrg.setValue(partyOrg);
        }
    }

    public boolean verify() {
        if (this.prmtPartyOrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.partyOrgNotNull"));
            return false;
        }
        return true;
    }
}

