/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.party.PartyOrgFactory;
import com.kingdee.eas.hr.party.PartyOrgInfo;
import com.kingdee.eas.hr.party.client.AbstractPartyFeeStatFilterUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.PartyOrgPromptBox;
import com.kingdee.eas.hr.party.client.util.PartyPermissionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PartyFeeStatFilterUI
extends AbstractPartyFeeStatFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PartyFeeStatFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.party.PartyResource";

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        PartyOrgPromptBox prmtPo = new PartyOrgPromptBox();
        prmtPo.setIsUsePermission(true);
        this.prmtPartyOrg.setSelector((KDPromptSelector)prmtPo);
        this.prmtPartyOrg.setEditable(false);
    }

    public void clear() {
        super.clear();
        this.prmtPartyOrg.setValue(null);
        Calendar beginDate = Calendar.getInstance();
        beginDate.set(2, 0);
        beginDate.set(5, 1);
        this.dpkBeginDate.setValue((Object)beginDate.getTime());
        Calendar endDate = Calendar.getInstance();
        endDate.set(2, 11);
        endDate.set(5, 31);
        this.dpkEndDate.setValue((Object)endDate.getTime());
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtPartyOrg.getValue() != null) {
            cp.addCustomerParam("partyOrg.id", ((PartyOrgInfo)this.prmtPartyOrg.getValue()).getId().toString());
        }
        cp.putDate("beginDate", (Date)this.dpkBeginDate.getValue());
        cp.putDate("endDate", (Date)this.dpkEndDate.getValue());
        return cp;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo PartyRetfilter = new FilterInfo();
        if (this.prmtPartyOrg.getValue() != null) {
            PartyRetfilter.getFilterItems().add(new FilterItemInfo("partyOrg.number", (Object)((PartyOrgInfo)this.prmtPartyOrg.getValue()).getNumber(), CompareType.EQUALS));
            PartyRetfilter.getFilterItems().add(new FilterItemInfo("partyOrg.longNumber", (Object)(((PartyOrgInfo)this.prmtPartyOrg.getValue()).getLongNumber() + "!%"), CompareType.LIKE));
            PartyRetfilter.setMaskString("#0 or #1");
            if (!this.cbIsCancel.isSelected()) {
                PartyRetfilter.getFilterItems().add(new FilterItemInfo("partyOrg.isCancel", (Object)new Boolean(false), CompareType.EQUALS));
                PartyRetfilter.setMaskString("#0 or (#1 and #2)");
                try {
                    PartyRetfilter.mergeFilter(PartyPermissionUtil.getPermissionFilter(0, "partyOrg"), "and");
                    PartyRetfilter.setMaskString("(#0 or (#1 and #2)) and #3");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                try {
                    PartyRetfilter.mergeFilter(PartyPermissionUtil.getPermissionFilter(0, "partyOrg"), "and");
                    PartyRetfilter.setMaskString("(#0 or #1) and #2");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
        return PartyRetfilter;
    }

    private void setDateFilter(FilterInfo filterInfo) {
        FilterInfo DateInfo = new FilterInfo();
        if (this.dpkBeginDate.getValue() != null) {
            DateInfo.getFilterItems().add(new FilterItemInfo("startDate", (Object)((Date)this.dpkBeginDate.getValue()), CompareType.GREATER_EQUALS));
        }
        if (this.dpkEndDate.getValue() != null) {
            DateInfo.getFilterItems().add(new FilterItemInfo("startDate", (Object)((Date)this.dpkEndDate.getValue()), CompareType.LESS_EQUALS));
        }
        try {
            filterInfo.mergeFilter(DateInfo, "and");
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp.getCustomerParam("partyOrg.id") != null) {
            String partyOrgId = cp.getCustomerParam("partyOrg.id");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)partyOrgId));
            PartyOrgInfo partyOrg = null;
            try {
                partyOrg = PartyOrgFactory.getRemoteInstance().getPartyOrgInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtPartyOrg.setValue((Object)partyOrg);
        }
        this.dpkBeginDate.setValue((Object)cp.getDate("beginDate"));
        this.dpkEndDate.setValue((Object)cp.getDate("endDate"));
    }

    public boolean verify() {
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.prmtPartyOrg);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.dpkBeginDate);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.dpkEndDate);
        if (this.dpkBeginDate.getValue() != null && this.dpkEndDate.getValue() != null) {
            Date beginDate = DateTimeUtils.truncateDate((Date)((Date)this.dpkBeginDate.getValue()));
            Date endDate = DateTimeUtils.truncateDate((Date)((Date)this.dpkEndDate.getValue()));
            if (endDate.before(beginDate)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"StartDateBeforeEndDate"));
                SysUtil.abort();
            }
        }
        return true;
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
    }

    public HashMap getStatusMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("partyOrg.id", ((PartyOrgInfo)this.prmtPartyOrg.getValue()).getId().toString());
        map.put("partyOrg.number", ((PartyOrgInfo)this.prmtPartyOrg.getValue()).getNumber());
        map.put("partyOrg.longNumber", ((PartyOrgInfo)this.prmtPartyOrg.getValue()).getLongNumber());
        map.put("beginDate", this.dpkBeginDate.getValue());
        map.put("endDate", this.dpkEndDate.getValue());
        return map;
    }
}

