/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.party.PartyOrgFactory;
import com.kingdee.eas.hr.party.PartyOrgInfo;
import com.kingdee.eas.hr.party.client.AbstractPartyInfoActivityStatFilterUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.PartyOrgPromptBox;
import com.kingdee.eas.hr.party.client.util.PartyPermissionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PartyInfoActivityStatFilterUI
extends AbstractPartyInfoActivityStatFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PartyInfoActivityStatFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.party.PartyResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtHROrg.setEditable(false);
        PartyOrgPromptBox prmtPo = new PartyOrgPromptBox();
        prmtPo.setIsUsePermission(true);
        this.prmtPartyOrg.setSelector((KDPromptSelector)prmtPo);
        this.prmtPartyOrg.setEditable(false);
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    public void clear() {
        super.clear();
        this.prmtPartyOrg.setValue(null);
        Calendar beginDate = Calendar.getInstance();
        beginDate.set(2, 0);
        beginDate.set(5, 1);
        this.dpkStartDate.setValue((Object)beginDate.getTime());
        Calendar endDate = Calendar.getInstance();
        endDate.set(2, 11);
        endDate.set(5, 31);
        this.dpkEndDate.setValue((Object)endDate.getTime());
    }

    public boolean verify() {
        Date startDate = null;
        Date endDate = null;
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.prmtPartyOrg);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.dpkStartDate);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.dpkEndDate);
        if (this.dpkStartDate.getValue() != null && this.dpkEndDate.getValue() != null && (startDate = DateTimeUtils.truncateDate((Date)((Date)this.dpkStartDate.getValue()))).after(endDate = DateTimeUtils.truncateDate((Date)((Date)this.dpkEndDate.getValue())))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"StartDateBeforeEndDate"));
            this.dpkStartDate.requestFocus();
            SysUtil.abort();
        }
        return true;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo PartyRetfilter = new FilterInfo();
        PartyRetfilter.getFilterItems().add(new FilterItemInfo("partyOrg.number", (Object)((PartyOrgInfo)this.prmtPartyOrg.getValue()).getNumber(), CompareType.EQUALS));
        PartyRetfilter.getFilterItems().add(new FilterItemInfo("partyOrg.longNumber", (Object)(((PartyOrgInfo)this.prmtPartyOrg.getValue()).getLongNumber() + "!%"), CompareType.LIKE));
        if (!this.cbIsCancel.isSelected()) {
            PartyRetfilter.getFilterItems().add(new FilterItemInfo("partyOrg.isCancel", (Object)new Boolean(false), CompareType.EQUALS));
            PartyRetfilter.setMaskString("#0 or (#1 and #2)");
            try {
                PartyRetfilter.mergeFilter(PartyPermissionUtil.getPermissionFilter(0, "partyOrg"), "and");
                PartyRetfilter.setMaskString("(#0 or (#1 and #2)) and #3");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            try {
                PartyRetfilter.mergeFilter(PartyPermissionUtil.getPermissionFilter(0, "partyOrg"), "and");
                PartyRetfilter.setMaskString("(#0 or #1) and #2");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        this.setDateFilter(PartyRetfilter);
        return PartyRetfilter;
    }

    private void setDateFilter(FilterInfo filterInfo) {
        FilterInfo DateInfo = new FilterInfo();
        if (this.dpkStartDate.getValue() != null) {
            DateInfo.getFilterItems().add(new FilterItemInfo("startDate", (Object)((Date)this.dpkStartDate.getValue()), CompareType.GREATER_EQUALS));
        }
        if (this.dpkEndDate.getValue() != null) {
            DateInfo.getFilterItems().add(new FilterItemInfo("startDate", (Object)((Date)this.dpkEndDate.getValue()), CompareType.LESS_EQUALS));
        }
        try {
            filterInfo.mergeFilter(DateInfo, "and");
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public HashMap getStatusMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.prmtPartyOrg.getValue() != null) {
            map.put("partyOrg.Id", ((PartyOrgInfo)this.prmtPartyOrg.getValue()).getId().toString());
            map.put("partyOrg.longNumber", ((PartyOrgInfo)this.prmtPartyOrg.getValue()).getLongNumber());
            map.put("partyOrg.number", ((PartyOrgInfo)this.prmtPartyOrg.getValue()).getNumber());
        }
        if (this.dpkStartDate.getValue() != null) {
            map.put("startDate", (Date)this.dpkStartDate.getValue());
        }
        if (this.dpkEndDate.getValue() != null) {
            map.put("endDate", (Date)this.dpkEndDate.getValue());
        }
        return map;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtPartyOrg.getValue() != null) {
            cp.addCustomerParam("partyOrgId", ((PartyOrgInfo)this.prmtPartyOrg.getValue()).getId().toString());
        }
        if (this.dpkStartDate.getValue() != null) {
            cp.putDate("startDate", (Date)this.dpkStartDate.getValue());
        }
        if (this.dpkEndDate.getValue() != null) {
            cp.putDate("endDate", (Date)this.dpkEndDate.getValue());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        try {
            this._setCustomerParams(cp);
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"FilterUIInitError"));
            SysUtil.abort();
        }
    }

    private void _setCustomerParams(CustomerParams cp) throws EASBizException, BOSException {
        ObjectUuidPK pk = null;
        if (cp.getCustomerParam("partyOrgId") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("partyOrgId")));
            this.prmtPartyOrg.setValue((Object)PartyOrgFactory.getRemoteInstance().getPartyOrgInfo((IObjectPK)pk));
        }
        this.dpkStartDate.setValue((Object)cp.getDate("startDate"));
        this.dpkEndDate.setValue((Object)cp.getDate("endDate"));
    }

    public void storeFields() {
        super.storeFields();
    }
}

