/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.emp.client.HRTreeTable;
import com.kingdee.eas.hr.party.ActivityTypeCollection;
import com.kingdee.eas.hr.party.ActivityTypeFactory;
import com.kingdee.eas.hr.party.ActivityTypeInfo;
import com.kingdee.eas.hr.party.IActivityType;
import com.kingdee.eas.hr.party.PartyOrgInfo;
import com.kingdee.eas.hr.party.client.AbstractPartyInfoActivityStatListUI;
import com.kingdee.eas.hr.party.client.HRPartyGroupReportUtil;
import com.kingdee.eas.hr.party.client.HRPartyOrgReportUtil;
import com.kingdee.eas.hr.party.client.PartyInfoActivityStatFilterUI;
import com.kingdee.eas.hr.state.client.HRStateTWOClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PartyInfoActivityStatListUI
extends AbstractPartyInfoActivityStatListUI {
    private static final Logger logger = CoreUIObject.getLogger(PartyInfoActivityStatListUI.class);
    private static final String PANEL_CLASSNAME = "com.kingdee.eas.hr.party.client.PartyInfoActivityStatFilterUI";
    private static final String RES = "com.kingdee.eas.hr.party.PartyResource";
    private static final String QUERY_PATH = "com.kingdee.eas.hr.party.app";
    private static final String QUERY_NAME = "PartyInfoActivityStatCountTimesQuery";
    private HashMap statusMap;
    private HashMap latitudeIDMap;
    private HashMap headMap;
    private static final String COLUMN_NAME_TREECOLUMN = "treeColumn";

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        excelUtil.appendToExcel(this.tblMain, true, true, this.getUITitle());
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.getDialog() != null) {
            this.statusMap = ((PartyInfoActivityStatFilterUI)this.getDialog().getUserPanel(PANEL_CLASSNAME)).getStatusMap();
            this.loadData();
        } else {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            PartyInfoActivityStatFilterUI filterUI = new PartyInfoActivityStatFilterUI();
            QuerySolutionInfo solution = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), this.mainQueryPK.getFullName());
            CustomerParams params = CustomerParams.getCustomerParams2((String)this.getCustomerParamsStr(solution));
            if (params != null) {
                filterUI.setCustomerParams(params);
                this.statusMap = filterUI.getStatusMap();
                this.loadData();
            }
        }
    }

    private String getCustomerParamsStr(QuerySolutionInfo solution) {
        if (null != solution && null != solution.getQueryPanelInfo() && solution.getQueryPanelInfo().size() > 0) {
            int len = solution.getQueryPanelInfo().size();
            for (int i = 0; i < len; ++i) {
                if (null == solution.getQueryPanelInfo().get(i) || !PANEL_CLASSNAME.equals(solution.getQueryPanelInfo().get(i).getPanelClassName())) continue;
                return solution.getQueryPanelInfo().get(i).getCustomerParams();
            }
        }
        return null;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.refreshData();
    }

    private void refreshData() {
        this.loadData();
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        HRTreeTable.setHRTreeTable((KDTable)this.tblMain, (String)COLUMN_NAME_TREECOLUMN);
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.setAutoscrolls(true);
        this.enableExportExcel(this.tblMain);
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            return new PartyInfoActivityStatFilterUI();
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"FilterUIInitError"));
            SysUtil.abort();
            return null;
        }
    }

    private void loadData() {
        this.resetTable();
        try {
            this.initLatitude();
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"LatitudeInitError"));
            SysUtil.abort();
        }
        try {
            this.initTableHead();
        }
        catch (BOSException e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"TableHeadInitError"));
            SysUtil.abort();
        }
        this.tblMain.setRowCount(this.tblMain.getBody().size());
        try {
            this.initData();
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"DataInitError"));
            SysUtil.abort();
        }
        HRPartyGroupReportUtil.sumUpOnTree(this.tblMain, COLUMN_NAME_TREECOLUMN, null);
    }

    private void resetTable() {
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        this.tblMain.getHead().removeRows();
    }

    private void initLatitude() throws Exception {
        IColumn col = null;
        col = this.tblMain.addColumn();
        col.setKey(COLUMN_NAME_TREECOLUMN);
        col.setWidth(250);
        IRow row = null;
        PartyOrgInfo info = null;
        this.latitudeIDMap = new HashMap();
        Vector<PartyOrgInfo> vec = new Vector<PartyOrgInfo>();
        DefaultKingdeeTreeNode rootNode = HRPartyOrgReportUtil.getPartyOrgTreeNode(true, (String)this.statusMap.get("partyOrg.Id"));
        if (rootNode == null) {
            return;
        }
        PartyOrgInfo rootPartyOrgInfo = (PartyOrgInfo)rootNode.getUserObject();
        if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode)) {
            rootPartyOrgInfo.put("isEnable", new Boolean(false));
        } else {
            rootPartyOrgInfo.put("isEnable", new Boolean(true));
        }
        rootPartyOrgInfo.setLevel(rootNode.getLevel());
        vec.add(rootPartyOrgInfo);
        HRPartyOrgReportUtil.getCellUserObjects(rootNode, vec);
        HRCellTreeRenderer orgCellRen = new HRCellTreeRenderer();
        int initLevel = 0;
        int size = vec.size();
        for (int i = 0; i < size; ++i) {
            info = (PartyOrgInfo)vec.get(i);
            if (i == 0) {
                initLevel = info.getLevel();
            }
            row = this.tblMain.addRow(i);
            if (!Boolean.valueOf(info.get("isEnable").toString()).booleanValue()) {
                row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
            }
            HRCellUserObject orgCellObj = new HRCellUserObject();
            orgCellObj.setCompanyId(info.getId().toString());
            orgCellObj.setName(info.getName());
            orgCellObj.setLongNumber(info.getLongNumber());
            orgCellObj.setIsLeaf(info.isIsLeaf());
            orgCellObj.setLevel(info.getLevel() - initLevel);
            orgCellObj.setExpanded(true);
            this.latitudeIDMap.put(info.getId().toString(), new Integer(row.getRowIndex()));
            row.getCell(COLUMN_NAME_TREECOLUMN).setValue((Object)orgCellObj);
            row.getCell(COLUMN_NAME_TREECOLUMN).setRenderer((IBasicRender)orgCellRen);
        }
    }

    private void initTableHead() throws BOSException {
        this.tblMain.addHeadRow(0);
        this.tblMain.addHeadRow(1);
        KDTMergeManager manager = this.tblMain.getHeadMergeManager();
        manager.mergeBlock(0, 0, 1, 0);
        if (this.tblMain.getHead().getRow(0).getCell(0) != null) {
            this.tblMain.getHead().getRow(0).getCell(0).setValue((Object)EASResource.getString((String)RES, (String)"PartyOrg"));
        }
        this.headMap = new HashMap();
        IActivityType iActivityType = ActivityTypeFactory.getRemoteInstance();
        ActivityTypeCollection coll = iActivityType.getActivityTypeCollection();
        if (coll != null && coll.size() > 0) {
            IColumn col = null;
            ActivityTypeInfo atInfo = null;
            this.tblMain.getHeadMergeManager().mergeBlock(0, 0, 0, 0);
            this.tblMain.getHead().getRow(0).getCell(0).setValue((Object)EASResource.getString((String)RES, (String)"PartyOrg"));
            int baseColIndex = this.tblMain.getColumnCount();
            for (int i = 0; i < coll.size(); ++i) {
                col = this.tblMain.addColumn();
                atInfo = coll.get(i);
                this.headMap.put(atInfo.getId().toString(), new Integer(col.getColumnIndex()));
                manager.mergeBlock(0, baseColIndex, 0, baseColIndex + i);
                manager.mergeBlock(1, baseColIndex + i, 1, baseColIndex + i);
                this.tblMain.getHead().getRow(1).getCell(baseColIndex + i).setValue((Object)atInfo.getName());
            }
            this.tblMain.getHead().getRow(0).getCell(baseColIndex).setValue((Object)EASResource.getString((String)RES, (String)"activityTimes"));
        }
    }

    private void initData() throws BOSException, SQLException {
        this.setDataOnTable(this.getActivityData());
    }

    private IRowSet getActivityData() throws BOSException {
        IRowSet dataRows = null;
        dataRows = HRStateTWOClientUtils.query((EntityViewInfo)this.mainQuery, (String)QUERY_PATH, (String)QUERY_NAME);
        return dataRows;
    }

    private void setDataOnTable(IRowSet dataRows) throws SQLException {
        if (dataRows != null) {
            while (dataRows.next()) {
                if (dataRows.getString("PartyOrg.ID") == null || this.latitudeIDMap.get(dataRows.getString("PartyOrg.ID")) == null) continue;
                this.tblMain.getCell(((Integer)this.latitudeIDMap.get(dataRows.getString("PartyOrg.ID"))).intValue(), ((Integer)this.headMap.get(dataRows.getString("ACTIVITYTYPE.ID"))).intValue()).setValue((Object)new Integer(dataRows.getInt("COUNTTIMES")));
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected void handleQueryDialog(CommonQueryDialog dialog) throws Exception {
        dialog.setUiObject(null);
        dialog.setShowFilter(false);
        dialog.setShowSorter(false);
        dialog.setMaxReturnCountVisible(false);
    }

    protected boolean isUseStandardPermission() {
        return true;
    }

    protected String getKeyFieldName() {
        return COLUMN_NAME_TREECOLUMN;
    }
}

