/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.F7Render;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.party.PartyCommonException;
import com.kingdee.eas.hr.party.PartyJobCollection;
import com.kingdee.eas.hr.party.PartyJobFactory;
import com.kingdee.eas.hr.party.PartyJobInfo;
import com.kingdee.eas.hr.party.PartyJobTypeFactory;
import com.kingdee.eas.hr.party.PartyJobTypeInfo;
import com.kingdee.eas.hr.party.client.AbstractPartyJobListUI;
import com.kingdee.eas.hr.party.client.PartyJobTypeEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class PartyJobListUI
extends AbstractPartyJobListUI {
    private static final long serialVersionUID = 598104518240555302L;
    private static final Logger logger = CoreUIObject.getLogger(PartyJobListUI.class);
    private final String strResource = "com.kingdee.eas.hr.party.PartyResource.";
    private F7Render f7Delegate;
    private boolean isF7Use;

    public PartyJobListUI() throws Exception {
        this.iniTreeItem();
        this.treeView.setShowButton(false);
        this.treeMain.setExpandsSelectedPaths(true);
    }

    protected void iniTreeItem() throws Exception {
        long ll_RowCount = this.treeMain.getVisibleRowCount();
        if (ll_RowCount < 2L) {
            // empty if block
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        KDTreeNode treeNode = this.getSelectedTreeNode();
        String ls_PartyJobName = EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.PartyJobName");
        String ls_TeamJobName = EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.TeamJobName");
        String ls_unionJobName = EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.UnionJobName");
        if (treeNode != null && this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo) {
            if (treeNode.getLevel() == 0) {
                this.btnGroupAddNew.setEnabled(true);
            } else {
                this.btnGroupAddNew.setEnabled(false);
            }
            if (treeNode.isLeaf() && treeNode.getText().equals(ls_PartyJobName)) {
                this.btnGroupEdit.setEnabled(false);
                this.btnGroupRemove.setEnabled(false);
            } else if (treeNode.isLeaf() && treeNode.getText().equals(ls_TeamJobName)) {
                this.btnGroupEdit.setEnabled(false);
                this.btnGroupRemove.setEnabled(false);
            } else if (treeNode.isLeaf() && treeNode.getText().equals(ls_unionJobName)) {
                this.btnGroupEdit.setEnabled(false);
                this.btnGroupRemove.setEnabled(false);
            } else {
                this.btnGroupEdit.setEnabled(true);
                this.btnGroupRemove.setEnabled(true);
            }
        } else {
            this.btnGroupAddNew.setEnabled(true);
            this.btnGroupEdit.setEnabled(false);
            this.btnGroupRemove.setEnabled(false);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.treeMain_valueChanged(null);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        String ls_delete = EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.CanNotDelete");
        String ls_PartyJobName = EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.PartyJobName");
        String ls_TeamJobName = EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.TeamJobName");
        String ls_unionJobName = EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.UnionJobName");
        if (treeNode == null) {
            return;
        }
        if (treeNode.isLeaf()) {
            this.checkCanDelete("");
        }
        if (treeNode.getText().equals(ls_PartyJobName)) {
            String ls_msg = ls_delete.replaceFirst("%%", ls_PartyJobName);
            MsgBox.showWarning((String)ls_msg);
        } else if (treeNode.getText().equals(ls_TeamJobName)) {
            String ls_msg = ls_delete.replaceFirst("%%", ls_TeamJobName);
            MsgBox.showWarning((String)ls_msg);
        } else if (treeNode.getText().equals(ls_unionJobName)) {
            String ls_msg = ls_delete.replaceFirst("%%", ls_unionJobName);
            MsgBox.showWarning((String)ls_msg);
        } else {
            super.actionGroupRemove_actionPerformed(e);
        }
    }

    public void checkCanDelete(String sltedKeyValue) throws Exception {
        PartyJobCollection JobInfoCol = null;
        KDTreeNode treeNode = this.getSelectedTreeNode();
        PartyJobTypeInfo jobType = (PartyJobTypeInfo)treeNode.getUserObject();
        try {
            String oql = "select id , name where PartyJobType = '" + jobType.getId() + "'";
            JobInfoCol = PartyJobFactory.getRemoteInstance().getPartyJobCollection(oql);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (JobInfoCol.size() > 0) {
            throw new PartyCommonException(PartyCommonException.PARTYJOBNOTNULL);
        }
    }

    protected IObjectValue createNewData() {
        PartyJobInfo objectValue = new PartyJobInfo();
        return objectValue;
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.hr.party.client.PartyJobEditUI";
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode != null && treeNode.isLeaf()) {
            super.actionAddNew_actionPerformed(e);
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.DIPLOMA_NOTLEAF"));
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PartyJobFactory.getRemoteInstance();
    }

    protected String getRootName() {
        return EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.PartyJobType");
    }

    protected String getGroupEditUIName() {
        return PartyJobTypeEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "PartyJobType.FID";
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        try {
            return new ObjectUuidPK(this.getSelectedNodeKeyValue());
        }
        catch (Exception ex) {
            this.handUIException(ex);
            return null;
        }
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return PartyJobTypeFactory.getRemoteInstance();
    }

    public Object getData() {
        return this.f7Delegate.getF7Data();
    }

    public boolean isCanceled() {
        return this.f7Delegate.isF7Cancel();
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (!this.isF7Use) {
            super.handlePermissionForItemAction(action);
        }
    }

    public void setF7Use(boolean isF7Use, HashMap ctx) {
        this.isF7Use = isF7Use;
        if (isF7Use) {
            try {
                this.setPreferredSize(new Dimension(700, 400));
                if (ctx == null) {
                    ctx = new HashMap();
                }
                this.f7Delegate = new F7Render((ListUI)this, ctx);
                this.f7Delegate.init();
                this.initLayout();
            }
            catch (Exception e) {
                SysUtil.abort();
            }
        }
    }

    public void show() {
        if (this.isF7Use) {
            this.lockAction();
            this.toolBar.setVisible(false);
            this.menuBar.setVisible(false);
            this.f7Delegate.show();
        } else {
            super.show();
        }
        this.pnlMain.setDividerLocation(0.25);
    }

    protected void beforeExcutQuery(EntityViewInfo queryFilter) {
        super.beforeExcutQuery(queryFilter);
        if (this.isF7Use) {
            this.f7Delegate.mergeF7Filter(queryFilter);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && this.isF7Use) {
            this.f7Delegate.actionConfirm();
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor f7QueryExecutor;
        if (this.isF7Use && this.mainQueryPK.equals(queryPK) && (f7QueryExecutor = this.f7Delegate.getF7QueryExecutor(queryPK, viewInfo)) != null) {
            return f7QueryExecutor;
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected boolean isIgnoreCUFilter() {
        if (this.isF7Use) {
            return !this.f7Delegate.isF7HasCuDefaultFilter();
        }
        return super.isIgnoreCUFilter();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog commonQueryDialog = super.initCommonQueryDialog();
        commonQueryDialog.setShowSorter(false);
        return commonQueryDialog;
    }
}

