/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.emp.PersonCommunistCollection;
import com.kingdee.eas.hr.emp.PersonCommunistFactory;
import com.kingdee.eas.hr.party.LaborUnionMemberCollection;
import com.kingdee.eas.hr.party.LaborUnionMemberFactory;
import com.kingdee.eas.hr.party.MemberInforCollection;
import com.kingdee.eas.hr.party.MemberInforFactory;
import com.kingdee.eas.hr.party.PartyCommonException;
import com.kingdee.eas.hr.party.PartyPayPerInfo;
import com.kingdee.eas.hr.party.PartyPayPerTypeInfo;
import com.kingdee.eas.hr.party.client.AbstractPartyPayPerEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PartyPayPerEditUI
extends AbstractPartyPayPerEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PartyPayPerEditUI.class);
    private static final String resClassName = "com.kingdee.eas.hr.party.PartyResource";
    private final String strResource = "com.kingdee.eas.hr.party.PartyResource.";

    public void loadFields() {
        super.loadFields();
        if (this.prmtPartyFeeMode.getSelectedIndex() < 1) {
            this.prmtPartyFeeMode.setSelectedIndex(0);
        }
        this.txtPayPerTemp.setSupportedEmpty(false);
        this.txtPayPerTemp.setNegatived(false);
        this.txtPayPerTemp.setDataType(6);
        this.txtPayPerTemp.setPrecision(2);
        this.txtPayPer.setVisible(false);
        this.PartyFeeModeShowPer(false);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.prmtPartyFeeMode.setSelectedIndex(0);
    }

    protected IObjectValue createNewData() {
        PartyPayPerInfo objectValue = new PartyPayPerInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setPaypertype((PartyPayPerTypeInfo)this.getUIContext().get("ParentNode"));
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        PartyPayPerInfo payPerInfo = this.editData;
        if (StringUtils.isEmpty((String)payPerInfo.getNumber())) {
            this.txtNumber.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        if (StringUtils.isEmpty((String)payPerInfo.getName())) {
            this.txtName.requestFocusInWindow();
            throw new PartyCommonException(PartyCommonException.PARTYPAYTYPEISNULL);
        }
        if (payPerInfo.getPartyfeemode() == null) {
            this.prmtPartyFeeMode.requestFocusInWindow();
            throw new PartyCommonException(PartyCommonException.PARTYFEEMODE_ISNULL);
        }
        if (this.txtPayPerTemp.getText() == null) {
            this.txtPayPerTemp.requestFocusInWindow();
            throw new PartyCommonException(PartyCommonException.PAYPERNOTNULL);
        }
        if (this.prmtPayPerType.getData() == null) {
            throw new BaseException(BaseException.MUST_SELECT_CERTIFYTYPE);
        }
        if (this.isNotExistPartyPayPerType()) {
            throw new BaseException(BaseException.DIPLOMYTYPE_NOT_EXIST);
        }
    }

    private boolean isNotExistPartyPayPerType() throws BOSException, SQLException {
        boolean result = true;
        String sql = "select * from T_HR_PartyPayPerType where fname_l2 = '" + this.prmtPayPerType.getData().toString() + "'";
        IRowSet rs = null;
        ISQLExecutor exector = SQLExecutorFactory.getRemoteInstance((String)sql);
        rs = exector.executeSQL();
        while (rs.next()) {
            result = false;
        }
        return result;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.initPartyPayPerTypeF7();
    }

    private void initPartyPayPerTypeF7() {
        this.prmtPayPerType.setQueryInfo("com.kingdee.eas.hr.party.app.PartyPayPerTypeF7Query");
        this.prmtPayPerType.setEditFormat("$number$");
        this.prmtPayPerType.setCommitFormat("$number$");
        this.prmtPayPerType.setDisplayFormat("$name$");
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filterLeaf = new FilterInfo();
        filterLeaf.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Boolean(true)));
        env.setFilter(filterLeaf);
        this.prmtPayPerType.setEntityViewInfo(env);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.editData.setPaypertype((PartyPayPerTypeInfo)this.getUIContext().get("ParentNode"));
        this.prmtPayPerType.setData((Object)this.editData.getPaypertype());
    }

    protected void prmtPartyFeeMode_itemStateChanged(ItemEvent e) throws Exception {
        this.PartyFeeModeShowPer(true);
    }

    protected void PartyFeeModeShowPer(boolean isModified) {
        PartyPayPerInfo payPerInfo = (PartyPayPerInfo)this.getDataObject();
        int itemIndex = this.prmtPartyFeeMode.getSelectedIndex();
        if (itemIndex == -1) {
            this.prmtPartyFeeMode.setSelectedIndex(0);
        }
        if (itemIndex == 1) {
            this.kDLabelPer.setVisible(false);
            this.kDLabelYuan.setVisible(true);
        } else {
            this.kDLabelPer.setVisible(true);
            this.kDLabelYuan.setVisible(false);
        }
        if (isModified) {
            BigDecimal bigDec = new BigDecimal(0);
            this.txtPayPerTemp.setNumberValue((Number)bigDec);
        } else if (payPerInfo != null && payPerInfo.getPayper() != null) {
            if (itemIndex == 1) {
                this.txtPayPerTemp.setNumberValue((Number)payPerInfo.getPayper());
            } else {
                this.txtPayPerTemp.setNumberValue((Number)payPerInfo.getPayper().multiply(new BigDecimal(100.0)));
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.txtPayPerTemp.getNumberValue() == null) {
            throw new PartyCommonException(PartyCommonException.PAYPERNOTNULL);
        }
        BigDecimal bigDec2 = new BigDecimal(999999.99);
        BigDecimal bigDec1 = (BigDecimal)this.txtPayPerTemp.getNumberValue();
        if (bigDec1.compareTo(bigDec2) == 1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource.NUMTOOMAX"));
            return;
        }
        int itemIndex = this.prmtPartyFeeMode.getSelectedIndex();
        if (itemIndex == 1) {
            if (!this.txtPayPerTemp.getNumberValue().equals(this.txtPayPer.getNumberValue())) {
                this.txtPayPer.setNumberValue(this.txtPayPerTemp.getNumberValue());
            }
        } else if (!(bigDec1 = new BigDecimal(bigDec1.doubleValue() / 100.0)).equals(bigDec2 = (BigDecimal)this.txtPayPer.getNumberValue())) {
            this.txtPayPer.setNumberValue((Number)bigDec1);
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void deletePartyPayPerInfo() throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        String keyValue = this.editData.getId().toString();
        PersonCommunistCollection PersonCommunistInfoCol = null;
        try {
            String oql = "select id , name where partyPayPer = '" + keyValue + "'";
            PersonCommunistInfoCol = PersonCommunistFactory.getRemoteInstance().getPersonCommunistCollection(oql);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (PersonCommunistInfoCol != null && PersonCommunistInfoCol.size() > 0) {
            throw new PartyCommonException(PartyCommonException.PARTYPAYPERISUSEDBYORG);
        }
    }

    protected void deleteMemberPayPerInfo() throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        String keyValue = this.editData.getId().toString();
        MemberInforCollection MemberInforCol = null;
        try {
            String oql = "select id , name where payPer = '" + keyValue + "'";
            MemberInforCol = MemberInforFactory.getRemoteInstance().getMemberInforCollection(oql);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (MemberInforCol != null && MemberInforCol.size() > 0) {
            throw new PartyCommonException(PartyCommonException.MEMPAYPERISUSEDBYORG);
        }
    }

    protected void deleteLaborUnionPayPerInfo() throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        String keyValue = this.editData.getId().toString();
        LaborUnionMemberCollection laborUnionMemberCol = null;
        try {
            String oql = "select id , name where feeRatio = '" + keyValue + "'";
            laborUnionMemberCol = LaborUnionMemberFactory.getRemoteInstance().getLaborUnionMemberCollection(oql);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (laborUnionMemberCol != null && laborUnionMemberCol.size() > 0) {
            throw new PartyCommonException(PartyCommonException.LABORPAYPERISUSEDBYORG);
        }
    }
}

