/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.client.f7.IF7Support;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.client.f7.F7ConfigManager;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.party.IPartyPaymentBase;
import com.kingdee.eas.hr.party.PartyPaymentBaseCollection;
import com.kingdee.eas.hr.party.PartyPaymentBaseFactory;
import com.kingdee.eas.hr.party.PartyPaymentBaseInfo;
import com.kingdee.eas.hr.party.client.AbstractPartyPaymentBaseUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.PartyGroupEmployeeF7PromptBox;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PartyPaymentBaseUI
extends AbstractPartyPaymentBaseUI {
    private static final long serialVersionUID = 1758185962016979914L;
    private static final Logger logger = CoreUIObject.getLogger(PartyPaymentBaseUI.class);
    protected AdminByOrgRangePromptBox adminF7 = null;
    protected PartyGroupEmployeeF7PromptBox memberF7 = null;
    protected final String ErrorRES = "com.kingdee.eas.hr.party.PartyCommonException";
    private static final String resClassName = "com.kingdee.eas.hr.party.PartyResource";
    private static BigDecimal ZERO = new BigDecimal(0.0).setScale(2);
    private boolean isEditStatus = false;
    private HashSet partyPaymentBaseDeleteSet = new HashSet();
    private PartyPaymentBaseCollection partyPaymentBaseCollection = new PartyPaymentBaseCollection();
    protected final Color CANNOT_INPUT_COLOR = new Color(208, 208, 208);

    public PartyPaymentBaseUI() throws Exception {
        this.dataBinder.registerBinding("PartyPaymentBase", PartyPaymentBaseInfo.class, (Component)this.kdtEntrys, "userObject");
        this.initEmpF7();
        this.adminF7 = new AdminByOrgRangePromptBox();
        this.adminF7.showChkSealUp(true);
        this.adminF7.setIncludeSealUp("false");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadFields();
        this.prmtAdminOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                PartyPaymentBaseUI.this.prmtAdminOrgUnit_dataChanged();
            }
        });
        this.initEditorForKDTable();
        this.loadPaymentBaseData();
    }

    protected void prmtAdminOrgUnit_dataChanged() {
        try {
            this.loadTableData();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void loadPaymentBaseData() throws Exception {
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("person.id"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("person.number"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("person.name"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("adminOrg.*"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("importData"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("basePay"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("description"));
            SorterItemInfo sortInfo = new SorterItemInfo("person.number");
            sortInfo.setSortType(SortType.ASCEND);
            entityViewInfo.getSorter().add(sortInfo);
            this.partyPaymentBaseCollection = ((IPartyPaymentBase)this.getBizInterface()).getPartyPaymentBaseCollection(entityViewInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.partyPaymentBaseDeleteSet.clear();
    }

    private void loadTableData() throws Exception {
        String adminOrgNumber;
        this.loadPaymentBaseData();
        this.kdtEntrys.removeRows();
        int countCycle = this.partyPaymentBaseCollection.size();
        if (this.prmtAdminOrgUnit.getData() != null) {
            FullOrgUnitInfo adminOrg;
            if (this.prmtAdminOrgUnit.getValue() instanceof FullOrgUnitInfo) {
                adminOrg = (FullOrgUnitInfo)this.prmtAdminOrgUnit.getValue();
                adminOrgNumber = adminOrg.getNumber();
            } else {
                adminOrg = (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getValue();
                adminOrgNumber = adminOrg.getNumber();
            }
        } else {
            adminOrgNumber = "";
        }
        for (int i = 0; i < countCycle; ++i) {
            boolean isSelected = false;
            if (!StringUtils.isEmpty((String)adminOrgNumber)) {
                if (this.partyPaymentBaseCollection.get(i) != null && this.partyPaymentBaseCollection.get(i).getAdminOrg() != null) {
                    String adminOrgLongNumber;
                    if (this.partyPaymentBaseCollection.get(i).getAdminOrg().getNumber().equals(adminOrgNumber)) {
                        isSelected = true;
                    }
                    if ((adminOrgLongNumber = this.partyPaymentBaseCollection.get(i).getAdminOrg().getLongNumber()).indexOf(adminOrgNumber) == 0) {
                        isSelected = true;
                    }
                }
            } else {
                isSelected = false;
            }
            if (!isSelected) continue;
            IRow detailRow = this.kdtEntrys.addRow();
            this.loadTableRow(this.partyPaymentBaseCollection.get(i), detailRow);
        }
    }

    private void loadTableRow(PartyPaymentBaseInfo partyPaymentBaseInfo, IRow detailRow) {
        PersonInfo pInfo;
        if (detailRow == null) {
            detailRow = this.kdtEntrys.addRow();
        }
        detailRow.setUserObject((Object)partyPaymentBaseInfo);
        if (partyPaymentBaseInfo.getId() != null) {
            detailRow.getCell("ID").setValue((Object)partyPaymentBaseInfo.getId().toString());
        }
        if ((pInfo = partyPaymentBaseInfo.getPerson()).getNumber() != null) {
            detailRow.getCell("person.number").setValue((Object)pInfo.getNumber());
        }
        if (pInfo.getName() != null) {
            detailRow.getCell("person").setValue((Object)pInfo.getName());
        }
        if (partyPaymentBaseInfo.getAdminOrg() != null) {
            detailRow.getCell("adminOrg").setValue((Object)partyPaymentBaseInfo.getAdminOrg().getName());
        }
        if (partyPaymentBaseInfo.getImportData() != null) {
            detailRow.getCell("importData").setValue((Object)partyPaymentBaseInfo.getImportData());
        }
        if (partyPaymentBaseInfo.getBasePay() != null) {
            detailRow.getCell("basePay").setValue((Object)partyPaymentBaseInfo.getBasePay());
        }
        if (partyPaymentBaseInfo.getDescription() != null) {
            detailRow.getCell("description").setValue((Object)partyPaymentBaseInfo.getDescription());
        }
    }

    private void initEditorForKDTable() {
        this.kdtEntrys.checkParsed();
        this.kdtEntrys.getColumn("importData").getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn("importData").getStyleAttributes().setNumberFormat("0.00");
        KDFormattedTextField kdtEntrys_formatted_TextField = new KDFormattedTextField();
        kdtEntrys_formatted_TextField.setName("kdtEntrys_formatted_TextField");
        kdtEntrys_formatted_TextField.setVisible(true);
        kdtEntrys_formatted_TextField.setEditable(true);
        kdtEntrys_formatted_TextField.setDataType(1);
        kdtEntrys_formatted_TextField.setPrecision(2);
        kdtEntrys_formatted_TextField.setDataVerifierType(12);
        kdtEntrys_formatted_TextField.setMaximumValue((Comparable)new BigDecimal(9.999999999E7));
        kdtEntrys_formatted_TextField.setMinimumValue((Comparable)new BigDecimal(0));
        kdtEntrys_formatted_TextField.setSupportedEmpty(true);
        KDTDefaultCellEditor kdtEntrys_formatted_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_formatted_TextField);
        this.kdtEntrys.getColumn("basePay").setEditor((ICellEditor)kdtEntrys_formatted_CellEditor);
        this.kdtEntrys.getColumn("basePay").getStyleAttributes().setNumberFormat("0.00");
        KDTextField kdtEntrys_description_TextField = new KDTextField();
        kdtEntrys_description_TextField.setName("kdtEntrys_description_TextField");
        kdtEntrys_description_TextField.setMaxLength(80);
        KDTDefaultCellEditor kdtEntrys_remark_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_description_TextField);
        this.kdtEntrys.getColumn("description").setEditor((ICellEditor)kdtEntrys_remark_CellEditor);
        IColumn colPersonNumber = this.kdtEntrys.getColumn(1);
        colPersonNumber.getStyleAttributes().setLocked(true);
        colPersonNumber.getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
        IColumn colImportData = this.kdtEntrys.getColumn(4);
        colImportData.getStyleAttributes().setLocked(true);
        colImportData.getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.contEntrys.setTitle(EASResource.getString((String)resClassName, (String)"PartyPaymentBase"));
        this.prmtAdminOrgUnit.setSelector((KDPromptSelector)this.adminF7);
        this.prmtAdminOrgUnit.setEditable(false);
        this.btRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnImportData.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btRemoveLine.setText(null);
        this.btInsertLine.setText(null);
        this.btAddLine.setText(null);
        this.btnPrint.setEnabled(true);
        this.btnRefresh.setEnabled(true);
        this.contEntrys.addButton((JButton)this.btAddLine);
        this.contEntrys.addButton((JButton)this.btInsertLine);
        this.contEntrys.addButton((JButton)this.btRemoveLine);
        this.changeEditStatus(false);
    }

    protected void changeEditStatus(boolean lbEditStatus) {
        this.isEditStatus = lbEditStatus;
        if (this.isEditStatus) {
            this.kdtEntrys.setEditable(true);
            this.btAddLine.setEnabled(true);
            this.btRemoveLine.setEnabled(true);
            this.btInsertLine.setEnabled(true);
            this.btnImportData.setEnabled(true);
            this.btnSave.setEnabled(true);
            this.btnDelete.setEnabled(true);
            this.btnEdit.setEnabled(false);
        } else {
            this.kdtEntrys.setEditable(false);
            this.btnEdit.setEnabled(true);
            this.btAddLine.setEnabled(false);
            this.btRemoveLine.setEnabled(false);
            this.btInsertLine.setEnabled(false);
            this.btnImportData.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnDelete.setEnabled(false);
            this.btnPrint.setEnabled(true);
        }
    }

    protected void btAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLineByPersonF7(false);
    }

    protected void btInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLineByPersonF7(true);
    }

    protected void btRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        Hashtable hashtable = new Hashtable();
        if (this.kdtEntrys.getSelectManager().size() == 0 || this.isTableColumnSelected(this.kdtEntrys)) {
            MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"118_SelectEntry"));
            return;
        }
        int top = this.kdtEntrys.getSelectManager().get().getTop();
        if (this.kdtEntrys.getRow(top) == null) {
            MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"118_SelectEntry"));
            return;
        }
        PartyPaymentBaseInfo partyPaymentBaseInfo = (PartyPaymentBaseInfo)this.kdtEntrys.getRow(top).getUserObject();
        if (partyPaymentBaseInfo.getId() != null) {
            Object obj = hashtable.get(partyPaymentBaseInfo.getId());
            if (obj == null) {
                ObjectUuidPK pk = new ObjectUuidPK(partyPaymentBaseInfo.getId());
                String pkString = pk.toString();
                this.partyPaymentBaseDeleteSet.add(pkString);
            }
            this.kdtEntrys.removeRow(top);
        } else {
            this.kdtEntrys.removeRow(top);
        }
    }

    protected void initEmpF7() {
        if (this.memberF7 == null) {
            this.memberF7 = HRPartyClientUtils.initPersonF7(new FilterItemInfo("personCommunist.joinDate", null, CompareType.NOTEQUALS));
        }
        this.memberF7.setIsShowAllAdmin(true);
    }

    public void addLineByPersonF7(boolean isInsert) throws Exception {
        if (this.memberF7 == null) {
            return;
        }
        new F7ConfigManager().apply((IF7Support)this.memberF7);
        this.memberF7.show();
        if (!this.memberF7.isCanceled()) {
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            if (this.memberF7.getData() instanceof Object[]) {
                Object[] obj = (Object[])this.memberF7.getData();
                if (obj == null || obj.length <= 0) {
                    return;
                }
                int size = obj.length;
                for (int i = 0; i < size; ++i) {
                    persons.add((PersonInfo)obj[i]);
                }
            }
            if (this.memberF7.getData() instanceof PersonInfo) {
                persons.add((PersonInfo)this.memberF7.getData());
            }
            this.addLineByPersonList(persons, isInsert);
        }
    }

    public void addLineByPersonList(List persons, boolean isInsert) throws Exception {
        if ((persons = this.getProcessedPersons(persons)) != null) {
            boolean isSelect = false;
            int top = 0;
            boolean isTableColumnSelected = false;
            if (isInsert && this.kdtEntrys.getSelectManager().size() > 0) {
                isSelect = true;
                top = this.kdtEntrys.getSelectManager().get().getTop();
                isTableColumnSelected = this.isTableColumnSelected(this.kdtEntrys);
            }
            IRow row = null;
            int size = persons.size();
            for (int i = 0; i < size; ++i) {
                if (isInsert) {
                    if (isSelect && !isTableColumnSelected) {
                        row = this.kdtEntrys.addRow(top + i);
                    }
                } else {
                    row = this.kdtEntrys.addRow();
                }
                this.addLineByPerson(this.kdtEntrys, row, (PersonInfo)persons.get(i));
            }
        }
    }

    protected List getProcessedPersons(List persons) throws Exception {
        ArrayList<PersonInfo> personsTemp = new ArrayList<PersonInfo>();
        for (int i = 0; i < persons.size(); ++i) {
            PersonInfo person = (PersonInfo)persons.get(i);
            if (this.findPersonsInTable(person.getNumber())) continue;
            personsTemp.add(person);
        }
        return personsTemp;
    }

    protected boolean findPersonsInTable(String findValus) {
        boolean lb_return = false;
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            if (!this.kdtEntrys.getRow(i).getCell("person.number").getValue().equals(findValus)) continue;
            lb_return = true;
            break;
        }
        return lb_return;
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected String getKeyFieldName() {
        return "adminOrg";
    }

    protected void addLineByPerson(KDTable table, IRow row, PersonInfo pInfo) throws BOSException {
        if (table == null) {
            return;
        }
        if (row == null) {
            row = table.addRow();
        }
        PartyPaymentBaseInfo partyPaymentBaseInfo = null;
        int countCycle = this.partyPaymentBaseCollection.size();
        boolean isSelected = false;
        String personId = pInfo.getId().toString();
        if (StringUtils.isEmpty((String)personId)) {
            return;
        }
        for (int i = 0; i < countCycle; ++i) {
            isSelected = false;
            if (this.partyPaymentBaseCollection.get(i) == null || this.partyPaymentBaseCollection.get(i).getPerson() == null || !this.partyPaymentBaseCollection.get(i).getPerson().getId().toString().equals(personId)) continue;
            isSelected = true;
            partyPaymentBaseInfo = this.partyPaymentBaseCollection.get(i);
            break;
        }
        if (!isSelected) {
            partyPaymentBaseInfo = new PartyPaymentBaseInfo();
            partyPaymentBaseInfo.setPerson(pInfo);
            partyPaymentBaseInfo.setImportData(ZERO);
            partyPaymentBaseInfo.setBasePay(ZERO);
            partyPaymentBaseInfo.setDescription("");
            if (pInfo.get("primaryAdminOrg") != null) {
                partyPaymentBaseInfo.setAdminOrg((AdminOrgUnitInfo)pInfo.get("primaryAdminOrg"));
            } else {
                try {
                    partyPaymentBaseInfo.setAdminOrg(HRPartyClientUtils.getNoPositionAdmin(pInfo.getId().toString()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.loadTableRow(partyPaymentBaseInfo, row);
    }

    public void actionEdit_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionEdit_actionPerformed(arg0);
        this.changeEditStatus(true);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PartyPaymentBaseFactory.getRemoteInstance();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.submit();
        this.loadFields();
        this.changeEditStatus(false);
    }

    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        int countCycle = this.kdtEntrys.getRowCount();
        Hashtable hashtable = new Hashtable();
        if (countCycle == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)resClassName, (String)"118_SelectEntry"));
            return;
        }
        int intMsgReturn = MsgBox.showConfirm2((String)EASResource.getString((String)resClassName, (String)"delAllPaymentbase"));
        if (intMsgReturn == 0) {
            for (int i = 0; i < countCycle; ++i) {
                Object obj;
                IRow currentRow = this.kdtEntrys.getRow(i);
                PartyPaymentBaseInfo partyPaymentBaseInfo = (PartyPaymentBaseInfo)currentRow.getUserObject();
                if (partyPaymentBaseInfo.getId() == null || (obj = hashtable.get(partyPaymentBaseInfo.getId())) != null) continue;
                ObjectUuidPK pk = new ObjectUuidPK(partyPaymentBaseInfo.getId());
                String pkString = pk.toString();
                this.partyPaymentBaseDeleteSet.add(pkString);
            }
            if (!this.partyPaymentBaseDeleteSet.isEmpty()) {
                Object[] arraypartyPaymentBaseString = this.partyPaymentBaseDeleteSet.toArray();
                ObjectUuidPK[] pkArray = new ObjectUuidPK[arraypartyPaymentBaseString.length];
                for (Object obj : arraypartyPaymentBaseString) {
                    pkArray[i] = new ObjectUuidPK(BOSUuid.read((String)obj.toString()));
                }
                this.getBizInterface().delete((IObjectPK[])pkArray);
            }
        }
        this.loadTableData();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.loadTableData();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kdtEntrys);
        this.kdtEntrys.getPrintManager().printPreview();
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.hr.party.partyPaymentBaseInfo";
        param.alias = EASResource.getString((String)resClassName, (String)"PartyPaymentBase");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.invoke(this.getImportParam(), 0, true);
        this.actionRefresh_actionPerformed(null);
    }

    private void submit() throws Exception {
        ICell cell = null;
        this.kdtEntrys.getEditManager().stopEditing();
        CoreBaseCollection coreCollAdd = new CoreBaseCollection();
        CoreBaseCollection coreCollUpdate = new CoreBaseCollection();
        int countCycleAll = this.partyPaymentBaseCollection.size();
        int countCycle = this.kdtEntrys.getRowCount();
        for (int i = 0; i < countCycle; ++i) {
            BigDecimal bigDecValue;
            String cellValue;
            String personId = "";
            IRow currentRow = this.kdtEntrys.getRow(i);
            PartyPaymentBaseInfo partyPaymentBaseInfo = (PartyPaymentBaseInfo)currentRow.getUserObject();
            if (partyPaymentBaseInfo == null || partyPaymentBaseInfo.getPerson() == null) continue;
            personId = partyPaymentBaseInfo.getPerson().getId().toString();
            if (partyPaymentBaseInfo.getId() == null) {
                for (int loopVer = 0; loopVer < countCycleAll; ++loopVer) {
                    if (this.partyPaymentBaseCollection.get(loopVer) == null || this.partyPaymentBaseCollection.get(loopVer).getPerson() == null || !this.partyPaymentBaseCollection.get(loopVer).getPerson().getId().toString().equals(personId)) continue;
                    partyPaymentBaseInfo.setId(this.partyPaymentBaseCollection.get(loopVer).getId());
                    break;
                }
            }
            if ((cell = currentRow.getCell("importData")).getValue() != null) {
                cellValue = cell.getValue().toString();
                if (cellValue != null) {
                    bigDecValue = new BigDecimal(cellValue);
                    partyPaymentBaseInfo.setImportData(bigDecValue);
                } else {
                    partyPaymentBaseInfo.setImportData(ZERO);
                }
            } else {
                partyPaymentBaseInfo.setImportData(ZERO);
            }
            cell = currentRow.getCell("basePay");
            if (cell.getValue() != null) {
                cellValue = cell.getValue().toString();
                if (cellValue != null) {
                    bigDecValue = new BigDecimal(cellValue);
                    partyPaymentBaseInfo.setBasePay(bigDecValue);
                } else {
                    partyPaymentBaseInfo.setBasePay(ZERO);
                }
            } else {
                partyPaymentBaseInfo.setBasePay(ZERO);
            }
            cell = currentRow.getCell("description");
            if (cell.getValue() != null) {
                cellValue = cell.getValue().toString();
                if (cellValue != null) {
                    partyPaymentBaseInfo.setDescription(cellValue);
                } else {
                    partyPaymentBaseInfo.setDescription("");
                }
            } else {
                partyPaymentBaseInfo.setDescription("");
            }
            if (partyPaymentBaseInfo.getId() == null) {
                this.partyPaymentBaseCollection.add(partyPaymentBaseInfo);
                coreCollAdd.add((CoreBaseInfo)partyPaymentBaseInfo);
                continue;
            }
            this.partyPaymentBaseCollection.get(partyPaymentBaseInfo.getId()).putAll((IObjectValue)partyPaymentBaseInfo);
            coreCollUpdate.add((CoreBaseInfo)partyPaymentBaseInfo);
        }
        if (!this.partyPaymentBaseDeleteSet.isEmpty()) {
            Object[] arraypartyPaymentBaseString = this.partyPaymentBaseDeleteSet.toArray();
            ObjectUuidPK[] pkArray = new ObjectUuidPK[arraypartyPaymentBaseString.length];
            int countCycleSize = arraypartyPaymentBaseString.length;
            for (int i = 0; i < countCycleSize; ++i) {
                Object obj = arraypartyPaymentBaseString[i];
                pkArray[i] = new ObjectUuidPK(BOSUuid.read((String)obj.toString()));
                this.partyPaymentBaseCollection.removeObject(pkArray[i]);
            }
            this.getBizInterface().delete((IObjectPK[])pkArray);
        }
        if (!coreCollAdd.isEmpty()) {
            this.getBizInterface().save(coreCollAdd);
        }
        if (!coreCollUpdate.isEmpty()) {
            this.getBizInterface().update(coreCollUpdate);
        }
        this.loadTableData();
        this.partyPaymentBaseDeleteSet.clear();
    }
}

