/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.core.hr.client.f7.IF7Support;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.hr.base.client.PlugInUIParam;
import com.kingdee.eas.hr.base.client.f7.F7ConfigManager;
import com.kingdee.eas.hr.emp.IPersonCommunist;
import com.kingdee.eas.hr.emp.PersonCommunistCollection;
import com.kingdee.eas.hr.emp.PersonCommunistFactory;
import com.kingdee.eas.hr.emp.PersonCommunistInfo;
import com.kingdee.eas.hr.party.PartyFeeModeEnum;
import com.kingdee.eas.hr.party.PartyPayPerInfo;
import com.kingdee.eas.hr.party.PartyPaymentBaseCollection;
import com.kingdee.eas.hr.party.PartyPaymentBaseFactory;
import com.kingdee.eas.hr.party.PartyPaymentBaseInfo;
import com.kingdee.eas.hr.party.PartyPaymentEntryInfo;
import com.kingdee.eas.hr.party.PartyPaymentFactory;
import com.kingdee.eas.hr.party.PartyPaymentInfo;
import com.kingdee.eas.hr.party.client.AbstractPartyPaymentEditUI;
import com.kingdee.eas.hr.party.client.HRPartyClientUtils;
import com.kingdee.eas.hr.party.client.PartyGroupEmployeeF7PromptBox;
import com.kingdee.eas.hr.party.client.PartyOrgPromptBox;
import com.kingdee.eas.hr.party.client.PartyPrint;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PartyPaymentEditUI
extends AbstractPartyPaymentEditUI {
    protected final String ErrorRES = "com.kingdee.eas.hr.party.PartyCommonException";
    public static final String pubResource = "com.kingdee.eas.hr.party.PartyResource";
    private static final Logger logger = CoreUIObject.getLogger(PartyPaymentEditUI.class);
    private static final String resClassName = "com.kingdee.eas.hr.party.PartyResource";
    protected PartyGroupEmployeeF7PromptBox memberF7 = null;
    protected PlugInUIParam ctx = null;
    protected IUIWindow currOrgTreeDialog;
    protected PartyPaymentBaseCollection paymentBaseList;
    protected PersonCommunistCollection personCommunistList;
    private static String partyPrintID = null;
    private static String printParth = "/HR/state/party/PartyPaymenberBill";
    private static String queryName = "PartyPaymentPrintQuery";
    private static String entryQueryName = "PartyPaymentEntryPrintQuery";
    private static String queryParth = "com.kingdee.eas.hr.party.app";
    private static String entryID = "partyPayment.id";
    protected String orgKeyFieldName = null;

    public PartyPaymentEditUI() throws Exception {
        this.initEmpF7();
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.kdtEntrys.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    PartyPaymentEditUI.this.kdtEntrys_Changed(e.getRowIndex(), e.getColIndex());
                }
                catch (Exception exc) {
                    PartyPaymentEditUI.this.handUIException(exc);
                }
            }
        });
        KDTextField kdtEntrys_payPeriod_TextField = new KDTextField();
        kdtEntrys_payPeriod_TextField.setName("kdtEntrys_payPeriod_TextField");
        kdtEntrys_payPeriod_TextField.setMaxLength(80);
        KDTDefaultCellEditor kdtEntrys_payPeriod_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_payPeriod_TextField);
        this.kdtEntrys.getColumn("payYear").setEditor((ICellEditor)kdtEntrys_payPeriod_CellEditor);
        KDFormattedTextField kdtEntrys_formatted_TextField = new KDFormattedTextField();
        kdtEntrys_formatted_TextField.setName("kdtEntrys_formatted_TextField");
        kdtEntrys_formatted_TextField.setVisible(true);
        kdtEntrys_formatted_TextField.setEditable(true);
        kdtEntrys_formatted_TextField.setDataType(1);
        kdtEntrys_formatted_TextField.setPrecision(2);
        kdtEntrys_formatted_TextField.setDataVerifierType(12);
        kdtEntrys_formatted_TextField.setMaximumValue((Comparable)new BigDecimal(9.999999999E7));
        kdtEntrys_formatted_TextField.setMinimumValue((Comparable)new BigDecimal(0));
        kdtEntrys_formatted_TextField.setSupportedEmpty(true);
        KDTDefaultCellEditor kdtEntrys_formatted_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_formatted_TextField);
        this.kdtEntrys.getColumn("payper").setEditor((ICellEditor)kdtEntrys_formatted_CellEditor);
        this.kdtEntrys.getColumn("payper").getStyleAttributes().setNumberFormat("0.00");
        this.kdtEntrys.getColumn("basePay").setEditor((ICellEditor)kdtEntrys_formatted_CellEditor);
        this.kdtEntrys.getColumn("basePay").getStyleAttributes().setNumberFormat("0.00");
        this.kdtEntrys.getColumn("payAmount").setEditor((ICellEditor)kdtEntrys_formatted_CellEditor);
        this.kdtEntrys.getColumn("payAmount").getStyleAttributes().setNumberFormat("0.00");
        this.kdtEntrys.getColumn("payment").setEditor((ICellEditor)kdtEntrys_formatted_CellEditor);
        this.kdtEntrys.getColumn("payment").getStyleAttributes().setNumberFormat("0.00");
        this.kdtEntrys.getColumn("payMonths").getStyleAttributes().setNumberFormat("0.0");
        KDTextField kdtEntrys_description_TextField = new KDTextField();
        kdtEntrys_description_TextField.setName("kdtEntrys_description_TextField");
        kdtEntrys_description_TextField.setMaxLength(80);
        KDTDefaultCellEditor kdtEntrys_description_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_description_TextField);
        this.kdtEntrys.getColumn("description").setEditor((ICellEditor)kdtEntrys_description_CellEditor);
        PartyOrgPromptBox prmtPo = new PartyOrgPromptBox();
        prmtPo.setIsUsePermission(true);
        this.prmtPartyOrg.setSelector((KDPromptSelector)prmtPo);
        this.btnAttachment.setVisible(true);
        this.prmtPartyOrg.setEditable(false);
        if (this.prmtHROrg.getValue() == null) {
            HROrgUnitInfo hrOrgUnitInfo = SysContext.getSysContext().getCurrentHRUnit();
            this.prmtHROrg.setValue((Object)hrOrgUnitInfo);
        }
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (this.kdtEntrys.getCell(i, "partyfeemode").getValue() == null) continue;
            if (this.kdtEntrys.getCell(i, "partyfeemode").getValue().equals((Object)PartyFeeModeEnum.RATE)) {
                this.kdtEntrys.getCell(i, "payper").getStyleAttributes().setNumberFormat("0.00%");
                continue;
            }
            this.kdtEntrys.getCell(i, "payper").getStyleAttributes().setNumberFormat("0.00");
        }
    }

    public void kdtEntrys_Changed(int rowIndex, int colIndex) throws Exception {
        if ("payMonths".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey())) {
            Object partyfeemode = this.kdtEntrys.getCell(rowIndex, "partyfeemode").getValue();
            if (partyfeemode == null) {
                return;
            }
            BigDecimal decPayPer = new BigDecimal(0);
            BigDecimal decBasePay = new BigDecimal(0);
            BigDecimal decPayMonths = new BigDecimal(0);
            BigDecimal decPayAmount = new BigDecimal(0);
            if (this.kdtEntrys.getCell(rowIndex, "payper") != null && this.kdtEntrys.getCell(rowIndex, "payper").getValue() != null) {
                decPayPer = UIRuleUtil.getBigDecimal((Object)this.kdtEntrys.getCell(rowIndex, "payper").getValue());
            }
            if (this.kdtEntrys.getCell(rowIndex, "basePay").getValue() != null) {
                decBasePay = UIRuleUtil.getBigDecimal((Object)this.kdtEntrys.getCell(rowIndex, "basePay").getValue());
            }
            if (this.kdtEntrys.getCell(rowIndex, "payMonths").getValue() != null) {
                decPayMonths = UIRuleUtil.getBigDecimal((Object)this.kdtEntrys.getCell(rowIndex, "payMonths").getValue());
            }
            decPayAmount = partyfeemode.equals((Object)PartyFeeModeEnum.RATE) ? decPayPer.multiply(decBasePay).multiply(decPayMonths) : decPayPer.multiply(decPayMonths);
            this.kdtEntrys.getCell(rowIndex, "payAmount").setValue((Object)decPayAmount);
            this.kdtEntrys.getCell(rowIndex, "payment").setValue((Object)decPayAmount);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("VIEW".equals(this.getOprtState())) {
            this.btAddLine.setEnabled(false);
            this.btRemoveLine.setEnabled(false);
            this.btInsertLine.setEnabled(false);
        }
        if ("EDIT".equals(this.getOprtState())) {
            this.btAddLine.setEnabled(true);
            this.btRemoveLine.setEnabled(true);
            this.btInsertLine.setEnabled(true);
        }
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.contEntrys.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource", (String)"PayDetail"));
        this.prmtHROrg.setEditable(false);
        this.contEntrys.addButton((JButton)this.btAddLine);
        this.contEntrys.addButton((JButton)this.btInsertLine);
        this.contEntrys.addButton((JButton)this.btRemoveLine);
        this.btAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btAddLine.setEnabled(false);
            this.btRemoveLine.setEnabled(false);
            this.btInsertLine.setEnabled(false);
        } else {
            this.btAddLine.setEnabled(true);
            this.btRemoveLine.setEnabled(true);
            this.btInsertLine.setEnabled(true);
        }
    }

    protected IObjectValue createNewData() {
        PartyPaymentInfo info = new PartyPaymentInfo();
        info.setPayDate(new Date());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PartyPaymentFactory.getRemoteInstance();
    }

    protected void btAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLineByPersonF7(false);
    }

    protected void btInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLineByPersonF7(true);
    }

    protected void btRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        HRPartyClientUtils.removeLine(this.kdtEntrys);
    }

    protected IObjectValue createNewDetailData(PersonInfo personInfo) {
        PartyPaymentEntryInfo info = new PartyPaymentEntryInfo();
        info.setPerson(personInfo);
        if (personInfo.get("primaryAdminOrg") != null) {
            info.setAdminOrg((AdminOrgUnitInfo)personInfo.get("primaryAdminOrg"));
        } else {
            try {
                info.setAdminOrg(HRPartyClientUtils.getNoPositionAdmin(personInfo.getId().toString()));
            }
            catch (Exception e) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.party.PartyCommonException", (String)"GETNOPOSITIONADMINERROR"));
            }
        }
        return info;
    }

    protected void initEmpF7() {
        if (this.memberF7 == null) {
            this.memberF7 = HRPartyClientUtils.initPersonF7(new FilterItemInfo("personCommunist.joinDate", null, CompareType.NOTEQUALS));
            this.memberF7.setIsShowAllAdmin(true);
        }
    }

    public void addLineByPersonF7(boolean isInsert) throws Exception {
        if (this.memberF7 == null) {
            return;
        }
        new F7ConfigManager().apply((IF7Support)this.memberF7);
        this.memberF7.show();
        if (!this.memberF7.isCanceled()) {
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            if (this.memberF7.getData() instanceof Object[]) {
                Object[] obj = (Object[])this.memberF7.getData();
                if (obj == null || obj.length <= 0) {
                    return;
                }
                int size = obj.length;
                for (int i = 0; i < size; ++i) {
                    persons.add((PersonInfo)obj[i]);
                }
            }
            if (this.memberF7.getData() instanceof PersonInfo) {
                persons.add((PersonInfo)this.memberF7.getData());
            }
            this.addLineByPersonList(persons, isInsert);
        }
    }

    public void addLineByPersonList(List persons, boolean isInsert) throws Exception {
        if ((persons = this.getProcessedPersons(persons)) != null) {
            boolean isSelect = false;
            int top = 0;
            boolean isTableColumnSelected = false;
            if (isInsert && this.kdtEntrys.getSelectManager().size() > 0) {
                isSelect = true;
                top = this.kdtEntrys.getSelectManager().get().getTop();
                isTableColumnSelected = this.isTableColumnSelected(this.kdtEntrys);
            }
            IRow row = null;
            int size = persons.size();
            for (int i = 0; i < size; ++i) {
                if (isInsert) {
                    if (isSelect && !isTableColumnSelected) {
                        row = this.kdtEntrys.addRow(top + i);
                    }
                } else {
                    row = this.kdtEntrys.addRow();
                }
                this.addLineByPerson(this.kdtEntrys, row, (PersonInfo)persons.get(i));
            }
        }
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected String getSelectedKeyValue() {
        String keyFiledName = this.orgKeyFieldName == null ? "adminOrg" : this.orgKeyFieldName;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntrys);
        return ListUiHelper.getSelectedKeyValue((int[])selectRows, (KDTable)this.kdtEntrys, (String)keyFiledName);
    }

    protected void addLineByPerson(KDTable table, IRow row, PersonInfo pInfo) throws BOSException {
        PersonCommunistInfo partyInfo;
        if (table == null) {
            return;
        }
        if (row == null) {
            row = table.addRow();
        }
        EntityViewInfo personCommunistViewInfo = new EntityViewInfo();
        FilterInfo personCommunistFilter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        personCommunistFilter.getFilterItems().add(new FilterItemInfo("person", (Object)pInfo.getId(), CompareType.EQUALS));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("partyPayPer.*"));
        personCommunistViewInfo.setSelector(sic);
        personCommunistViewInfo.setFilter(personCommunistFilter);
        IPersonCommunist ipersonCommunist = PersonCommunistFactory.getRemoteInstance();
        PersonCommunistCollection collection = ipersonCommunist.getPersonCommunistCollection(personCommunistViewInfo);
        row.getCell("person").setValue((Object)pInfo);
        row.getCell("person.number").setValue(pInfo.get("number"));
        if (pInfo.get("primaryAdminOrg") != null) {
            row.getCell("adminOrg").setValue((Object)((AdminOrgUnitInfo)pInfo.get("primaryAdminOrg")));
            this.editData.setAdminOrgUnit((AdminOrgUnitInfo)pInfo.get("primaryAdminOrg"));
        } else {
            try {
                row.getCell("adminOrg").setValue((Object)HRPartyClientUtils.getNoPositionAdmin(pInfo.getId().toString()));
                this.editData.setAdminOrgUnit(HRPartyClientUtils.getNoPositionAdmin(pInfo.getId().toString()));
            }
            catch (Exception e) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.party.PartyCommonException", (String)"GETNOPOSITIONADMINERROR"));
            }
        }
        if (collection.size() > 0 && (partyInfo = collection.get(0)).getPartyPayPer() != null) {
            PartyPayPerInfo payPer = partyInfo.getPartyPayPer();
            row.getCell("partyPayper").setValue((Object)payPer);
            row.getCell("partyfeemode").setValue((Object)payPer.getPartyfeemode());
            if (payPer.getPartyfeemode() != null) {
                if (payPer.getPartyfeemode().equals((Object)PartyFeeModeEnum.RATION)) {
                    row.getCell("payper").getStyleAttributes().setNumberFormat("0.00");
                } else {
                    row.getCell("payper").getStyleAttributes().setNumberFormat("0.00%");
                }
            }
            row.getCell("payper").setValue((Object)payPer.getPayper());
        }
        String oql = "select basePay where person.id = '" + pInfo.getId().toString() + "'";
        PartyPaymentBaseCollection partyPaymentBaseCol = PartyPaymentBaseFactory.getRemoteInstance().getPartyPaymentBaseCollection(oql);
        if (partyPaymentBaseCol.size() > 0) {
            PartyPaymentBaseInfo partyPaymentBase = partyPaymentBaseCol.get(0);
            if (partyPaymentBase == null) {
                row.getCell("basePay").setValue((Object)new BigDecimal(0));
            } else {
                row.getCell("basePay").setValue((Object)partyPaymentBase.getBasePay());
            }
        }
        row.getCell("payMonths").setValue((Object)new BigDecimal(0));
        row.getCell("payAmount").setValue((Object)new BigDecimal(0));
        row.getCell("payment").setValue((Object)new BigDecimal(0));
    }

    public static void checkHasInputRows(KDTable kdt) throws Exception {
        if (kdt.getRowCount() != 0) {
            return;
        }
        MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource", (String)"entrys") + EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource", (String)"CanNotBeNull")));
        SysUtil.abort();
    }

    public static void checkHasInputRows(KDTable kdt, ArrayList columns) throws Exception {
        PartyPaymentEditUI.checkHasInputRows(kdt);
        int colCount = columns.size();
        int rowCount = kdt.getRowCount();
        IRow row = null;
        Object value = null;
        for (int i = 0; i < rowCount; ++i) {
            row = kdt.getRow(i);
            for (int j = 0; j < colCount; ++j) {
                if (columns.get(j) == null || row.getCell(columns.get(j).toString()) == null) continue;
                value = row.getCell(columns.get(j).toString()).getValue();
                if (value == null || value instanceof String && value.toString().trim().equals("")) {
                    kdt.getSelectManager().select(i, j);
                    MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource", (String)"several") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource", (String)"row") + PartyPaymentEditUI.getColumnStrs(kdt, columns, j) + EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource", (String)"CanNotBeNull")));
                    SysUtil.abort();
                }
                if (row.getCell("description").getValue() == null || row.getCell("description").getValue().toString().length() <= 80) continue;
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource", (String)"several") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource", (String)"row") + kdt.getHeadRow(0).getCell("description").getValue().toString() + EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource", (String)"characterLength")));
                SysUtil.abort();
            }
        }
    }

    public static String getColumnStrs(KDTable kdt, ArrayList columns, int j) {
        String colStr = "";
        colStr = PartyPaymentEditUI.getColumnAlias(kdt, columns.get(j).toString());
        return colStr;
    }

    public static String getColumnAlias(KDTable kdt, String colName) {
        Object value = kdt.getHeadRow(0).getCell(colName).getValue();
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    protected List getProcessedPersons(List persons) throws Exception {
        return persons;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.prmtHROrg.getValue() == null) {
            HROrgUnitInfo hrOrgUnitInfo = SysContext.getSysContext().getCurrentHRUnit();
            this.prmtHROrg.setValue((Object)hrOrgUnitInfo);
        }
        this.verifyInput();
        PartyPaymentEditUI.checkHasInputRows(this.kdtEntrys, this.getNoNullColumns());
        super.beforeStoreFields(e);
    }

    protected ArrayList getNoNullColumns() {
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("payMonths");
        cols.add("payment");
        return cols;
    }

    private void verifyInput() {
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.prmtPartyOrg);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.pkpayDate);
        HRPartyClientUtils.verifyEmpty((CoreUIObject)this, this.kdtEntrys);
        HRPartyClientUtils.checkPersonDup((CoreUIObject)this, this.kdtEntrys, "person");
        String[] entryKsys = new String[]{"payment"};
        HRPartyClientUtils.verifyEntryEmpty(this.kdtEntrys, entryKsys);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.setButton();
    }

    public void actionEdit_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionEdit_actionPerformed(arg0);
        this.setButton();
    }

    private void setButton() {
        this.btAddLine.setEnabled(true);
        this.btInsertLine.setEnabled(true);
        this.btRemoveLine.setEnabled(true);
    }

    public void actionBatchPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null | this.isModify()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource", (String)"SaveBeforePrint"));
            SysUtil.abort();
        } else {
            partyPrintID = this.editData.getId().toString();
            PartyPrint.executePrint(partyPrintID, (Component)((Object)this), printParth, queryName, entryQueryName, queryParth, entryID);
        }
    }

    protected void MenuItemBatchPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null | this.isModify()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.party.PartyResource", (String)"SaveBeforePrint"));
            SysUtil.abort();
        } else {
            partyPrintID = this.editData.getId().toString();
            PartyPrint.executePrint(partyPrintID, (Component)((Object)this), printParth, queryName, entryQueryName, queryParth, entryID);
        }
    }
}

