/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.party.LaborUintFactory;
import com.kingdee.eas.hr.party.LaborUintInfo;
import com.kingdee.eas.hr.party.MemOrgBillFactory;
import com.kingdee.eas.hr.party.MemOrgBillInfo;
import com.kingdee.eas.hr.party.PartyOrgFactory;
import com.kingdee.eas.hr.party.PartyOrgInfo;
import com.kingdee.eas.hr.party.PartyOrgMappingPartyJobFactory;
import com.kingdee.eas.hr.party.client.AbstractPartyPermissionSetUI;
import com.kingdee.eas.hr.party.client.PartyPermissionListUI;
import com.kingdee.eas.hr.party.client.PartyUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class PartyPermissionSetUI
extends AbstractPartyPermissionSetUI {
    private static final Logger logger = CoreUIObject.getLogger(PartyPermissionSetUI.class);
    private ITreeBase treeBase = PartyOrgFactory.getRemoteInstance();
    private KDTreeNode treeNode = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(2);
        PartyUtils.enableTableHeadSortNotNeedSortManager(this.tblMain, 0, this.tblMain.getRowCount() - 1, new KDTSortManager(this.tblMain));
        if (this.getSelectedTreeNode() != null) {
            this.treeMain.expandAllNodes(true, (TreeNode)this.getSelectedTreeNode());
        }
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return this.treeBase;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected FilterInfo getDefaultFilterForTree() {
        return null;
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.tblMain.removeRows();
        this.initTree();
        this.treeMain.setSelectionRow(0);
        if (this.getSelectedTreeNode() != null) {
            this.treeMain.expandAllNodes(true, (TreeNode)this.getSelectedTreeNode());
        }
        this.treeMain_valueChanged(null);
        super.refresh(e);
    }

    protected void rdoParty_stateChanged(ChangeEvent e) throws Exception {
        this.treeBase = PartyOrgFactory.getRemoteInstance();
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app.PersonCommunistQuery");
        this.refresh(null);
    }

    protected void rdoMember_stateChanged(ChangeEvent e) throws Exception {
        this.treeBase = MemOrgBillFactory.getRemoteInstance();
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.party.app.MemberInfoQuery");
        this.refresh(null);
    }

    protected void rdoUnion_stateChanged(ChangeEvent e) throws Exception {
        this.treeBase = LaborUintFactory.getRemoteInstance();
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.party.app.UnionMemberQuery");
        this.refresh(null);
    }

    protected void chkChildOrgPerson_stateChanged(ChangeEvent e) throws Exception {
        this.treeMain_valueChanged(null);
    }

    protected void chkShowPartyJobPerson_stateChanged(ChangeEvent e) throws Exception {
        this.treeMain_valueChanged(null);
    }

    public void actionViewAndSetPermission_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext();
        int[] selectRowCount = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String personId = this.tblMain.getRow(selectRowCount[0]).getCell("personId").getValue().toString();
        uiContext.put((Object)"personId", (Object)personId);
        if (this.rdoParty.isSelected()) {
            uiContext.put((Object)"ORGTYPE", (Object)"PartyOrg");
        } else if (this.rdoMember.isSelected()) {
            uiContext.put((Object)"ORGTYPE", (Object)"MemOrg");
        } else if (this.rdoUnion.isSelected()) {
            uiContext.put((Object)"ORGTYPE", (Object)"UnionOrg");
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PartyPermissionListUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.refresh(e);
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.treeNode == null) {
            return;
        }
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        if (this.mainQueryPK != null) {
            try {
                IQueryExecutor exec = this.getQueryExecutor(this.mainQueryPK, this.mainQuery);
                IRowSet rowSet = exec.executeQuery();
                this.loadTableValue(rowSet);
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        }
    }

    private void loadTableValue(IRowSet rowSet) throws SQLException, EASBizException, BOSException {
        this.tblMain.removeRows();
        IRow row = null;
        StringBuffer personId = new StringBuffer();
        while (rowSet.next()) {
            personId.append("'" + rowSet.getString("person.id") + "',");
        }
        if (personId.length() == 0) {
            return;
        }
        HashMap adminMap = PartyOrgMappingPartyJobFactory.getRemoteInstance().getAdminByPersonId(personId.toString().substring(0, personId.toString().length() - 1));
        rowSet.beforeFirst();
        while (rowSet.next()) {
            row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)rowSet.getString("id"));
            row.getCell("personId").setValue((Object)rowSet.getString("person.id"));
            row.getCell("personNumber").setValue((Object)rowSet.getString("person.number"));
            row.getCell("personName").setValue((Object)rowSet.getString("person.name"));
            row.getCell("partyOrg").setValue((Object)rowSet.getString("partyOrg.name"));
            row.getCell("adminOrg").setValue((Object)((AdminOrgUnitInfo)adminMap.get(rowSet.getString("person.id"))).getName());
            row.getCell("partyJob").setValue((Object)rowSet.getString("partyJob.name"));
            row.getCell("permissionState").setValue((Object)rowSet.getBoolean("permissionState"));
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.treeNode = this.getSelectedTreeNode();
        this.mainQuery = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.treeNode == null) {
            return;
        }
        if (this.treeNode.getUserObject() instanceof PartyOrgInfo) {
            PartyOrgInfo poInfo = (PartyOrgInfo)this.treeNode.getUserObject();
            filter.getFilterItems().add(new FilterItemInfo("partyOrg.id", (Object)poInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("transDate is not null"));
            if (this.chkChildOrgPerson.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("partyOrg.longNumber", (Object)(poInfo.getLongNumber() + "!%"), CompareType.LIKE));
                if (this.chkShowPartyJobPerson.isSelected()) {
                    filter.getFilterItems().add(new FilterItemInfo("partyJob.id is not null"));
                    filter.setMaskString("(#0 or #2) and #1 and #3");
                } else {
                    filter.setMaskString("(#0 or #2) and #1");
                }
            } else if (this.chkShowPartyJobPerson.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("partyJob.id is not null"));
                filter.setMaskString("#0 and #1 and #2");
            } else {
                filter.setMaskString("#0 and #1");
            }
        } else if (this.treeNode.getUserObject() instanceof MemOrgBillInfo) {
            MemOrgBillInfo moInfo = (MemOrgBillInfo)this.treeNode.getUserObject();
            filter.getFilterItems().add(new FilterItemInfo("memOrg.id", (Object)moInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("joinDate is not null"));
            if (this.chkChildOrgPerson.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("memOrg.longNumber", (Object)(moInfo.getLongNumber() + "!%"), CompareType.LIKE));
                if (this.chkShowPartyJobPerson.isSelected()) {
                    filter.getFilterItems().add(new FilterItemInfo("memJob.id is not null"));
                    filter.setMaskString("(#0 or #2) and #1 and #3");
                } else {
                    filter.setMaskString("(#0 or #2) and #1");
                }
            } else if (this.chkShowPartyJobPerson.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("memJob.id is not null"));
                filter.setMaskString("#0 and #1 and #2");
            } else {
                filter.setMaskString("#0 and #1");
            }
        } else if (this.treeNode.getUserObject() instanceof LaborUintInfo) {
            LaborUintInfo luInfo = (LaborUintInfo)this.treeNode.getUserObject();
            filter.getFilterItems().add(new FilterItemInfo("belongUnit.id", (Object)luInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("checkInDate is not null"));
            if (this.chkChildOrgPerson.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("belongUnit.longNumber", (Object)(luInfo.getLongNumber() + "!%"), CompareType.LIKE));
                if (this.chkShowPartyJobPerson.isSelected()) {
                    filter.getFilterItems().add(new FilterItemInfo("laborUnionJob.id is not null"));
                    filter.setMaskString("(#0 or #2) and #1 and #3");
                } else {
                    filter.setMaskString("(#0 or #2) and #1");
                }
            } else if (this.chkShowPartyJobPerson.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("laborUnionJob.id is not null"));
                filter.setMaskString("#0 and #1 and #2");
            } else {
                filter.setMaskString("#0 and #1");
            }
        }
        this.mainQuery.setFilter(filter);
        this.tblMain_doRequestRowSet(null);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }
}

