/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.client.chart;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.hr.party.client.chart.DrawLaborUnit;
import com.kingdee.eas.hr.party.client.chart.LaborUnitChartNodeInfo;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.tree.DefaultMutableTreeNode;

public class LaborUnitDrawingPanel
extends KDPanel {
    private DefaultMutableTreeNode root = null;
    private DrawLaborUnit drawLaborUnit = null;
    public LaborUnitChartNodeInfo selLaborUnit = null;
    private LaborUnitChartNodeInfo currLaborUnit = null;
    private int translateX = 0;
    private int translateY = 0;
    public Color rectLineColor = new Color(0x9E9E9E);
    public Color currRectLineColor = new Color(14581776);
    public Color selRectLineColor = new Color(14588434);
    public Color orgRectColor = new Color(13296622);
    public Color currOrgRectColor = new Color(16247737);
    public Color selOrgRectColor = new Color(15653292);
    public Color otherRectColor = new Color(0xFFFFFF);
    public Color selOtherRectColor = new Color(16314050);
    public Color textColor = Color.BLACK;
    public Color separateLineColor = new Color(0xE6E6E6);
    public Color selSeparateLineColor = new Color(15653292);
    public Color lineColor = new Color(4145719);
    public Color currOtherRectColor = new Color(0xFFFFFF);
    public Color currSeparateLineColor = new Color(0xE6E6E6);
    public Color noPPBackgroudColor = new Color(0xD9D9D0);
    public Color bgColor = new Color(0xD9D9D0);
    private Point startPoint = null;
    private Point endPoint = null;
    private boolean finded = false;

    public void setRoot(DefaultMutableTreeNode root) {
        this.root = root;
    }

    public void clearSelectNode() {
        this.selLaborUnit = null;
        this.currLaborUnit = null;
    }

    public void setDrawingPaneSize(int maxX, int maxY) {
        this.setPreferredSize(new Dimension(maxX + 30, maxY + 30));
        this.translateX = 0;
        this.translateY = 0;
        if (maxX < this.drawLaborUnit.getWidth()) {
            this.translateX = (this.drawLaborUnit.getWidth() - maxX) / 2;
        }
    }

    public LaborUnitDrawingPanel(DrawLaborUnit drawLaborUnit) {
        this.drawLaborUnit = drawLaborUnit;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.setBackground(this.bgColor);
        g2.translate(this.translateX, this.translateY);
        if (this.root != null) {
            this.drawOrgNode(g2, this.root);
            g2.setColor(this.lineColor);
            this.drawOrgUnitLineH(g2, this.root);
        }
    }

    private void drawOrgUnit(Graphics2D g2, LaborUnitChartNodeInfo laborUnitChartNode) {
        Color tempRectLineColor = null;
        Color tempOrgRectColor = null;
        Color tempTextColor = this.textColor;
        Color tempOtherRectColor = null;
        Color tempSeparateLineColor = null;
        if (laborUnitChartNode.isMain || laborUnitChartNode.isCurrent) {
            tempRectLineColor = this.currRectLineColor;
            tempOrgRectColor = this.currOrgRectColor;
            tempOtherRectColor = this.currOtherRectColor;
            tempSeparateLineColor = this.currSeparateLineColor;
        } else if (laborUnitChartNode.isSelected) {
            tempRectLineColor = this.selRectLineColor;
            tempOrgRectColor = this.selOrgRectColor;
            tempOtherRectColor = this.selOtherRectColor;
            tempSeparateLineColor = this.selSeparateLineColor;
        } else {
            tempRectLineColor = this.rectLineColor;
            tempOrgRectColor = this.orgRectColor;
            tempOtherRectColor = this.noPPBackgroudColor;
            tempSeparateLineColor = this.separateLineColor;
        }
        laborUnitChartNode.rect = new Rectangle((int)laborUnitChartNode.X, (int)laborUnitChartNode.Y, (int)laborUnitChartNode.width, (int)laborUnitChartNode.height);
        g2.setColor(tempOrgRectColor);
        g2.fillRoundRect((int)laborUnitChartNode.X, (int)laborUnitChartNode.Y, (int)laborUnitChartNode.width, (int)laborUnitChartNode.height, 10, 10);
        g2.setColor(tempTextColor);
        int length = 0;
        if (StringUtils.isEmpty((String)laborUnitChartNode.name)) {
            length = 0;
            g2.drawString("", (int)laborUnitChartNode.X + ((int)laborUnitChartNode.width - length) / 2, (int)laborUnitChartNode.Y + 15);
        } else {
            length = g2.getFontMetrics().stringWidth(laborUnitChartNode.name);
            g2.drawString(laborUnitChartNode.name, (int)laborUnitChartNode.X + ((int)laborUnitChartNode.width - length) / 2, (int)laborUnitChartNode.Y + 15);
        }
        if (this.drawLaborUnit.showInsideJob) {
            g2.setColor(Color.WHITE);
            g2.fillRoundRect((int)laborUnitChartNode.X, (int)laborUnitChartNode.Y + 20, (int)laborUnitChartNode.width, 20, 10, 10);
            g2.fillRect((int)laborUnitChartNode.X, (int)laborUnitChartNode.Y + 20, (int)laborUnitChartNode.width, 20);
            g2.setColor(tempTextColor);
            if (laborUnitChartNode.chiefPosition != null) {
                if (StringUtils.isEmpty((String)laborUnitChartNode.chiefPosition.getLaborUnitPosition().getName())) {
                    length = 0;
                    g2.drawString("", (int)laborUnitChartNode.X + ((int)laborUnitChartNode.width - length) / 2, (int)laborUnitChartNode.Y + 35);
                } else {
                    String displayTxt = null;
                    displayTxt = laborUnitChartNode.chiefPosition.getEmployeeName() == null ? laborUnitChartNode.chiefPosition.getLaborUnitPosition().getName() : laborUnitChartNode.chiefPosition.getLaborUnitPosition().getName() + ":" + laborUnitChartNode.chiefPosition.getEmployeeName().getName();
                    length = g2.getFontMetrics().stringWidth(displayTxt);
                    g2.drawString(displayTxt, (int)laborUnitChartNode.X + ((int)laborUnitChartNode.width - length) / 2, (int)laborUnitChartNode.Y + 35);
                }
            }
        }
        g2.setColor(tempRectLineColor);
        g2.drawRoundRect((int)laborUnitChartNode.X, (int)laborUnitChartNode.Y, (int)laborUnitChartNode.width, (int)laborUnitChartNode.height, 10, 10);
    }

    private void drawOrgNode(Graphics2D g2, DefaultMutableTreeNode node) {
        if (node.getLevel() - this.drawLaborUnit.baseLevel + 1 > this.drawLaborUnit.chooseLevel && this.drawLaborUnit.chartType == 0) {
            return;
        }
        LaborUnitChartNodeInfo laborUnitChartNode = (LaborUnitChartNodeInfo)node.getUserObject();
        this.drawOrgUnit(g2, laborUnitChartNode);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.drawOrgNode(g2, (DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    private void drawOrgUnitLineH(Graphics2D g, DefaultMutableTreeNode node) {
        if (node.getLevel() - this.drawLaborUnit.baseLevel + 1 > this.drawLaborUnit.chooseLevel && this.drawLaborUnit.chartType == 0) {
            return;
        }
        if ((node.getLevel() - this.drawLaborUnit.baseLevel + 1 < this.drawLaborUnit.chooseLevel || this.drawLaborUnit.chartType == 1) && node.getChildCount() == 1) {
            this.startPoint = this.getStartPointH(node);
            this.endPoint = new Point();
            this.endPoint.x = this.startPoint.x;
            this.endPoint.y = this.startPoint.y + 40;
            g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            this.drawOrgUnitLineH(g, (DefaultMutableTreeNode)node.getLastChild());
        } else if ((node.getLevel() - this.drawLaborUnit.baseLevel + 1 < this.drawLaborUnit.chooseLevel || this.drawLaborUnit.chartType == 1) && node.getChildCount() > 1) {
            this.startPoint = this.getStartPointH(node);
            this.endPoint = new Point();
            this.endPoint.x = this.startPoint.x;
            this.endPoint.y = this.startPoint.y + 20;
            g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            DefaultMutableTreeNode lastChildNode = (DefaultMutableTreeNode)node.getLastChild();
            DefaultMutableTreeNode firstChildNode = (DefaultMutableTreeNode)node.getFirstChild();
            LaborUnitChartNodeInfo startOrg = (LaborUnitChartNodeInfo)firstChildNode.getUserObject();
            LaborUnitChartNodeInfo endOrg = (LaborUnitChartNodeInfo)lastChildNode.getUserObject();
            g.drawLine((int)(startOrg.X + startOrg.width / 2.0f), (int)(startOrg.Y - 20.0f), (int)(endOrg.X + endOrg.width / 2.0f), (int)(endOrg.Y - 20.0f));
            for (int i = 0; i < node.getChildCount(); ++i) {
                lastChildNode = (DefaultMutableTreeNode)node.getChildAt(i);
                this.endPoint = this.getEndPointH(lastChildNode);
                this.startPoint.x = this.endPoint.x;
                this.startPoint.y = this.endPoint.y - 20;
                g.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
                this.drawOrgUnitLineH(g, lastChildNode);
            }
        }
    }

    private Point getStartPointH(DefaultMutableTreeNode node) {
        Point point = new Point();
        LaborUnitChartNodeInfo laborUnitChartNode = (LaborUnitChartNodeInfo)node.getUserObject();
        point.x = (int)(laborUnitChartNode.X + laborUnitChartNode.width / 2.0f);
        point.y = (int)(laborUnitChartNode.Y + laborUnitChartNode.height);
        return point;
    }

    private Point getEndPointH(DefaultMutableTreeNode node) {
        Point point = new Point();
        LaborUnitChartNodeInfo laborUnitChartNode = (LaborUnitChartNodeInfo)node.getUserObject();
        point.x = (int)(laborUnitChartNode.X + laborUnitChartNode.width / 2.0f);
        point.y = (int)laborUnitChartNode.Y;
        return point;
    }
}

