/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluResultInfo;
import com.kingdee.eas.hr.perf.NDSolutionTableInfo;
import com.kingdee.eas.hr.perf.SumResultInfo;

public class NDSolutionTableFactory {
    private static NDSolutionTableFactory instance;
    private static final BOSObjectType EVALURESULT_BOSTYPE;
    private static final BOSObjectType SUMRESULT_BOSTYPE;

    private NDSolutionTableFactory() {
    }

    public static NDSolutionTableFactory getInstance() {
        if (instance == null) {
            instance = new NDSolutionTableFactory();
        }
        return instance;
    }

    public NDSolutionTableInfo getTableInfo(Context ctx, BOSUuid bosUuid) throws EASBizException, BOSException {
        if (bosUuid == null) {
            return null;
        }
        NDSolutionTableInfo tableInfo = null;
        if (EVALURESULT_BOSTYPE.equals((Object)bosUuid.getType())) {
            EvaluObjectTypeEnum type = this.getEvaluObjectType(ctx, bosUuid);
            if (type != null) {
                tableInfo = this.getEvaluResultTableInfo(type);
            }
        } else if (SUMRESULT_BOSTYPE.equals((Object)bosUuid.getType())) {
            tableInfo = this.getSumResultTableInfo();
        }
        return tableInfo;
    }

    private EvaluObjectTypeEnum getEvaluObjectType(Context ctx, BOSUuid bosUuid) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("evaluObject.evaluObjectType"));
        EvaluResultInfo resultInfo = EvaluResultFactory.getLocalInstance(ctx).getEvaluResultInfo((IObjectPK)new ObjectUuidPK(bosUuid.toString()), sic);
        return resultInfo.getEvaluObject().getEvaluObjectType();
    }

    private NDSolutionTableInfo getEvaluResultTableInfo(EvaluObjectTypeEnum type) {
        NDSolutionTableInfo evaluResultTableInfo = new NDSolutionTableInfo();
        evaluResultTableInfo.setTableName("T_PF_EvaluResult");
        evaluResultTableInfo.setTargetScore("FTargetEvaluScore");
        evaluResultTableInfo.setModifiedScore("FModifiedScore");
        evaluResultTableInfo.setRank("FPerfRankID");
        StringBuffer sql = new StringBuffer();
        sql.append("select result.FID as FID, result.FTargetEvaluScore as FTargetEvaluScore, result.FModifiedScore as FModifiedScore, obj.FNumber as objectNumber");
        sql.append(" from T_PF_EvaluResult as result");
        sql.append(" inner join T_PF_EvaluObject as evaluObject on evaluObject.FID = result.FEvaluObjectID");
        sql.append(" inner join ");
        if (EvaluObjectTypeEnum.PERSON.equals((Object)type)) {
            sql.append("T_BD_Person");
        } else if (EvaluObjectTypeEnum.ORGUNIT.equals((Object)type)) {
            sql.append("T_ORG_Admin");
        }
        sql.append(" as obj on obj.FID = evaluObject.FObjectID");
        evaluResultTableInfo.setQuerySQL(sql.toString());
        evaluResultTableInfo.setObjectNumber("objectNumber");
        return evaluResultTableInfo;
    }

    private NDSolutionTableInfo getSumResultTableInfo() {
        NDSolutionTableInfo sumResultTableInfo = new NDSolutionTableInfo();
        sumResultTableInfo.setTableName("T_PF_SumResult");
        sumResultTableInfo.setTargetScore("FScore");
        sumResultTableInfo.setModifiedScore("FModifyScore");
        sumResultTableInfo.setRank("FRankID");
        StringBuffer sql = new StringBuffer();
        sql.append("select result.FID as FID, result.FScore as FScore, result.FModifyScore as FModifyScore, obj.FNumber as objectNumber");
        sql.append(" from T_PF_SumResult as result");
        sql.append(" inner join T_PF_SumPerson as sumPerson on sumPerson.FID = result.FSumPersonID");
        sql.append(" inner join ");
        sql.append("T_BD_Person");
        sql.append(" as obj on obj.FID = sumPerson.FPersonID");
        sumResultTableInfo.setQuerySQL(sql.toString());
        sumResultTableInfo.setObjectNumber("objectNumber");
        return sumResultTableInfo;
    }

    static {
        EVALURESULT_BOSTYPE = new EvaluResultInfo().getBOSType();
        SUMRESULT_BOSTYPE = new SumResultInfo().getBOSType();
    }
}

