/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.sso.ltpa.ConfigurationError;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class PerfUtils {
    public static final String PERSON = "personid";
    public static final String ERRORMSG = "errorMsg";
    public static final String SEPERATOR = "\n";
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final String HR_PERF_001 = "hr_perf_001";
    public static final String HR_PERF_003 = "hr_perf_003";
    public static final String SOLUTIONPERIODID = "solutionPeriodID";
    public static final String EVALUOBJECTID = "evaluObjectID";
    public static final String EVALUERID = "evaluerID";

    public static Date getDateBefore() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        calendar.setTimeInMillis(calendar.getTimeInMillis() - 1800000L);
        return calendar.getTime();
    }

    public static PositionInfo getPositionInfo(Context ctx, String id) throws Exception {
        if (id == null) {
            return null;
        }
        PositionInfo positionInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)id));
        fi.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)new Integer(1)));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("position.name"));
        CoreBaseCollection coll = PositionMemberFactory.getLocalInstance((Context)ctx).getCollection(evi);
        if (coll.size() != 0) {
            positionInfo = ((PositionMemberInfo)coll.get(0)).getPosition();
        }
        return positionInfo;
    }

    public static String formatBigDecimal(BigDecimal value, int precicion) {
        if (PerfUtils.objectIsNull(value)) {
            return "";
        }
        String str = ZERO.compareTo(value) == 0 ? "0.00000000000000000000000" : value.toString();
        if (str.lastIndexOf(".") == -1) {
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(str);
            strBuffer.append(".");
            for (int i = 0; i < precicion; ++i) {
                strBuffer.append("0");
            }
            return strBuffer.toString();
        }
        if (str.lastIndexOf(".") == str.length() - 2) {
            return str + "0";
        }
        int len = str.lastIndexOf(".") + 1 + precicion;
        return str.substring(0, len);
    }

    public static boolean objectIsNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return StringUtils.isEmpty((String)obj.toString());
        }
        return false;
    }

    public static String getWebStringValue(IRowSet rowSet, String key) throws Exception {
        if (rowSet.getString(key) != null && rowSet.getString(key).length() > 0) {
            return rowSet.getString(key);
        }
        return "&nbsp;";
    }

    public static String getWebBigDecimalStringValue(IRowSet rowSet, String key) throws Exception {
        if (rowSet.getBigDecimal(key) != null) {
            return PerfUtils.formatBigDecimal(rowSet.getBigDecimal(key), 2);
        }
        return "&nbsp;";
    }

    public static String getStrFromList(List list) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("')");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append((String)list.get(i));
            sb.append("')");
        }
        return sb.toString();
    }

    public static SelectorItemCollection getSic(String[] columns) {
        SelectorItemCollection sic = new SelectorItemCollection();
        for (int i = 0; i < columns.length; ++i) {
            sic.add(new SelectorItemInfo(columns[i]));
        }
        return sic;
    }

    public static int subTwoDate(Date edate, Date sdate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdate);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long slong = cal.getTimeInMillis();
        cal.setTime(edate);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long elong = cal.getTimeInMillis();
        int days = (int)((elong - slong) / 86400000L);
        return days / 365;
    }

    public static boolean isNotEq(Object o1, Object o2) {
        if (o1 != null && o2 != null && !o1.equals(o2)) {
            return true;
        }
        if (o1 == null && o2 != null) {
            return true;
        }
        return o2 == null && o1 != null;
    }

    public static boolean getParamValue(Context ctx, String id) throws EASBizException, BOSException {
        String hrOrgId = null;
        String paramValue = null;
        if (ctx == null) {
            return false;
        }
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            return false;
        }
        hrOrgId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(hrOrgId), (String)id);
        return TypeConversionUtils.objToBoolean((Object)paramValue);
    }

    public static HashSet getHRRange(Context ctx) throws BOSException, EASBizException {
        String userID = PerfUtils.getCurrentUserId(ctx);
        String sql = PerfUtils.getHRRangeByUserId(userID);
        HashSet<String> set = new HashSet<String>();
        IRowSet rows = null;
        rows = ctx != null ? DbUtil.executeQuery((Context)ctx, (String)sql.toString()) : SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        if (rows != null) {
            try {
                while (rows.next()) {
                    set.add(rows.getString("forgId"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return set;
    }

    private static String getCurrentUserId(Context ctx) {
        String userID = null;
        userID = ctx != null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        return userID;
    }

    public static String getHRRangeByUserId(String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("select orgRange.forgId as forgId from T_PM_OrgRange orgRange ");
        sql.append("where orgRange.ftype = ");
        sql.append(10);
        sql.append(" and fuserid = '");
        sql.append(userID);
        sql.append("' ");
        return sql.toString();
    }

    public static FilterItemInfo getAdminRangeFilterItemInfo(Context ctx, String orgID) {
        String sql = PerfUtils.getAdminRangeSql(ctx);
        FilterItemInfo item = new FilterItemInfo(orgID, (Object)sql, CompareType.INNER);
        return item;
    }

    public static String getAdminRangeSql(Context ctx) {
        String userID = PerfUtils.getCurrentUserId(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID in (");
        sql.append(PerfUtils.getHRRangeByUserId(userID));
        sql.append(") AND FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND FType = ");
        sql.append(20);
        sql.append(")");
        return sql.toString();
    }

    public static HashMap getSubordinateByPrimaryPosition(String hierarchyId, HashSet personIdSet) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierarchyId));
        fi.getFilterItems().add(new FilterItemInfo("PM2.isPrimary", (Object)Boolean.TRUE));
        fi.getFilterItems().add(new FilterItemInfo("Person2.id", (Object)personIdSet, CompareType.INCLUDE));
        fi.setMaskString("#0 and #1 and #2");
        viewInfo.setFilter(fi);
        return PerfUtils.getRowSet("com.kingdee.eas.hr.base.app.PersonSubordinateQuery", viewInfo);
    }

    public static HashMap getSubordinate(String hierarchyId, HashSet personIdSet) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierarchyId));
        fi.getFilterItems().add(new FilterItemInfo("Person2.id", (Object)personIdSet, CompareType.INCLUDE));
        fi.setMaskString("#0 and #1");
        viewInfo.setFilter(fi);
        return PerfUtils.getRowSet("com.kingdee.eas.hr.base.app.PersonSubordinateQuery", viewInfo);
    }

    private static HashMap getRowSet(String queryName, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK(queryName);
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        HashMap personMap = new HashMap();
        try {
            String person = null;
            String person2 = null;
            HashSet<String> personSet = null;
            while (rows.next()) {
                person = rows.getString("id");
                person2 = rows.getString("Person2.id");
                personSet = (HashSet<String>)personMap.get(person2);
                if (personSet == null) {
                    personSet = new HashSet<String>();
                }
                if (person.equals(person2)) continue;
                personSet.add(person);
                personMap.put(person2, personSet);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return personMap;
    }

    public static String convertSetToString(Set set) {
        if (set == null || set.size() <= 0) {
            return "''";
        }
        Iterator iter = set.iterator();
        StringBuffer sql = new StringBuffer();
        while (iter.hasNext()) {
            sql.append("'");
            sql.append(iter.next());
            sql.append("',");
        }
        sql.deleteCharAt(sql.length() - 1);
        return sql.toString();
    }

    public static Set getAdminRangeSet(Context ctx) throws EASBizException, BOSException {
        String sql = PerfUtils.getAdminRangeSql(ctx);
        HashSet<String> orgIds = new HashSet<String>();
        IRowSet row = ctx != null ? DbUtil.executeQuery((Context)ctx, (String)sql) : SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        try {
            while (row.next()) {
                orgIds.add(row.getString("FFromUnitID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return orgIds;
    }

    public static void promptInfo(String path, String item) {
        MsgBox.showInfo((String)EASResource.getString((String)path, (String)item));
        SysUtil.abort();
    }

    public static void setKDTableSortable(KDTable table) {
        KDTSortManager sm = new KDTSortManager(table);
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            table.getColumn(i).setSortable(true);
        }
        sm.setSortAuto(true);
    }

    public static String getNumberFormatString(int precicion) {
        StringBuffer sb = new StringBuffer("0");
        for (int i = 0; i < precicion; ++i) {
            if (i == 0) {
                sb.append(".");
            }
            sb.append("0");
        }
        return sb.toString();
    }

    public static boolean autoFitRowHeight(KDTable table, int rowIndex, int extend, boolean isHead, int rowMaxHeight) {
        Object rows = null;
        rows = isHead ? table.getHead() : table.getBody();
        KDTColumns cols = table.getColumns();
        KDTRow row = rows.getRow(rowIndex);
        if (row == null || !row.isResizeable() || row.getStyle().isHided()) {
            return false;
        }
        int maxHeight = 0;
        int rowHeight = rows.getRowHeight(rowIndex);
        int defaultHeight = isHead ? table.getDefaultHeadRowHeight() : table.getDefaultRowHeight();
        int colCount = table.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            IBasicRender render;
            Object obj;
            KDTCell cell = row.getCell(i);
            if (cell == null) continue;
            Object object = obj = isHead ? cell.getValue() : table.getCellDisplayText(cell, rowIndex, i);
            if (obj == null) continue;
            IBasicRender iBasicRender = render = isHead ? table.getHeadCellRenderer(rowIndex, i) : table.getCellRenderer(rowIndex, i);
            if (!(render instanceof CellTextRender)) continue;
            CellTextRender textRender = (CellTextRender)render;
            Rectangle rect = new Rectangle(0, 0, cols.getColumnWidth(i) - 6, rowHeight);
            int h = (int)textRender.getPreferredHeight(table.getGraphics(), (Shape)rect, obj.toString(), cell.getStyle(), cell.getValue());
            h = h < defaultHeight ? defaultHeight : (h += extend);
            if (h <= maxHeight) continue;
            maxHeight = h;
        }
        if (maxHeight != 0 && maxHeight != rowHeight) {
            if (maxHeight <= rowMaxHeight) {
                row.setHeight(maxHeight);
            } else {
                row.setHeight(rowMaxHeight);
            }
            table.reLayoutAndPaint();
            return true;
        }
        return false;
    }

    public static boolean isTrue(Object target) {
        return PerfUtils.isTrue(target, false);
    }

    public static boolean isTrue(Object target, boolean defaultValue) {
        String[] TRUTH = new String[]{"true", "yes", "1", "sure", "Y", "confirm", EASResource.getString((String)"com.kingdee.eas.hr.perf.PerformanceResource", (String)"YES")};
        String[] FALSE = new String[]{"false", "no", "0", "cancel", "N", EASResource.getString((String)"com.kingdee.eas.hr.perf.PerformanceResource", (String)"NO")};
        if (target == null) {
            return defaultValue;
        }
        if (target instanceof Boolean) {
            return (Boolean)target;
        }
        String s = target.toString().trim();
        int f = 0;
        int t = 0;
        while (t < TRUTH.length) {
            if (t >= TRUTH.length) continue;
            if (s.equalsIgnoreCase(TRUTH[t])) {
                return true;
            }
            ++t;
        }
        while (f < FALSE.length) {
            if (f >= FALSE.length) continue;
            if (s.equalsIgnoreCase(FALSE[f])) {
                return false;
            }
            ++f;
        }
        try {
            return Boolean.valueOf(s);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean isEq(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean setAutoNumberByOrg(String orgType, IObjectValue createNewData, IObjectValue editData, KDTextField txtNumber, String bindingProperty) throws Exception {
        boolean isUseNumberRule = false;
        int editDataType = 3;
        DataBaseInfo DBeditDataInfo = null;
        if (createNewData instanceof DataBaseInfo) {
            DBeditDataInfo = (DataBaseInfo)editData;
            editDataType = 0;
        }
        CoreBillBaseInfo BBeditDataInfo = null;
        if (createNewData instanceof CoreBillBaseInfo) {
            BBeditDataInfo = (CoreBillBaseInfo)editData;
            editDataType = 1;
        }
        if (editDataType != 0 && editDataType != 1) {
            throw new Exception("editData base type unknown");
        }
        String companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        String numberGet = null;
        if (!iCodingRuleManager.isExist(createNewData, companyID, bindingProperty)) {
            isUseNumberRule = false;
            return isUseNumberRule;
        }
        isUseNumberRule = true;
        boolean isModifiable = iCodingRuleManager.isModifiable(createNewData, companyID, bindingProperty);
        txtNumber.setEnabled(isModifiable);
        if (editDataType == 0 ? DBeditDataInfo == null || DBeditDataInfo.getNumber() != null : BBeditDataInfo == null || BBeditDataInfo.getNumber() != null) {
            return isUseNumberRule;
        }
        String customString = null;
        if (isModifiable) {
            numberGet = iCodingRuleManager.getNumber(createNewData, companyID, bindingProperty, customString);
        } else if (iCodingRuleManager.isAddView(createNewData, companyID, bindingProperty)) {
            numberGet = iCodingRuleManager.getNumber(createNewData, companyID, bindingProperty, customString);
            txtNumber.setEnabled(false);
        } else if (iCodingRuleManager.isUseIntermitNumber(createNewData, companyID, bindingProperty)) {
            txtNumber.setEnabled(false);
        }
        if (editDataType == 0) {
            DBeditDataInfo.setNumber(numberGet);
        } else {
            BBeditDataInfo.setNumber(numberGet);
        }
        return isUseNumberRule;
    }

    public static boolean setAutoNumberByOrg(String orgType, IObjectValue createNewData, IObjectValue editData, KDTextField txtNumber) throws Exception {
        boolean isUseNumberRule = false;
        int editDataType = 3;
        DataBaseInfo DBeditDataInfo = null;
        if (createNewData instanceof DataBaseInfo) {
            DBeditDataInfo = (DataBaseInfo)editData;
            editDataType = 0;
        }
        CoreBillBaseInfo BBeditDataInfo = null;
        if (createNewData instanceof CoreBillBaseInfo) {
            BBeditDataInfo = (CoreBillBaseInfo)editData;
            editDataType = 1;
        }
        if (editDataType != 0 && editDataType != 1) {
            throw new Exception("editData base type unknown");
        }
        String companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        String numberGet = null;
        if (!iCodingRuleManager.isExist(createNewData, companyID)) {
            isUseNumberRule = false;
            return isUseNumberRule;
        }
        isUseNumberRule = true;
        boolean isModifiable = iCodingRuleManager.isModifiable(createNewData, companyID);
        txtNumber.setEnabled(isModifiable);
        if (editDataType == 0 ? DBeditDataInfo == null || DBeditDataInfo.getNumber() != null : BBeditDataInfo == null || BBeditDataInfo.getNumber() != null) {
            return isUseNumberRule;
        }
        if (isModifiable) {
            numberGet = iCodingRuleManager.getNumber(createNewData, companyID);
        } else if (iCodingRuleManager.isAddView(createNewData, companyID)) {
            numberGet = iCodingRuleManager.getNumber(createNewData, companyID);
            txtNumber.setEnabled(false);
        } else if (iCodingRuleManager.isUseIntermitNumber(createNewData, companyID)) {
            txtNumber.setEnabled(false);
        }
        if (editDataType == 0) {
            DBeditDataInfo.setNumber(numberGet);
        } else {
            BBeditDataInfo.setNumber(numberGet);
        }
        return isUseNumberRule;
    }

    public static String getURL(Context ctx) {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String username = user.getNumber();
        String dataCenter = ctx.getAIS();
        String fileName = System.getProperty("EAS_INSTANCE_CONFIG_PATH").trim() + "/portalConfig/LtpaToken.properties";
        String password = LtpaTokenManager.generate((String)username, (String)fileName).toString();
        Properties properties = new Properties();
        InputStream is = null;
        try {
            is = new FileInputStream(System.getProperty("eas.properties.dir").trim() + "/eas_httpd.conf");
            properties.load(is);
        }
        catch (IOException ioe) {
            throw new ConfigurationError("eas_httpd.conf not found");
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String proxyPassReverse = properties.getProperty("ProxyPassReverse");
        String domian = proxyPassReverse.substring(proxyPassReverse.indexOf("http"));
        String url = null;
        try {
            url = domian + "easportal/index2sso.jsp?username=" + URLEncoder.encode(username, "utf-8") + "&password=" + password + "&dataCenter=" + dataCenter;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return url;
    }
}

