/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf;

import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.RankConvertRuleDetailCollection;
import com.kingdee.eas.hr.perf.RankConvertRuleDetailInfo;
import com.kingdee.eas.hr.perf.RankConvertRuleInfo;
import com.kingdee.eas.hr.perf.RankInfo;
import java.math.BigDecimal;

public class RankConvertRuleHelper {
    public static RankInfo getRank(GradeModeInfo gradeModeInfo, RankConvertRuleInfo rankConvertRule, BigDecimal score) {
        RankInfo rank = null;
        BigDecimal max = gradeModeInfo.getMaxGrade();
        BigDecimal min = gradeModeInfo.getMinGrade();
        if (score.compareTo(max) > 0) {
            rank = RankConvertRuleHelper.findMaxRankInfo(rankConvertRule);
            return rank;
        }
        if (score.compareTo(min) < 0) {
            rank = RankConvertRuleHelper.findMinRankInfo(rankConvertRule);
            return rank;
        }
        if (rankConvertRule != null && rankConvertRule.getEntries() != null) {
            RankConvertRuleDetailInfo ruleDetailInfo = null;
            RankConvertRuleDetailCollection coll = rankConvertRule.getEntries();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                ruleDetailInfo = coll.get(i);
                BigDecimal ruleMax = ruleDetailInfo.getMaxScore();
                BigDecimal ruleMin = ruleDetailInfo.getMinScore();
                ruleDetailInfo.getMaxScoreCondition();
                String maxCondition = ruleDetailInfo.getMaxScoreCondition();
                String minCondition = ruleDetailInfo.getMinScoreCondition();
                if (score.compareTo(ruleMax) > 0 || score.compareTo(ruleMin) < 0) continue;
                if (score.compareTo(ruleMax) == 0) {
                    if (!"\u2264".equals(maxCondition)) continue;
                    return ruleDetailInfo.getRank();
                }
                if (score.compareTo(ruleMin) == 0) {
                    if (!"\u2264".equals(minCondition)) continue;
                    return ruleDetailInfo.getRank();
                }
                return ruleDetailInfo.getRank();
            }
        }
        return rank;
    }

    public static RankInfo findMaxRankInfo(RankConvertRuleInfo info) {
        RankInfo rank = null;
        if (info != null && info.getEntries() != null) {
            RankConvertRuleDetailInfo ruleDetailInfo = null;
            RankConvertRuleDetailCollection coll = info.getEntries();
            BigDecimal currentMax = null;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                ruleDetailInfo = coll.get(i);
                BigDecimal ruleMax = ruleDetailInfo.getMaxScore();
                if (currentMax == null) {
                    currentMax = ruleMax;
                }
                if (ruleMax.compareTo(currentMax) < 0) continue;
                currentMax = ruleMax;
                rank = ruleDetailInfo.getRank();
            }
        }
        return rank;
    }

    public static RankInfo findMinRankInfo(RankConvertRuleInfo info) {
        RankInfo rank = null;
        if (info != null && info.getEntries() != null) {
            RankConvertRuleDetailInfo ruleDetailInfo = null;
            RankConvertRuleDetailCollection coll = info.getEntries();
            BigDecimal currentMin = null;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                ruleDetailInfo = coll.get(i);
                BigDecimal ruleMin = ruleDetailInfo.getMinScore();
                if (currentMin == null) {
                    currentMin = ruleMin;
                }
                if (ruleMin.compareTo(currentMin) > 0) continue;
                currentMin = ruleMin;
                rank = ruleDetailInfo.getRank();
            }
        }
        return rank;
    }
}

