/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.client.AbstractAchieveDataForOrgListUI;
import org.apache.log4j.Logger;

public class AchieveDataForOrgListUI
extends AbstractAchieveDataForOrgListUI {
    private static final Logger logger = CoreUIObject.getLogger(AchieveDataForOrgListUI.class);

    @Override
    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"orgUnit.number", "orgUnit.name"};
        return locateNames;
    }

    @Override
    protected EvaluSolutionTypeEnum getSolutionType() {
        return EvaluSolutionTypeEnum.ORGUNIT;
    }

    @Override
    protected String getEvaluObjectTypeStringValue() {
        return "org";
    }

    @Override
    protected int getEvaluObjectTypeIntValue() {
        return 101;
    }

    @Override
    protected EvaluObjectTypeEnum getEvaluObjectType() {
        return EvaluObjectTypeEnum.ORGUNIT;
    }

    @Override
    protected String[] getNeedSortColumns() {
        String[] colKeys = new String[]{"orgUnit.number", "orgUnit.name", "responser.name", "achieveItem.name"};
        return colKeys;
    }

    @Override
    protected void checkUpdatePermsion() throws Exception {
        IPermission permission = PermissionFactory.getRemoteInstance();
        int rows = this.tblMain.getRowCount();
        String objID = null;
        for (int i = 0; i < rows; ++i) {
            IRow row = this.tblMain.getRow(i);
            String id = row.getCell("id").getValue().toString();
            objID = this.getObjID(i);
            try {
                permission.checkDataPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentHRUnit().getId()), "perf_orgAchieveData_maintain", (IObjectPK)new ObjectUuidPK(id));
                if (this.formSubmitIdSet != null && this.formSubmitIdSet.contains(objID)) {
                    row.getCell("formula.name").getStyleAttributes().setLocked(true);
                    row.getCell("realValue").getStyleAttributes().setLocked(true);
                    continue;
                }
                row.getCell("formula.name").getStyleAttributes().setLocked(false);
                row.getCell("realValue").getStyleAttributes().setLocked(false);
                continue;
            }
            catch (PermissionException e) {
                row.getCell("realValue").getStyleAttributes().setLocked(true);
                row.getCell("formula.name").getStyleAttributes().setLocked(true);
            }
        }
    }

    private String getObjID(int row_idx) {
        if ("org".equals(this.getEvaluObjectTypeStringValue())) {
            return this.tblMain.getCell(row_idx, "orgUnit.id").getValue().toString();
        }
        return this.tblMain.getCell(row_idx, "person.id").getValue().toString();
    }
}

