/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.log.common.Resource;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.AchieveDataComputeFacadeFactory;
import com.kingdee.eas.hr.perf.AchieveDataFacadeFactory;
import com.kingdee.eas.hr.perf.AchieveDataFactory;
import com.kingdee.eas.hr.perf.DeliverModeEnum;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.FormulaInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.client.AbstractAchieveDataForPersonListUI;
import com.kingdee.eas.hr.perf.client.AchieveDataBtachEditUI;
import com.kingdee.eas.hr.perf.client.AchieveDataQueryPanelUI;
import com.kingdee.eas.hr.perf.client.AchieveDataSynTargetUI;
import com.kingdee.eas.hr.perf.client.FormulaPromptBox;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.ProgDialog;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class AchieveDataForPersonListUI
extends AbstractAchieveDataForPersonListUI {
    private static final Logger logger = CoreUIObject.getLogger(AchieveDataForPersonListUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.AchieveDataResource";
    private SolutionPeriodInfo spInfo;
    private KDTPropertyChangeListener propChangeListener;
    private CommonQueryDialog cqd;
    private boolean spChanged = false;
    private Map changedFormula = new HashMap();
    private Map changedValue = new HashMap();
    private Set needSortColumn = null;
    protected Set formSubmitIdSet;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.propChangeListener = new TablePropertyChangeListener();
        super.onLoad();
        this.initUI();
        this.initData();
        this.setBtnState();
        Map uiContext = this.getUIContext();
        if (uiContext.get("solutionPeriod") != null) {
            this.prmtSp.setValue(uiContext.get("solutionPeriod"));
            this.prmtSp.setEnabled(false);
        }
    }

    private void initUI() throws Exception {
        this.chkAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AchieveDataForPersonListUI.this.chkAllStateChanged(e);
            }
        });
        this.prmtSp.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                AchieveDataForPersonListUI.this.prmtSp_actionPerformed(e);
            }
        });
        this.tblMain.getTreeColumn().getStyleAttributes().setBackground(new Color(210, 233, 251));
        this.tblMain.getColumn("formula.name").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("realValue").getStyleAttributes().setLocked(false);
        KDTextField textField = new KDTextField();
        textField.setMaxLength(255);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)textField);
        this.tblMain.getColumn("realValue").setEditor((ICellEditor)cellEditor);
        KDBizPromptBox prmtFormula = new KDBizPromptBox();
        FormulaPromptBox formulaBox = new FormulaPromptBox();
        formulaBox.setFormulaType(1);
        prmtFormula.setSelector((KDPromptSelector)formulaBox);
        prmtFormula.setEditable(false);
        KDTDefaultCellEditor formula_cellEditor = new KDTDefaultCellEditor((IKDEditor)prmtFormula);
        this.tblMain.getColumn("formula.name").setEditor((ICellEditor)formula_cellEditor);
        this.tblMain.getSelectManager().setSelectMode(15);
        this.btnView.setVisible(false);
        this.btnEdit.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemView.setVisible(false);
        this.actionSyn.setDaemonRun(true);
    }

    private void initData() throws Exception {
        this.prmtSp.setQueryInfo("com.kingdee.eas.hr.perf.app.SolutionPeriodF7Query");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = null;
        item = new FilterItemInfo("evaluSolution.solutionType", (Object)new Integer(this.getSolutionType().getValue()), CompareType.EQUALS);
        filter.getFilterItems().add(item);
        filter.getFilterItems().add(new FilterItemInfo("evaluSolution.hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        viewInfo.setFilter(filter);
        this.prmtSp.setEntityViewInfo(viewInfo);
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.btnSelectCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnSyn.setIcon(EASResource.getIcon((String)"imgTbtn_synchronization"));
        this.btnCompute.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        Map uiContext = this.getUIContext();
        if (uiContext.get("isFromWorkbench") != null) {
            this.actionImportData.setVisible(false);
            this.actionExportData.setVisible(false);
            this.actionSelectCopy.setVisible(false);
            this.actionSyn.setVisible(false);
            this.actionAddNew.setVisible(false);
            this.actionRemove.setVisible(false);
        }
    }

    protected void chkAllStateChanged(ItemEvent e) {
        ActionEvent evt = new ActionEvent(this.btnRefresh, 0, "Double Clicked");
        ItemAction actView = this.getActionFromActionEvent(evt);
        actView.actionPerformed(evt);
    }

    protected void prmtSp_actionPerformed(DataChangeEvent e) {
        if (this.prmtSp.getValue() == null || !(this.prmtSp.getValue() instanceof SolutionPeriodInfo)) {
            return;
        }
        this.spInfo = (SolutionPeriodInfo)this.prmtSp.getValue();
        this.spChanged = true;
        this.setBtnState();
        ActionEvent evt = new ActionEvent(this.btnRefresh, 0, "Double Clicked");
        ItemAction actView = this.getActionFromActionEvent(evt);
        actView.actionPerformed(evt);
    }

    protected void checkUpdatePermsion() throws Exception {
        IPermission permission = PermissionFactory.getRemoteInstance();
        int rows = this.tblMain.getRowCount();
        String objID = null;
        for (int i = 0; i < rows; ++i) {
            IRow row = this.tblMain.getRow(i);
            String id = row.getCell("id").getValue().toString();
            objID = this.getObjID(i);
            try {
                permission.checkDataPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentHRUnit().getId()), "perf_personAchieveDataMaintain", (IObjectPK)new ObjectUuidPK(id));
                if (this.formSubmitIdSet != null && this.formSubmitIdSet.contains(objID)) {
                    row.getCell("formula.name").getStyleAttributes().setLocked(true);
                    row.getCell("realValue").getStyleAttributes().setLocked(true);
                    continue;
                }
                row.getCell("formula.name").getStyleAttributes().setLocked(false);
                row.getCell("realValue").getStyleAttributes().setLocked(false);
                continue;
            }
            catch (PermissionException e) {
                row.getCell("realValue").getStyleAttributes().setLocked(true);
                row.getCell("formula.name").getStyleAttributes().setLocked(true);
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.chkAll.isSelected()) {
            return;
        }
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1 && (this.changedFormula.size() > 0 || this.changedValue.size() > 0)) {
            int flg = MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"beforeExitMsg"));
            if (flg != 0) {
                SysUtil.abort();
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"beforeExitMsg"));
            ActionEvent evt = new ActionEvent(this.btnSave, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
        int colIndex = e.getColIndex();
        String colKey = this.tblMain.getColumnKey(colIndex);
        if (this.needSortColumn == null) {
            this.needSortColumn = new HashSet();
            String[] colKeys = this.getNeedSortColumns();
            for (int i = 0; i < colKeys.length; ++i) {
                this.needSortColumn.add(colKeys[i]);
            }
        }
        if (this.needSortColumn.contains(colKey)) {
            super.tblMain_tableClicked(e);
        }
        this.checkUpdatePermsion();
    }

    protected String[] getNeedSortColumns() {
        String[] colKeys = new String[]{"adminOrgUnit.name", "achieveItem.name", "position.name", "person.name", "person.number"};
        return colKeys;
    }

    public void execQuery() {
        this.tblMain.removeKDTPropertyChangeListener(this.propChangeListener);
        super.execQuery();
        this.tblMain.addKDTPropertyChangeListener(this.propChangeListener);
        String[] columnName = new String[]{"thresholdValue", "standardValue", "challengeValue"};
        this.setFormatString(this.tblMain, columnName);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectedSP();
        if (this.spInfo.getAchievePeriod() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)Resource.getString((String)RES, (String)"achPer_null_can_not_addNew"));
            return;
        }
        IUIFactory uiFactory = null;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"evaluType", (Object)this.getEvaluObjectTypeStringValue());
        uiContext.put((Object)"spId", (Object)this.spInfo.getId().toString());
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(AchieveDataBtachEditUI.class.getName(), (Map)uiContext, null, null);
        window.show();
        AchieveDataBtachEditUI achieveDataBtachEditUI = (AchieveDataBtachEditUI)window.getUIObject();
        if (!achieveDataBtachEditUI.isCancel()) {
            ActionEvent evt = new ActionEvent(this.btnRefresh, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        this.tblMain.removeKDTPropertyChangeListener(this.propChangeListener);
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < rows.length; ++i) {
            BizEnumValueDTO inte = (BizEnumValueDTO)this.tblMain.getCell(rows[i], "dataType").getValue();
            if (inte != null && 20 == inte.getInt()) {
                MsgBox.showWarning((Component)((Object)this), (String)Resource.getString((String)RES, (String)"can_remove_achData"));
                SysUtil.abort();
            }
            String id = this.tblMain.getCell(rows[i], "id").getValue().toString();
            this.changedValue.remove(id);
            this.changedFormula.remove(id);
        }
        super.actionRemove_actionPerformed(e);
        this.tblMain.addKDTPropertyChangeListener(this.propChangeListener);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        if (this.chkAll.isSelected()) {
            this.tblMain.getTreeColumn().setDepth(2);
        }
        this.setPercent();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AchieveDataFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        this.cqd = super.initCommonQueryDialog();
        AchieveDataQueryPanelUI userPanel = null;
        try {
            userPanel = new AchieveDataQueryPanelUI(this.getEvaluObjectTypeStringValue());
        }
        catch (Exception e) {
            super.handleException(e);
        }
        if (userPanel != null) {
            this.cqd.addUserPanel((KDPanel)userPanel);
        }
        this.cqd.setShowSorter(true);
        return this.cqd;
    }

    @Override
    public void actionSelectCopy_actionPerformed(ActionEvent arg0) throws Exception {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        int size = this.tblMain.getSelectManager().size();
        if (size > 0) {
            KDTSelectBlock sb = this.tblMain.getSelectManager().get(0);
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.tblMain.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked() || this.tblMain.getCell(row, column).getStyleAttributes().isLocked()) {
                return;
            }
            Object value = this.tblMain.getCell(row, column).getValue();
            Object fmId = this.tblMain.getCell(row, "formula.id").getValue();
            for (int i = 0; i < size; ++i) {
                sb = this.tblMain.getSelectManager().get(i);
                for (int j = sb.getBeginRow(); j <= sb.getEndRow(); ++j) {
                    if (this.tblMain.getCell(j, column).getStyleAttributes().isLocked()) continue;
                    this.tblMain.getCell(j, column).setValue(value);
                    if (!"formula.name".equals(iColumn.getKey())) continue;
                    if (value == null || value.toString().trim().length() <= 0) {
                        this.tblMain.getCell(j, "formula.id").setValue(null);
                        continue;
                    }
                    this.tblMain.getCell(j, "formula.id").setValue(fmId);
                }
            }
        }
    }

    @Override
    public void actionCompute_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.checkSelected();
        this.checkSelectedSP();
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        final ArrayList<String> ids = new ArrayList<String>();
        String id = null;
        for (i = 0; i < rows.length; ++i) {
            Boolean formSubmit = (Boolean)this.tblMain.getCell(rows[i], "formSubmit").getValue();
            if (formSubmit != null && formSubmit.booleanValue()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"26_AchieveDataForPersonListUI"));
                SysUtil.abort();
            }
            if ((id = this.tblMain.getCell(rows[i], "id").getValue().toString()) == null) continue;
            ids.add(id);
        }
        if (this.changedValue.size() > 0 || this.changedFormula.size() > 0) {
            i = MsgBox.showConfirm2((Component)((Object)this), (String)Resource.getString((String)RES, (String)"please_save"));
            if (0 == i) {
                AchieveDataFacadeFactory.getRemoteInstance().updateAchieveData(this.changedFormula, this.changedValue);
                this.changedFormula.clear();
                this.changedValue.clear();
            } else {
                return;
            }
        }
        IProgTask prog = new IProgTask(){

            @Override
            public Object exec() throws Exception {
                AchieveDataComputeFacadeFactory.getRemoteInstance().batchCompute(ids);
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
                MsgBox.showInfo((String)Resource.getString((String)AchieveDataForPersonListUI.RES, (String)"compute_success"));
                ActionEvent evt = new ActionEvent(AchieveDataForPersonListUI.this.btnRefresh, 0, "Double Clicked");
                ItemAction actView = AchieveDataForPersonListUI.this.getActionFromActionEvent(evt);
                actView.actionPerformed(evt);
            }
        };
        ProgDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new ProgDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new ProgDialog((Dialog)win);
        }
        dialog.setLongTimeTask(prog);
        dialog.show();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.changedFormula.size() > 0 || this.changedValue.size() > 0) {
            AchieveDataFacadeFactory.getRemoteInstance().updateAchieveData(this.changedFormula, this.changedValue);
            this.changedFormula.clear();
            this.changedValue.clear();
            MsgBox.showInfo((Component)((Object)this), (String)Resource.getString((String)RES, (String)"save_success"));
            ActionEvent evt = new ActionEvent(this.btnRefresh, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    @Override
    public void actionSyn_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectedSP();
        if (this.spInfo == null) {
            return;
        }
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        Map map = AchieveDataFacadeFactory.getRemoteInstance().getNeedSynTargetData(this.spInfo.getId().toString(), this.getEvaluObjectTypeStringValue());
        Boolean hasDup = (Boolean)map.get("hasDup");
        boolean isCancel = false;
        if (hasDup != null && hasDup.booleanValue()) {
            IUIFactory uiFactory = null;
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"evaluType", (Object)this.getEvaluObjectTypeStringValue());
            uiContext.put((Object)"spId", (Object)this.spInfo.getId().toString());
            uiContext.put((Object)"map", (Object)map);
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow window = uiFactory.create(AchieveDataSynTargetUI.class.getName(), (Map)uiContext, null, null);
            window.show();
            AchieveDataSynTargetUI ui = (AchieveDataSynTargetUI)window.getUIObject();
            isCancel = ui.isCancel();
        }
        if (!isCancel) {
            ActionEvent evt = new ActionEvent(this.btnRefresh, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectedSP();
        DatataskParameter param = new DatataskParameter();
        if ("person".equals(this.getEvaluObjectTypeStringValue())) {
            param.solutionName = "eas.hr.perf.PersonAchieveData";
            param.alias = EASResource.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"27_AchieveDataForPersonListUI");
        } else {
            param.solutionName = "eas.hr.perf.OrgAchieveData";
            param.alias = EASResource.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"28_AchieveDataForPersonListUI");
        }
        param.datataskMode = 1;
        param.putContextParam((Object)"spId", (Object)this.spInfo.getId().toString());
        param.putContextParam((Object)"evaluType", (Object)this.getEvaluObjectTypeStringValue());
        param.putContextParam((Object)"isAll", (Object)new Boolean(this.chkAll.isSelected()));
        if (this.cqd != null) {
            FilterInfo fi = new FilterInfo();
            FilterInfo comFi = this.cqd.getCommonFilter();
            FilterInfo sefFi = new FilterInfo();
            if (this.cqd.getEntityViewInfoResult() != null) {
                sefFi = this.cqd.getEntityViewInfoResult().getFilter();
            }
            try {
                if (comFi != null) {
                    fi.mergeFilter(comFi, "and");
                }
                if (sefFi != null) {
                    fi.mergeFilter(sefFi, "and");
                }
            }
            catch (BOSException ex) {
                super.handleException((Exception)((Object)ex));
            }
            if (fi.getFilterItems().size() > 0) {
                param.putContextParam((Object)"userFilter", (Object)fi);
            }
        }
        ArrayList<DatataskParameter> array = new ArrayList<DatataskParameter>();
        array.add(param);
        DatataskCaller dc = new DatataskCaller();
        if (SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof KDFrame) {
            dc.setParentComponent((Component)((Object)this));
        }
        dc.invoke(array, 1);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectedSP();
        if (this.spInfo.getAchievePeriod() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"29_AchieveDataForPersonListUI"));
            SysUtil.abort();
        }
        ArrayList<DatataskParameter> arrayList = new ArrayList<DatataskParameter>();
        DatataskParameter param = new DatataskParameter();
        if ("person".equals(this.getEvaluObjectTypeStringValue())) {
            param.solutionName = "eas.hr.perf.PersonAchieveData";
            param.alias = EASResource.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"30_AchieveDataForPersonListUI");
        } else {
            param.solutionName = "eas.hr.perf.OrgAchieveData";
            param.alias = EASResource.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"31_AchieveDataForPersonListUI");
        }
        param.putContextParam((Object)"spId", (Object)this.spInfo.getId().toString());
        param.putContextParam((Object)"evaluType", (Object)this.getEvaluObjectTypeStringValue());
        param.putContextParam((Object)"spPeriodId", (Object)this.spInfo.getAchievePeriod().getId().toString());
        arrayList.add(param);
        DatataskCaller task = new DatataskCaller();
        if (SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof KDFrame) {
            task.setParentComponent((Component)((Object)this));
            task.invoke(arrayList, 0);
        }
        if (!task.isCanceld()) {
            ActionEvent evt = new ActionEvent(this.btnRefresh, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        AchieveDataQueryPanelUI ui;
        FilterInfo fi = new FilterInfo();
        if (!this.spChanged && this.cqd != null) {
            FilterInfo comFi = this.cqd.getCommonFilter();
            if (this.cqd.getEntityViewInfoResult() != null) {
                FilterInfo sefFi = this.cqd.getEntityViewInfoResult().getFilter();
                try {
                    if (comFi != null) {
                        fi.mergeFilter(comFi, "and");
                    }
                    if (sefFi != null) {
                        fi.mergeFilter(sefFi, "and");
                    }
                }
                catch (BOSException e) {
                    super.handleException((Exception)((Object)e));
                }
            }
        } else if (this.cqd != null && (ui = (AchieveDataQueryPanelUI)this.cqd.getUserPanel(AchieveDataQueryPanelUI.class.getName())) != null) {
            ui.clear();
        }
        FilterInfo filter = new FilterInfo();
        if (this.spInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)this.spInfo.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", null));
        }
        if (!this.chkAll.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("rootPeriod", (Object)new Boolean(true)));
        }
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("evaluObject.deleted", (Object)new Boolean(false)));
        filter2.getFilterItems().add(new FilterItemInfo("evaluObject.deleted", null, CompareType.IS));
        filter2.setMaskString("#0 OR #1");
        Map uiContext = this.getUIContext();
        if (uiContext.get("objectID") != null) {
            if (EvaluObjectTypeEnum.PERSON.equals((Object)this.getEvaluObjectType())) {
                filter.getFilterItems().add(new FilterItemInfo("person.id", uiContext.get("objectID"), CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", uiContext.get("objectID"), CompareType.EQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("targetEvaluStore.uniteTarget", (Object)Boolean.FALSE));
        } else {
            String personId = null;
            PersonInfo person = SysContext.getSysContext().getCurrentUserInfo().getPerson();
            if (person != null && person.getId() != null) {
                personId = person.getId().toString();
            }
            String evaluSolutionId = null;
            if (this.spInfo != null && this.spInfo.getEvaluSolution() != null && this.spInfo.getEvaluSolution().getId() != null) {
                evaluSolutionId = this.spInfo.getEvaluSolution().getId().toString();
            }
            if (EvaluObjectTypeEnum.PERSON.equals((Object)this.getEvaluObjectType())) {
                Set personSet = new HashSet();
                try {
                    if (!StringUtils.isEmpty((String)personId) && !StringUtils.isEmpty((String)evaluSolutionId)) {
                        personSet = AchieveDataFacadeFactory.getRemoteInstance().getAchieveDataInputPersons(personId, evaluSolutionId);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    logger.info((Object)("personId = " + personId + "evaluSolutionId = " + evaluSolutionId));
                    ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                }
                if (personSet.size() > 0) {
                    filter.getFilterItems().add(new FilterItemInfo("person.id", personSet, CompareType.INCLUDE));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("person.id", null));
                }
            } else {
                Set orgSet = new HashSet();
                if (!StringUtils.isEmpty((String)personId) && !StringUtils.isEmpty(evaluSolutionId)) {
                    try {
                        orgSet = AchieveDataFacadeFactory.getRemoteInstance().getAchieveDataInputOrgs(personId, evaluSolutionId);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        logger.info((Object)("personId = " + personId + "evaluSolutionId = " + evaluSolutionId));
                        ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                    }
                }
                if (orgSet.size() > 0) {
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgSet, CompareType.INCLUDE));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", null, CompareType.EQUALS));
                }
            }
        }
        try {
            filter.mergeFilter(filter2, "and");
            fi.mergeFilter(filter, "and");
        }
        catch (BOSException e) {
            super.handleException((Exception)((Object)e));
            logger.error((Object)"merge the filter is error", (Throwable)e);
        }
        viewInfo.setFilter(fi);
        this.spChanged = false;
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        int i;
        int count;
        this.tblMain.getColumn("formula.name").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("realValue").getStyleAttributes().setLocked(false);
        this.formSubmitIdSet = new HashSet();
        String objID = null;
        if (this.chkAll.isSelected()) {
            this.tblMain.getTreeColumn().setDepth(2);
            count = this.tblMain.getRowCount();
            for (i = 0; i < count; ++i) {
                Boolean b = (Boolean)this.tblMain.getRow(i).getCell("rootPeriod").getValue();
                String parentId = (String)this.tblMain.getRow(i).getCell("parent.id").getValue();
                if (b == null || parentId == null || b != null && b.booleanValue()) {
                    this.tblMain.getRow(i).setTreeLevel(0);
                } else {
                    this.tblMain.getRow(i).setTreeLevel(1);
                }
                Boolean formSubmit = (Boolean)this.tblMain.getCell(i, "formSubmit").getValue();
                objID = this.getObjID(i);
                if (formSubmit == null || !formSubmit.booleanValue()) continue;
                this.formSubmitIdSet.add(objID);
                this.tblMain.getRow(i).getCell("formula.name").getStyleAttributes().setLocked(true);
                this.tblMain.getRow(i).getCell("realValue").getStyleAttributes().setLocked(true);
            }
        } else {
            count = this.tblMain.getRowCount();
            for (i = 0; i < count; ++i) {
                Boolean formSubmit = (Boolean)this.tblMain.getCell(i, "formSubmit").getValue();
                objID = this.getObjID(i);
                if (formSubmit == null || !formSubmit.booleanValue()) continue;
                this.formSubmitIdSet.add(objID);
                this.tblMain.getRow(i).getCell("formula.name").getStyleAttributes().setLocked(true);
                this.tblMain.getRow(i).getCell("realValue").getStyleAttributes().setLocked(true);
            }
        }
        if (this.spInfo != null && SolutionPeriodStatusEnum.END_EVALU.equals((Object)this.spInfo.getStatus())) {
            this.tblMain.getColumn("formula.name").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("realValue").getStyleAttributes().setLocked(true);
        }
        EvaluSolutionInfo evalusInfo = null;
        if (this.spInfo != null) {
            evalusInfo = this.spInfo.getEvaluSolution();
        }
        boolean canInputAchData = false;
        DeliverModeEnum deliverModeEnum = null;
        if (this.spInfo != null) {
            canInputAchData = this.spInfo.isCanInputAchData();
        }
        if (evalusInfo != null) {
            deliverModeEnum = evalusInfo.getDeliverMode();
        }
        if (DeliverModeEnum.PART_UNITY_DELIVER.equals((Object)deliverModeEnum) && !canInputAchData || DeliverModeEnum.DIS_UNITY_DELIVER.equals((Object)deliverModeEnum) && !canInputAchData) {
            this.tblMain.getColumn("realValue").getStyleAttributes().setLocked(true);
        }
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"person.number", "person.name"};
        return locateNames;
    }

    private void tblMain_propertyChange(KDTPropertyChangeEvent evt) {
        int row_idx = evt.getRowIndex();
        int col_idx = evt.getColIndex();
        if (this.tblMain.getCell(row_idx, "id").getValue() == null) {
            return;
        }
        IColumn col = this.tblMain.getColumn(col_idx);
        Object value = evt.getNewValue();
        if (this.isEq(value, evt.getOldValue())) {
            return;
        }
        String id = this.tblMain.getCell(row_idx, "id").getValue().toString();
        if ("realValue".equals(col.getKey())) {
            BizEnumValueDTO dt = (BizEnumValueDTO)this.tblMain.getCell(row_idx, "achieveItem.dataType").getValue();
            if (dt != null && dt.getInt() == 1) {
                this.dealRealValueChange(row_idx, col_idx, value, id, 1);
            } else if (dt != null && dt.getInt() == 3) {
                boolean isMatch = false;
                if (value != null) {
                    String realValue = value.toString().trim();
                    Pattern pattern = Pattern.compile(".*%");
                    Matcher matcher = pattern.matcher(realValue);
                    isMatch = matcher.matches();
                    if (isMatch) {
                        String rv = realValue.substring(0, realValue.length() - 1);
                        if (rv.length() == 0) {
                            this.tblMain.getCell(row_idx, "realValue").setValue((Object)"");
                            this.changedValue.put(id, "");
                        } else {
                            this.dealRealValueChange(row_idx, col_idx, rv, id, 3);
                        }
                    } else {
                        this.dealRealValueChange(row_idx, col_idx, value, id, 3);
                    }
                } else {
                    this.changedValue.put(id, "");
                }
            } else {
                this.changedValue.put(id, value);
            }
        } else if ("formula.name".equals(col.getKey())) {
            if (value instanceof FormulaInfo || value == null || value.toString().trim().length() <= 0) {
                FormulaInfo info = (FormulaInfo)value;
                if (info == null) {
                    this.changedFormula.put(id, "");
                } else {
                    this.changedFormula.put(id, info.getId().toString());
                }
            }
        } else if ("formula.id".equals(col.getKey())) {
            String fmId = (String)this.tblMain.getCell(row_idx, "formula.id").getValue();
            if (fmId != null && fmId.trim().length() > 0) {
                this.changedFormula.put(id, fmId);
            } else {
                this.changedFormula.put(id, "");
            }
        }
    }

    private void dealRealValueChange(int row_idx, int col_idx, Object value, String id, int dataType) {
        if (value != null && value.toString().trim().length() > 0) {
            double rv = 0.0;
            BigDecimal realValue = null;
            boolean hasError = false;
            try {
                rv = Double.parseDouble(value.toString().trim());
            }
            catch (Exception e) {
                this.tblMain.getCell(row_idx, "realValue").setValue((Object)"");
                hasError = true;
            }
            if (rv > 2.147483647E9 || rv < -2.147483648E9) {
                this.tblMain.getCell(row_idx, "realValue").setValue((Object)"");
                hasError = true;
            }
            if (!hasError) {
                int pre = (Integer)this.tblMain.getCell(row_idx, "achieveItem.dataPrecision").getValue();
                DecimalFormat df = this.getDecimalFormat(pre);
                DecimalFormat per = this.getDecimalFormat(pre + 2);
                BizEnumValueDTO dt = null;
                if (this.tblMain.getCell(row_idx, "achieveItem.precisionType").getValue() != null) {
                    dt = (BizEnumValueDTO)this.tblMain.getCell(row_idx, "achieveItem.precisionType").getValue();
                }
                realValue = new BigDecimal(new Double(rv).toString());
                switch (dataType) {
                    case 1: {
                        if (dt != null) {
                            if (10 == dt.getInt()) {
                                this.tblMain.getCell(row_idx, "realValue").setValue((Object)df.format(realValue.setScale(pre, 4)));
                            } else if (30 == dt.getInt()) {
                                this.tblMain.getCell(row_idx, "realValue").setValue((Object)df.format(realValue.setScale(pre, 1)));
                            } else {
                                this.tblMain.getCell(row_idx, "realValue").setValue((Object)df.format(realValue.setScale(pre, 0)));
                            }
                        } else {
                            this.tblMain.getCell(row_idx, "realValue").setValue((Object)df.format(realValue.setScale(pre, 4)));
                        }
                        this.changedValue.put(id, String.valueOf(rv));
                        break;
                    }
                    case 3: {
                        if (dt != null) {
                            if (10 == dt.getInt()) {
                                this.tblMain.getCell(row_idx, "realValue").setValue((Object)(df.format(realValue.setScale(pre, 4)) + "%"));
                            } else if (30 == dt.getInt()) {
                                this.tblMain.getCell(row_idx, "realValue").setValue((Object)(df.format(realValue.setScale(pre, 1)) + "%"));
                            } else {
                                this.tblMain.getCell(row_idx, "realValue").setValue((Object)(df.format(realValue.setScale(pre, 0)) + "%"));
                            }
                        } else {
                            this.tblMain.getCell(row_idx, "realValue").setValue((Object)(df.format(realValue.setScale(pre, 4)) + "%"));
                        }
                        this.changedValue.put(id, String.valueOf(rv / 100.0));
                    }
                }
            } else {
                this.tblMain.getSelectManager().select(row_idx, col_idx);
            }
        } else {
            this.changedValue.put(id, "");
        }
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            Object rv = null;
            while (rowSet.next()) {
                BizEnumValueDTO dt = (BizEnumValueDTO)rowSet.getObject("achieveItem.dataType");
                BizEnumValueDTO dt_precisionType = (BizEnumValueDTO)rowSet.getObject("achieveItem.precisionType");
                if (dt == null || dt.getInt() != 1 && dt.getInt() != 3) {
                    return;
                }
                int dp = rowSet.getInt("achieveItem.dataPrecision");
                BigDecimal value = null;
                if (rowSet.getString("realValue") == null) continue;
                DecimalFormat df = this.getDecimalFormat(dp);
                switch (dt.getInt()) {
                    case 1: {
                        if (10 == dt_precisionType.getInt()) {
                            value = rowSet.getBigDecimal("realValue").setScale(dp, 4);
                            rowSet.updateString("realValue", df.format(value));
                            break;
                        }
                        if (30 == dt_precisionType.getInt()) {
                            value = rowSet.getBigDecimal("realValue").setScale(dp, 1);
                            rowSet.updateString("realValue", df.format(value));
                            break;
                        }
                        value = rowSet.getBigDecimal("realValue").setScale(dp, 0);
                        rowSet.updateString("realValue", df.format(value));
                        break;
                    }
                    case 3: {
                        if (10 == dt_precisionType.getInt()) {
                            value = rowSet.getBigDecimal("realValue").multiply(BigDecimal.valueOf(100L)).setScale(dp, 4);
                            rowSet.updateString("realValue", df.format(value) + "%");
                            break;
                        }
                        if (30 == dt_precisionType.getInt()) {
                            value = rowSet.getBigDecimal("realValue").multiply(BigDecimal.valueOf(100L)).setScale(dp, 1);
                            rowSet.updateString("realValue", df.format(value) + "%");
                            break;
                        }
                        value = rowSet.getBigDecimal("realValue").multiply(BigDecimal.valueOf(100L)).setScale(dp, 0);
                        rowSet.updateString("realValue", df.format(value) + "%");
                    }
                }
            }
        }
        catch (SQLException e) {
            super.handleException((Exception)e);
        }
    }

    protected boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                this.actionSave.setDaemonRun(false);
                ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                this.actionSave.actionPerformed(event);
                return !this.actionSave.isInvokeFailed();
            }
            return result == 1;
        }
        return true;
    }

    public boolean isModify() {
        return this.changedValue.size() > 0 || this.changedFormula.size() > 0;
    }

    private void checkSelectedSP() {
        if (this.spInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)Resource.getString((String)RES, (String)"solutionPeriod_null"));
            SysUtil.abort();
        }
    }

    private String getObjID(int row_idx) {
        if ("org".equals(this.getEvaluObjectTypeStringValue())) {
            return this.tblMain.getCell(row_idx, "orgUnit.id").getValue().toString();
        }
        return this.tblMain.getCell(row_idx, "person.id").getValue().toString();
    }

    protected EvaluSolutionTypeEnum getSolutionType() {
        return EvaluSolutionTypeEnum.PERSON;
    }

    protected String getEvaluObjectTypeStringValue() {
        return "person";
    }

    protected int getEvaluObjectTypeIntValue() {
        return 100;
    }

    protected EvaluObjectTypeEnum getEvaluObjectType() {
        return EvaluObjectTypeEnum.PERSON;
    }

    private DecimalFormat getDecimalFormat(int pre) {
        if (pre >= 0) {
            return new DecimalFormat(PFUtils.getNumberFormat(pre));
        }
        return new DecimalFormat("0.00");
    }

    private boolean isEq(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private void setBtnState() {
        boolean flag = this.spInfo == null || SolutionPeriodStatusEnum.END_EVALU.equals((Object)this.spInfo.getStatus()) || OprtState.VIEW.equals(this.getOprtState());
        this.actionAddNew.setEnabled(!flag);
        this.actionSave.setEnabled(!flag);
        this.actionImportData.setEnabled(!flag);
        this.actionExportData.setEnabled(!flag);
        this.actionCompute.setEnabled(!flag);
        this.actionSyn.setEnabled(!flag);
        this.actionRemove.setEnabled(!flag);
        this.actionSelectCopy.setEnabled(!flag);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.tblMain.getStyleAttributes().setLocked(true);
        }
    }

    private void setPercent() {
        String[] columnName = new String[]{"thresholdValue", "standardValue", "challengeValue"};
        this.setFormatString(this.tblMain, columnName);
    }

    private void setFormatString(KDTable tblMain, String[] columnName) {
        String PERCENTFORMATSTRING = "0.00%";
        int count = tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            int j;
            BizEnumValueDTO dt = (BizEnumValueDTO)tblMain.getCell(i, "target.kind").getValue();
            int dataPrecision = (Integer)tblMain.getCell(i, "target.dataPrecision").getValue();
            DecimalFormat df = this.getDecimalFormat(dataPrecision);
            Object value = null;
            if (dt != null && dt.getInt() == 22) {
                PERCENTFORMATSTRING = PFUtils.getNumberFormat(dataPrecision) + "%";
                for (j = 0; j < columnName.length; ++j) {
                    if (tblMain.getRow(i).getCell(columnName[j]) == null || (value = tblMain.getRow(i).getCell(columnName[j]).getValue()) == null) continue;
                    tblMain.getRow(i).getCell(columnName[j]).getStyleAttributes().setNumberFormat(PERCENTFORMATSTRING);
                }
                continue;
            }
            if ((dt == null || dt.getInt() != 21) && (dt == null || dt.getInt() != 10)) continue;
            for (j = 0; j < columnName.length; ++j) {
                if (tblMain.getRow(i).getCell(columnName[j]) == null) continue;
                value = tblMain.getRow(i).getCell(columnName[j]).getValue();
                String precision = PFUtils.getNumberFormat(dataPrecision);
                if (value == null) continue;
                tblMain.getRow(i).getCell(columnName[j]).getStyleAttributes().setNumberFormat(precision);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setPercent();
    }

    private class TablePropertyChangeListener
    implements KDTPropertyChangeListener {
        private TablePropertyChangeListener() {
        }

        public void propertyChange(KDTPropertyChangeEvent evt) {
            AchieveDataForPersonListUI.this.tblMain_propertyChange(evt);
        }
    }
}

