/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.AchieveItemFactory;
import com.kingdee.eas.hr.perf.AchieveItemInfo;
import com.kingdee.eas.hr.perf.AchieveItemTreeInfo;
import com.kingdee.eas.hr.perf.DataTypeEnum;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.PrecisionTypeEnum;
import com.kingdee.eas.hr.perf.client.AbstractAchieveItemEditUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class AchieveItemEditUI
extends AbstractAchieveItemEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AchieveItemEditUI.class);
    private static final String MACHINE = "machine";
    private DataTypeEnum checkState = null;
    private boolean isUseNumberRule = false;

    public void onLoad() throws Exception {
        this.init();
        super.onLoad();
    }

    private void init() throws Exception, BOSException {
        ((SpinnerNumberModel)this.txtMaxGrade.getModel()).setMaximum(new Integer(4));
        ((SpinnerNumberModel)this.txtMaxGrade.getModel()).setMinimum(new Integer(0));
        this.comboDefault.removeAllItems();
        this.comboDefault.addItem((Object)DataTypeEnum.NUMERICAL);
        this.comboDefault.addItem((Object)DataTypeEnum.PERCENT);
        this.comboPrecisionType.addItems(PrecisionTypeEnum.getEnumList().toArray());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("isEnable"));
        return sic;
    }

    @Override
    public void loadFields() {
        try {
            this.isUseNumberRule = PerfUtils.setAutoNumberByOrg("HRO", this.createNewData(), (IObjectValue)this.editData, this.txtNumber);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        super.loadFields();
        if (this.editData != null && this.editData.isIsEnable()) {
            this.actionRemove.setEnabled(false);
        }
    }

    private void setAutoNumber() {
        if (this.editData.getNumber() == null) {
            String sysNumber = null;
            try {
                if (SysContext.getSysContext().getCurrentFIUnit() != null) {
                    sysNumber = FrameWorkUtils.getCodeRuleClient((CoreBaseInfo)this.editData, (String)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (sysNumber != null && sysNumber.trim().length() > 0) {
                this.editData.setNumber(sysNumber);
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEnabled(true);
            }
        } else if (this.editData.getNumber().trim().length() > 0) {
            this.txtNumber.setText(this.editData.getNumber());
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.txtNumber.setEnabled(false);
        if (this.editData.isIsEnable()) {
            this.actionRemove.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        AchieveItemInfo objectValue = new AchieveItemInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        AchieveItemTreeInfo treeInfo = (AchieveItemTreeInfo)this.getUIContext().get("ParentNode");
        if (treeInfo != null && treeInfo.isIsLeaf()) {
            objectValue.setTreeid(treeInfo);
        }
        objectValue.setIsEnable(true);
        objectValue.setDataType(DataTypeEnum.NUMERICAL);
        objectValue.setPrecisionType(PrecisionTypeEnum.ROUND);
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AchieveItemFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.txtNumber.isEnabled()) {
            PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        }
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        int i = Integer.parseInt(this.txtMaxGrade.getValue().toString());
        if (i < 0 || i > 4) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"DataPrecision_error"));
            SysUtil.abort();
        }
    }

    @Override
    protected void comboValue_itemStateChanged(ItemEvent e) throws Exception {
        if (MACHINE.equals(this.comboDefault.getActionCommand())) {
            return;
        }
        if (this.comboDefault.getSelectedItem() instanceof DataTypeEnum && ((DataTypeEnum)((Object)this.comboDefault.getSelectedItem())).getValue() == 0) {
            this.txtMaxGrade.setEnabled(false);
            this.comboPrecisionType.setEnabled(false);
        } else {
            this.txtMaxGrade.setEnabled(true);
            this.comboPrecisionType.setEnabled(true);
        }
    }
}

