/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.AchieveStatisticsPeriodFactory;
import com.kingdee.eas.hr.perf.AchieveStatisticsPeriodInfo;
import com.kingdee.eas.hr.perf.ISolutionPeriod;
import com.kingdee.eas.hr.perf.ReportFrequencyEnum;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.client.AbstractAchieveStatisticsPeriodEditUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class AchieveStatisticsPeriodEditUI
extends AbstractAchieveStatisticsPeriodEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AchieveStatisticsPeriodEditUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private static Object val = null;
    private ICodingRuleManager crm;
    private boolean isExistRule = false;
    private boolean isUseIntermitNumber = false;
    private boolean isModifiable = false;
    private String orgId = null;
    private String number = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.editData.getParent();
        this.initParentStatisticsPeriod();
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.initTxtNumberState();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected IObjectValue createNewData() {
        AchieveStatisticsPeriodInfo info = new AchieveStatisticsPeriodInfo();
        this.orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        if (this.getOprtState().equals(OprtState.ADDNEW) && this.orgId != null && this.orgId.length() > 0) {
            try {
                this.crm = CodingRuleManagerFactory.getRemoteInstance();
                this.isModifiable = this.crm.isModifiable((IObjectValue)info, this.orgId);
                this.isExistRule = this.crm.isExist((IObjectValue)info, this.orgId);
                this.isUseIntermitNumber = this.crm.isUseIntermitNumber((IObjectValue)info, this.orgId);
                if (this.isExistRule) {
                    if (this.isModifiable) {
                        this.txtNumber.setEnabled(true);
                    } else {
                        this.txtNumber.setEnabled(false);
                    }
                    if (!this.isUseIntermitNumber) {
                        info.setNumber(this.crm.getNumber((IObjectValue)info, this.orgId));
                    }
                }
            }
            catch (EASBizException e) {
                this.txtNumber.setEnabled(true);
                logger.error((Object)e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return info;
    }

    public IObjectPK runSubmit() throws Exception {
        if (this.isExistRule && this.isUseIntermitNumber) {
            this.editData.setNumber(this.crm.getNonbreakNumber((IObjectValue)this.editData, this.orgId));
        }
        IObjectPK objectPK = super.runSubmit();
        this.editData.setId(BOSUuid.read((String)objectPK.toString()));
        return objectPK;
    }

    public boolean checkBeforeWindowClosing() {
        try {
            if (this.getOprtState().equals(OprtState.ADDNEW) && this.orgId != null && this.orgId.length() > 0 && this.isExistRule && this.isUseIntermitNumber) {
                this.crm.recycleNumber((IObjectValue)this.editData, this.orgId, this.editData.getNumber());
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return super.checkBeforeWindowClosing();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AchieveStatisticsPeriodFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add(new SelectorItemInfo("longNumber"));
        selectors.add(new SelectorItemInfo("parent.*"));
        return selectors;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if ("ADDNEW".equals(this.getOprtState())) {
            dataObject.put("parent", this.getUIContext().get("ParentNode"));
        }
        super.setDataObject(dataObject);
    }

    protected void initParentStatisticsPeriod() {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(PFUtils.getHRFilter());
        this.prmtParent.setEntityViewInfo(evi);
        this.prmtParent.setEditFormat("$number$");
        this.prmtParent.setCommitFormat("$number$");
        val = this.prmtParent.getValue();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        Object obj;
        super.beforeStoreFields(e);
        if (this.txtNumber.isEnabled()) {
            PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        }
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkStartDate);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkEndDate);
        PFVerifyUtils.verifyDateBigOrSmall((CoreUIObject)this, this.pkStartDate, this.pkEndDate);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.comboFre);
        if (ReportFrequencyEnum.NULL.equals(this.comboFre.getSelectedItem())) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"comboFreISNULL"));
            SysUtil.abort();
        }
        if ((obj = this.prmtParent.getValue()) != null && obj instanceof AchieveStatisticsPeriodInfo) {
            AchieveStatisticsPeriodInfo info = (AchieveStatisticsPeriodInfo)obj;
            Date startDate = DateTimeUtils.truncateDate((Date)((Date)this.pkStartDate.getValue()));
            Date endDate = DateTimeUtils.truncateDate((Date)((Date)this.pkEndDate.getValue()));
            if (startDate.before(info.getStartDate()) || endDate.after(info.getEndDate())) {
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"parentPeriodIllegal"));
                SysUtil.abort();
            }
            if (info.getId().equals((Object)this.editData.getId())) {
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"parentCanNotBeSelf"));
                SysUtil.abort();
            }
        } else {
            this.prmtParent.setValue(obj);
        }
    }

    private boolean isRefered() throws Exception {
        BOSUuid id = this.editData.getId();
        if (id == null) {
            return false;
        }
        ISolutionPeriod iSolutionPeriod = SolutionPeriodFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("achievePeriod.id", (Object)id.toString(), CompareType.EQUALS));
        return iSolutionPeriod.exists(filter);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isRefered()) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"periodHasRef"));
            return;
        }
        super.actionEdit_actionPerformed(e);
        this.initTxtNumberState();
    }

    private void initTxtNumberState() {
        this.orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        if (this.orgId != null && this.orgId.length() > 0) {
            try {
                this.crm = CodingRuleManagerFactory.getRemoteInstance();
                this.isModifiable = this.crm.isModifiable((IObjectValue)this.editData, this.orgId);
                if (this.isModifiable) {
                    this.txtNumber.setEnabled(true);
                } else {
                    this.txtNumber.setEnabled(false);
                }
            }
            catch (EASBizException e) {
                this.txtNumber.setEnabled(true);
                logger.error((Object)e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.isRefered()) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"periodHasRef"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.getEnum((String)"HRO");
    }
}

