/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.TreePathUtil;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.perf.AchieveStatisticsPeriodFactory;
import com.kingdee.eas.hr.perf.ISolutionPeriod;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.client.AbstractAchieveStatisticsPeriodListUI;
import com.kingdee.eas.hr.perf.client.AchieveStatisticsPeriodEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class AchieveStatisticsPeriodListUI
extends AbstractAchieveStatisticsPeriodListUI {
    private static final Logger logger = CoreUIObject.getLogger(AchieveStatisticsPeriodListUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.refresh(e);
    }

    protected void refresh(ActionEvent e) throws Exception {
        if (e == null) {
            return;
        }
        ItemAction action = this.getActionFromActionEvent(e);
        if (action.equals(this.actionAddNew)) {
            KDTreeNode treeNode = (KDTreeNode)this.treeMain.getModel().getRoot();
            if (treeNode != null) {
                TreePath oldPath = this.treeMain.getSelectionPath();
                if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo && ((TreeBaseInfo)treeNode.getUserObject()).isIsLeaf()) {
                    ((TreeBaseInfo)treeNode.getUserObject()).setIsLeaf(false);
                }
                this.treeBuilder.refreshTreeNode(this.treeMain, treeNode, this.getDefaultFilterForTree());
                this.treeMain.setSelectionRow(-1);
                this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, (TreeModel)this.treeMain.getModel(), (TreePath)oldPath));
                this.treeMain.expandPath(oldPath);
            }
        } else {
            super.refresh(e);
        }
    }

    public void onLoad() throws Exception {
        this.setIncludeAllChildren(true);
        super.onLoad();
        this.btnQuery.setVisible(false);
        this.menuView.remove((JMenuItem)this.menuItemQuery);
        this.tblMain.setColumnMoveable(true);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AchieveStatisticsPeriodFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return AchieveStatisticsPeriodEditUI.class.getName();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        return filter;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return AchieveStatisticsPeriodFactory.getRemoteInstance();
    }

    protected String getLongNumberFieldName() {
        return "longNumber";
    }

    protected String getRootName() {
        return EASResource.getString((String)RES, (String)"AchieveStatisticsPeriod");
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        return filter;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isRefered()) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"periodHasRef"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    private boolean isRefered() throws Exception {
        String id = this.getSelectedKeyValue();
        if (id == null) {
            return false;
        }
        ISolutionPeriod iSolutionPeriod = SolutionPeriodFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("achievePeriod.id", (Object)id, CompareType.EQUALS));
        return iSolutionPeriod.exists(filter);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.isRefered()) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"periodHasRef"));
            return;
        }
        KDTreeNode node = this.getSelectedTreeNode();
        if (node == null || node.isRoot()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"PleaseChooseNode"));
            SysUtil.abort();
        }
        if (node.getChildCount() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"typeHaveSubType"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }
}

