/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.AssessPeriodFactory;
import com.kingdee.eas.hr.perf.AssessPeriodInfo;
import com.kingdee.eas.hr.perf.ISolutionPeriod;
import com.kingdee.eas.hr.perf.PeriodException;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.client.AbstractAssessPeriodEditUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AssessPeriodEditUI
extends AbstractAssessPeriodEditUI {
    private static final long serialVersionUID = -61166L;
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return AssessPeriodFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        AssessPeriodInfo objectValue = new AssessPeriodInfo();
        objectValue.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return objectValue;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkstartDate);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkendDate);
        PFVerifyUtils.verifyDateBigOrSmall((CoreUIObject)this, this.pkstartDate, this.pkendDate);
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.editData, (String)"name");
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.txtName.requestFocus();
            throw new PeriodException(PeriodException.NAME_NULL);
        }
        if (this.pkstartDate.getValue() == null) {
            this.pkstartDate.requestFocus();
            throw new PeriodException(PeriodException.STARTDATE_NULL);
        }
        if (this.pkendDate.getValue() == null) {
            this.pkendDate.requestFocus();
            throw new PeriodException(PeriodException.ENDDATE_NULL);
        }
        Date end = (Date)this.pkendDate.getValue();
        end = this.turncate(end);
        Date start = (Date)this.pkstartDate.getValue();
        if (!end.after(start = this.turncate(start))) {
            this.pkendDate.requestFocus();
            throw new PeriodException(PeriodException.END_GT_START);
        }
    }

    private Date turncate(Date date) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = f.parse(f.format(date));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isRefered()) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"assessPeriodRefed"));
            return;
        }
        this.setUIEnabled(true);
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.isRefered()) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"assessPeriodRefedRemove"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    private boolean isRefered() throws Exception {
        if (this.editData.getId() == null) {
            return false;
        }
        String id = this.editData.getId().toString();
        if (id == null) {
            return false;
        }
        ISolutionPeriod iSolutionPeriod = SolutionPeriodFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("assessPeriod.id", (Object)id, CompareType.EQUALS));
        return iSolutionPeriod.exists(filter);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            if (OprtState.VIEW.equals(this.getOprtState()) || this.isRefered()) {
                this.setUIEnabled(false);
            } else {
                this.setUIEnabled(true);
            }
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
    }

    private void setUIEnabled(boolean status) {
        this.txtName.setEditable(status);
        this.txtNumber.setEditable(status);
        this.pkendDate.setEditable(status);
        this.pkstartDate.setEditable(status);
        this.pkendDate.setRequired(status);
        this.pkstartDate.setRequired(status);
        this.txtRemark.setEditable(status);
        this.btnSubmit.setEnabled(status);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        return sic;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
        super.setAutoNumberByOrg(orgType);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String orgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
            boolean isModifiable = true;
            try {
                ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                boolean result = codingRuleManager.isExist((IObjectValue)this.editData, orgUnitId);
                if (result) {
                    isModifiable = codingRuleManager.isModifiable((IObjectValue)this.editData, orgUnitId);
                    this.txtNumber.setEnabled(isModifiable);
                    this.txtNumber.setEditable(isModifiable);
                }
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (EASBizException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
        } else {
            this.txtNumber.setEnabled(false);
        }
    }
}

