/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTDeleteAction;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.hr.perf.BatchEvaluProcessFacadeFactory;
import com.kingdee.eas.hr.perf.BatchEvaluProcessHelper;
import com.kingdee.eas.hr.perf.CommentEnum;
import com.kingdee.eas.hr.perf.EvaluDetailCollection;
import com.kingdee.eas.hr.perf.EvaluDetailInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.INodeProcesser;
import com.kingdee.eas.hr.perf.NodeProcesserFactory;
import com.kingdee.eas.hr.perf.NodeProcesserInfo;
import com.kingdee.eas.hr.perf.PrecisionMaintainCollection;
import com.kingdee.eas.hr.perf.PrecisionMaintainFactory;
import com.kingdee.eas.hr.perf.PrecisionMaintainInfo;
import com.kingdee.eas.hr.perf.ProcesserWorkedStateEnum;
import com.kingdee.eas.hr.perf.RankCollection;
import com.kingdee.eas.hr.perf.RankConvertRuleInfo;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.AbstractBatchEvaluProcessEditUI;
import com.kingdee.eas.hr.perf.client.EvalCommUI;
import com.kingdee.eas.hr.perf.client.KDFormattedTextField1;
import com.kingdee.eas.hr.perf.client.ModelDialogHelper;
import com.kingdee.eas.hr.perf.client.NodeProcesserEditUI;
import com.kingdee.eas.hr.perf.client.NodeProcesserHelper;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BatchEvaluProcessEditUI
extends AbstractBatchEvaluProcessEditUI {
    private static final String TOTAL_ROW = "totalRow";
    private static final String SUM_ROW = "sumRow";
    private static final String RANK_ROW = "rankRow";
    private static final String INFO = "nodeProcesserInfo";
    private static final String TARGET_STANDARD = "targetStandard";
    private static final String TARGET_COMMENT = "targetDesc";
    private static final String TARGET_TYPE = "targetType";
    private static final String TARGET_ID = "targetID";
    private static final String TARGET_WEIGHT = "targetWeight";
    private static final Logger logger = CoreUIObject.getLogger(BatchEvaluProcessEditUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private static final int COMMENT_LENGTH = 2000;
    private Icon activeIcon = EASResource.getIcon((String)"imgTbtn_ymyjbj");
    private boolean isGrade = false;
    private RankCollection ranks = null;
    private RankCollection targetRanks = null;
    private boolean isCanComment = false;
    private IRowSet evaluTargetRowSet = null;
    private boolean isOutGradeMode = false;
    private GradeModeInfo gradeMode = null;
    private HashMap datas = new HashMap();
    private HashMap datasMirror = new HashMap();
    private String FORMATSTRING = "0.00";
    private KDTable table = new KDTable();
    private int defWidth = 760;
    private String comeFromFlag = null;
    private List comments = new ArrayList();
    private String solutionPeriodID = null;
    private PersonInfo person = null;
    private BigDecimal MAX;
    private BigDecimal MIN;
    private boolean isWeightVisible = false;
    private boolean isMaxSize = false;
    private Rectangle winSize;
    private GradeModeInfo solutionGradeMode;
    private RankConvertRuleInfo rankConvertRule;
    private boolean isLastNode = false;
    private boolean isAllocateTarget;
    public static final BigDecimal percent = new BigDecimal("0.000000");
    private IRow sumRow;
    private IRow rankRow;
    private Set specialRows;
    private String evaluObjectID = null;
    private String evalor = null;
    private String nodeID = null;
    private boolean isOrg = false;
    boolean b = true;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setQueryPreference(false);
        this.specialRows = new HashSet();
        this.specialRows.add(SUM_ROW);
        this.specialRows.add(RANK_ROW);
        this.specialRows.add(TOTAL_ROW);
        this.initParams();
        this.initUI();
        this.initButton();
        if (Integer.parseInt(this.comeFromFlag) != 1) {
            this.btnSubmit.setEnabled(false);
        }
        ((KDTDeleteAction)this.table.getActionMap().get("Delete")).setDeleteMode(2);
        this.table.getActionMap().remove("Cut");
        this.table.getEditHelper().setCoypMode(2);
    }

    private void initButton() throws Exception {
        this.btnViewExistEvaluNode.setText(EASResource.getString((String)RES, (String)"viewExistEvaluNode"));
        this.btnViewExistEvaluNode.setToolTipText(EASResource.getString((String)RES, (String)"viewExistEvaluNode"));
        this.btnViewExistEvaluNode.setIcon(EASResource.getIcon((String)"imgTbtn_applyworkcalendar"));
        this.btnViewExistEvaluNode.setEnabled(true);
        this.btnViewExistEvaluNode.setVisible(true);
    }

    private void initParams() throws Exception {
        Map context = this.getUIContext();
        Map map = this.getBatchEvaluData();
        this.datas = (HashMap)map.get("nodeProcesser");
        this.evaluTargetRowSet = (IRowSet)map.get("evaluTarget");
        this.isGrade = (Boolean)context.get("isGrade");
        this.ranks = (RankCollection)((Object)context.get("ranks"));
        this.targetRanks = (RankCollection)((Object)context.get("targetRanks"));
        this.isCanComment = (Boolean)context.get("isCanComment");
        this.isOutGradeMode = (Boolean)context.get("isOutGradeMode");
        this.gradeMode = (GradeModeInfo)context.get("gradeMode");
        if (this.isGrade) {
            this.MAX = this.gradeMode.getMaxGrade();
            this.MIN = this.gradeMode.getMinGrade();
        }
        this.rankConvertRule = (RankConvertRuleInfo)context.get("rankConvertRule");
        this.solutionGradeMode = (GradeModeInfo)context.get("solutionGradeMode");
        this.comeFromFlag = String.valueOf((Integer)context.get("comeFromFlag"));
        this.solutionPeriodID = (String)context.get("solutionPeriodID");
        this.person = SysContext.getSysContext().getCurrentUserInfo().getPerson();
        this.isLastNode = (Boolean)context.get("isLastNode");
        Dimension dim = NodeProcesserHelper.getDimension();
        this.defWidth = dim.width - 40;
        this.initData();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("formTitle"));
        sic.add(new SelectorItemInfo("evaluFormDesc"));
        sic.add(new SelectorItemInfo("evaluSolution.id"));
        sic.add(new SelectorItemInfo("evaluSolution.inputMode"));
        sic.add(new SelectorItemInfo("evaluSolution.modifyScore"));
        sic.add(new SelectorItemInfo("evaluSolution.targetRankGroup.id"));
        sic.add(new SelectorItemInfo("evaluSolution.targetRankGroup.name"));
        sic.add(new SelectorItemInfo("evaluSolution.rankGroup.id"));
        sic.add(new SelectorItemInfo("evaluSolution.rankGroup.id"));
        sic.add(new SelectorItemInfo("evaluSolution.targetGradeModeLink.id"));
        sic.add(new SelectorItemInfo("evaluSolution.targetGradeModeLink.maxGrade"));
        sic.add(new SelectorItemInfo("evaluSolution.targetGradeModeLink.minGrade"));
        sic.add(new SelectorItemInfo("evaluSolution.targetGradeModeLink.name"));
        sic.add(new SelectorItemInfo("evaluSolution.gradeMode.id"));
        sic.add(new SelectorItemInfo("evaluSolution.gradeMode.maxGrade"));
        sic.add(new SelectorItemInfo("evaluSolution.gradeMode.minGrade"));
        sic.add(new SelectorItemInfo("evaluSolution.gradeMode.name"));
        sic.add(new SelectorItemInfo("evaluSolution.rankConvertRule.id"));
        sic.add(new SelectorItemInfo("evaluSolution.viewSelfForm"));
        sic.add(new SelectorItemInfo("evaluSolution.viewOtherResult"));
        sic.add(new SelectorItemInfo("evaluSolution.outGradeMode"));
        sic.add(new SelectorItemInfo("evaluSolution.viewWeight"));
        sic.add(new SelectorItemInfo("evaluSolution.allocateTarget"));
        sic.add(new SelectorItemInfo("evaluSolution.targetGradeMode"));
        sic.add(new SelectorItemInfo("evaluSolution.canComment"));
        sic.add(new SelectorItemInfo("evaluSolution.solutionType"));
        sic.add(new SelectorItemInfo("evaluSolution.parallelDisplay"));
        sic.add(new SelectorItemInfo("evaluSolution.scoreToNextNode"));
        sic.add(new SelectorItemInfo("evaluSolution.nodeVisibleMode"));
        sic.add(new SelectorItemInfo("assessPeriod.id"));
        SolutionPeriodInfo info = SolutionPeriodFactory.getRemoteInstance().getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(this.solutionPeriodID), sic);
        EvaluSolutionInfo evaluSolution = info.getEvaluSolution();
        this.isOrg = EvaluSolutionTypeEnum.ORGUNIT.equals((Object)evaluSolution.getSolutionType());
    }

    private void initData() throws Exception {
        NodeProcesserInfo info = new NodeProcesserInfo();
        HashMap<String, NodeProcesserInfo> entry = new HashMap<String, NodeProcesserInfo>();
        int size = this.datas.size();
        for (int i = 0; i < size; ++i) {
            entry = (HashMap<String, NodeProcesserInfo>)this.datas.get("" + i);
            info = (NodeProcesserInfo)entry.get(INFO);
            info.setEvaluer(this.person);
            info.setProcesserName(this.person.getName());
            entry.put(INFO, info);
            this.datas.put("" + i, entry);
            entry = new HashMap<String, NodeProcesserInfo>();
            entry.put(INFO, (NodeProcesserInfo)info.clone());
            this.datasMirror.put("" + i, entry);
        }
    }

    protected boolean checkBeforeWindowClosing() {
        this.simpleSaveTable();
        this.saveComment();
        Map entry = null;
        Object key2 = null;
        NodeProcesserInfo info = null;
        NodeProcesserInfo oldInfo = null;
        for (Object key2 : this.datasMirror.keySet()) {
            entry = (Map)this.datas.get(key2);
            info = (NodeProcesserInfo)entry.get(INFO);
            if (ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)info, (AbstractObjectValue)(oldInfo = (NodeProcesserInfo)(entry = (Map)this.datasMirror.get(key2)).get(INFO)))) continue;
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                this.actionSave.setDaemonRun(false);
                ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                this.actionSave.actionPerformed(event);
                return !this.actionSave.isInvokeFailed();
            }
            return result != 2;
        }
        return true;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.saveTable();
        this.saveComment();
        Map entry = null;
        Object key2 = null;
        NodeProcesserInfo info = null;
        IObjectPK pk = null;
        INodeProcesser iNodeProcesser = NodeProcesserFactory.getRemoteInstance();
        for (Object key2 : this.datas.keySet()) {
            entry = (Map)this.datas.get(key2);
            info = (NodeProcesserInfo)entry.get(INFO);
            info.setEvaluer(this.person);
            info.setProcesserName(this.person.getName());
            if (info.getWorkedState() == null) {
                info.setWorkedState(ProcesserWorkedStateEnum.NOTSUBMIT);
            }
            pk = iNodeProcesser.save((CoreBaseInfo)info);
            info.setId(BOSUuid.read((String)pk.toString()));
            entry.put(INFO, info);
            this.datas.put(key2, entry);
        }
        this.backup();
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"saveDataOK"));
    }

    private EvaluDetailInfo getEvaluDetailInfoByEvaluTargetID(String id, NodeProcesserInfo info) {
        if (id == null) {
            return null;
        }
        EvaluDetailInfo detailInfo = null;
        EvaluDetailCollection coll = info.getEvaluDetails();
        if (coll == null || coll.size() == 0) {
            return null;
        }
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            if (!coll.get(i).getTargetEvaluStore().getEvaluTarget().getId().toString().equals(id)) continue;
            detailInfo = coll.get(i);
            break;
        }
        return detailInfo;
    }

    private void saveTable() throws Exception {
        if (this.isGrade) {
            this.checkGradeMode();
        }
        this.simpleSaveTable();
        this.calTotalValue();
    }

    private void simpleSaveTable() {
        int rowCount = this.table.getRowCount();
        int colCount = this.table.getColumnCount();
        int weightColIndex = this.table.getColumnIndex(TARGET_WEIGHT);
        IRow row = null;
        ICell cell = null;
        Object cellValue = null;
        int index = 0;
        Map entry = null;
        NodeProcesserInfo info = null;
        EvaluDetailInfo evaluDetailInfo = null;
        String typeID = null;
        for (int i = weightColIndex + 1; i < colCount; ++i) {
            for (int j = 0; j < rowCount; ++j) {
                row = this.table.getRow(j);
                cell = this.table.getCell(j, i);
                cellValue = cell.getValue();
                typeID = (String)row.getCell(TARGET_ID).getValue();
                if (this.specialRows.contains(typeID)) continue;
                entry = (Map)this.datas.get("" + index);
                info = (NodeProcesserInfo)entry.get(INFO);
                evaluDetailInfo = this.getEvaluDetailInfoByEvaluTargetID(typeID, info);
                if (this.isGrade) {
                    if (cellValue != null) {
                        evaluDetailInfo.setTargetScore((BigDecimal)cellValue);
                    } else {
                        evaluDetailInfo.setTargetScore(null);
                    }
                } else if (cellValue != null) {
                    evaluDetailInfo.setRank((RankInfo)cellValue);
                } else {
                    evaluDetailInfo.setRank(null);
                }
                if (this.isCanComment) {
                    if ((cellValue = this.table.getCell(j, ++i).getValue()) != null) {
                        evaluDetailInfo.setComment((String)cellValue);
                    } else {
                        evaluDetailInfo.setComment(null);
                    }
                    --i;
                }
                entry.put(INFO, info);
                this.datas.put("" + index, entry);
            }
            if (this.isCanComment) {
                ++i;
            }
            ++index;
        }
    }

    private void calTotalValue() {
        int rowCount = this.table.getRowCount();
        int colCount = this.table.getColumnCount();
        int weightColIndex = this.table.getColumnIndex(TARGET_WEIGHT);
        BigDecimal totalValue = null;
        BigDecimal percent = new BigDecimal("0.01");
        BigDecimal weight = null;
        ICell cell = null;
        Object cellValue = null;
        int index = 0;
        Map entry = null;
        NodeProcesserInfo info = null;
        String typeID = null;
        for (int i = weightColIndex + 1; i < colCount; ++i) {
            totalValue = new BigDecimal("0.000000");
            for (int j = 0; j < rowCount; ++j) {
                IRow row = this.table.getRow(j);
                typeID = (String)row.getCell(TARGET_ID).getValue();
                if (this.specialRows.contains(typeID)) continue;
                weight = new BigDecimal(row.getCell(TARGET_WEIGHT).getValue().toString());
                cell = row.getCell(i);
                cellValue = cell.getValue();
                if (cellValue == null) continue;
                if (!this.isGrade) {
                    cellValue = ((RankInfo)cellValue).getGrade();
                }
                totalValue = totalValue.add(((BigDecimal)cellValue).multiply(weight));
            }
            totalValue = totalValue.multiply(percent);
            cell = this.isAllocateTarget && this.isLastNode ? this.table.getCell(rowCount - 3, i) : this.table.getCell(rowCount - 2, i);
            entry = (Map)this.datas.get("" + index);
            info = (NodeProcesserInfo)entry.get(INFO);
            info.setNodeScore(totalValue);
            cell.setValue((Object)totalValue);
            if (this.isCanComment) {
                ++i;
            }
            ++index;
        }
    }

    private void checkGradeMode() {
        int rowCount = this.table.getRowCount();
        int colCount = this.table.getColumnCount();
        int weightColIndex = this.table.getColumnIndex(TARGET_WEIGHT);
        IRow row = null;
        ICell cell = null;
        Object cellValue = null;
        int index = 0;
        String typeID = null;
        KDTEditManager em = this.table.getEditManager();
        for (int i = weightColIndex + 1; i < colCount; ++i) {
            for (int j = 0; j < rowCount; ++j) {
                row = this.table.getRow(j);
                cell = this.table.getCell(j, i);
                cellValue = cell.getValue();
                typeID = (String)row.getCell(TARGET_ID).getValue();
                if (this.specialRows.contains(typeID) || !this.isGrade || cellValue == null) continue;
                if (((BigDecimal)cellValue).compareTo(this.MAX) > 0 && !this.isOutGradeMode) {
                    MsgBox.showInfo((String)(EASResource.getString((String)RES, (String)"gradeUPIllegal") + PFVerifyUtils.formatBigDecimal(this.MAX, 2)));
                    cell.setValue(null);
                    em.editCellAt(j, i);
                    SysUtil.abort();
                    continue;
                }
                if (((BigDecimal)cellValue).compareTo(this.MIN) >= 0 || this.isOutGradeMode) continue;
                MsgBox.showInfo((String)(EASResource.getString((String)RES, (String)"gradeDownIllegal") + PFVerifyUtils.formatBigDecimal(this.MIN, 2)));
                cell.setValue(null);
                em.editCellAt(j, i);
                SysUtil.abort();
            }
            if (this.isCanComment) {
                ++i;
            }
            ++index;
        }
    }

    private void backup() {
        Map entry = null;
        Object key2 = null;
        NodeProcesserInfo info = null;
        for (Object key2 : this.datasMirror.keySet()) {
            entry = (Map)this.datas.get(key2);
            info = (NodeProcesserInfo)entry.get(INFO);
            entry = (Map)this.datasMirror.get(key2);
            entry.put(INFO, info.clone());
            this.datasMirror.put(key2, entry);
        }
    }

    private void saveComment() {
        KDTextArea area2 = null;
        NodeProcesserInfo info = null;
        for (KDTextArea area2 : this.comments) {
            String comment = area2.getText();
            info = (NodeProcesserInfo)area2.getUserObject();
            if (comment == null || "".equals(comment.trim())) {
                info.setComment(null);
                continue;
            }
            info.setComment(comment);
        }
    }

    private boolean checkValid() {
        ICell cell = null;
        int weightIndex = this.table.getColumn(TARGET_WEIGHT).getColumnIndex();
        KDTEditManager editManager = this.table.getEditManager();
        NodeProcesserInfo info = null;
        int count = this.table.getRowCount();
        IRow row = null;
        String typeID = null;
        for (int i = 0; i < count; ++i) {
            row = this.table.getRow(i);
            typeID = (String)row.getCell(TARGET_ID).getValue();
            if (this.specialRows.contains(typeID)) continue;
            int colCount = this.table.getColumnCount();
            for (int j = weightIndex + 1; j < colCount; ++j) {
                cell = this.table.getCell(i, j);
                info = (NodeProcesserInfo)this.table.getColumn(j).getUserObject();
                if (cell.getValue() == null && info.getEvaluNode().isCanGrade()) {
                    if (this.isGrade) {
                        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"plzInputScore"));
                    } else {
                        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"plzInputGrade"));
                    }
                    editManager.editCellAt(i, j);
                    return false;
                }
                if (!this.isCanComment) continue;
                ++j;
            }
        }
        int colCount = this.table.getColumnCount();
        for (int j = weightIndex + 1; j < colCount; ++j) {
            cell = this.rankRow.getCell(j);
            if (cell.getValue() != null || cell.getStyleAttributes().isLocked()) continue;
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"plzInputGrade"));
            return false;
        }
        KDTextArea area2 = null;
        for (KDTextArea area2 : this.comments) {
            if (area2.getText() != null && !"".equals(area2.getText().trim()) || !CommentEnum.mandatoryComment.equals((Object)(info = (NodeProcesserInfo)area2.getUserObject()).getEvaluNode().getCanComment())) continue;
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"plzInputComm"));
            area2.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkValid()) {
            return;
        }
        this.saveTable();
        this.saveComment();
        int result = MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"synPaperSubmitConfirm"));
        if (result != 0) {
            return;
        }
        BatchEvaluProcessFacadeFactory.getRemoteInstance().batchSubmit(this.datas);
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"synPaperSubmitOK"));
        this.backup();
        this.getUIWindow().close();
    }

    private void initUI() throws Exception {
        int i;
        int index;
        int i2;
        SolutionPeriodInfo info = SolutionPeriodFactory.getRemoteInstance().getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(this.solutionPeriodID));
        EvaluSolutionInfo evaluSolution = info.getEvaluSolution();
        PrecisionMaintainInfo PMinfo1 = BatchEvaluProcessEditUI.getPrecisionMaintainInfo(evaluSolution.getId().toString());
        StringBuffer jingdu1 = new StringBuffer();
        StringBuffer jingduTotal = new StringBuffer();
        jingdu1.append("0.");
        jingduTotal.append("0.");
        if (PMinfo1 != null) {
            int j;
            for (j = 0; j < PMinfo1.getIndexGradePrecision(); ++j) {
                jingdu1.append("0");
            }
            for (j = 0; j < PMinfo1.getNodeScorePrecision(); ++j) {
                jingduTotal.append("0");
            }
        } else {
            jingdu1.append("00");
            jingduTotal.append("00");
        }
        int datasSize = this.datas.size();
        String[] cols = new String[]{TARGET_ID, TARGET_TYPE, TARGET_COMMENT, TARGET_STANDARD, TARGET_WEIGHT};
        int[] targetWidth = new int[]{0, 125, 175, 250, 100};
        String[] title = new String[]{TARGET_ID, EASResource.getString((String)RES, (String)TARGET_TYPE), EASResource.getString((String)RES, (String)TARGET_COMMENT), EASResource.getString((String)RES, (String)TARGET_STANDARD), EASResource.getString((String)RES, (String)TARGET_WEIGHT)};
        int totalHeight = 0;
        int totalWidth = 0;
        int heightBase = 10;
        int rowHeight = 19;
        int columnWidth = 100;
        IColumn column = null;
        KDTDefaultCellEditor editor = null;
        for (int i3 = 0; i3 < cols.length; ++i3) {
            column = this.table.addColumn();
            column.setKey(cols[i3]);
            column.setWidth(targetWidth[i3]);
            totalWidth += targetWidth[i3];
            column.getStyleAttributes().setLocked(true);
        }
        this.table.getColumn(TARGET_ID).getStyleAttributes().setHided(true);
        NodeProcesserInfo nodeProcesserInfo = null;
        boolean isCanGrade = false;
        editor = this.getGradeCellEditor(this.isGrade);
        String headKey = null;
        if (this.isCanComment) {
            for (i2 = 0; i2 < datasSize; ++i2) {
                column = this.table.addColumn();
                column.setWidth(columnWidth);
                totalWidth += columnWidth;
                headKey = (String)((Map)this.datas.get("" + i2)).get("assignID");
                column.setKey(headKey);
                nodeProcesserInfo = (NodeProcesserInfo)((Map)this.datas.get("" + i2)).get(INFO);
                isCanGrade = nodeProcesserInfo.getEvaluNode().isCanGrade();
                column.getStyleAttributes().setLocked(!isCanGrade);
                if (!isCanGrade) {
                    column.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                }
                column.setEditor((ICellEditor)editor);
                column.setUserObject((Object)nodeProcesserInfo);
                column = this.table.addColumn();
                column.setWidth(columnWidth);
                totalWidth += columnWidth;
                column.setKey(headKey + "comment");
                column.setUserObject((Object)nodeProcesserInfo);
                column.getStyleAttributes().setLocked(true);
            }
        } else {
            for (i2 = 0; i2 < datasSize; ++i2) {
                column = this.table.addColumn();
                column.setWidth(columnWidth);
                totalWidth += columnWidth;
                headKey = (String)((Map)this.datas.get("" + i2)).get("assignID");
                column.setKey(headKey);
                nodeProcesserInfo = (NodeProcesserInfo)((Map)this.datas.get("" + i2)).get(INFO);
                isCanGrade = nodeProcesserInfo.getEvaluNode().isCanGrade();
                column.getStyleAttributes().setLocked(!isCanGrade);
                if (!isCanGrade) {
                    column.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                }
                column.setEditor((ICellEditor)editor);
                column.setUserObject((Object)nodeProcesserInfo);
            }
        }
        this.table.addHeadRow();
        int flag = 0;
        ICell cell = null;
        int count = this.table.getColumnCount();
        IRow headRow = this.table.getHeadRow(0);
        headRow.setHeight(rowHeight);
        totalHeight += rowHeight;
        for (index = 0; index < title.length; ++index) {
            headRow.getCell(index).setValue((Object)title[index]);
        }
        String targetComm = EASResource.getString((String)RES, (String)"targetComm");
        if (this.isCanComment) {
            while (index < count) {
                headRow.getCell(index).setValue((Object)((String)((Map)this.datas.get("" + flag)).get("evaluObjectName")));
                headRow.getCell(++index).setValue((Object)targetComm);
                ++index;
                ++flag;
            }
        } else {
            while (index < count) {
                headRow.getCell(index).setValue((Object)((String)((Map)this.datas.get("" + flag)).get("evaluObjectName")));
                ++index;
                ++flag;
            }
        }
        int style = 13;
        IRow row = null;
        int rowSize = 12;
        int max = 0;
        String content = null;
        String standard = null;
        String targetID = null;
        Map entry = null;
        this.evaluTargetRowSet.beforeFirst();
        while (this.evaluTargetRowSet.next()) {
            row = this.table.addRow();
            int currentHeight = rowHeight;
            max = rowSize;
            cell = row.getCell(TARGET_ID);
            cell.setValue((Object)this.evaluTargetRowSet.getString("evaluTargetID"));
            targetID = row.getCell(TARGET_ID).getValue().toString();
            cell = row.getCell(TARGET_TYPE);
            cell.setValue((Object)this.evaluTargetRowSet.getString("targetTypeName"));
            cell = row.getCell(TARGET_COMMENT);
            content = this.evaluTargetRowSet.getString("content");
            cell.setValue((Object)content);
            if (content != null && content.length() > max) {
                max = content.length();
            }
            cell.getStyleAttributes().setWrapText(true);
            cell = row.getCell(TARGET_STANDARD);
            standard = this.evaluTargetRowSet.getString("standard");
            cell.setValue((Object)standard);
            if (standard != null && standard.length() > max) {
                max = standard.length();
            }
            cell.getStyleAttributes().setWrapText(true);
            currentHeight = max / rowSize < 3 ? 19 * (max / rowSize) : 12 * (max / rowSize - 3) + 57;
            cell = row.getCell(TARGET_WEIGHT);
            cell.setValue((Object)this.evaluTargetRowSet.getString("weight"));
            cell.setRenderer(NodeProcesserHelper.WEIGHT_PERCENT_RENDER);
            EvaluDetailInfo evaluDetailInfo = null;
            for (i = 0; i < datasSize; ++i) {
                entry = (Map)this.datas.get("" + i);
                nodeProcesserInfo = (NodeProcesserInfo)entry.get(INFO);
                if (!this.isWeightVisible && nodeProcesserInfo.getEvaluNode().isWeightVisable()) {
                    this.isWeightVisible = true;
                }
                cell = row.getCell((String)entry.get("assignID"));
                cell.setEditor((ICellEditor)this.getGradeCellEditor(this.isGrade));
                evaluDetailInfo = this.getEvaluDetailInfoByEvaluTargetID(targetID, nodeProcesserInfo);
                if (this.isGrade) {
                    cell.setValue((Object)evaluDetailInfo.getTargetScore());
                    cell.getStyleAttributes().setNumberFormat(jingdu1.toString());
                    cell.setUserObject((Object)evaluDetailInfo);
                } else {
                    cell.setValue((Object)evaluDetailInfo.getRank());
                    if (evaluDetailInfo.getRank() != null) {
                        PerfClientUtils.setComboBoxSelected((KDComboBox)cell.getEditor().getComponent(), evaluDetailInfo.getRank().getId().toString());
                    }
                    cell.setUserObject((Object)evaluDetailInfo);
                }
                if (!this.isCanComment) continue;
                cell = row.getCell(entry.get("assignID") + "comment");
                cell.setValue((Object)evaluDetailInfo.getComment());
                cell.setUserObject((Object)evaluDetailInfo);
            }
            row.setHeight(currentHeight);
            totalHeight += currentHeight;
        }
        if (!this.isWeightVisible) {
            int col = this.table.getColumnIndex(TARGET_WEIGHT);
            ICell weightCell = null;
            int curCount = this.table.getRowCount();
            for (i = 0; i < curCount; ++i) {
                weightCell = this.table.getCell(i, col);
                weightCell.setRenderer(NodeProcesserHelper.WEIGHT_XINGHAO_RENDER);
            }
        }
        KDTMergeManager mergeManager = this.table.getMergeManager();
        row = this.table.addRow();
        row.getCell(TARGET_ID).setValue((Object)SUM_ROW);
        this.sumRow = row;
        row.setHeight(rowHeight);
        totalHeight += rowHeight;
        row.getCell(1).setValue((Object)EASResource.getString((String)RES, (String)"sumTestPaperInput"));
        row.getStyleAttributes().setBackground(new Color(0xF6F6BF));
        editor = this.getGradeCellEditor(true);
        for (int i4 = 0; i4 < datasSize; ++i4) {
            entry = (Map)this.datas.get("" + i4);
            nodeProcesserInfo = (NodeProcesserInfo)entry.get(INFO);
            cell = row.getCell((String)entry.get("assignID"));
            cell.setEditor((ICellEditor)editor);
            cell.setValue((Object)nodeProcesserInfo.getNodeScore());
            cell.setUserObject((Object)nodeProcesserInfo);
            cell.getStyleAttributes().setNumberFormat(jingduTotal.toString());
        }
        row.getStyleAttributes().setLocked(true);
        mergeManager.mergeBlock(row.getRowIndex(), 1, row.getRowIndex(), row.getCell(TARGET_WEIGHT).getColumnIndex());
        row = this.table.addRow();
        row.getCell(TARGET_ID).setValue((Object)RANK_ROW);
        this.rankRow = row;
        row.setHeight(rowHeight);
        totalHeight += rowHeight;
        row.getCell(1).setValue((Object)EASResource.getString((String)RES, (String)"rank"));
        row.getStyleAttributes().setBackground(new Color(0xF6F6BF));
        editor = this.getRankCellEditor();
        boolean isCanEvaluLevel = false;
        for (i = 0; i < datasSize; ++i) {
            entry = (Map)this.datas.get("" + i);
            nodeProcesserInfo = (NodeProcesserInfo)entry.get(INFO);
            cell = row.getCell((String)entry.get("assignID"));
            cell.setUserObject((Object)nodeProcesserInfo);
            cell.setEditor((ICellEditor)editor);
            isCanEvaluLevel = nodeProcesserInfo.getEvaluNode().isCanEvaluateLevel();
            cell.getStyleAttributes().setLocked(!isCanEvaluLevel);
            if (isCanEvaluLevel) {
                cell.setValue((Object)nodeProcesserInfo.getRank());
                if (nodeProcesserInfo.getRank() != null) {
                    PerfClientUtils.setComboBoxSelected((KDComboBox)cell.getEditor().getComponent(), nodeProcesserInfo.getRank().getId().toString());
                }
            } else {
                cell.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
            }
            if (!this.isCanComment) continue;
            cell = row.getCell((String)entry.get("assignID") + "comment");
            cell.getStyleAttributes().setLocked(true);
        }
        mergeManager.mergeBlock(row.getRowIndex(), 1, row.getRowIndex(), row.getCell(TARGET_WEIGHT).getColumnIndex());
        if (this.isAllocateTarget && this.isLastNode) {
            row = this.table.addRow();
            row.getCell(TARGET_ID).setValue((Object)TOTAL_ROW);
            row.setHeight(rowHeight);
            totalHeight += rowHeight;
            row.getCell(1).setValue((Object)EASResource.getString((String)RES, (String)"totalScore"));
            row.getStyleAttributes().setLocked(true);
            for (i = 0; i < datasSize; ++i) {
                entry = (Map)this.datas.get("" + i);
                nodeProcesserInfo = (NodeProcesserInfo)entry.get(INFO);
                cell = row.getCell((String)entry.get("assignID"));
                cell.getStyleAttributes().setNumberFormat(this.FORMATSTRING);
                BigDecimal oldTotalScore = (BigDecimal)nodeProcesserInfo.get("oldTotalScore");
                if (nodeProcesserInfo.getNodeScore() != null) {
                    cell.setValue((Object)oldTotalScore.add(nodeProcesserInfo.getNodeScore().multiply(nodeProcesserInfo.getEvaluNode().getWeight()).multiply(percent)));
                    continue;
                }
                cell.setValue((Object)oldTotalScore);
            }
            mergeManager.mergeBlock(row.getRowIndex(), 1, row.getRowIndex(), row.getCell(TARGET_WEIGHT).getColumnIndex());
        }
        this.table.getColumn(TARGET_WEIGHT).getStyleAttributes().setNumberFormat(this.FORMATSTRING);
        this.table.getGroupManager().setGroup(true);
        this.table.getColumn(TARGET_TYPE).setGroup(true);
        this.table.getColumn(TARGET_TYPE).setMergeable(true);
        totalHeight += 2;
        if ((totalWidth += 27) > this.defWidth) {
            totalHeight += 17;
        }
        heightBase += totalHeight;
        heightBase = this.renderComment(heightBase, this.defWidth);
        heightBase += 10;
        this.table.setSize(this.defWidth, totalHeight);
        this.pnlMain.add((Component)this.table, (Object)new KDLayout.Constraints(10, 10, this.defWidth, totalHeight, style));
        if (this.table.isEditable()) {
            this.table.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

                public void propertyChange(KDTPropertyChangeEvent evt) {
                    try {
                        BatchEvaluProcessEditUI.this.actionTableeditStopped(evt);
                    }
                    catch (Exception e) {
                        BatchEvaluProcessEditUI.this.handUIException(e);
                    }
                }
            });
        }
        this.table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                BatchEvaluProcessEditUI.this.actionTableClicked(e);
            }
        });
        this.table.checkParsed();
        this.table.getViewManager().setFreezeView(0, this.table.getColumn(TARGET_WEIGHT).getColumnIndex());
        ((KDTDeleteAction)this.table.getActionMap().get("Delete")).setDeleteMode(2);
        this.simpleSaveTable();
        if (heightBase > 630) {
            this.pnlMain.setPreferredSize(new Dimension(760, heightBase));
        }
        this.revalidate();
        this.pnlMain.revalidate();
    }

    @Override
    public void actionViewExistEvaluNode_actionPerformed(ActionEvent e) throws Exception {
        int colIndex = this.table.getSelectManager().getActiveColumnIndex();
        if (colIndex < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"pleaseSelectEvaluObject"));
            return;
        }
        Object nodeInfo = this.table.getColumn(colIndex).getUserObject();
        if (nodeInfo == null || !(nodeInfo instanceof NodeProcesserInfo)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"pleaseSelectEvaluObject"));
            return;
        }
        NodeProcesserInfo info = null;
        info = (NodeProcesserInfo)nodeInfo;
        this.evaluObjectID = info.getEvaluResult().getEvaluObject().getId().toString();
        this.evalor = info.getEvaluResult().getEvaluObject().getObjectID();
        this.nodeID = new Integer(info.getEvaluNode().getSeqNumber()).toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"evaluObjectID", (Object)this.evaluObjectID);
        uiContext.put((Object)"solutionPeriodID", (Object)this.solutionPeriodID);
        uiContext.put((Object)"evalor", (Object)this.evalor);
        uiContext.put((Object)"nodeID", (Object)this.nodeID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(NodeProcesserEditUI.class.getName(), (Map)uiContext, this.dataObjects, OprtState.VIEW);
        uiWindow.show();
        super.actionViewExistEvaluNode_actionPerformed(e);
    }

    private void actionTableClicked(KDTMouseEvent e) {
        try {
            int col = this.table.getColumn(TARGET_WEIGHT).getColumnIndex();
            if (e.getColIndex() <= col) {
                return;
            }
            if (!this.isCanComment) {
                return;
            }
            if (e.getClickCount() != 2) {
                return;
            }
            KDTable table = (KDTable)e.getSource();
            if (this.isAllocateTarget && this.isLastNode ? e.getRowIndex() >= table.getRowCount() - 3 : e.getRowIndex() >= table.getRowCount() - 2) {
                return;
            }
            if ((e.getColIndex() - col) % 2 != 0) {
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"0", table.getRow(e.getRowIndex()).getCell(e.getColIndex()).getValue());
            String oprtStateStr = null;
            oprtStateStr = table.isEditable() ? OprtState.EDIT : OprtState.VIEW;
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EvalCommUI.class.getName(), (Map)uiContext, null, oprtStateStr);
            uiWindow.show();
            if (!table.isEditable()) {
                return;
            }
            EvalCommUI ui = (EvalCommUI)uiWindow.getUIObject();
            String comment = ui.getComment();
            NodeProcesserInfo info = (NodeProcesserInfo)table.getColumn(e.getColIndex()).getUserObject();
            if (comment == null || "".equals(comment.trim())) {
                info.setComment(comment);
            } else {
                info.setComment(comment);
            }
            table.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)info.getComment());
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void actionTableeditStopped(KDTPropertyChangeEvent evt) throws Exception {
        SolutionPeriodInfo info1 = SolutionPeriodFactory.getRemoteInstance().getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(this.solutionPeriodID));
        EvaluSolutionInfo evaluSolution = info1.getEvaluSolution();
        boolean customPrecision = evaluSolution.isCustomPrecision();
        StringBuffer jingdu2 = new StringBuffer();
        if (customPrecision) {
            PrecisionMaintainInfo PMinfo2 = BatchEvaluProcessEditUI.getPrecisionMaintainInfo(evaluSolution.getId().toString());
            jingdu2.append("0.");
            if (PMinfo2 != null) {
                for (int j = 0; j < PMinfo2.getNodeScorePrecision(); ++j) {
                    jingdu2.append("0");
                }
            }
        } else {
            jingdu2.append("0.00");
        }
        try {
            NodeProcesserInfo nodeProcesserinfo = null;
            int colIndex = evt.getColIndex();
            int rowIndex = evt.getRowIndex();
            KDTable table = (KDTable)evt.getSource();
            int weightColIndex = table.getColumn(TARGET_WEIGHT).getColumnIndex();
            if (colIndex <= weightColIndex) {
                return;
            }
            if (this.isCanComment && (colIndex - weightColIndex) % 2 == 0) {
                return;
            }
            int rowCount = table.getRowCount();
            ICell cell = null;
            cell = table.getCell(rowIndex, colIndex);
            if (this.isAllocateTarget && this.isLastNode) {
                if (rowIndex == rowCount - 3) {
                    nodeProcesserinfo = (NodeProcesserInfo)cell.getUserObject();
                    BatchEvaluProcessHelper.dealSumValueChange(this.solutionGradeMode, this.gradeMode, evt, nodeProcesserinfo, table.getColumnKey(colIndex), this.rankConvertRule, rowIndex);
                    return;
                }
                if (rowIndex == rowCount - 1) {
                    return;
                }
            } else if (rowIndex == rowCount - 2) {
                nodeProcesserinfo = (NodeProcesserInfo)cell.getUserObject();
                BatchEvaluProcessHelper.dealSumValueChange(this.solutionGradeMode, this.gradeMode, evt, nodeProcesserinfo, table.getColumnKey(colIndex), this.rankConvertRule, rowIndex);
                return;
            }
            boolean flag = false;
            if (this.isAllocateTarget && this.isLastNode) {
                if (rowIndex == rowCount - 2) {
                    flag = true;
                }
            } else if (rowIndex == rowCount - 1) {
                flag = true;
            }
            if (flag) {
                cell = table.getCell(rowIndex, colIndex);
                nodeProcesserinfo = (NodeProcesserInfo)cell.getUserObject();
                if (nodeProcesserinfo.getEvaluNode().isCanEvaluateLevel()) {
                    if (cell.getValue() != null) {
                        RankInfo rank = (RankInfo)cell.getValue();
                        nodeProcesserinfo.setRank(rank);
                    } else {
                        nodeProcesserinfo.setRank(null);
                    }
                }
                return;
            }
            Object vo = null;
            cell = table.getCell(rowIndex, colIndex);
            EvaluDetailInfo info = (EvaluDetailInfo)cell.getUserObject();
            vo = cell.getValue();
            if (this.isGrade) {
                if (vo != null) {
                    info.setTargetScore((BigDecimal)vo);
                } else {
                    info.setTargetScore(null);
                    this.clearSumCell(colIndex);
                }
            } else if (vo != null) {
                info.setRank((RankInfo)vo);
            } else {
                info.setRank(null);
                this.clearSumCell(colIndex);
            }
            BigDecimal cellValue = null;
            BigDecimal weight = null;
            RankInfo value = null;
            BigDecimal totalValue = new BigDecimal("0.000000");
            BigDecimal percent = new BigDecimal("0.01");
            int count = rowCount - 2;
            if (this.isAllocateTarget && this.isLastNode) {
                count = rowCount - 3;
            }
            for (int i = 0; i < count; ++i) {
                cell = table.getCell(i, weightColIndex);
                if (cell.getValue() == null) continue;
                weight = new BigDecimal(cell.getValue().toString());
                cell = table.getCell(i, colIndex);
                if (this.isGrade) {
                    cellValue = (BigDecimal)cell.getValue();
                } else {
                    value = (RankInfo)cell.getValue();
                    if (value == null) continue;
                    cellValue = value.getGrade();
                }
                if (cellValue == null) continue;
                totalValue = totalValue.add(cellValue.multiply(weight));
            }
            totalValue = totalValue.multiply(percent);
            cell = table.getCell(count, colIndex);
            KDTDefaultCellEditor editor = this.getGradeCellEditor(true);
            cell.setEditor((ICellEditor)editor);
            cell.getStyleAttributes().setNumberFormat(jingdu2.toString());
            nodeProcesserinfo = (NodeProcesserInfo)cell.getUserObject();
            nodeProcesserinfo.setNodeScore(totalValue);
            cell.setValue((Object)totalValue);
            if (this.isAllocateTarget && this.isLastNode) {
                cell = table.getCell(rowCount - 1, colIndex);
                BigDecimal oldTotalScore = (BigDecimal)nodeProcesserinfo.get("oldTotalScore");
                cell.setValue((Object)oldTotalScore.add(nodeProcesserinfo.getNodeScore().multiply(nodeProcesserinfo.getEvaluNode().getWeight()).multiply(percent)));
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void clearSumCell(int colIndex) {
        int rowCount = this.table.getRowCount();
        int count = rowCount - 2;
        if (this.isAllocateTarget && this.isLastNode) {
            count = rowCount - 3;
        }
        ICell cell = this.table.getCell(count, colIndex);
        NodeProcesserInfo sumNodeInfo = (NodeProcesserInfo)cell.getUserObject();
        cell.setValue(null);
        sumNodeInfo.setNodeScore(null);
    }

    private int renderComment(int heightBase, int width) throws Exception {
        KDLabel iconlbl = null;
        KDLabelContainer contIcon = null;
        StringBuffer sb = null;
        KDScrollPane scroll = null;
        KDTextArea commArea = null;
        int commStyle = 13;
        String comment = EASResource.getString((String)RES, (String)"pleaseComment");
        Map temp = new HashMap();
        NodeProcesserInfo nodeProcesserInfo = null;
        int size = this.datas.size();
        for (int i = 0; i < size; ++i) {
            temp = (Map)this.datas.get("" + i);
            nodeProcesserInfo = (NodeProcesserInfo)temp.get(INFO);
            if (CommentEnum.noComment.equals((Object)nodeProcesserInfo.getEvaluNode().getCanComment())) continue;
            iconlbl = new KDLabel();
            iconlbl.setBounds(10, heightBase += 10, 30, 19);
            iconlbl.setIcon(this.activeIcon);
            this.pnlMain.add((Component)iconlbl, (Object)new KDLayout.Constraints(10, heightBase, 30, 19, commStyle));
            sb = new StringBuffer();
            sb.append(comment);
            sb.append(": ");
            sb.append(temp.get("evaluObjectName"));
            contIcon = new KDLabelContainer();
            contIcon.setBoundLabelText(sb.toString());
            contIcon.setBounds(30, heightBase, 270, 19);
            this.pnlMain.add((Component)contIcon, (Object)new KDLayout.Constraints(30, heightBase, 270, 19, commStyle));
            scroll = new KDScrollPane();
            scroll.setBounds(10, heightBase += 19, width, 100);
            this.pnlMain.add((Component)scroll, (Object)new KDLayout.Constraints(10, heightBase, width, 100, commStyle));
            commArea = new KDTextArea();
            commArea.setMaxLength(2000);
            commArea.setUserObject((Object)nodeProcesserInfo);
            commArea.setText(nodeProcesserInfo.getComment());
            scroll.getViewport().add((Component)commArea, null);
            this.comments.add(commArea);
            heightBase += 100;
        }
        return heightBase;
    }

    private KDTDefaultCellEditor getRankCellEditor() {
        KDComboBox rankComboBox = new KDComboBox();
        rankComboBox.addItems(this.ranks.toArray());
        return new KDTDefaultCellEditor((JComboBox)rankComboBox);
    }

    private KDTDefaultCellEditor getGradeCellEditor(boolean isGrade) throws Exception {
        SolutionPeriodInfo info1 = SolutionPeriodFactory.getRemoteInstance().getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(this.solutionPeriodID));
        EvaluSolutionInfo evaluSolution = info1.getEvaluSolution();
        PrecisionMaintainInfo pmInfo = BatchEvaluProcessEditUI.getPrecisionMaintainInfo(evaluSolution.getId().toString());
        KDTDefaultCellEditor editor = null;
        if (isGrade) {
            KDFormattedTextField1 scoreTextField = new KDFormattedTextField1();
            scoreTextField.setDataType(1);
            scoreTextField.setRemoveingZeroInDispaly(false);
            scoreTextField.setRemoveingZeroInEdit(false);
            if (pmInfo != null) {
                if (10 == pmInfo.getIndexGradePrecisionType().getValue()) {
                    scoreTextField.setRoundingMode(4);
                } else if (20 == pmInfo.getIndexGradePrecisionType().getValue()) {
                    scoreTextField.setRoundingMode(0);
                } else if (30 == pmInfo.getIndexGradePrecisionType().getValue()) {
                    scoreTextField.setRoundingMode(1);
                }
            }
            editor = new KDTDefaultCellEditor((JTextField)((Object)scoreTextField));
        } else {
            KDComboBox comboBox = new KDComboBox();
            comboBox.addItems(this.targetRanks.toArray());
            editor = new KDTDefaultCellEditor((JComboBox)comboBox);
        }
        return editor;
    }

    public static PrecisionMaintainInfo getPrecisionMaintainInfo(String evaluSolutionID) throws Exception {
        PrecisionMaintainInfo info = null;
        if (evaluSolutionID != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)evaluSolutionID, CompareType.EQUALS));
            view.setFilter(filterInfo);
            PrecisionMaintainCollection col = PrecisionMaintainFactory.getRemoteInstance().getPrecisionMaintainCollection(view);
            if (col != null && col.size() > 0) {
                info = col.get(0);
            }
        }
        return info;
    }

    private Map getBatchEvaluData() throws Exception {
        String solutionPeriodID = (String)this.getUIContext().get("solutionPeriodID");
        String evaluerID = (String)this.getUIContext().get("evaluerID");
        String evaluObjectID = (String)this.getUIContext().get("evaluObjectID");
        String nodeId = null;
        if (this.getUIContext().get("nodeId") != null) {
            nodeId = (String)this.getUIContext().get("nodeId");
        }
        this.isAllocateTarget = (Boolean)this.getUIContext().get("isAllocateTarget");
        if (this.isAllocateTarget) {
            return BatchEvaluProcessFacadeFactory.getRemoteInstance().getBatchEvaluDataForAllocate(solutionPeriodID, evaluerID, evaluObjectID, nodeId);
        }
        return BatchEvaluProcessFacadeFactory.getRemoteInstance().getBatchEvaluData(solutionPeriodID, evaluerID, evaluObjectID, nodeId);
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.b) {
            Dimension dim = NodeProcesserHelper.getDimension();
            Point p = this.getLocation();
            UIModelDialog ui = (UIModelDialog)this.getUIWindow();
            ui.setBounds(p.x, p.y, dim.width, dim.height);
            this.b = false;
            ui.validate();
            ui.repaint();
        }
        this.pnlMain.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, this.scrollMain.getWidth(), this.scrollMain.getHeight()));
    }

    @Override
    protected void btnMaxBothWin_actionPerformed(ActionEvent e) throws Exception {
        Window dialog = ComponentUtil.getOwnerWindow(null);
        if (!this.isMaxSize) {
            this.winSize = dialog.getBounds();
        }
        ModelDialogHelper.adjustWindow(dialog, this.winSize, this.isMaxSize);
        this.isMaxSize = !this.isMaxSize;
    }
}

