/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class CustomerQueryUtil {
    private static final String SINGLE = "single";
    private static final String MULTI = "multi";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String TRUE = "true";

    public static void storeToCustomerParams(CustomerParams cp, KDRadioButton radio) {
        if (radio.isSelected()) {
            cp.addCustomerParam(radio.getName(), TRUE);
        }
    }

    public static void storeToCustomerParams(CustomerParams cp, KDCheckBox checkBox) {
        if (checkBox.isSelected()) {
            cp.addCustomerParam(checkBox.getName(), TRUE);
        }
    }

    public static void storeToCustomerParams(CustomerParams cp, KDComboBox comboBox) {
        Object value = comboBox.getSelectedItem();
        if (value != null) {
            if (value instanceof StringEnum) {
                cp.addCustomerParam(comboBox.getName(), ((StringEnum)value).getValue());
            } else if (value instanceof IntEnum) {
                String key = String.valueOf(((IntEnum)value).getValue());
                cp.addCustomerParam(comboBox.getName(), key);
            } else if (value instanceof CoreBaseInfo) {
                String id = ((CoreBaseInfo)value).getId().toString();
                cp.addCustomerParam(comboBox.getName(), id);
            } else {
                cp.addCustomerParam(comboBox.getName(), value.toString());
            }
        }
    }

    public static void storeToCustomerParams(CustomerParams cp, KDDatePicker datePicker) {
        if (datePicker.getValue() != null) {
            cp.putDate(datePicker.getName(), (Date)datePicker.getValue());
        }
    }

    public static void storeToCustomerParams(CustomerParams cp, KDTextField kdTextField) {
        if (kdTextField.getText() != null) {
            cp.addCustomerParam(kdTextField.getName(), kdTextField.getText());
        }
    }

    public static void storeToCustomerParams(CustomerParams cp, KDBizMultiLangBox kdBizMultiLangBox) {
        if (kdBizMultiLangBox.getSelectedItem() != null) {
            cp.addCustomerParam(kdBizMultiLangBox.getName(), kdBizMultiLangBox.getSelectedItem().toString());
        }
    }

    public static void storeToCustomerParams(CustomerParams cp, KDBizPromptBox promptBox) {
        Object[] infos;
        Object obj = promptBox.getValue();
        if (obj instanceof CoreBaseInfo) {
            CoreBaseInfo info = (CoreBaseInfo)obj;
            if (info.getId() != null) {
                CustomerParams params = new CustomerParams();
                params.putMe(SINGLE, CustomerQueryUtil.assembleCustomerParams(info));
                cp.putMe(promptBox.getName(), params);
            }
        } else if (obj instanceof Object[] && (infos = (Object[])obj) != null && infos.length > 0) {
            CustomerParams params = new CustomerParams();
            for (int i = 0; i < infos.length; ++i) {
                DataBaseInfo info = (DataBaseInfo)infos[i];
                if (info == null) continue;
                params.putMe(String.valueOf(i), CustomerQueryUtil.assembleCustomerParams((CoreBaseInfo)info));
            }
            CustomerParams key = new CustomerParams();
            key.putMe(MULTI, params);
            cp.putMe(promptBox.getName(), key);
        }
    }

    private static CustomerParams assembleCustomerParams(CoreBaseInfo info) {
        CustomerParams element = new CustomerParams();
        element.addCustomerParam(ID, info.getId().toString());
        element.addCustomerParam(NAME, info.getString(NAME));
        element.addCustomerParam(NUMBER, info.getString(NUMBER));
        return element;
    }

    public static void loadFromCustomerParams(CustomerParams cp, KDRadioButton radio) {
        if (cp == null) {
            radio.setSelected(false);
            return;
        }
        String value = cp.getCustomerParam(radio.getName());
        if (TRUE.equals(value)) {
            radio.setSelected(true);
        } else {
            radio.setSelected(false);
        }
    }

    public static void loadFromCustomerParams(CustomerParams cp, KDCheckBox checkBox) {
        if (cp == null) {
            checkBox.setSelected(false);
            return;
        }
        String value = cp.getCustomerParam(checkBox.getName());
        if (TRUE.equals(value)) {
            checkBox.setSelected(true);
        } else {
            checkBox.setSelected(false);
        }
    }

    public static void loadFromCustomerParams(CustomerParams cp, KDComboBox comboBox) {
        if (cp == null) {
            comboBox.setSelectedIndex(-1);
            return;
        }
        String value = cp.getCustomerParam(comboBox.getName());
        if (!StringUtils.isEmpty((String)value)) {
            if (CustomerQueryUtil.isEnumComboBox(comboBox)) {
                PerfClientUtils.setEnumComboBoxSelected(comboBox, value);
            } else if (CustomerQueryUtil.isCustomerEnumComboBox(comboBox)) {
                PerfClientUtils.setComboBoxSelected(comboBox, value);
            }
        } else {
            comboBox.setSelectedIndex(-1);
        }
    }

    private static boolean isEnumComboBox(KDComboBox comboBox) {
        if (comboBox.getItemCount() > 0) {
            Object item = null;
            int count = comboBox.getItemCount();
            for (int i = 0; i < count && (item = comboBox.getItemAt(i)) == null; ++i) {
            }
            if (item instanceof StringEnum || item instanceof IntEnum) {
                return true;
            }
        }
        return false;
    }

    private static boolean isCustomerEnumComboBox(KDComboBox comboBox) {
        return comboBox.getItemCount() > 0 && comboBox.getItemAt(0) instanceof CoreBaseInfo;
    }

    public static void loadFromCustomerParams(CustomerParams cp, KDDatePicker datePicker) {
        Date date = null;
        if (cp != null) {
            date = cp.getDate(datePicker.getName());
        }
        datePicker.setValue(date);
    }

    public static void loadFromCustomerParams(CustomerParams cp, KDTextField kdTextField) {
        String name = null;
        if (cp != null) {
            name = cp.getCustomerParam(kdTextField.getName());
        }
        kdTextField.setText(name);
    }

    public static void loadFromCustomerParams(CustomerParams cp, KDBizMultiLangBox kdBizMultiLangBox) {
        if (cp != null) {
            kdBizMultiLangBox.setSelectedItem((Object)cp.getCustomerParam(kdBizMultiLangBox.getName()));
        } else {
            kdBizMultiLangBox.setSelectedIndex(-1);
        }
    }

    public static void loadFromCustomerParams(CustomerParams cp, KDBizPromptBox promptBox, String className) {
        if (cp == null) {
            promptBox.setValue(null);
            return;
        }
        Object[] obj = null;
        CustomerParams key = cp.getMe(promptBox.getName());
        if (key != null) {
            CustomerParams params = key.getMe(SINGLE);
            if (params != null) {
                obj = CustomerQueryUtil.assembleDataBaseInfo(className, params);
            }
            if ((params = key.getMe(MULTI)) != null) {
                ArrayList<CoreBaseInfo> infos = new ArrayList<CoreBaseInfo>();
                Iterator it = params.getKeys().iterator();
                while (it.hasNext()) {
                    CustomerParams element = params.getMe((String)it.next());
                    if (element == null) continue;
                    infos.add(CustomerQueryUtil.assembleDataBaseInfo(className, element));
                }
                obj = infos.toArray();
            }
        }
        promptBox.setValue(obj);
    }

    private static CoreBaseInfo assembleDataBaseInfo(String className, CustomerParams element) {
        CoreBaseInfo info = CustomerQueryUtil.getCoreBaseInfo(className);
        if (info != null) {
            info.setId(BOSUuid.read((String)element.getCustomerParam(ID)));
            info.put(NAME, (Object)element.getCustomerParam(NAME));
            info.put(NUMBER, (Object)element.getCustomerParam(NUMBER));
        }
        return info;
    }

    public static CoreBaseInfo getCoreBaseInfo(String className) {
        CoreBaseInfo info = null;
        try {
            Object object = Class.forName(className).newInstance();
            if (object instanceof CoreBaseInfo) {
                info = (CoreBaseInfo)object;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return info;
    }
}

