/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.AchieveDataPermissionFacadeFactory;
import com.kingdee.eas.hr.perf.AlterAssessScoreRecorderFacadeFactory;
import com.kingdee.eas.hr.perf.DeliverModeEnum;
import com.kingdee.eas.hr.perf.EvaluGroupObjectCollection;
import com.kingdee.eas.hr.perf.EvaluGroupObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectCollection;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.IEvaluObject;
import com.kingdee.eas.hr.perf.IEvaluSolutionFacade;
import com.kingdee.eas.hr.perf.ITargetDeliverFacade;
import com.kingdee.eas.hr.perf.TargetDeliverFacadeFactory;
import com.kingdee.eas.hr.perf.TargetDelivererCollection;
import com.kingdee.eas.hr.perf.TargetDelivererInfo;
import com.kingdee.eas.hr.perf.client.AbstractESEvaluObjectOrgUnitUI;
import com.kingdee.eas.hr.perf.client.AchieveDataSetRecorderUI;
import com.kingdee.eas.hr.perf.client.AlterAssessScoreRecorderUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionF7Helper;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.IEvaluSolutionUI;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.ProgDialog;
import com.kingdee.eas.hr.perf.client.TargetDelivererSetRecorderUI;
import com.kingdee.eas.hr.train.client.LocateAssistant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class ESEvaluObjectOrgUnitUI
extends AbstractESEvaluObjectOrgUnitUI
implements IEvaluSolutionUI {
    private static final long serialVersionUID = -61166L;
    private String resourcePath = "com.kingdee.eas.hr.perf.EvaluSolutionResource";
    private String evaluSolutionId;
    private EvaluObjectCollection oldEvaluObjectCollection;
    private static int TARGET_EVALU_MODE = 1;
    private boolean isUnitedDelivered;
    private IEvaluSolutionFacade evaluSolutionFacade = null;
    private LocateAssistant locateAssistant;
    IEvaluObject evaluObject = null;
    private IObjectPK[] pk;
    private Container parentToolBar;
    boolean isFirstFind = true;
    private Map deliverStringMap = new HashMap();

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"number", "name", "longName", "responser", "targetDeliverer"};
        return locateNames;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        RequestContext req = new RequestContext();
        this.evaluSolutionId = (String)this.getUIContext().get("ID");
        req.put("evaluSolutionId", (Object)this.evaluSolutionId);
        postman.setRequestContext((Serializable)req);
        return postman;
    }

    public void onLoad() throws Exception {
        this.tblEvaluObjectOrgUnit.checkParsed();
        this.parentToolBar = (Container)this.getUIContext().get("ToolBar");
        this.tblEvaluObjectOrgUnit.checkParsed();
        this.tblEvaluObjectOrgUnit.getSelectManager().setSelectMode(10);
        this.evaluSolutionId = (String)this.getUIContext().get("ID");
        EvaluSolutionInfo evaluSolutionInfo = EvaluSolutionHelper.getEvaluSolutionInfo(this.evaluSolutionId);
        DeliverModeEnum deliverMode = evaluSolutionInfo.getDeliverMode();
        if (deliverMode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"NotExistTargetEvaluMode"));
            KDTabbedPane tbpMain = (KDTabbedPane)this.getUIContext().get("TBPMain");
            tbpMain.setSelectedComponent(tbpMain.getComponentAt(TARGET_EVALU_MODE));
            SysUtil.abort();
        }
        if (!this.isUnitedDelivered) {
            this.deliverStringMap = TargetDeliverFacadeFactory.getRemoteInstance().getSolutionTargetDeliverString(this.evaluSolutionId, true);
        }
        super.onLoad();
        this.loadData(this.evaluSolutionId);
        this.initUIStatus(EvaluSolutionHelper.isExistSolutionPeriodStarted(this.evaluSolutionId));
        this.setUIStatusByView();
        KDTSortManager sm = new KDTSortManager(this.tblEvaluObjectOrgUnit);
        for (int col = 0; col < this.tblEvaluObjectOrgUnit.getColumnCount(); ++col) {
            this.tblEvaluObjectOrgUnit.getColumn(col).setSortable(true);
        }
        sm.setSortAuto(true);
        this.tblEvaluObjectOrgUnit.getColumn("alterAsseScoRecorder").getStyleAttributes().setHided(true);
    }

    private void setUIStatusByView() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            EvaluSolutionHelper.setEnabled(this.parentToolBar, new String[]{"btnAddEvaluObject_EvaluObject", "btnDelEvaluObject_EvaluObject", "btnSetResponser_EvaluObject", "btnSetTargetDeliverer_EvaluObject", "btnSetAchieveData_EvaluObject", "btnAlterAsseScore_EvaluObject"}, false, false);
        }
    }

    public void setUIStatusByDeliverMode(DeliverModeEnum deliverMode) throws Exception {
        if (deliverMode == null) {
            EvaluSolutionInfo evaluSolutionInfo = EvaluSolutionHelper.getEvaluSolutionInfo(this.evaluSolutionId);
            deliverMode = evaluSolutionInfo.getDeliverMode();
            if (deliverMode == null) {
                return;
            }
        } else if (deliverMode.equals((Object)DeliverModeEnum.DIRECT_ENTER) || deliverMode.equals((Object)DeliverModeEnum.UNITY_DELIVER)) {
            this.isUnitedDelivered = true;
            Container toolBar = (Container)this.getUIContext().get("ToolBar");
            EvaluSolutionHelper.setEnabled(toolBar, new String[]{"btnSetTargetDeliverer_EvaluObject"}, false, false);
            this.tblEvaluObjectOrgUnit.getColumn("targetDeliverer").getStyleAttributes().setBackground(EvaluSolutionHelper.UNENABLE_COLOR);
        } else {
            this.isUnitedDelivered = false;
            Container toolBar = (Container)this.getUIContext().get("ToolBar");
            EvaluSolutionHelper.setEnabled(toolBar, new String[]{"btnSetTargetDeliverer_EvaluObject"}, false, true);
            this.tblEvaluObjectOrgUnit.getColumn("targetDeliverer").getStyleAttributes().setBackground(EvaluSolutionHelper.ENABLE_COLOR);
        }
    }

    public void initUIStatus(boolean isExistSolutionPeriodStarted) {
        Container toolBar = (Container)this.getUIContext().get("ToolBar");
        if (isExistSolutionPeriodStarted) {
            EvaluSolutionHelper.setEnabled(toolBar, new String[]{"btnAddEvaluObject_EvaluObject", "btnDelEvaluObject_EvaluObject", "btnSetResponser_EvaluObject", "btnLocaleEvaluObject"}, false, true);
        } else {
            DeliverModeEnum deliverMode = EvaluSolutionHelper.getDeliverMode(this.evaluSolutionId);
            if (deliverMode.equals((Object)DeliverModeEnum.DIRECT_ENTER) || deliverMode.equals((Object)DeliverModeEnum.UNITY_DELIVER)) {
                EvaluSolutionHelper.setEnabled(toolBar, new String[]{"btnAddEvaluObject_EvaluObject", "btnDelEvaluObject_EvaluObject", "btnSetResponser_EvaluObject", "btnLocaleEvaluObject", "btnSetAchieveData_EvaluObject", "btnAlterAsseScore_EvaluObject"}, false, true);
            } else {
                EvaluSolutionHelper.setEnabled(toolBar, new String[]{"btnAddEvaluObject_EvaluObject", "btnDelEvaluObject_EvaluObject", "btnSetResponser_EvaluObject", "btnSetTargetDeliverer_EvaluObject", "btnLocaleEvaluObject", "btnSetAchieveData_EvaluObject", "btnAlterAsseScore_EvaluObject"}, false, true);
            }
        }
        this.setUIStatusByView();
    }

    private void loadData(String id) throws Exception {
        if (id == null) {
            return;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)id));
        fi.getFilterItems().add(new FilterItemInfo("evaluObjectType", (Object)new Integer(101)));
        fi.getFilterItems().add(new FilterItemInfo("deleted", (Object)new Integer(0)));
        SorterItemCollection sorters = new SorterItemCollection();
        SorterItemInfo sortName = new SorterItemInfo("createTime");
        sortName.setSortType(SortType.ASCEND);
        sorters.add(sortName);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(fi);
        view.setSorter(sorters);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "ESEvaluObjectOrgUnitQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(view);
        IRowSet rowSet = exec.executeQuery();
        EvaluObjectCollection evaluObjectCollection = new EvaluObjectCollection();
        EvaluObjectInfo evaluObjectInfo = null;
        String evaluObjectId = null;
        while (rowSet.next()) {
            String responsePositionId;
            evaluObjectInfo = new EvaluObjectInfo();
            evaluObjectId = rowSet.getString("id");
            evaluObjectInfo.setId(BOSUuid.read((String)evaluObjectId));
            evaluObjectInfo.setObjectID(rowSet.getString("objectID"));
            evaluObjectInfo.setNumber(rowSet.getString("number"));
            evaluObjectInfo.setName(rowSet.getString("name"));
            String responserId = rowSet.getString("responser.id");
            if (responserId != null) {
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)responserId));
                personInfo.setName(rowSet.getString("responser.name"));
                evaluObjectInfo.setResponser(personInfo);
            }
            if ((responsePositionId = rowSet.getString("responsePosition.id")) != null) {
                PositionInfo positionInfo = new PositionInfo();
                positionInfo.setId(BOSUuid.read((String)responsePositionId));
                evaluObjectInfo.setPosition(positionInfo);
            }
            if (this.deliverStringMap != null) {
                evaluObjectInfo.setDescription((String)this.deliverStringMap.get(evaluObjectId));
            }
            evaluObjectInfo.setSimpleName(rowSet.getString("simpleName"));
            evaluObjectCollection.add(evaluObjectInfo);
        }
        this.oldEvaluObjectCollection = (EvaluObjectCollection)((Object)evaluObjectCollection.clone());
        this.tblEvaluObjectOrgUnit.removeRows();
        this.fillTable(evaluObjectCollection, true);
        this.setDeliverString();
    }

    private void fillTable(EvaluObjectCollection evaluObjectCollection, boolean isLoad) throws Exception {
        EvaluObjectInfo evaluObjectInfo = null;
        Map map = AchieveDataPermissionFacadeFactory.getRemoteInstance().getRecorderName(this.evaluSolutionId);
        Map map_AssessScore = AlterAssessScoreRecorderFacadeFactory.getRemoteInstance().getRecorderName(this.evaluSolutionId);
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        String evaluObjectId = null;
        Object deliverString = null;
        ITargetDeliverFacade ideliverfacade = TargetDeliverFacadeFactory.getRemoteInstance();
        for (int i = 0; i < evaluObjectCollection.size(); ++i) {
            evaluObjectInfo = evaluObjectCollection.get(i);
            if (this.checkIfRefered(evaluObjectInfo)) continue;
            IRow row = this.tblEvaluObjectOrgUnit.addRow();
            row.setUserObject((Object)evaluObjectInfo);
            EvaluSolutionInfo solutionInfo = new EvaluSolutionInfo();
            solutionInfo.setId(BOSUuid.read((String)this.evaluSolutionId));
            evaluObjectInfo.setEvaluSolution(solutionInfo);
            if (evaluObjectInfo.getId() != null) {
                evaluObjectId = evaluObjectInfo.getId().toString();
                row.getCell("id").setValue((Object)evaluObjectId);
            }
            String orgId = evaluObjectInfo.getObjectID();
            row.getCell("orgUnitId").setValue((Object)orgId);
            row.getCell("number").setValue((Object)evaluObjectInfo.getNumber());
            row.getCell("name").setValue((Object)evaluObjectInfo.getName());
            row.getCell("longName").setValue((Object)evaluObjectInfo.getSimpleName());
            evaluObjectInfo.setEvaluObjectType(EvaluObjectTypeEnum.ORGUNIT);
            PersonInfo responser = evaluObjectInfo.getResponser();
            if (responser != null) {
                row.getCell("responser").setValue((Object)responser.getName());
                row.getCell("responserId").setValue((Object)responser.getId().toString());
            }
            row.getCell("achieveDataRecorder").setValue(map.get(orgId));
            row.getCell("alterAsseScoRecorder").setValue(map_AssessScore.get(orgId));
        }
    }

    private void setDeliverString() throws EASBizException, BOSException {
        if (!this.isUnitedDelivered) {
            int i;
            HashSet<String> ids = new HashSet<String>();
            IRow row = null;
            String objectId = null;
            int size = this.tblEvaluObjectOrgUnit.getRowCount();
            for (i = 0; i < size; ++i) {
                row = this.tblEvaluObjectOrgUnit.getRow(i);
                if (!StringUtils.isEmpty((String)((String)row.getCell("targetDeliverer").getValue()))) continue;
                objectId = (String)row.getCell("id").getValue();
                if (this.deliverStringMap != null && this.deliverStringMap.get(objectId) != null) {
                    row.getCell("targetDeliverer").setValue(this.deliverStringMap.get(objectId));
                    continue;
                }
                ids.add((String)row.getCell("id").getValue());
            }
            if (ids.isEmpty()) {
                return;
            }
            if (this.deliverStringMap == null) {
                this.deliverStringMap = new HashMap();
            }
            this.deliverStringMap.putAll(TargetDeliverFacadeFactory.getRemoteInstance().getTargetDeliverString(ids, true));
            size = this.tblEvaluObjectOrgUnit.getRowCount();
            for (i = 0; i < size; ++i) {
                row = this.tblEvaluObjectOrgUnit.getRow(i);
                if (!StringUtils.isEmpty((String)((String)row.getCell("targetDeliverer").getValue()))) continue;
                row.getCell("targetDeliverer").setValue(this.deliverStringMap.get((String)row.getCell("id").getValue()));
            }
        }
    }

    private PersonCollection getPersonCollection(TargetDelivererCollection targetDeliverers) {
        PersonCollection personColl = new PersonCollection();
        int size = targetDeliverers.size();
        for (int i = 0; i < size; ++i) {
            personColl.add(targetDeliverers.get(i).getPerson());
        }
        return personColl;
    }

    public void loadDeliverers() throws Exception {
        IRow row = null;
        EvaluObjectInfo evaluObjectInfo = null;
        int size = this.tblEvaluObjectOrgUnit.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblEvaluObjectOrgUnit.getRow(i);
            evaluObjectInfo = (EvaluObjectInfo)row.getUserObject();
            row.getCell("targetDeliverer").setValue((Object)evaluObjectInfo.getDescription());
        }
    }

    private String getTargetDelivererString(String personId, PersonCollection personCollection) throws Exception {
        StringBuffer targetDeliverers = new StringBuffer();
        int MAX_SIZE = 30;
        PersonCollection defaultDeliverers = EvaluSolutionHelper.getPersonCollectionByPersonId(this.evaluSolutionFacade, personId);
        int size = personCollection.size();
        for (int j = 0; j < size; ++j) {
            if (j > 30) {
                targetDeliverers.append("...");
                break;
            }
            targetDeliverers.append(personCollection.get(j).getName());
            if (EvaluSolutionHelper.isContainPerson(defaultDeliverers, personCollection.get(j))) {
                targetDeliverers.append(EASResource.getString((String)this.resourcePath, (String)"Default"));
            }
            if (j == size - 1) continue;
            targetDeliverers.append(",");
        }
        return targetDeliverers.toString();
    }

    private String getDefaultTargetDelivererString(PersonCollection personCollection) throws Exception {
        StringBuffer targetDeliverers = new StringBuffer();
        int MAX_SIZE = 30;
        int size = personCollection.size();
        for (int j = 0; j < size; ++j) {
            if (j > 30) {
                targetDeliverers.append("...");
                break;
            }
            targetDeliverers.append(personCollection.get(j).getName());
            targetDeliverers.append(EASResource.getString((String)this.resourcePath, (String)"Default"));
            if (j == size - 1) continue;
            targetDeliverers.append(",");
        }
        return targetDeliverers.toString();
    }

    public void unLoadDeliverers() {
        IRow row = null;
        int size = this.tblEvaluObjectOrgUnit.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblEvaluObjectOrgUnit.getRow(i);
            row.getCell("targetDeliverer").setValue(null);
        }
    }

    private boolean checkIfRefered(EvaluObjectInfo evaluObjectInfo) {
        IRow row = null;
        for (int i = 0; i < this.tblEvaluObjectOrgUnit.getRowCount(); ++i) {
            row = this.tblEvaluObjectOrgUnit.getRow(i);
            String orgUnitId = (String)row.getCell("orgUnitId").getValue();
            if (!evaluObjectInfo.getObjectID().equals(orgUnitId)) continue;
            return true;
        }
        return false;
    }

    private void setTargetDeliverers(TargetDelivererCollection targetDeliverers, PersonCollection personCollection) {
        TargetDelivererInfo info = null;
        PersonInfo personInfo = null;
        for (int i = 0; i < personCollection.size(); ++i) {
            personInfo = personCollection.get(i);
            if (personInfo == null) continue;
            info = new TargetDelivererInfo();
            info.setPerson(personInfo);
            targetDeliverers.add(info);
        }
    }

    @Override
    public void secondLoad() throws Exception {
    }

    @Override
    public void submit() throws Exception {
        this.submit(true);
    }

    public void submit(boolean isVerify) throws Exception {
        if (isVerify) {
            this.verifyInput();
        }
        EvaluObjectCollection coll = new EvaluObjectCollection();
        IEvaluObject evaluObject = EvaluObjectFactory.getRemoteInstance();
        IRow row = null;
        EvaluObjectInfo evaluObjectInfo = null;
        int size = this.tblEvaluObjectOrgUnit.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblEvaluObjectOrgUnit.getRow(i);
            evaluObjectInfo = (EvaluObjectInfo)row.getUserObject();
            evaluObjectInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            if (evaluObjectInfo.getId() != null) continue;
            coll.add(evaluObjectInfo);
        }
        Map idMap = evaluObject.submitBatchEvaluObject(coll);
        int size2 = this.tblEvaluObjectOrgUnit.getRowCount();
        for (int i = 0; i < size2; ++i) {
            row = this.tblEvaluObjectOrgUnit.getRow(i);
            evaluObjectInfo = (EvaluObjectInfo)row.getUserObject();
            if (evaluObjectInfo.getId() != null) continue;
            String id = (String)idMap.get(evaluObjectInfo.getObjectID());
            evaluObjectInfo.setId(BOSUuid.read((String)id));
            row.getCell("id").setValue((Object)id);
        }
        this.updateOldData();
    }

    public void submit(IRow row, boolean isVerify, boolean isUpdateOldData) throws Exception {
        if (isVerify) {
            this.verifyInput();
        }
        if (this.evaluObject == null) {
            this.evaluObject = EvaluObjectFactory.getRemoteInstance();
        }
        EvaluObjectInfo evaluObjectInfo = (EvaluObjectInfo)row.getUserObject();
        this.evaluObject.saveResponser(evaluObjectInfo.getId().toString(), evaluObjectInfo.getResponser().getId().toString());
        if (isUpdateOldData) {
            this.updateOldData();
        }
    }

    private EvaluObjectCollection getEvaluObjectCollection() throws Exception {
        EvaluObjectCollection evaluObjectColl = new EvaluObjectCollection();
        EvaluObjectInfo evaluObjectInfo = null;
        IRow row = null;
        int size = this.tblEvaluObjectOrgUnit.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblEvaluObjectOrgUnit.getRow(i);
            evaluObjectInfo = (EvaluObjectInfo)row.getUserObject();
            evaluObjectColl.add(evaluObjectInfo);
        }
        return evaluObjectColl;
    }

    public void addEvaluObject() throws Exception {
        final KDCommonPromptDialog admin = EvaluSolutionF7Helper.getAdminOrgUnitF7((IUIObject)this);
        admin.show();
        if (!admin.isCanceled()) {
            IProgTask prog = new IProgTask(){

                @Override
                public Object exec() throws Exception {
                    if (admin.getData() instanceof Object[]) {
                        Object[] obj = (Object[])admin.getData();
                        ESEvaluObjectOrgUnitUI.this.dealAddEvaluObject(obj);
                    }
                    return "";
                }

                @Override
                public void afterExec(Object result) throws Exception {
                }
            };
            ProgDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new ProgDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new ProgDialog((Dialog)win);
            }
            dialog.setLongTimeTask(prog);
            dialog.show();
        }
    }

    private void dealAddEvaluObject(Object[] obj) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        HashMap<String, String> numberMap = new HashMap<String, String>();
        AdminOrgUnitInfo adminInfo = null;
        for (int i = 0; i < obj.length; ++i) {
            adminInfo = (AdminOrgUnitInfo)obj[i];
            idSet.add(adminInfo.getId().toString());
            numberMap.put(adminInfo.getId().toString(), adminInfo.getDisplayName());
        }
        if (idSet.size() != 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)"00000000-0000-0000-0000-000000000001396FCAD0"));
            fi.getFilterItems().add(new FilterItemInfo("hierarchy.id", null));
            fi.setMaskString("#0 and (#1 or #2)");
            HashMap<String, String> longNameMap = numberMap;
            EvaluObjectCollection objectColl = this.getEvaluObjectCollection(this.getRowSet(fi), longNameMap);
            this.fillTable(objectColl, false);
            this.submit(false);
            this.setDeliverString();
        }
    }

    private EvaluObjectCollection getEvaluObjectCollection(IRowSet rowSet, Map longNameMap) throws Exception {
        EvaluObjectCollection objectColl = new EvaluObjectCollection();
        EvaluObjectInfo objectInfo = null;
        TargetDelivererInfo delivererInfo = null;
        PersonInfo responserInfo = null;
        PersonInfo personInfo = null;
        while (rowSet.next()) {
            String orgUnitId = rowSet.getString("id");
            objectInfo = this.getEvaluObjectInfo(objectColl, orgUnitId);
            if (objectInfo == null) {
                objectInfo = new EvaluObjectInfo();
                objectColl.add(objectInfo);
                objectInfo.setName(rowSet.getString("name"));
                objectInfo.setNumber(rowSet.getString("number"));
                objectInfo.setObjectID(orgUnitId);
                objectInfo.setSimpleName((String)longNameMap.get(orgUnitId));
                objectInfo.setSuperior(true);
                String positionId = rowSet.getString("responsePosition.id");
                if (positionId == null) continue;
                PositionInfo positionInfo = new PositionInfo();
                positionInfo.setId(BOSUuid.read((String)positionId));
                objectInfo.setPosition(positionInfo);
            }
            if (objectInfo.getResponser() == null && rowSet.getString("responser.id") != null) {
                responserInfo = new PersonInfo();
                responserInfo.setId(BOSUuid.read((String)rowSet.getString("responser.id")));
                responserInfo.setName(rowSet.getString("responser.name"));
                objectInfo.setResponser(responserInfo);
            }
            delivererInfo = new TargetDelivererInfo();
            personInfo = new PersonInfo();
            String delivererId = rowSet.getString("deliverer.id");
            if (delivererId == null || delivererId.equals(objectInfo.getObjectID())) continue;
            personInfo.setId(BOSUuid.read((String)delivererId));
            personInfo.setName(rowSet.getString("deliverer.name"));
            personInfo.setNumber(rowSet.getString("deliverer.number"));
            delivererInfo.setPerson(personInfo);
            delivererInfo.setEvaluObject(objectInfo);
            objectInfo.getTargetDeliverers().add(delivererInfo);
        }
        int size = objectColl.size();
        for (int i = 0; i < size; ++i) {
            objectInfo = objectColl.get(i);
            TargetDelivererCollection defaultDeliverers = objectInfo.getTargetDeliverers();
            objectInfo.setDescription(this.getDefaultTargetDelivererString(this.getPersonCollection(defaultDeliverers)));
            objectInfo.getTargetDeliverers().clear();
        }
        return objectColl;
    }

    private EvaluObjectInfo getEvaluObjectInfo(EvaluObjectCollection objectColl, String orgUnitId) {
        EvaluObjectInfo objectInfo = null;
        int size = objectColl.size();
        for (int i = 0; i < size; ++i) {
            objectInfo = objectColl.get(i);
            if (!objectInfo.getObjectID().equals(orgUnitId)) continue;
            return objectInfo;
        }
        return null;
    }

    private IRowSet getRowSet(FilterInfo fi) throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "ESOrgUnitAboutQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    public void delEvaluObject() throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblEvaluObjectOrgUnit);
        if (this.confirmRemove()) {
            List rowIndexList = PFUtils.getSelectedRows(this.tblEvaluObjectOrgUnit);
            Arrays.sort(rowIndexList.toArray());
            IRow row = null;
            final HashSet<String> idSet = new HashSet<String>();
            for (int i = rowIndexList.size() - 1; i >= 0; --i) {
                int rowIndex = (Integer)rowIndexList.get(i);
                row = this.tblEvaluObjectOrgUnit.getRow(rowIndex);
                String id = (String)row.getCell("id").getValue();
                if (id == null) continue;
                idSet.add(id);
            }
            Set unAbleDel = this.delAbleObjectId(idSet);
            idSet.removeAll(unAbleDel);
            final ArrayList<Integer> delRowIndex0 = new ArrayList<Integer>();
            for (int i = rowIndexList.size() - 1; i >= 0; --i) {
                int rowIndex = (Integer)rowIndexList.get(i);
                row = this.tblEvaluObjectOrgUnit.getRow(rowIndex);
                if (!idSet.contains((String)row.getCell("id").getValue())) continue;
                delRowIndex0.add(new Integer(rowIndex));
            }
            if (idSet.size() != 0) {
                final IEvaluObject evaluObject = EvaluObjectFactory.getRemoteInstance();
                final StringBuffer names = new StringBuffer();
                if (idSet.size() > 20) {
                    IProgTask prog = new IProgTask(){

                        @Override
                        public Object exec() throws Exception {
                            ESEvaluObjectOrgUnitUI.access$102(ESEvaluObjectOrgUnitUI.this, evaluObject.delete(idSet));
                            names.append(ESEvaluObjectOrgUnitUI.this.getReferedObjectNames(ESEvaluObjectOrgUnitUI.this.pk));
                            ESEvaluObjectOrgUnitUI.this.removeRowsFromTable(delRowIndex0, ESEvaluObjectOrgUnitUI.this.pk);
                            return "";
                        }

                        @Override
                        public void afterExec(Object result) throws Exception {
                        }
                    };
                    ProgDialog dialog = null;
                    Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
                    if (win instanceof Frame) {
                        dialog = new ProgDialog((Frame)win);
                    } else if (win instanceof Dialog) {
                        dialog = new ProgDialog((Dialog)win);
                    }
                    dialog.setLongTimeTask(prog);
                    dialog.show();
                } else {
                    this.pk = evaluObject.delete(idSet);
                    names.append(this.getReferedObjectNames(this.pk));
                    this.removeRowsFromTable(delRowIndex0, this.pk);
                }
                if (names != null && names.length() != 0) {
                    String msg = EASResource.getString((String)this.resourcePath, (String)"CanNotDelEvaluObject");
                    msg = msg.replaceAll("#", names.substring(0, names.length() - 1));
                    MsgBox.showInfo((Component)((Object)this), (String)msg);
                }
                if (!unAbleDel.isEmpty()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"notDelSolutionObject"));
                }
            } else if (!unAbleDel.isEmpty()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"notDelSolutionObject"));
            }
        }
    }

    private Set delAbleObjectId(Set objectIdSet) throws BOSException {
        HashSet<String> returnSet = new HashSet<String>();
        if (objectIdSet == null || objectIdSet.isEmpty()) {
            return returnSet;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)objectIdSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluGroup.delivered", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluGroup.solutionPeriod.status", (Object)String.valueOf(100)));
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluGroup.solutionPeriod.status", (Object)String.valueOf(101)));
        filterInfo.setMaskString("#0 and #1 and (#2 or #3)");
        viewInfo.setFilter(filterInfo);
        EvaluGroupObjectCollection evaluGroupObjectCollection = EvaluGroupObjectFactory.getRemoteInstance().getEvaluGroupObjectCollection(viewInfo);
        int size = evaluGroupObjectCollection.size();
        for (int i = 0; i < size; ++i) {
            returnSet.add(evaluGroupObjectCollection.get(i).getEvaluObject().getId().toString());
        }
        return returnSet;
    }

    private String getReferedObjectNames(IObjectPK[] referedPK) {
        if (referedPK == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int size = referedPK.length;
        block0: for (int i = 0; i < size; ++i) {
            String canDelId = referedPK[i].toString();
            int count = this.tblEvaluObjectOrgUnit.getRowCount();
            for (int j = 0; j < count; ++j) {
                IRow row = this.tblEvaluObjectOrgUnit.getRow(j);
                String id = (String)row.getCell("id").getValue();
                if (!id.equals(canDelId)) continue;
                sb.append(row.getCell("name").getValue());
                sb.append(",");
                continue block0;
            }
        }
        return sb.toString();
    }

    private void removeRowsFromTable(List delRowIndex, IObjectPK[] cannotDelPK) {
        IRow row = null;
        for (int i = 0; i < delRowIndex.size(); ++i) {
            int rowIndex = (Integer)delRowIndex.get(i);
            row = this.tblEvaluObjectOrgUnit.getRow(rowIndex);
            String id = (String)row.getCell("id").getValue();
            if (id == null) {
                this.tblEvaluObjectOrgUnit.removeRow(rowIndex);
                continue;
            }
            boolean isRefered = false;
            if (cannotDelPK != null) {
                for (int j = 0; j < cannotDelPK.length; ++j) {
                    if (!id.equals(cannotDelPK[j].toString())) continue;
                    isRefered = true;
                }
            }
            if (isRefered) continue;
            this.tblEvaluObjectOrgUnit.removeRow(rowIndex);
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    public void setResponser() throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblEvaluObjectOrgUnit);
        int selectedRow = PFUtils.getSelectedRow(this.tblEvaluObjectOrgUnit);
        EvaluObjectInfo evaluObjectInfo = (EvaluObjectInfo)this.tblEvaluObjectOrgUnit.getRow(selectedRow).getUserObject();
        EmployeeMultiF7PromptBox pmt = (EmployeeMultiF7PromptBox)EvaluSolutionF7Helper.getEmployeeF7((IUIObject)this);
        pmt.setSelectDefaultPostion(evaluObjectInfo.getPosition());
        pmt.show();
        if (pmt.isCanceled()) {
            return;
        }
        Object obj = pmt.getData();
        if (obj == null) {
            return;
        }
        PersonInfo personInfo = (PersonInfo)((Object[])obj)[0];
        IRow row = this.tblEvaluObjectOrgUnit.getRow(selectedRow);
        row.getCell("responser").setValue((Object)personInfo.getName());
        row.getCell("responserId").setValue((Object)personInfo.getId().toString());
        EvaluObjectInfo objectInfo = (EvaluObjectInfo)this.tblEvaluObjectOrgUnit.getRow(selectedRow).getUserObject();
        if (personInfo.getId() != null && objectInfo.getResponser() != null && personInfo.getId().toString().equals(objectInfo.getResponser().getId().toString())) {
            return;
        }
        objectInfo.setResponser(personInfo);
        objectInfo.setPosition((PositionInfo)personInfo.get("personselectposition"));
        DeliverModeEnum deliverMode = EvaluSolutionHelper.getDeliverMode(this.evaluSolutionId);
        this.submit(row, false, true);
        if (!DeliverModeEnum.UNITY_DELIVER.equals((Object)deliverMode) && !DeliverModeEnum.DIRECT_ENTER.equals((Object)deliverMode)) {
            String evaluobjectId = objectInfo.getId().toString();
            String deliverString = TargetDeliverFacadeFactory.getRemoteInstance().getTargetDeliverString(evaluobjectId, true);
            row.getCell("targetDeliverer").setValue((Object)deliverString);
            this.deliverStringMap.put(evaluobjectId, deliverString);
        }
    }

    public void setTargetDeliverer() throws Exception {
        String responserId;
        PFUtils.checkSelected((Component)((Object)this), this.tblEvaluObjectOrgUnit);
        int selectedRow = PFUtils.getSelectedRow(this.tblEvaluObjectOrgUnit);
        IRow row = this.tblEvaluObjectOrgUnit.getRow(selectedRow);
        String id = (String)row.getCell("id").getValue();
        if (id == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CurrentEvaluObjectError"));
            SysUtil.abort();
        }
        if ((responserId = (String)row.getCell("responserId").getValue()) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"responserIsNull"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"id", (Object)id);
        uiContext.put((Object)"evaluSolutionId", (Object)this.evaluSolutionId);
        uiContext.put((Object)"objectId", (Object)responserId);
        uiContext.put((Object)"isOrg", (Object)Boolean.TRUE);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.hr.perf.client.TargetDelivererSetRecorderUI", (Map)uiContext);
        uiWindow.show();
        TargetDelivererSetRecorderUI recorder = (TargetDelivererSetRecorderUI)uiWindow.getUIObject();
        if (recorder.isCancel()) {
            return;
        }
        if (recorder.isApplyForAllObj()) {
            if (!this.isUnitedDelivered) {
                this.deliverStringMap = TargetDeliverFacadeFactory.getRemoteInstance().getSolutionTargetDeliverString(this.evaluSolutionId, true);
            }
            this.refreshTargetDeliver();
        } else {
            String deliverString = TargetDeliverFacadeFactory.getRemoteInstance().getTargetDeliverString(id, true);
            if (!this.isUnitedDelivered) {
                this.deliverStringMap.put(id, deliverString);
            }
            row.getCell("targetDeliverer").setValue((Object)deliverString);
        }
    }

    private void refreshTargetDeliver() {
        IRow row = null;
        String evaluObjectId = null;
        String deliverString = null;
        int size = this.tblEvaluObjectOrgUnit.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblEvaluObjectOrgUnit.getRow(i);
            if (row.getCell("id").getValue() == null) continue;
            evaluObjectId = (String)row.getCell("id").getValue();
            deliverString = (String)this.deliverStringMap.get(evaluObjectId);
            row.getCell("targetDeliverer").setValue((Object)deliverString);
        }
    }

    @Override
    public void verifyInput() throws Exception {
    }

    public boolean isDataModified() throws Exception {
        EvaluObjectCollection evaluObjectCollection = this.getEvaluObjectCollection();
        if (evaluObjectCollection.size() != this.oldEvaluObjectCollection.size()) {
            return true;
        }
        for (int i = 0; i < evaluObjectCollection.size(); ++i) {
            if (ObjectValueUtil.objectValueEquals((AbstractObjectValue)this.oldEvaluObjectCollection.get(i), (AbstractObjectValue)evaluObjectCollection.get(i))) continue;
            return true;
        }
        return false;
    }

    public void updateOldData() throws Exception {
        this.oldEvaluObjectCollection = (EvaluObjectCollection)((Object)this.getEvaluObjectCollection().clone());
    }

    public void localeEvaluObject(ActionEvent e) throws Exception {
        if (this.locateAssistant == null) {
            this.locateAssistant = new LocateAssistant((CoreUIObject)this, this.tblEvaluObjectOrgUnit, this.getLocateNames());
        }
        this.locateAssistant.actionLocate();
    }

    public void setAlterAssessScoreRecorder() throws Exception {
        if (this.tblEvaluObjectOrgUnit.getRowCount() == 0 || this.tblEvaluObjectOrgUnit.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        int selectedRow = PFUtils.getSelectedRow(this.tblEvaluObjectOrgUnit);
        Object orgId = this.tblEvaluObjectOrgUnit.getCell(selectedRow, "orgUnitId").getValue();
        Object objId = this.tblEvaluObjectOrgUnit.getCell(selectedRow, "id").getValue();
        if (this.evaluSolutionId == null || orgId == null || objId == null) {
            return;
        }
        String permissionId = AlterAssessScoreRecorderFacadeFactory.getRemoteInstance().getPermissionId(this.evaluSolutionId, orgId.toString());
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionId", (Object)this.evaluSolutionId);
        uiContext.put((Object)"orgId", (Object)orgId.toString());
        uiContext.put((Object)"objId", (Object)objId.toString());
        uiContext.put((Object)"evaluType", (Object)"org");
        IUIWindow win = null;
        String recorderUi = "com.kingdee.eas.hr.perf.client.AlterAssessScoreRecorderUI";
        if (permissionId == null) {
            uiContext.put((Object)"ID", null);
            win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(recorderUi, (Map)uiContext, null, OprtState.ADDNEW);
        } else {
            uiContext.put((Object)"ID", (Object)permissionId);
            win = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(recorderUi, (Map)uiContext, null, OprtState.EDIT) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(recorderUi, (Map)uiContext, null, OprtState.EDIT);
        }
        win.show();
        AlterAssessScoreRecorderUI ui = (AlterAssessScoreRecorderUI)win.getUIObject();
        if (!ui.isCancel()) {
            boolean isApplyForAllObj = ui.isApplyForAllObj();
            if (isApplyForAllObj) {
                AlterAssessScoreRecorderFacadeFactory.getRemoteInstance().applyAllEvaluObject(this.evaluSolutionId, orgId.toString());
            }
            this.loadData(this.evaluSolutionId);
        }
    }

    public void setAchieveDataRecorder() throws Exception {
        if (this.tblEvaluObjectOrgUnit.getRowCount() == 0 || this.tblEvaluObjectOrgUnit.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        int selectedRow = PFUtils.getSelectedRow(this.tblEvaluObjectOrgUnit);
        Object orgId = this.tblEvaluObjectOrgUnit.getCell(selectedRow, "orgUnitId").getValue();
        Object objId = this.tblEvaluObjectOrgUnit.getCell(selectedRow, "id").getValue();
        if (this.evaluSolutionId == null || orgId == null || objId == null) {
            return;
        }
        String permissionId = AchieveDataPermissionFacadeFactory.getRemoteInstance().getPermissionId(this.evaluSolutionId, orgId.toString());
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionId", (Object)this.evaluSolutionId);
        uiContext.put((Object)"orgId", (Object)orgId.toString());
        uiContext.put((Object)"objId", (Object)objId.toString());
        uiContext.put((Object)"evaluType", (Object)"org");
        IUIWindow win = null;
        String recorderUi = "com.kingdee.eas.hr.perf.client.AchieveDataSetRecorderUI";
        if (permissionId == null) {
            uiContext.put((Object)"ID", null);
            win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(recorderUi, (Map)uiContext, null, OprtState.ADDNEW);
        } else {
            uiContext.put((Object)"ID", (Object)permissionId);
            win = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(recorderUi, (Map)uiContext, null, OprtState.EDIT) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(recorderUi, (Map)uiContext, null, OprtState.EDIT);
        }
        win.show();
        AchieveDataSetRecorderUI ui = (AchieveDataSetRecorderUI)win.getUIObject();
        if (!ui.isCancel()) {
            boolean isApplyForAllObj = ui.isApplyForAllObj();
            if (isApplyForAllObj) {
                AchieveDataPermissionFacadeFactory.getRemoteInstance().applyAllEvaluObject(this.evaluSolutionId, orgId.toString());
            }
            this.loadData(this.evaluSolutionId);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    static /* synthetic */ IObjectPK[] access$102(ESEvaluObjectOrgUnitUI x0, IObjectPK[] x1) {
        x0.pk = x1;
        return x1;
    }
}

