/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.perf.DeliverModeEnum;
import com.kingdee.eas.hr.perf.EvaluFormSolutionContractTemplateCollection;
import com.kingdee.eas.hr.perf.EvaluFormSolutionContractTemplateInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionMultiTableCollection;
import com.kingdee.eas.hr.perf.EvaluFormSolutionMultiTableInfo;
import com.kingdee.eas.hr.perf.EvaluGroupCollection;
import com.kingdee.eas.hr.perf.EvaluGroupFactory;
import com.kingdee.eas.hr.perf.EvaluGroupInfo;
import com.kingdee.eas.hr.perf.EvaluGroupTargetCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetFactory;
import com.kingdee.eas.hr.perf.EvaluGroupTargetInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionRuleFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.EvaluTargetInfo;
import com.kingdee.eas.hr.perf.IEvaluSolutionFacade;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.client.AbstractESPerformanceTargetListUI;
import com.kingdee.eas.hr.perf.client.EvaluGroup2UI;
import com.kingdee.eas.hr.perf.client.EvaluGroupTargetObjectOrgUnitUI;
import com.kingdee.eas.hr.perf.client.EvaluGroupTargetObjectUI;
import com.kingdee.eas.hr.perf.client.EvaluGroupUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.KDTableUtil;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.TargetPatchObjectUI;
import com.kingdee.eas.hr.perf.client.TargetTemplateDeployUI;
import com.kingdee.eas.hr.perf.client.TargetUniteDeployUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ESPerformanceTargetListUI
extends AbstractESPerformanceTargetListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ESPerformanceTargetListUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.EvaluSolutionResource";
    private static final int SOLUTION_PERIOD_INDEX = 3;
    private boolean isDelivered = false;
    private boolean isCanUnDeliver = false;
    private int isAllocateTarget = 0;
    private String evaluSolutionId;
    private Container parentToolBar;
    private Map param = null;
    private SolutionPeriodStatusEnum solutionStatus;
    private boolean isInitialized = false;
    private EvaluSolutionInfo evaluSolution = null;

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        RequestContext context = new RequestContext();
        String aEvaluSolutionId = (String)this.getUIContext().get("ID");
        context.put("evaluSolutionId", (Object)aEvaluSolutionId);
        postman.setRequestContext((Serializable)context);
        return postman;
    }

    public void onLoad() throws Exception {
        this.parentToolBar = (Container)this.getUIContext().get("ToolBar");
        super.onLoad();
        this.param = (Map)this.getUIContext().get("param");
        this.evaluSolutionId = (String)this.getUIContext().get("ID");
        this.initSolutionPeriod();
        this.isInitialized = true;
        this.setUIStatusByView();
        super.setQueryPreference(false);
    }

    private void initSolutionPeriod() throws Exception {
        this.evaluSolution = EvaluSolutionHelper.getEvaluSolutionInfo(this.evaluSolutionId);
        this.isAllocateTarget = this.evaluSolution.getAllocateTarget();
        this.tblMain.getColumn("flow").getStyleAttributes().setHided(this.isAllocateTarget == 0);
        EvaluSolutionHelper.setEnabled(this.parentToolBar, new String[]{"btnTargetDeploy_PerformanceTarget"}, false, this.isAllocateTarget != 0);
        if (this.getOprtState().equals(OprtState.VIEW) && this.isInitialized) {
            return;
        }
        SolutionPeriodInfo solutionPeriodInfo = null;
        if (this.comboSolutionPeriod.getSelectedItem() != null) {
            solutionPeriodInfo = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        }
        this.comboSolutionPeriod.setActionCommand("INIT");
        EvaluSolutionHelper.initSolutionPeriod(this.comboSolutionPeriod, this.evaluSolutionId, false);
        if (this.comboSolutionPeriod.getItemCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"NotExistSolutionPeriod"));
            KDTabbedPane tbpMain = (KDTabbedPane)this.getUIContext().get("TBPMain");
            tbpMain.setSelectedComponent(tbpMain.getComponentAt(3));
            SysUtil.abort();
        }
        this.comboSolutionPeriod.setActionCommand(null);
        if (solutionPeriodInfo == null) {
            this.comboSolutionPeriod.setSelectedIndex(0);
        } else {
            SolutionPeriodInfo info = this.restoreSolutionPeriodInfo(solutionPeriodInfo);
            if (info != null) {
                this.comboSolutionPeriod.setSelectedItem((Object)info);
            } else {
                this.comboSolutionPeriod.setSelectedIndex(0);
                solutionPeriodInfo = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
            }
        }
        this.initTableForTargetTemplate();
    }

    private void initTableForTargetTemplate() throws EASBizException, BOSException {
        EvaluSolutionInfo evaluSolution = EvaluSolutionFactory.getRemoteInstance().getEvaluSolutionInfo((IObjectPK)new ObjectUuidPK(this.evaluSolutionId));
        if (evaluSolution != null && DeliverModeEnum.TARGETTEMPLATEMODE.equals((Object)evaluSolution.getDeliverMode())) {
            this.tblMain.getHeadRow(0).getCell("name").setValue((Object)EASResource.getString((String)RES, (String)"targetTemplateGroup"));
        }
    }

    private SolutionPeriodInfo restoreSolutionPeriodInfo(SolutionPeriodInfo solutionPeriodInfo) {
        SolutionPeriodInfo selectedInfo = null;
        int count = this.comboSolutionPeriod.getItemCount();
        for (int i = 0; i < count; ++i) {
            selectedInfo = (SolutionPeriodInfo)this.comboSolutionPeriod.getItemAt(i);
            if (!solutionPeriodInfo.getId().equals((Object)selectedInfo.getId())) continue;
            return selectedInfo;
        }
        return null;
    }

    private IObjectValue getEntityViewInfo(String solutionPeriodId) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        evi.setFilter(fi);
        return evi;
    }

    protected String getEditUIName() {
        SolutionPeriodInfo info;
        EvaluSolutionInfo eInfo;
        String editUI = EvaluGroupUI.class.getName();
        if (this.comboSolutionPeriod.getSelectedItem() != null && !(eInfo = (info = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getEvaluSolution()).isIsControlWeight() && eInfo.getAllocateTarget() == 1 && DeliverModeEnum.PART_UNITY_DELIVER.equals((Object)eInfo.getDeliverMode())) {
            editUI = EvaluGroup2UI.class.getName();
        }
        return editUI;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EvaluGroupFactory.getRemoteInstance();
    }

    @Override
    protected void comboSolutionPeriod_actionPerformed(ActionEvent e) throws Exception {
        if ("INIT".equals(this.comboSolutionPeriod.getActionCommand())) {
            return;
        }
        if (this.comboSolutionPeriod.getSelectedItem() == null) {
            return;
        }
        SolutionPeriodInfo info = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        EvaluSolutionInfo evaluSolutionInfo = info.getEvaluSolution();
        if (evaluSolutionInfo.getAllocateTarget() == 1 && !evaluSolutionInfo.isIsControlWeight() && DeliverModeEnum.PART_UNITY_DELIVER.equals((Object)evaluSolutionInfo.getDeliverMode())) {
            this.tblMain.getColumn("weight").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("weight").getStyleAttributes().setHided(true);
        }
        String solutionPeriodId = info.getId().toString();
        this.getUIContext().put("SolutionPeriodID", solutionPeriodId);
        this.setDataObject(this.getEntityViewInfo(solutionPeriodId));
        this.refresh(null);
        this.isDelivered = EvaluSolutionHelper.checkIfAllGroupDelivered(solutionPeriodId);
        this.setWorkButtonStatus(solutionPeriodId);
    }

    private void setWorkButtonStatus(String solutionPeriodId) throws Exception {
        if (EvaluSolutionHelper.getEvaluSolutionStatus(this.evaluSolutionId).equals((Object)SolutionStatusEnum.CLOSED)) {
            Container toolBar = (Container)this.getUIContext().get("ToolBar");
            EvaluSolutionHelper.setEnabled(toolBar, new String[]{"btnAddGroup_PerformanceTarget", "btnEditGroup_PerformanceTarget", "btnDelGroup_PerformanceTarget", "btnSetGroup_PerformanceTarget", "btnDeliverTarget_PerformanceTarget", "btnUnDeliverTarget_PerformanceTarget", "btnPatchObject_PerformanceTarget"}, false, false);
            EvaluSolutionHelper.setEnabled(toolBar, new String[]{"btnTargetDeploy_PerformanceTarget"}, false, true);
        } else {
            this.changeWorkButtonStatus(solutionPeriodId);
        }
    }

    private void changeWorkButtonStatus(String solutionPeriodId) throws Exception {
        this.solutionStatus = EvaluSolutionHelper.getSolutionPeriodStatus(solutionPeriodId);
        Container toolBar = (Container)this.getUIContext().get("ToolBar");
        if (this.solutionStatus.equals((Object)SolutionPeriodStatusEnum.UN_EVALU) && this.isDelivered) {
            EvaluSolutionHelper.setEnabled(toolBar, new String[]{"btnViewGroup_PerformanceTarget", "btnUnDeliverTarget_PerformanceTarget", "btnTargetDeploy_PerformanceTarget", "btnAddGroup_PerformanceTarget", "btnEditGroup_PerformanceTarget", "btnDelGroup_PerformanceTarget", "btnSetGroup_PerformanceTarget", "btnPatchObject_PerformanceTarget"}, false, true);
            EvaluSolutionHelper.setEnabled(toolBar, new String[]{"btnDelGroup_PerformanceTarget", "btnSetGroup_PerformanceTarget", "btnDeliverTarget_PerformanceTarget"}, false, false);
        } else if (this.solutionStatus.equals((Object)SolutionPeriodStatusEnum.ON_EVALU) && this.isDelivered) {
            EvaluSolutionHelper.setEnabled(toolBar, new String[]{"btnViewGroup_PerformanceTarget", "btnTargetDeploy_PerformanceTarget", "btnPatchObject_PerformanceTarget"}, false, true);
            EvaluSolutionHelper.setEnabled(toolBar, new String[]{"btnAddGroup_PerformanceTarget", "btnEditGroup_PerformanceTarget", "btnDelGroup_PerformanceTarget", "btnSetGroup_PerformanceTarget", "btnDeliverTarget_PerformanceTarget", "btnUnDeliverTarget_PerformanceTarget"}, false, false);
        } else if (this.solutionStatus.equals((Object)SolutionPeriodStatusEnum.UN_EVALU) && !this.isDelivered) {
            EvaluSolutionHelper.setEnabled(toolBar, new String[]{"btnAddGroup_PerformanceTarget", "btnEditGroup_PerformanceTarget", "btnDelGroup_PerformanceTarget", "btnSetGroup_PerformanceTarget", "btnViewGroup_PerformanceTarget", "btnDeliverTarget_PerformanceTarget", "btnTargetDeploy_PerformanceTarget"}, false, true);
            EvaluSolutionHelper.setEnabled(toolBar, new String[]{"btnUnDeliverTarget_PerformanceTarget", "btnPatchObject_PerformanceTarget"}, false, false);
        } else if (this.solutionStatus.equals((Object)SolutionPeriodStatusEnum.END_EVALU)) {
            EvaluSolutionHelper.setEnabled(toolBar, new String[]{"btnViewGroup_PerformanceTarget", "btnTargetDeploy_PerformanceTarget"}, false, true);
            EvaluSolutionHelper.setEnabled(toolBar, new String[]{"btnAddGroup_PerformanceTarget", "btnEditGroup_PerformanceTarget", "btnDelGroup_PerformanceTarget", "btnSetGroup_PerformanceTarget", "btnDeliverTarget_PerformanceTarget", "btnUnDeliverTarget_PerformanceTarget", "btnPatchObject_PerformanceTarget"}, false, false);
        }
        if (this.solutionStatus.equals((Object)SolutionPeriodStatusEnum.UN_EVALU) && this.isCanUnDeliver) {
            EvaluSolutionHelper.setEnabled(this.parentToolBar, new String[]{"btnUnDeliverTarget_PerformanceTarget"}, false, true);
        } else {
            EvaluSolutionHelper.setEnabled(this.parentToolBar, new String[]{"btnUnDeliverTarget_PerformanceTarget"}, false, false);
        }
        this.setUIStatusByView();
        if (this.isDelivered) {
            this.lblIsDelivered.setText(EASResource.getString((String)RES, (String)"AllGroupDelivered"));
        } else {
            this.lblIsDelivered.setText(EASResource.getString((String)RES, (String)"AllGroupNotDelivered"));
        }
    }

    private void setUIStatusByView() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            EvaluSolutionHelper.setEnabled(this.parentToolBar, new String[]{"btnAddGroup_PerformanceTarget", "btnEditGroup_PerformanceTarget", "btnDelGroup_PerformanceTarget", "btnSetGroup_PerformanceTarget", "btnDeliverTarget_PerformanceTarget", "btnUnDeliverTarget_PerformanceTarget", "btnPatchObject_PerformanceTarget"}, false, false);
            EvaluSolutionHelper.setEnabled(this.parentToolBar, new String[]{"btnTargetDeploy_PerformanceTarget"}, false, true);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> uiContext = new HashMap<String, Object>(this.getUIContext());
        String evaluSolutionId = (String)uiContext.get("ID");
        uiContext.put("EvaluSolutionID", evaluSolutionId);
        uiContext.put("Owner", (Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        uiContext.put("ID", evaluSolutionId);
        if (uiWindow != null && this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.dealEditUI(OprtState.VIEW, e);
    }

    private void dealEditUI(String oprtState, ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        HashMap<String, Object> uiContext = new HashMap<String, Object>(this.getUIContext());
        String evaluSolutionId = (String)uiContext.get("ID");
        uiContext.put("EvaluSolutionID", evaluSolutionId);
        uiContext.put("ID", this.getSelectedKeyValue());
        uiContext.put("isDelivered", this.isDelivered);
        uiContext.put("parentState", this.getOprtState());
        uiContext.put("Owner", (Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), uiContext, null, oprtState);
        uiWindow.show();
        uiContext.put("ID", evaluSolutionId);
        if (uiWindow != null && this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.dealEditUI(OprtState.EDIT, e);
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    public void setGroup() throws Exception {
        this.dealEdit(OprtState.ADDNEW);
    }

    public void viewGroup() throws Exception {
        this.dealEdit(OprtState.VIEW);
    }

    private void dealEdit(String oprtState) throws Exception {
        int[] rows;
        IRow row;
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        if (OprtState.ADDNEW.equals(oprtState) && (row = this.tblMain.getRow((rows = KDTableUtil.getSelectedRows(this.tblMain))[0])).getCell("isDelivered") != null && ((Boolean)row.getCell("isDelivered").getValue()).booleanValue()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"groupHasDelivered"));
            SysUtil.abort();
        }
        HashMap<String, Object> uiContext = new HashMap<String, Object>(this.getUIContext());
        uiContext.put("Owner", (Object)this);
        uiContext.put("EvaluGroupID", this.getSelectedKeyValue());
        uiContext.put("isAllocateTarget", this.isAllocateTarget);
        EvaluSolutionTypeEnum type = (EvaluSolutionTypeEnum)((Object)this.getUIContext().get("EvaluSolutionType"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("isControlWeight"));
        sic.add(new SelectorItemInfo("deliverMode"));
        EvaluSolutionInfo esInfo = EvaluSolutionFactory.getRemoteInstance().getEvaluSolutionInfo((IObjectPK)new ObjectUuidPK(this.evaluSolutionId), sic);
        uiContext.put("deliverMode", (Object)esInfo.getDeliverMode());
        if (this.evaluSolutionId != null) {
            boolean isControlWeight = esInfo.isIsControlWeight();
            uiContext.put("isControlWeight", isControlWeight);
        } else {
            uiContext.put("isControlWeight", Boolean.FALSE);
        }
        String className = null;
        className = EvaluSolutionTypeEnum.PERSON.equals((Object)type) ? EvaluGroupTargetObjectUI.class.getName() : EvaluGroupTargetObjectOrgUnitUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(className, uiContext, null, oprtState);
        uiWindow.show();
    }

    public void deployTarget() throws Exception {
        Set evaluGroupIdSet;
        if (this.comboSolutionPeriod.getSelectedItem() == null) {
            return;
        }
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        if (this.isAllocateTarget == 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"cannotDeployTarget"));
            SysUtil.abort();
        }
        if ((evaluGroupIdSet = this.getEvaluGroupIdSet(true, true)).size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"noEvaluGroup"));
            return;
        }
        SolutionPeriodInfo info = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        String solutionPeriodId = info.getId().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("SolutionPeriodID", solutionPeriodId);
        uiContext.put("isControlWeight", info.getEvaluSolution().isIsControlWeight());
        uiContext.put("deliverMode", info.getEvaluSolution().getDeliverMode());
        uiContext.put("EvaluSolutionID", this.getUIContext().get("ID"));
        uiContext.put("isAllocateTarget", new Integer(this.isAllocateTarget));
        this.solutionStatus = EvaluSolutionHelper.getSolutionPeriodStatus(solutionPeriodId);
        if (OprtState.VIEW.equals(this.getOprtState()) || !this.solutionStatus.equals((Object)SolutionPeriodStatusEnum.UN_EVALU)) {
            uiContext.put("OprtState", OprtState.VIEW);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getTargetDeployUI(info.getEvaluSolution().getDeliverMode()), (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
        this.refreshList();
    }

    private String getTargetDeployUI(DeliverModeEnum deliverMode) {
        if (DeliverModeEnum.TARGETTEMPLATEMODE.equals((Object)deliverMode)) {
            return TargetTemplateDeployUI.class.getName();
        }
        return TargetUniteDeployUI.class.getName();
    }

    public void deliverTarget() throws Exception {
        SolutionPeriodInfo info;
        String solutionPeriodId;
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        Set evaluGroupIdSet = this.getEvaluGroupIdSet(true, false);
        if (evaluGroupIdSet.size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"noEvaluGroup"));
            SysUtil.abort();
        }
        if (!EvaluSolutionHelper.getEvaluGroupObjectIsIfExist(solutionPeriodId = (info = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getId().toString(), evaluGroupIdSet)) {
            PerfUtils.promptInfo(RES, "NotSuitObjectCanNotDeliver");
        }
        EvaluFormSolutionMultiTableCollection esMutiTableColl = EvaluSolutionHelper.getEvaluMultiTableColl(EvaluSolutionHelper.getEvaluFormSolutionID(solutionPeriodId));
        EvaluGroupCollection evaluGroupColl = EvaluSolutionHelper.getEvaluGroupCollection(evaluGroupIdSet);
        EvaluGroupInfo evaluGroupInfo = null;
        EvaluGroupTargetCollection evaluGroupTargetColl = null;
        for (int i = 0; i < evaluGroupColl.size(); ++i) {
            evaluGroupInfo = evaluGroupColl.get(i);
            if (evaluGroupInfo.isSavedTemplateTarget()) continue;
            evaluGroupTargetColl = new EvaluGroupTargetCollection();
            if ((evaluGroupTargetColl = this.getGroupTargetColl(solutionPeriodId, esMutiTableColl, evaluGroupInfo, evaluGroupTargetColl)) == null || evaluGroupTargetColl.isEmpty()) continue;
            EvaluGroupTargetFactory.getRemoteInstance().submitBatchEvaluGroupTarget(evaluGroupInfo.getId().toString(), evaluGroupTargetColl);
            evaluGroupInfo.setSavedTemplateTarget(true);
            EvaluGroupFactory.getRemoteInstance().save((CoreBaseInfo)evaluGroupInfo);
        }
        if (this.isAllocateTarget == 0 && !EvaluSolutionRuleFacadeFactory.getRemoteInstance().isFitRuleSolutionPhase(evaluGroupIdSet)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"groupTargetNotFitRule"));
            SysUtil.abort();
        }
        if (this.isAllocateTarget == 1) {
            EvaluSolutionRuleFacadeFactory.getRemoteInstance().AbsoluteFitRuleSolutionPhase_deploy1(evaluGroupIdSet);
        }
        if (this.isAllocateTarget == 2) {
            EvaluSolutionRuleFacadeFactory.getRemoteInstance().AbsoluteFitRuleSolutionPhase_deploy2(evaluGroupIdSet);
        }
        IEvaluSolutionFacade iEvaluSolutionFacade = EvaluSolutionFacadeFactory.getRemoteInstance();
        iEvaluSolutionFacade.deliverGroupTarget(solutionPeriodId, evaluGroupIdSet);
        this.setEvaluGroupDelivered(true);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"DeliverSuccess"));
        ICell cell = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            cell = this.tblMain.getRow(i).getCell("isDelivered");
            this.isDelivered = (Boolean)cell.getValue();
            if (!this.isDelivered) break;
        }
        this.isCanUnDeliver = true;
        this.changeWorkButtonStatus(solutionPeriodId);
    }

    private EvaluGroupTargetCollection getGroupTargetColl(String solutionPeriodId, EvaluFormSolutionMultiTableCollection mutiTableColl, EvaluGroupInfo groupInfo, EvaluGroupTargetCollection groupTargetColl) {
        if (groupInfo.isSavedTemplateTarget()) {
            return null;
        }
        EvaluGroupTargetInfo evaluGroupTargetInfo = null;
        EvaluTargetInfo evaluTargetInfo = null;
        EvaluFormSolutionMultiTableInfo efsmTableInfo = null;
        EvaluFormSolutionContractTemplateCollection tempColl = null;
        EvaluFormSolutionContractTemplateInfo templetInfo = null;
        for (int j = 0; j < mutiTableColl.size(); ++j) {
            efsmTableInfo = mutiTableColl.get(j);
            if (efsmTableInfo == null || (tempColl = EvaluSolutionHelper.getContractTemplateColl(efsmTableInfo.getId().toString())) == null || tempColl.size() <= 0) continue;
            for (int k = 0; k < tempColl.size(); ++k) {
                templetInfo = tempColl.get(k);
                evaluGroupTargetInfo = new EvaluGroupTargetInfo();
                evaluGroupTargetInfo.setId(BOSUuid.create((BOSObjectType)evaluGroupTargetInfo.getBOSType()));
                evaluTargetInfo = this.initEvaluTargetInfo(templetInfo, solutionPeriodId);
                evaluGroupTargetInfo.setEvaluTarget(evaluTargetInfo);
                evaluGroupTargetInfo.setEvaluGroup(groupInfo);
                evaluGroupTargetInfo.setWeight(templetInfo.getWeight());
                evaluGroupTargetInfo.setValues(templetInfo.getValues());
                evaluGroupTargetInfo.setMultiTable(efsmTableInfo);
                if (groupTargetColl == null) {
                    groupTargetColl = new EvaluGroupTargetCollection();
                }
                groupTargetColl.add(evaluGroupTargetInfo);
            }
        }
        return groupTargetColl;
    }

    private EvaluTargetInfo initEvaluTargetInfo(EvaluFormSolutionContractTemplateInfo templetInfo, String solutionPeriodId) {
        EvaluTargetInfo evaluTargetInfo = new EvaluTargetInfo();
        evaluTargetInfo.setId(BOSUuid.create((BOSObjectType)evaluTargetInfo.getBOSType()));
        SolutionPeriodInfo tempSolutionPeriodInfo = new SolutionPeriodInfo();
        tempSolutionPeriodInfo.setId(BOSUuid.read((String)solutionPeriodId));
        evaluTargetInfo.setSolutionPeriod(tempSolutionPeriodInfo);
        evaluTargetInfo.setSeqNumber(templetInfo.getSeq());
        evaluTargetInfo.setContent(templetInfo.getName());
        evaluTargetInfo.setNumber(templetInfo.getNumber());
        evaluTargetInfo.setDescription(templetInfo.getDescription());
        evaluTargetInfo.setFirstTypeWeight(templetInfo.getFirstTypeWeight());
        evaluTargetInfo.setFirstTypeScore(templetInfo.getFirstTypeScore());
        evaluTargetInfo.setSecondTypeWeight(templetInfo.getSecondTypeWeight());
        evaluTargetInfo.setSecondTypeScore(templetInfo.getSecondTypeScore());
        evaluTargetInfo.setStandard(templetInfo.getStandard());
        evaluTargetInfo.setKind(templetInfo.getKind());
        evaluTargetInfo.setDataPrecision(templetInfo.getDataPrecision());
        evaluTargetInfo.setPrecisionType(templetInfo.getPrecisionType());
        evaluTargetInfo.setThresholdValue(templetInfo.getThresholdValue());
        evaluTargetInfo.setStandardValue(templetInfo.getStandardValue());
        evaluTargetInfo.setChallengeValue(templetInfo.getChallengeValue());
        evaluTargetInfo.setUnit(templetInfo.getUnit());
        evaluTargetInfo.setReportFrequency(templetInfo.getReportFrequency());
        evaluTargetInfo.setScoringMethod(templetInfo.getScoringMethod());
        evaluTargetInfo.setEvaluationSide(templetInfo.getEvaluationSide());
        evaluTargetInfo.setReservedField1(templetInfo.getReservedFieldText1());
        evaluTargetInfo.setReservedField2text(templetInfo.getReservedFieldText2());
        evaluTargetInfo.setReservedField3(templetInfo.getReservedFieldText3());
        evaluTargetInfo.setReservedField4(templetInfo.getReservedFieldText4());
        evaluTargetInfo.setReservedField5(templetInfo.getReservedFieldText5());
        evaluTargetInfo.setReservedField6(templetInfo.getReservedFieldText6());
        evaluTargetInfo.setReservedField2(templetInfo.getReservedFieldNumber());
        evaluTargetInfo.setFormula(templetInfo.getFormula());
        evaluTargetInfo.setType(templetInfo.getFirstType());
        evaluTargetInfo.setSecondType(templetInfo.getSecondType());
        return evaluTargetInfo;
    }

    private void setEvaluGroupDelivered(boolean isDelivered) {
        int[] rows = KDTableUtil.getSelectedRows(this.tblMain);
        for (int i = 0; i < rows.length; ++i) {
            ICell cell = this.tblMain.getRow(rows[i]).getCell("isDelivered");
            cell.setValue((Object)isDelivered);
        }
    }

    private Set getEvaluGroupIdSet(boolean isDelivered, boolean isSame) {
        HashSet<Object> evaluGroupIdSet = new HashSet<Object>();
        int[] rows = KDTableUtil.getSelectedRows(this.tblMain);
        boolean delivered = false;
        IRow row = null;
        for (int i = 0; i < rows.length; ++i) {
            row = this.tblMain.getRow(rows[i]);
            if (row.getCell("isDelivered").getValue() != null) {
                delivered = (Boolean)row.getCell("isDelivered").getValue();
            }
            if (isDelivered == delivered && isSame) {
                evaluGroupIdSet.add(this.tblMain.getRow(rows[i]).getCell("id").getValue());
                continue;
            }
            if (isDelivered == delivered || isSame) continue;
            evaluGroupIdSet.add(this.tblMain.getRow(rows[i]).getCell("id").getValue());
        }
        return evaluGroupIdSet;
    }

    private boolean checkTargetWeight(String solutionPeriodId, Set evaluGroupIdSet) throws Exception {
        return EvaluSolutionFacadeFactory.getRemoteInstance().checkTargetWeight(solutionPeriodId, evaluGroupIdSet);
    }

    private boolean checkIfExistObjectInTargetStore(String solutionPeriodId, Set evaluGroupIdSet) throws Exception {
        return EvaluSolutionFacadeFactory.getRemoteInstance().checkIfExistObjectInTargetStore(solutionPeriodId, evaluGroupIdSet);
    }

    private void checkSameTargetWeight(String solutionPeriodId, Set evaluGroupIdSet) throws Exception {
        String[] ret = EvaluSolutionFacadeFactory.getRemoteInstance().checkSameTargetWeight(solutionPeriodId, evaluGroupIdSet);
        this.checkSameTargetWeight(ret, "42_ESPerformanceTargetListUI");
    }

    private void checkTargetWeightLessThanType(String solutionPeriodId, Set evaluGroupIdSet) throws EASBizException, BOSException {
        String[] ret = EvaluSolutionFacadeFactory.getRemoteInstance().checkTargetWeightLessThanType(solutionPeriodId, evaluGroupIdSet);
        this.checkSameTargetWeight(ret, "96_targetWeightMoreThanTypeWeight");
    }

    private void checkSameTargetWeight(String solutionPeriodId) throws Exception {
        String[] ret = EvaluSolutionFacadeFactory.getRemoteInstance().checkSameTargetWeight(solutionPeriodId);
        this.checkSameTargetWeight(ret, "42_ESPerformanceTargetListUI");
    }

    private void checkSameTargetWeight(String[] ret, String resKey) {
        if (ret != null && ret.length > 0) {
            StringBuffer msg = new StringBuffer();
            msg.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)resKey));
            msg.append("\n");
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < ret.length; ++i) {
                if (set.contains(ret[i].trim())) continue;
                msg.append(ret[i]);
                msg.append("  ");
                set.add(ret[i].trim());
            }
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            SysUtil.abort();
        }
    }

    public void actionPatchObject_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"EvaluSolutionID", (Object)this.evaluSolutionId);
        String id = this.getSelectedKeyValue();
        uiContext.put((Object)"groupID", (Object)id);
        SolutionPeriodInfo period = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        uiContext.put((Object)"period", (Object)period);
        uiContext.put((Object)"isAllocateTarget", (Object)(Integer.valueOf(this.isAllocateTarget) != 0 ? 1 : 0));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TargetPatchObjectUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        TargetPatchObjectUI userUI = (TargetPatchObjectUI)uiWindow.getUIObject();
        if (userUI.isCanceled()) {
            return;
        }
        Map value = userUI.getValue();
        value.put("period", period);
        value.put("groupID", id);
        EvaluSolutionFactory.getRemoteInstance().patchEvaluObject(value);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.PerfResource", (String)"addOK"));
    }

    private boolean checkTargetWeight() throws Exception {
        if (this.comboSolutionPeriod.getSelectedItem() == null) {
            return false;
        }
        String solutionPeriodId = ((SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getId().toString();
        return EvaluSolutionHelper.checkTargetWeight(solutionPeriodId);
    }

    private boolean checkIfExistObjectInTargetStore() throws Exception {
        if (this.comboSolutionPeriod.getSelectedItem() == null) {
            return false;
        }
        String solutionPeriodId = ((SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getId().toString();
        return EvaluSolutionHelper.checkIfExistObjectInTargetStore(solutionPeriodId);
    }

    private boolean checkIfAllObjectHaveFlow() throws Exception {
        if (this.comboSolutionPeriod.getSelectedItem() == null) {
            return false;
        }
        String solutionPeriodId = ((SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getId().toString();
        return EvaluSolutionHelper.checkIfAllObjectHaveFlow(solutionPeriodId);
    }

    private boolean checkIfAllObjectHaveTarget() throws Exception {
        if (this.comboSolutionPeriod.getSelectedItem() == null) {
            return false;
        }
        String solutionPeriodId = ((SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getId().toString();
        return EvaluSolutionHelper.checkIfAllObjectHaveTarget(solutionPeriodId);
    }

    private boolean checkIfExistEvaluFlow() throws Exception {
        if (this.comboSolutionPeriod.getSelectedItem() == null) {
            return false;
        }
        String solutionPeriodId = ((SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getId().toString();
        return EvaluSolutionHelper.checkIfExistEvaluFlow(solutionPeriodId);
    }

    public void unDeliverTarget() throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        if (this.comboSolutionPeriod.getSelectedItem() == null) {
            return;
        }
        Set evaluGroupIdSet = this.getEvaluGroupIdSet(false, false);
        if (evaluGroupIdSet.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"noEvaluGroup"));
            return;
        }
        SolutionPeriodInfo info = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        String solutionPeriodId = info.getId().toString();
        if (!SolutionPeriodStatusEnum.UN_EVALU.equals((Object)EvaluSolutionHelper.getSolutionPeriodStatus(solutionPeriodId))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"CannotUnDeliver1"));
            SysUtil.abort();
        }
        boolean isDelPlatformTarget = false;
        int isDel = MsgBox.showConfirm3((Component)((Object)this), (String)"\u64a4\u9500\u4e0b\u8fbe\u65f6\uff0c\u8981\u5220\u9664\u5458\u5de5\u81ea\u52a9\u670d\u52a1\u81ea\u5efa\u7684\u6307\u6807\u8bf7\u70b9\u51fb\u201c\u662f\u201d\uff0c\u5426\u5219\u70b9\u51fb\u201c\u5426\u201d\uff01");
        if (isDel == 2) {
            return;
        }
        if (isDel == 0) {
            isDelPlatformTarget = true;
        }
        IEvaluSolutionFacade iEvaluSolutionFacade = EvaluSolutionFacadeFactory.getRemoteInstance();
        iEvaluSolutionFacade.undeliverGroupTarget(solutionPeriodId, evaluGroupIdSet, isDelPlatformTarget);
        this.setEvaluGroupDelivered(false);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"UnDeliverSuccess"));
        this.isDelivered = false;
        ICell cell = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            cell = this.tblMain.getRow(i).getCell("isDelivered");
            this.isCanUnDeliver = (Boolean)cell.getValue();
            if (this.isCanUnDeliver) break;
        }
        this.changeWorkButtonStatus(solutionPeriodId);
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            this.isDelivered = false;
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (!rowSet.getBoolean("delivered")) {
                    this.isDelivered = false;
                    break;
                }
                this.isDelivered = true;
            }
            this.isCanUnDeliver = false;
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (!rowSet.getBoolean("delivered")) continue;
                this.isCanUnDeliver = true;
                break;
            }
            rowSet.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int beginRow = e.getSelectBlock().getBeginRow();
        if (beginRow >= 0 && !OprtState.VIEW.equals(this.getOprtState()) && SolutionPeriodStatusEnum.UN_EVALU.equals((Object)this.solutionStatus)) {
            int[] rows = KDTableUtil.getSelectedRows(this.tblMain);
            ICell cell = null;
            boolean isDelivered = false;
            for (int i = 0; i < rows.length && !(isDelivered = ((Boolean)(cell = this.tblMain.getRow(rows[i]).getCell("isDelivered")).getValue()).booleanValue()); ++i) {
            }
            if (isDelivered) {
                EvaluSolutionHelper.setEnabled(this.parentToolBar, new String[]{"btnViewGroup_PerformanceTarget", "btnUnDeliverTarget_PerformanceTarget", "btnTargetDeploy_PerformanceTarget", "btnPatchObject_PerformanceTarget"}, false, true);
                EvaluSolutionHelper.setEnabled(this.parentToolBar, new String[]{"btnDelGroup_PerformanceTarget", "btnSetGroup_PerformanceTarget", "btnDeliverTarget_PerformanceTarget"}, false, false);
                if (this.isAllocateTarget == 0) {
                    EvaluSolutionHelper.setEnabled(this.parentToolBar, new String[]{"btnTargetDeploy_PerformanceTarget"}, false, false);
                }
            } else {
                EvaluSolutionHelper.setEnabled(this.parentToolBar, new String[]{"btnAddGroup_PerformanceTarget", "btnEditGroup_PerformanceTarget", "btnDelGroup_PerformanceTarget", "btnSetGroup_PerformanceTarget", "btnViewGroup_PerformanceTarget", "btnDeliverTarget_PerformanceTarget"}, false, true);
                EvaluSolutionHelper.setEnabled(this.parentToolBar, new String[]{"btnUnDeliverTarget_PerformanceTarget", "btnPatchObject_PerformanceTarget"}, false, false);
            }
        }
    }

    public void secondLoad() throws Exception {
        LoadThread loadThread = new LoadThread();
        loadThread.start();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    protected void initUserConfig() {
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    private class LoadThread
    extends Thread {
        private LoadThread() {
        }

        @Override
        public void run() {
            try {
                ESPerformanceTargetListUI.this.initSolutionPeriod();
            }
            catch (Exception e) {
                ESPerformanceTargetListUI.this.handleException(e);
            }
        }
    }
}

