/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.perf.DeliverModeEnum;
import com.kingdee.eas.hr.perf.EvaluSolutionFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.client.AbstractESSolutionPeriodListUI;
import com.kingdee.eas.hr.perf.client.CopyAssessPeriodUI;
import com.kingdee.eas.hr.perf.client.ESBaseInfoUI;
import com.kingdee.eas.hr.perf.client.ESEvaluObjectOrgUnitUI;
import com.kingdee.eas.hr.perf.client.ESEvaluObjectUI;
import com.kingdee.eas.hr.perf.client.ESTargetEvaluModeUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.ProgDialog;
import com.kingdee.eas.hr.perf.client.SolutionPeriodResetUI;
import com.kingdee.eas.hr.perf.client.SolutionPeriodUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.swing.SwingUtilities;

public class ESSolutionPeriodListUI
extends AbstractESSolutionPeriodListUI {
    private static final long serialVersionUID = 1L;
    private String resourcePath = "com.kingdee.eas.hr.perf.EvaluSolutionResource";
    private String evaluSolutionId;
    private Container parentToolBar;
    private boolean isControlWeight = false;

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        RequestContext req = new RequestContext();
        this.evaluSolutionId = (String)this.getUIContext().get("ID");
        req.put("evaluSolutionId", (Object)this.evaluSolutionId);
        postman.setRequestContext((Serializable)req);
        return postman;
    }

    public void onLoad() throws Exception {
        this.parentToolBar = (Container)this.getUIContext().get("ToolBar");
        super.onLoad();
        this.evaluSolutionId = (String)this.getUIContext().get("ID");
        if (this.evaluSolutionId != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("isControlWeight"));
            EvaluSolutionInfo esInfo = EvaluSolutionFactory.getRemoteInstance().getEvaluSolutionInfo((IObjectPK)new ObjectUuidPK(this.evaluSolutionId), sic);
            this.isControlWeight = esInfo.isIsControlWeight();
        }
        this.setDataObject(this.getEntityViewInfo());
        this.setUIStatusByView();
        this.setQueryPreference(false);
    }

    private void setUIStatusByView() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            String[] workButtons = new String[]{"btnAddAssessPeriod_AssessPeriod", "btnCopyAssessPeriod_AssessPeriod", "btnEditAssessPeriod_AssessPeriod", "btnDelAssessPeriod_AssessPeriod", "btnResetAssessPeriod_AssessPeriod", "btnFinishAssessPeriod_AssessPeriod", "btnStartAssessPeriod_AssessPeriod", "btnStopInputAchData_AssessPeriod"};
            EvaluSolutionHelper.setEnabled(this.parentToolBar, workButtons, false, false);
        }
    }

    private IObjectValue getEntityViewInfo() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)this.evaluSolutionId));
        evi.setFilter(fi);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("createTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorterItemInfo);
        return evi;
    }

    protected String getEditUIName() {
        return SolutionPeriodUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SolutionPeriodFactory.getRemoteInstance();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("EvaluSolutionID", this.evaluSolutionId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (uiWindow != null && this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmDelSolutionPeriod")));
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.dealEditUI(OprtState.VIEW, e);
    }

    private void dealEditUI(String oprtState, ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("EvaluSolutionID", this.evaluSolutionId);
        uiContext.put("ID", this.getSelectedKeyValue());
        uiContext.put("superOprtState", this.getOprtState());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, oprtState);
        uiWindow.show();
        uiContext.put("ID", this.evaluSolutionId);
        if (uiWindow != null && this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.dealEditUI(OprtState.EDIT, e);
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (EvaluSolutionHelper.getEvaluSolutionStatus(this.evaluSolutionId).equals((Object)SolutionStatusEnum.CLOSED)) {
            Container toolBar = (Container)this.getUIContext().get("ToolBar");
            String[] workButtons = new String[]{"btnAddAssessPeriod_AssessPeriod", "btnEditAssessPeriod_AssessPeriod", "btnDelAssessPeriod_AssessPeriod", "btnResetAssessPeriod_AssessPeriod", "btnFinishAssessPeriod_AssessPeriod", "btnStartAssessPeriod_AssessPeriod"};
            EvaluSolutionHelper.setEnabled(toolBar, workButtons, false, false);
        } else {
            this.changeWorkButtonStatus();
        }
    }

    private void changeWorkButtonStatus() {
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        IRow row = this.tblMain.getRow(selectedRow);
        if (row != null) {
            BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("status").getValue();
            Container toolBar = (Container)this.getUIContext().get("ToolBar");
            if (status.getInt() == 100) {
                String[] workButtonsUnEnabled = new String[]{"btnResetAssessPeriod_AssessPeriod", "btnFinishAssessPeriod_AssessPeriod"};
                EvaluSolutionHelper.setEnabled(toolBar, workButtonsUnEnabled, false, false);
                String[] workButtonsEnabled = new String[]{"btnEditAssessPeriod_AssessPeriod", "btnDelAssessPeriod_AssessPeriod", "btnStartAssessPeriod_AssessPeriod", "btnStopInputAchData_AssessPeriod"};
                EvaluSolutionHelper.setEnabled(toolBar, workButtonsEnabled, false, true);
            } else if (status.getInt() == 102) {
                String[] workButtons = new String[]{"btnEditAssessPeriod_AssessPeriod", "btnDelAssessPeriod_AssessPeriod", "btnResetAssessPeriod_AssessPeriod", "btnFinishAssessPeriod_AssessPeriod", "btnStartAssessPeriod_AssessPeriod", "btnStopInputAchData_AssessPeriod"};
                EvaluSolutionHelper.setEnabled(toolBar, workButtons, false, false);
            } else if (status.getInt() == 101) {
                String[] workButtonsEnabled = new String[]{"btnAddAssessPeriod_AssessPeriod", "btnResetAssessPeriod_AssessPeriod", "btnFinishAssessPeriod_AssessPeriod"};
                EvaluSolutionHelper.setEnabled(toolBar, workButtonsEnabled, false, true);
                String[] workButtonsUnEnabled = new String[]{"btnEditAssessPeriod_AssessPeriod", "btnDelAssessPeriod_AssessPeriod", "btnStartAssessPeriod_AssessPeriod", "btnStopInputAchData_AssessPeriod"};
                EvaluSolutionHelper.setEnabled(toolBar, workButtonsUnEnabled, false, false);
            }
        }
        this.setUIStatusByView();
    }

    public void startSolutionPeriod() throws Exception {
        EvaluSolutionTypeEnum type;
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        BizEnumValueInfo status = (BizEnumValueInfo)this.tblMain.getRow(selectedRow).getCell("status").getValue();
        if (status.getInt() == 102 || status.getInt() == 101) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotStartSolutionPeriod"));
            SysUtil.abort();
        }
        if (this.checkIfExistSolutionPeriodOnUsed()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ExistSolutionPeriodOnUsed"));
            SysUtil.abort();
        }
        if (!this.checkIfExistEvaluFlow()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"NotExistEvaluFlow"));
            SysUtil.abort();
        }
        if (!this.checkIfAllGroupDelivered()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ExistUnDeliveredGroup"));
            SysUtil.abort();
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("allocateTarget"));
        sic.add(new SelectorItemInfo("deliverMode"));
        EvaluSolutionInfo info = EvaluSolutionFactory.getRemoteInstance().getEvaluSolutionInfo((IObjectPK)new ObjectUuidPK(this.evaluSolutionId), sic);
        if (info.getAllocateTarget() != 0 && !this.checkIfAllGroupDeployed()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ExistUnDeployedGroup"));
            SysUtil.abort();
        }
        if (info.getAllocateTarget() != 0 && !this.checkIfAllObjectHaveFlow()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"NotAllObjectHaveFlow"));
            SysUtil.abort();
        }
        if ((type = (EvaluSolutionTypeEnum)((Object)this.getUIContext().get("EvaluSolutionType"))).equals((Object)EvaluSolutionTypeEnum.ORGUNIT) && !this.checkIfEvaluObjectHaveResponser()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"NotAllEvaluObjectHaveResponser"));
            SysUtil.abort();
        }
        IProgTask prog = new IProgTask(){

            @Override
            public Object exec() throws Exception {
                EvaluSolutionHelper.startSolutionPeriod(ESSolutionPeriodListUI.this.getSelectedKeyValue());
                ESSolutionPeriodListUI.this.setUIStatus(true, EvaluSolutionHelper.isExistSolutionPeriodEnded(ESSolutionPeriodListUI.this.evaluSolutionId));
                ESSolutionPeriodListUI.this.refresh(null);
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
                MsgBox.showInfo((String)EASResource.getString((String)ESSolutionPeriodListUI.this.resourcePath, (String)"StartSuccess"));
            }
        };
        ProgDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new ProgDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new ProgDialog((Dialog)win);
        }
        dialog.setLongTimeTask(prog);
        dialog.show();
    }

    private boolean checkIfAllGroupDeployed() throws Exception {
        return EvaluSolutionHelper.checkIfAllGroupDeployed(this.getSelectedKeyValue());
    }

    private boolean checkIfExistObjectInTargetStore() throws Exception {
        return EvaluSolutionHelper.checkIfExistObjectInTargetStore(this.getSelectedKeyValue());
    }

    private boolean checkIfEvaluObjectHaveResponser() throws Exception {
        return EvaluSolutionHelper.checkIfEvaluObjectHaveResponser(this.getSelectedKeyValue());
    }

    private boolean checkTargetWeight() throws Exception {
        return EvaluSolutionHelper.checkTargetWeight(this.getSelectedKeyValue());
    }

    private void setUIStatus(boolean isSolutionPeriodStarted, boolean isSolutionPeriodEnded) {
        ESEvaluObjectOrgUnitUI evaluObjectOrgUnitUI;
        ESEvaluObjectUI evaluObjectUI;
        ESTargetEvaluModeUI evaluModeUI;
        ESBaseInfoUI baseInfoUI = (ESBaseInfoUI)this.getUIContext().get(ESBaseInfoUI.class.getName());
        Map uiContext = ((CoreUIObject)this.getUIContext().get("MainFrame")).getUIContext();
        if (baseInfoUI != null) {
            baseInfoUI.initUIStatus(isSolutionPeriodStarted || isSolutionPeriodEnded);
        }
        if ((evaluModeUI = (ESTargetEvaluModeUI)uiContext.get(ESTargetEvaluModeUI.class.getName())) != null) {
            evaluModeUI.initUIStatus(isSolutionPeriodStarted || isSolutionPeriodEnded);
        }
        if ((evaluObjectUI = (ESEvaluObjectUI)uiContext.get(ESEvaluObjectUI.class.getName())) != null) {
            evaluObjectUI.initUIStatus(isSolutionPeriodStarted);
        }
        if ((evaluObjectOrgUnitUI = (ESEvaluObjectOrgUnitUI)uiContext.get(ESEvaluObjectOrgUnitUI.class.getName())) != null) {
            evaluObjectOrgUnitUI.initUIStatus(isSolutionPeriodStarted);
        }
    }

    public void finishSolutionPeriod() throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        BizEnumValueInfo status = (BizEnumValueInfo)this.tblMain.getRow(selectedRow).getCell("status").getValue();
        if (status.getInt() == 102 || status.getInt() == 100) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotFinishSolutionPeriod"));
            SysUtil.abort();
        }
        if (this.checkIfAllObjectHaveFinishFlow()) {
            if (this.confirmFinishSolutionPeriod()) {
                EvaluSolutionHelper.finishSolutionPeriod(this.getSelectedKeyValue());
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"FinishSuccess"));
                this.refresh(null);
                this.setUIStatus(false, true);
            }
        } else {
            EvaluSolutionHelper.finishSolutionPeriod(this.getSelectedKeyValue());
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"FinishSuccess"));
            this.refresh(null);
            this.setUIStatus(false, true);
        }
    }

    public void resetSolutionPeriod() throws Exception {
        Date endDate;
        Date startDate;
        boolean isReset;
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        BizEnumValueInfo status = (BizEnumValueInfo)this.tblMain.getRow(selectedRow).getCell("status").getValue();
        if (status.getInt() == 102 || status.getInt() == 100) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotResetSolutionPeriod"));
            SysUtil.abort();
        }
        if (isReset = SolutionPeriodResetUI.showDialogWindows((IUIObject)this, startDate = (Date)this.tblMain.getRow(selectedRow).getCell("assessPeriod.startDate").getValue(), endDate = (Date)this.tblMain.getRow(selectedRow).getCell("assessPeriod.endDate").getValue())) {
            IProgTask prog = new IProgTask(){

                @Override
                public Object exec() throws Exception {
                    EvaluSolutionHelper.resetSolutionPeriod(ESSolutionPeriodListUI.this.getSelectedKeyValue());
                    ESSolutionPeriodListUI.this.setUIStatus(false, EvaluSolutionHelper.isExistSolutionPeriodEnded(ESSolutionPeriodListUI.this.evaluSolutionId));
                    ESSolutionPeriodListUI.this.refresh(null);
                    return "";
                }

                @Override
                public void afterExec(Object result) throws Exception {
                    MsgBox.showInfo((String)EASResource.getString((String)ESSolutionPeriodListUI.this.resourcePath, (String)"ResetSuccess"));
                }
            };
            ProgDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new ProgDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new ProgDialog((Dialog)win);
            }
            dialog.setLongTimeTask(prog);
            dialog.show();
        }
    }

    private boolean confirmResetSolutionPeriod() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmResetSolutionPeriod")));
    }

    private boolean confirmFinishSolutionPeriod() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmFinishSolutionPeriod")));
    }

    private boolean checkIfAllObjectHaveFinishFlow() throws Exception {
        return EvaluSolutionHelper.checkIfAllObjectHaveFinishFlow(this.getSelectedKeyValue());
    }

    private boolean checkTargetHaveDelivered() throws Exception {
        return EvaluSolutionHelper.isAllTargetDelivered(this.getSelectedKeyValue());
    }

    private boolean checkIfAllObjectHaveFlow() throws Exception {
        return EvaluSolutionHelper.checkIfAllObjectHaveFlow(this.getSelectedKeyValue());
    }

    private boolean checkIfAllObjectHaveTarget() throws Exception {
        return EvaluSolutionHelper.checkIfAllObjectHaveTarget(this.getSelectedKeyValue());
    }

    private boolean checkIfExistEvaluFlow() throws Exception {
        return EvaluSolutionHelper.checkIfExistEvaluFlow(this.getSelectedKeyValue());
    }

    private boolean checkIfAllGroupDelivered() throws Exception {
        return EvaluSolutionHelper.checkIfAllGroupDelivered(this.getSelectedKeyValue());
    }

    private boolean checkIfExistSolutionPeriodOnUsed() throws Exception {
        return EvaluSolutionHelper.isExistSolutionPeriodStarted(this.evaluSolutionId);
    }

    public void copyAssessPeriod(ActionEvent e) throws Exception {
        this.beforeCopyAssessPeriod();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CopyAssessPeriodUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        CopyAssessPeriodUI uiObject = (CopyAssessPeriodUI)uiWindow.getUIObject();
        if (uiObject.isCopy()) {
            CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
            this.refresh(e);
        }
    }

    private void beforeCopyAssessPeriod() throws EASBizException, BOSException {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("evaluSolution.deliverMode"));
        SolutionPeriodInfo solutionPeriodInfo = SolutionPeriodFactory.getRemoteInstance().getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(id), sic);
        if (DeliverModeEnum.DIS_UNITY_DELIVER.equals((Object)solutionPeriodInfo.getEvaluSolution().getDeliverMode()) || DeliverModeEnum.TARGETTEMPLATEMODE.equals((Object)solutionPeriodInfo.getEvaluSolution().getDeliverMode())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotCopyAssessPeriod"));
            SysUtil.abort();
        }
    }

    protected void wfInit() {
        super.wfInit();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    protected void initUserConfig() {
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void checkQueryPK() {
        this.setHasQyeryPK(false);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public void stopInputAchData(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("canInputAchData"));
        SolutionPeriodInfo solutionPeriodInfo = SolutionPeriodFactory.getRemoteInstance().getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(id), sic);
        if (solutionPeriodInfo.isCanInputAchData()) {
            int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"isStopInputAchData"));
            if (0 == result) {
                solutionPeriodInfo.setCanInputAchData(false);
                SolutionPeriodFactory.getRemoteInstance().updatePartial((CoreBaseInfo)solutionPeriodInfo, sic);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"achieveDataInputFinished"));
        }
    }

    public void validateIsIfSelectRow() {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
    }
}

