/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.hr.perf.DeliverModeEnum;
import com.kingdee.eas.hr.perf.EvaluRuleCollection;
import com.kingdee.eas.hr.perf.EvaluRuleInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.GradeModeCollection;
import com.kingdee.eas.hr.perf.GradeModeEnum;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.IEvaluSolution;
import com.kingdee.eas.hr.perf.NodeVisibleEnum;
import com.kingdee.eas.hr.perf.PrecisionMaintainFactory;
import com.kingdee.eas.hr.perf.RankGroupCollection;
import com.kingdee.eas.hr.perf.RankGroupInfo;
import com.kingdee.eas.hr.perf.TargetAuditTypeEnum;
import com.kingdee.eas.hr.perf.TargetGradeModeEnum;
import com.kingdee.eas.hr.perf.client.AbstractESTargetEvaluModeUI;
import com.kingdee.eas.hr.perf.client.ESEvaluObjectOrgUnitUI;
import com.kingdee.eas.hr.perf.client.ESEvaluObjectUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.IEvaluSolutionUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.PrecisionMaintainUI;
import com.kingdee.eas.hr.perf.client.RankViewListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class ESTargetEvaluModeUI
extends AbstractESTargetEvaluModeUI
implements IEvaluSolutionUI {
    private static final long serialVersionUID = -61166L;
    private static final String RES = "com.kingdee.eas.hr.perf.EvaluSolutionResource";
    private String evaluSolutionId;
    private EvaluSolutionInfo oldSolutionInfo;
    private EvaluSolutionInfo solutionInfo;
    public static Component performanceTarget;
    public static String performanceTargetTitle;
    private DeliverModeEnum deliverMode;
    private Component currentDeliverModeBtn;
    private boolean isGrade = true;
    private boolean isOrg = false;
    private final int performanceTargetPanelIndex = 5;
    private static final String USER = "0";
    private static final String MACHINE = "1";
    private HashMap gradeAndRankMap = null;
    private Map param = null;
    private int gradeIndex = 0;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.evaluSolutionId = (String)this.getUIContext().get("ID");
        this.solutionInfo = EvaluSolutionHelper.getEvaluSolutionInfo(this.evaluSolutionId);
        this.oldSolutionInfo = (EvaluSolutionInfo)this.solutionInfo.clone();
        this.isOrg = EvaluSolutionTypeEnum.ORGUNIT.equals((Object)this.solutionInfo.getSolutionType());
        this.initLoadData();
        this.btnRank_itemStateChanged(null);
        this.initUIStatus();
        super.setQueryPreference(false);
        this.cbIsAudited_actionPerformed(null);
        if (this.solutionInfo.getEvaluRule() == null) {
            this.submit();
        }
    }

    @Override
    public void secondLoad() throws Exception {
        this.initUIStatus();
    }

    public void initUIStatus() throws Exception {
        if (this.isGrade) {
            this.comboRank.setEnabled(false);
        }
        if (this.isOrg) {
            this.chkForm.setText(EASResource.getString((String)RES, (String)"modeChkForm"));
            this.chkOtherResult.setVisible(false);
            this.chkCustomPrecision.setVisible(false);
            this.btnPrecisionMaintain.setVisible(false);
            this.chkWorkFlowAudit.setVisible(false);
            this.add((Component)this.chkOnlyLeaderCreate, new KDLayout.Constraints(this.chkOnlyLeaderCreate.getX(), 451, this.chkOnlyLeaderCreate.getWidth(), this.chkOnlyLeaderCreate.getHeight(), 5));
            this.add((Component)this.chk0utGradeMode, new KDLayout.Constraints(this.chk0utGradeMode.getX(), 478, this.chk0utGradeMode.getWidth(), this.chk0utGradeMode.getHeight(), 5));
            this.add((Component)this.cbIsAudited, new KDLayout.Constraints(this.cbIsAudited.getX(), 397, this.cbIsAudited.getWidth(), this.cbIsAudited.getHeight(), 5));
            this.add((Component)this.cbAuditType, new KDLayout.Constraints(this.cbAuditType.getX(), 424, this.cbAuditType.getWidth(), this.cbAuditType.getHeight(), 5));
            this.chkModifyScore.setBounds(this.chkModifyScore.getX(), this.chkModifyScore.getY(), this.chkModifyScore.getWidth(), this.chkModifyScore.getHeight());
        }
        if (EvaluSolutionHelper.isExistSolutionPeriodStartedOrEnded(this.solutionInfo.getId().toString())) {
            EvaluSolutionHelper.setEnabled((Container)((Object)this), false);
            this.chkAllowModifyTargetValue.setEnabled(false);
        } else if (EvaluSolutionHelper.isExistSolutionPeriod(this.solutionInfo.getId().toString())) {
            EvaluSolutionHelper.setEnabled((Container)((Object)this), false);
        } else {
            EvaluSolutionHelper.setEnabled((Container)((Object)this), true);
            this.chkAllowModifyTargetValue.setEnabled(true);
            this.logicEnabled();
            this.chkIsControlWeight.setEnabled(true);
            this.cbIsAudited.setEnabled(true);
            this.cbAuditType.setEnabled(true);
            this.radioAll.setEnabled(true);
            this.radioPart.setEnabled(true);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            EvaluSolutionHelper.setEnabled((Container)((Object)this), false);
            this.chkAllowModifyTargetValue.setEnabled(false);
        }
        if (this.solutionInfo.getAllocateTarget() == 1) {
            this.radioPart_actionPerformed(null);
        } else if (this.solutionInfo.getAllocateTarget() == 2) {
            this.radioPartNew_actionPerformed(null);
        }
    }

    public void initUIStatus(boolean isExistSolutionPeriodStarted) {
        if (isExistSolutionPeriodStarted) {
            EvaluSolutionHelper.setEnabled((Container)((Object)this), false);
            this.chkAllowModifyTargetValue.setEnabled(false);
        } else {
            EvaluSolutionHelper.setEnabled((Container)((Object)this), true);
            if (!this.btnRank.isSelected()) {
                this.comboRank.setEnabled(false);
                this.comboRank.setSelectedItem(null);
                this.btnViewRankGroup.setEnabled(false);
            }
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            EvaluSolutionHelper.setEnabled((Container)((Object)this), false);
            this.chkAllowModifyTargetValue.setEnabled(false);
        }
    }

    private void logicEnabled() {
        EvaluRuleInfo evaluRuleInfo;
        if (this.radioPart.isSelected()) {
            this.btnDirectEnter.setEnabled(false);
            this.chkAllowModifyTargetValue.setEnabled(false);
            this.chkModifyFormSolutionContent.setEnabled(false);
        }
        if (this.radioPartNew.isSelected()) {
            this.btnDirectEnter.setEnabled(false);
            this.chkAllowModifyTargetValue.setEnabled(false);
            this.chkModifyFormSolutionContent.setEnabled(false);
        }
        if (this.radioAll.isSelected()) {
            this.btnDirectEnter.setEnabled(true);
            this.chkAllowModifyTargetValue.setEnabled(true);
            this.chkModifyFormSolutionContent.setEnabled(true);
        }
        if (!this.btnRank.isSelected()) {
            this.comboRank.setEnabled(false);
            this.comboRank.setSelectedItem(null);
            this.btnViewRankGroup.setEnabled(false);
        }
        if (!this.chkCustomPrecision.isSelected()) {
            this.btnPrecisionMaintain.setEnabled(false);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.chkIsControlWeight.setEnabled(false);
            this.cbIsAudited.setEnabled(false);
            this.cbAuditType.setEnabled(false);
        }
        if ((evaluRuleInfo = (EvaluRuleInfo)this.comboEvaluRule.getSelectedItem()) != null) {
            if ("00000000-0000-0000-0000-000000000002044ED142".equals(evaluRuleInfo.getId().toString())) {
                this.txtTotalScore.setEditable(true);
                this.comboGrade.setEnabled(false);
            } else if ("00000000-0000-0000-0000-000000000003044ED142".equals(evaluRuleInfo.getId().toString())) {
                this.txtTotalScore.setEditable(false);
                this.comboGrade.setEnabled(false);
            } else {
                this.txtTotalScore.setEditable(false);
                this.comboGrade.setEnabled(true);
            }
        }
    }

    public void initLoadData() throws Exception {
        this.param = (Map)this.getUIContext().get("param");
        this.gradeAndRankMap = EvaluSolutionFactory.getRemoteInstance().getUsebleGradeModeAndRankGroup();
        GradeModeCollection gradeModeCollection = (GradeModeCollection)((Object)this.gradeAndRankMap.get("GradeMode"));
        this.comboGrade.setActionCommand(MACHINE);
        this.comboGrade.removeAllItems();
        this.comboGrade.addItems(gradeModeCollection.toArray());
        this.comboGrade.setSelectedItem(null);
        this.comboGrade.setActionCommand(USER);
        if (this.solutionInfo.getTargetGradeModeLink() == null) {
            GradeModeInfo gradeModeInfo = null;
            int n = this.comboGrade.getItemCount();
            for (int i = 0; i < n; ++i) {
                gradeModeInfo = (GradeModeInfo)this.comboGrade.getItemAt(i);
                if (!gradeModeInfo.getIsDefault().equals((Object)GradeModeEnum.YES)) continue;
                this.solutionInfo.setTargetGradeModeLink(gradeModeInfo);
                break;
            }
        }
        this.cbAuditType.removeAllItems();
        this.cbAuditType.addItem((Object)TargetAuditTypeEnum.directDeliver);
        this.cbAuditType.addItem((Object)TargetAuditTypeEnum.noDirectDeliver);
        this.cbAuditType.setSelectedItem(null);
        EvaluRuleCollection evaluRuleCollection = EvaluSolutionFactory.getRemoteInstance().getEvaluRuleCollection();
        this.comboEvaluRule.addItems(evaluRuleCollection.toArray());
        if (this.oldSolutionInfo.getTargetGradeMode() == null) {
            this.oldSolutionInfo.setTargetGradeMode(TargetGradeModeEnum.MANUAL_ENTER);
        }
        if (this.oldSolutionInfo.getNodeVisibleMode() == null) {
            this.oldSolutionInfo.setNodeVisibleMode(NodeVisibleEnum.all);
        }
        this.loadFields();
    }

    @Override
    public void loadFields() {
        int i;
        int count;
        super.loadFields();
        if (this.solutionInfo.getTargetGradeModeLink() != null) {
            count = this.comboGrade.getItemCount();
            for (i = 0; i < count; ++i) {
                if (!((GradeModeInfo)this.comboGrade.getItemAt(i)).getId().equals((Object)this.solutionInfo.getTargetGradeModeLink().getId())) continue;
                this.comboGrade.setSelectedIndex(i);
                this.gradeIndex = i;
            }
        }
        this.comboGrade.setSelectedItem((Object)this.solutionInfo.getTargetGradeModeLink());
        if (this.solutionInfo.getEvaluRule() != null) {
            count = this.comboEvaluRule.getItemCount();
            for (i = 0; i < count; ++i) {
                if (!((EvaluRuleInfo)this.comboEvaluRule.getItemAt(i)).getId().equals((Object)this.solutionInfo.getEvaluRule().getId())) continue;
                this.comboEvaluRule.setSelectedIndex(i);
                break;
            }
            this.fillEvaluRuleTable(this.solutionInfo.getEvaluRule());
        }
        if (this.solutionInfo.getTargetGradeMode() != null) {
            this.isGrade = this.solutionInfo.getTargetGradeMode().equals((Object)TargetGradeModeEnum.MANUAL_ENTER);
            if (this.isGrade) {
                this.btnManualGrade.setSelected(true);
                this.comboRank.setEnabled(false);
            }
            if (!this.isGrade) {
                this.btnRank.setSelected(true);
                this.comboRank.setEnabled(true);
                for (i = 0; i < this.comboRank.getItemCount(); ++i) {
                    if (!((RankGroupInfo)this.comboRank.getItemAt(i)).getId().equals((Object)this.solutionInfo.getTargetRankGroup().getId())) continue;
                    this.comboRank.setSelectedIndex(i);
                }
            }
        }
        if (this.solutionInfo.getAllocateTarget() == 1) {
            this.radioPart.setSelected(true);
        } else if (this.solutionInfo.getAllocateTarget() == 2) {
            this.radioPartNew.setSelected(true);
        } else {
            this.radioAll.setSelected(true);
        }
        DeliverModeEnum deliverMode = this.solutionInfo.getDeliverMode();
        if (DeliverModeEnum.UNITY_DELIVER.equals((Object)deliverMode) || deliverMode == null) {
            this.btnUnite.setSelected(true);
        } else if (DeliverModeEnum.DIRECT_ENTER.equals((Object)deliverMode)) {
            this.btnDirectEnter.setSelected(true);
        }
        NodeVisibleEnum nodeVisibleMode = this.solutionInfo.getNodeVisibleMode();
        if (NodeVisibleEnum.all.equals((Object)nodeVisibleMode) || nodeVisibleMode == null) {
            this.radioAllNodes.setSelected(true);
        } else if (NodeVisibleEnum.self.equals((Object)nodeVisibleMode)) {
            this.radioSelf.setSelected(true);
        } else {
            this.radioPartNodes.setSelected(true);
        }
        this.chkForm.setSelected(this.solutionInfo.isViewSelfForm());
        this.chkOtherResult.setSelected(this.solutionInfo.isViewOtherResult());
        this.chkScoreToNextNode.setSelected(this.solutionInfo.isScoreToNextNode());
        this.chkAllowModifyTargetValue.setSelected(this.solutionInfo.isAllowModifyTargetValue());
        this.chkIsControlWeight.setSelected(this.solutionInfo.isIsControlWeight());
        this.chkModifyScore.setSelected(this.solutionInfo.isModifyScore());
        if (this.solutionInfo.getTotalScore() != null) {
            this.txtTotalScore.setValue((Object)this.solutionInfo.getTotalScore());
        }
        this.chkOnlyLeaderCreate.setSelected(this.solutionInfo.isOnlyLeaderCreate());
        this.chkDeduction.setSelected(this.solutionInfo.isDeduction());
        this.chkKeyEventMode.setSelected(this.solutionInfo.isKeyEvent());
        this.chkWorkFlowAudit.setSelected(this.solutionInfo.isWorkflow());
        this.chkCustomPrecision.setSelected(this.solutionInfo.isCustomPrecision());
        this.chkModifyFormSolutionContent.setSelected(this.solutionInfo.isModifyContent());
        this.chk0utGradeMode.setSelected(this.solutionInfo.isOutGradeMode());
        TargetAuditTypeEnum auditType = this.solutionInfo.getAuditType();
        if (auditType != null && auditType.getValue() != 0) {
            this.cbIsAudited.setSelected(true);
            for (int i2 = 0; i2 < this.cbAuditType.getItemCount(); ++i2) {
                TargetAuditTypeEnum auditTypeEnum = (TargetAuditTypeEnum)((Object)this.cbAuditType.getItemAt(i2));
                if (auditTypeEnum.getValue() != this.solutionInfo.getAuditType().getValue()) continue;
                this.cbAuditType.setSelectedIndex(i2);
            }
            this.cbAuditType.setEnabled(true);
        } else {
            this.cbIsAudited.setSelected(false);
            this.cbAuditType.setSelectedItem(null);
            this.cbAuditType.setEnabled(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.comboEvaluRule.getSelectedItem() != null) {
            EvaluRuleInfo evaluRuleInfo = (EvaluRuleInfo)this.comboEvaluRule.getSelectedItem();
            this.solutionInfo.setEvaluRule(evaluRuleInfo);
        }
        if (this.comboGrade.getSelectedItem() != null) {
            this.solutionInfo.setTargetGradeModeLink((GradeModeInfo)this.comboGrade.getSelectedItem());
        } else {
            this.solutionInfo.setTargetGradeModeLink(null);
        }
        if (this.btnManualGrade.isSelected()) {
            this.solutionInfo.setTargetGradeMode(TargetGradeModeEnum.MANUAL_ENTER);
        }
        if (this.btnRank.isSelected()) {
            this.solutionInfo.setTargetGradeMode(TargetGradeModeEnum.RANK_GROUP);
            this.solutionInfo.setTargetRankGroup((RankGroupInfo)this.comboRank.getSelectedItem());
        }
        if (this.btnDirectEnter.isSelected()) {
            this.solutionInfo.setDeliverMode(DeliverModeEnum.DIRECT_ENTER);
        }
        if (this.btnUnite.isSelected()) {
            this.solutionInfo.setDeliverMode(DeliverModeEnum.UNITY_DELIVER);
        }
        if (this.radioPart.isSelected()) {
            this.solutionInfo.setAllocateTarget(1);
        } else if (this.radioPartNew.isSelected()) {
            this.solutionInfo.setAllocateTarget(2);
        } else {
            this.solutionInfo.setAllocateTarget(0);
        }
        if (this.radioAllNodes.isSelected()) {
            this.solutionInfo.setNodeVisibleMode(NodeVisibleEnum.all);
        } else if (this.radioSelf.isSelected()) {
            this.solutionInfo.setNodeVisibleMode(NodeVisibleEnum.self);
        } else {
            this.solutionInfo.setNodeVisibleMode(NodeVisibleEnum.part);
        }
        if (this.txtTotalScore.getBigDecimalValue() != null) {
            this.solutionInfo.setTotalScore(this.txtTotalScore.getBigDecimalValue());
        } else {
            this.solutionInfo.setTotalScore(null);
        }
        this.solutionInfo.setViewSelfForm(this.chkForm.isSelected());
        this.solutionInfo.setViewOtherResult(this.chkOtherResult.isSelected());
        this.solutionInfo.setScoreToNextNode(this.chkScoreToNextNode.isSelected());
        this.solutionInfo.setAllowModifyTargetValue(this.chkAllowModifyTargetValue.isSelected());
        this.solutionInfo.setIsControlWeight(this.chkIsControlWeight.isSelected());
        this.solutionInfo.setOnlyLeaderCreate(this.chkOnlyLeaderCreate.isSelected());
        this.solutionInfo.setDeduction(this.chkDeduction.isSelected());
        if (this.chkCustomPrecision.isEnabled()) {
            this.solutionInfo.setCustomPrecision(this.chkCustomPrecision.isSelected());
        }
        if (this.chkModifyScore.isEnabled()) {
            this.solutionInfo.setModifyScore(this.chkModifyScore.isSelected());
        }
        this.solutionInfo.setKeyEvent(this.chkKeyEventMode.isSelected());
        this.solutionInfo.setWorkflow(this.chkWorkFlowAudit.isSelected());
        this.solutionInfo.setModifyContent(this.chkModifyFormSolutionContent.isSelected());
        this.solutionInfo.setOutGradeMode(this.chk0utGradeMode.isSelected());
        if (this.cbAuditType.getSelectedItem() == null) {
            this.solutionInfo.setAuditType(TargetAuditTypeEnum.notNeedAudit);
        } else {
            this.solutionInfo.setAuditType((TargetAuditTypeEnum)((Object)this.cbAuditType.getSelectedItem()));
        }
    }

    @Override
    public void submit() throws Exception {
        this.verifyInput();
        this.storeFields();
        IEvaluSolution evaluSolution = EvaluSolutionFactory.getRemoteInstance();
        evaluSolution.submit((CoreBaseInfo)this.solutionInfo);
        this.updateOldData();
    }

    @Override
    public void verifyInput() throws Exception {
        try {
            EvaluRuleInfo evaluRuleInfo = (EvaluRuleInfo)this.comboEvaluRule.getSelectedItem();
            if ("00000000-0000-0000-0000-000000000002044ED142".equals(evaluRuleInfo.getId().toString())) {
                PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtTotalScore);
            } else if ("00000000-0000-0000-0000-000000000000044ED1422".equals(evaluRuleInfo.getId().toString()) || "00000000-0000-0000-0000-000000000001044ED142".equals(evaluRuleInfo.getId().toString())) {
                PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.comboGrade);
            }
            if (this.btnRank.isSelected()) {
                PFVerifyUtils.verifyEmpty((CoreUIObject)this, RES, this.comboRank, "RankGroupNull");
            }
        }
        catch (Exception e) {
            KDTabbedPane tbpMain = (KDTabbedPane)this.getUIContext().get("TBPMain");
            tbpMain.setSelectedIndex(((Integer)this.getUIContext().get("CurrentIndex")).intValue());
            SysUtil.abort();
        }
    }

    @Override
    protected void comboGrade_actionPerformed(ActionEvent e) throws Exception {
        if (!USER.equals(e.getActionCommand())) {
            return;
        }
        GradeModeInfo gradeModeInfo = (GradeModeInfo)this.comboGrade.getSelectedItem();
        if (gradeModeInfo != null) {
            String id = gradeModeInfo.getId().toString();
            RankGroupCollection rankGroupCollection = (RankGroupCollection)((Object)this.gradeAndRankMap.get(id));
            this.comboRank.removeAllItems();
            if (rankGroupCollection != null) {
                this.comboRank.addItems(rankGroupCollection.toArray());
            }
            if (this.btnManualGrade.isSelected()) {
                this.comboRank.setSelectedItem(null);
            }
        }
    }

    private void checkIfExistEvaluGroup() throws Exception {
        if (EvaluSolutionHelper.checkIfExistEvaluGroup(this.evaluSolutionId)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"ExistGroup"));
            if (this.currentDeliverModeBtn != null) {
                ((KDRadioButton)this.currentDeliverModeBtn).setSelected(true);
            }
            SysUtil.abort();
        }
    }

    @Override
    protected void btnManualGrade_itemStateChanged(ItemEvent e) throws Exception {
        if (this.btnManualGrade.isSelected()) {
            this.comboRank.setEnabled(false);
            this.comboRank.setSelectedItem(null);
            this.btnViewRankGroup.setEnabled(false);
            this.chkModifyScore.setEnabled(true);
            this.chkModifyScore.setSelected(false);
            this.chkCustomPrecision.setSelected(false);
            this.chkCustomPrecision.setEnabled(true);
        }
    }

    @Override
    protected void btnRank_itemStateChanged(ItemEvent e) throws Exception {
        if (this.btnRank.isSelected()) {
            this.comboRank.setEnabled(true);
            this.btnViewRankGroup.setEnabled(true);
            this.chkModifyScore.setEnabled(false);
            this.chkModifyScore.setSelected(false);
            this.chkCustomPrecision.setSelected(false);
            this.chkCustomPrecision.setEnabled(false);
            this.chkDeduction.setSelected(false);
            this.chkDeduction.setEnabled(false);
        } else {
            this.comboRank.setEnabled(false);
            this.comboRank.setSelectedItem(null);
            this.btnViewRankGroup.setEnabled(false);
            this.chkModifyScore.setEnabled(false);
            this.chkCustomPrecision.setEnabled(false);
            this.chkDeduction.setEnabled(true);
        }
    }

    @Override
    protected void btnViewRankGroup_actionPerformed(ActionEvent e) throws Exception {
        super.btnViewRankGroup_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        if (this.comboRank.getSelectedItem() != null) {
            String rankGroupId = ((RankGroupInfo)this.comboRank.getSelectedItem()).getId().toString();
            uiContext.put((Object)"RankGroupID", (Object)rankGroupId);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RankViewListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected void radioAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.radioAll.isSelected()) {
            this.chkAllowModifyTargetValue.setEnabled(true);
            this.chkModifyFormSolutionContent.setEnabled(true);
            this.btnDirectEnter.setEnabled(true);
            this.comboEvaluRule.setEnabled(true);
            this.param.put("allocate", 0);
        }
    }

    @Override
    protected void radioPart_actionPerformed(ActionEvent e) throws Exception {
        if (this.radioPart.isSelected()) {
            this.chkAllowModifyTargetValue.setEnabled(false);
            this.chkAllowModifyTargetValue.setSelected(false);
            this.chkModifyFormSolutionContent.setEnabled(false);
            this.chkModifyFormSolutionContent.setSelected(false);
            this.btnDirectEnter.setEnabled(false);
            this.btnDirectEnter.setSelected(false);
            this.comboEvaluRule.setSelectedIndex(0);
            this.comboEvaluRule.setEnabled(false);
            this.param.put("allocate", 1);
        } else {
            this.param.put("allocate", 0);
        }
    }

    @Override
    protected void radioPartNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.radioPartNew.isSelected()) {
            this.chkAllowModifyTargetValue.setEnabled(false);
            this.chkAllowModifyTargetValue.setSelected(false);
            this.chkModifyFormSolutionContent.setEnabled(false);
            this.chkModifyFormSolutionContent.setSelected(false);
            this.btnDirectEnter.setEnabled(false);
            this.btnDirectEnter.setSelected(false);
            this.comboEvaluRule.setSelectedIndex(0);
            this.comboEvaluRule.setEnabled(false);
            this.param.put("allocate", 2);
        } else {
            this.param.put("allocate", 0);
        }
    }

    public boolean isDataModified() {
        this.storeFields();
        return !ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)this.oldSolutionInfo, (AbstractObjectValue)this.solutionInfo);
    }

    public void updateOldData() throws Exception {
        this.oldSolutionInfo = (EvaluSolutionInfo)this.solutionInfo.clone();
    }

    private void setAssessMode(boolean canEdite) {
        this.btnUnite.setEnabled(canEdite);
        this.btnDirectEnter.setEnabled(canEdite);
        if (canEdite) {
            this.deliverMode = DeliverModeEnum.DIRECT_ENTER;
            if (!this.btnDirectEnter.isSelected()) {
                this.deliverMode = DeliverModeEnum.UNITY_DELIVER;
                this.btnUnite.setSelected(true);
            }
            this.setTargetStorePanel(this.deliverMode);
        } else {
            this.btnUnite.setSelected(false);
            this.btnDirectEnter.setSelected(false);
        }
    }

    private void setChkAllowModifyTargetValueState(boolean editable) {
        if (editable && !this.radioPart.isSelected()) {
            this.chkAllowModifyTargetValue.setEnabled(editable);
            this.chkAllowModifyTargetValue.setEditable(editable);
            this.chkAllowModifyTargetValue.setSelected(false);
        } else {
            this.chkAllowModifyTargetValue.setEnabled(!editable);
            this.chkAllowModifyTargetValue.setSelected(false);
        }
    }

    private void setTargetStorePanel(DeliverModeEnum deliverMode) {
        KDTabbedPane tbpMain = (KDTabbedPane)this.getUIContext().get("TBPMain");
        if (DeliverModeEnum.DIS_UNITY_DELIVER.equals((Object)deliverMode)) {
            if (tbpMain.getTabCount() >= 6 && tbpMain.getComponentAt(5).getName().equals("pnlPerformanceTarget")) {
                performanceTarget = tbpMain.getComponentAt(5);
                performanceTargetTitle = tbpMain.getTitleAt(5);
                tbpMain.insertTab(performanceTargetTitle, null, performanceTarget, null, 5);
                tbpMain.remove(performanceTarget);
            }
        } else if (tbpMain.getTabCount() >= 6 && tbpMain.getComponentAt(5).getName().equals("pnlPerformanceTarget")) {
            tbpMain.setTitleAt(5, performanceTargetTitle);
        } else {
            tbpMain.insertTab(performanceTargetTitle, null, performanceTarget, null, 5);
        }
    }

    @Override
    protected void chkCustomPrecision_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkCustomPrecision.isSelected()) {
            this.btnPrecisionMaintain.setEnabled(true);
        } else {
            this.btnPrecisionMaintain.setEnabled(false);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("evaluSolution", (Object)this.evaluSolutionId, CompareType.EQUALS));
            PrecisionMaintainFactory.getRemoteInstance().delete(filterInfo);
        }
    }

    @Override
    protected void btnPrecisionMaintain_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"evaluSolutionId", (Object)this.evaluSolutionId);
        if (!this.chkCustomPrecision.isEnabled()) {
            uiContext.put((Object)"OprtState", (Object)"VIEW");
        }
        if (this.btnRank.isSelected()) {
            uiContext.put((Object)"isRank", (Object)"ISRANK");
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PrecisionMaintainUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected void comboEvaluRule_actionPerformed(ActionEvent e) throws Exception {
        EvaluRuleInfo evaluRuleInfo = (EvaluRuleInfo)this.comboEvaluRule.getSelectedItem();
        if (evaluRuleInfo != null) {
            if ("00000000-0000-0000-0000-000000000002044ED142".equals(evaluRuleInfo.getId().toString())) {
                if (this.solutionInfo.getTotalScore() != null) {
                    this.txtTotalScore.setValue((Object)this.solutionInfo.getTotalScore());
                } else {
                    this.txtTotalScore.setValue((Object)new BigDecimal("100"));
                }
                this.txtTotalScore.setEditable(true);
                this.comboGrade.setSelectedItem(null);
                this.comboGrade.setEnabled(false);
            } else if ("00000000-0000-0000-0000-000000000003044ED142".equals(evaluRuleInfo.getId().toString())) {
                this.txtTotalScore.setValue(null);
                this.txtTotalScore.setEditable(false);
                this.comboGrade.setSelectedItem(null);
                this.comboGrade.setEnabled(false);
            } else {
                this.txtTotalScore.setValue(null);
                this.txtTotalScore.setEditable(false);
                this.comboGrade.setSelectedIndex(this.gradeIndex);
                this.comboGrade.setEnabled(true);
            }
            this.fillEvaluRuleTable(evaluRuleInfo);
        }
    }

    private void fillEvaluRuleTable(EvaluRuleInfo evaluRuleInfo) {
        if (evaluRuleInfo != null) {
            this.tblMain.removeRows();
            IRow iRow = this.tblMain.addRow();
            this.tblMain.getRow(0).setHeight(95);
            iRow.getCell("rulemode").setValue((Object)evaluRuleInfo.getRuleMode().getAlias());
            iRow.getCell("description").setValue((Object)evaluRuleInfo.getDescription());
            iRow.getCell("singleTableScoreDescr").setValue((Object)evaluRuleInfo.getSingleTableScoreDescr());
            iRow.getCell("evaluSumScoreDescr").setValue((Object)evaluRuleInfo.getEvaluSumScoreDescr());
        }
    }

    @Override
    protected void txtTotalScore_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtTotalScore.getBigDecimalValue() != null && (this.txtTotalScore.getBigDecimalValue().compareTo(new BigDecimal(MACHINE)) < 0 || this.txtTotalScore.getBigDecimalValue().compareTo(new BigDecimal("1000")) > 0)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"ESTargetEvaluModeUI"));
            this.txtTotalScore.setValue((Object)new BigDecimal("100"));
        }
    }

    @Override
    protected void cbIsAudited_actionPerformed(ActionEvent e) throws Exception {
        if (EvaluSolutionHelper.isExistSolutionPeriod(this.solutionInfo.getId().toString())) {
            this.cbIsAudited.setEnabled(false);
            this.cbAuditType.setEnabled(false);
            return;
        }
        if (this.cbIsAudited.isSelected()) {
            this.cbAuditType.setEnabled(true);
            if (this.cbAuditType.getSelectedItem() == null) {
                this.cbAuditType.setSelectedIndex(0);
            }
        } else {
            this.cbAuditType.setEnabled(false);
            this.cbAuditType.setSelectedItem(null);
        }
    }

    private class UnLoadThread
    extends Thread {
        private UnLoadThread() {
        }

        @Override
        public void run() {
            try {
                ESEvaluObjectOrgUnitUI evaluObjectOrgUnitUI;
                ESEvaluObjectUI evaluObjectUI = (ESEvaluObjectUI)EvaluSolutionHelper.getMainUIContext((CoreUIObject)ESTargetEvaluModeUI.this).get(ESEvaluObjectUI.class.getName());
                if (evaluObjectUI != null) {
                    evaluObjectUI.setUIStatusByDeliverMode(ESTargetEvaluModeUI.this.deliverMode);
                    evaluObjectUI.unLoadDeliverers();
                }
                if ((evaluObjectOrgUnitUI = (ESEvaluObjectOrgUnitUI)EvaluSolutionHelper.getMainUIContext((CoreUIObject)ESTargetEvaluModeUI.this).get(ESEvaluObjectOrgUnitUI.class.getName())) != null) {
                    evaluObjectOrgUnitUI.setUIStatusByDeliverMode(ESTargetEvaluModeUI.this.deliverMode);
                    evaluObjectOrgUnitUI.unLoadDeliverers();
                }
            }
            catch (Exception e) {
                ESTargetEvaluModeUI.this.handUIException(e);
            }
        }
    }

    private class LoadThread
    extends Thread {
        private LoadThread() {
        }

        @Override
        public void run() {
            try {
                ESEvaluObjectOrgUnitUI evaluObjectOrgUnitUI;
                ESEvaluObjectUI evaluObjectUI = (ESEvaluObjectUI)EvaluSolutionHelper.getMainUIContext((CoreUIObject)ESTargetEvaluModeUI.this).get(ESEvaluObjectUI.class.getName());
                if (evaluObjectUI != null) {
                    evaluObjectUI.setUIStatusByDeliverMode(ESTargetEvaluModeUI.this.deliverMode);
                    evaluObjectUI.loadDeliverers();
                }
                if ((evaluObjectOrgUnitUI = (ESEvaluObjectOrgUnitUI)EvaluSolutionHelper.getMainUIContext((CoreUIObject)ESTargetEvaluModeUI.this).get(ESEvaluObjectOrgUnitUI.class.getName())) != null) {
                    evaluObjectOrgUnitUI.setUIStatusByDeliverMode(ESTargetEvaluModeUI.this.deliverMode);
                    evaluObjectOrgUnitUI.loadDeliverers();
                }
            }
            catch (Exception e) {
                ESTargetEvaluModeUI.this.handUIException(e);
            }
        }
    }
}

