/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.perf.EvalPersonFactory;
import com.kingdee.eas.hr.perf.EvalRelationDetailFactory;
import com.kingdee.eas.hr.perf.EvalRelationDetailInfo;
import com.kingdee.eas.hr.perf.EvaluInfo;
import com.kingdee.eas.hr.perf.EvaluRelationDetailQuestCollection;
import com.kingdee.eas.hr.perf.EvaluRelationDetailQuestFactory;
import com.kingdee.eas.hr.perf.PaperQuestionsCollection;
import com.kingdee.eas.hr.perf.PaperQuestionsFactory;
import com.kingdee.eas.hr.perf.PaperQuestionsInfo;
import com.kingdee.eas.hr.perf.TestPaperFactory;
import com.kingdee.eas.hr.perf.TestPaperInfo;
import com.kingdee.eas.hr.perf.client.AbstractEvalPersonUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class EvalPersonUI
extends AbstractEvalPersonUI {
    private static final long serialVersionUID = 1L;
    private static final String resourcePath = "com.kingdee.eas.hr.perf.MDSolutionResource";
    private static final String testPagerScore = EASResource.getString((String)"com.kingdee.eas.hr.perf.MDSolutionResource", (String)"TESTPAGERSCORE");
    private HashSet set = new HashSet();
    private EvaluInfo infoGol = null;
    private BigDecimal minGradeScore = null;
    private BigDecimal maxGradeScore = null;
    private Set testQuestPagetID;
    private Map evalPersonandQuestID;
    private int fzColumn;
    private int questColumn;
    private String evalRelutionId;
    private int tableColumn;

    public EvalPersonUI() throws Exception {
        this.paperName.setText(null);
        this.PaperNumber.setText(null);
        this.btnFirst.setEnabled(true);
        this.btnPre.setEnabled(true);
        this.btnNext.setEnabled(true);
        this.btnLast.setEnabled(true);
        this.setButtonDefaultStyl(this.btnFirst);
        this.setButtonDefaultStyl(this.btnNext);
        this.setButtonDefaultStyl(this.btnPre);
        this.setButtonDefaultStyl(this.btnLast);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EvalPersonFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (this.getUIContext().get("EvalRelationDetail.id") != null) {
            FilterItemInfo filterItem = new FilterItemInfo("evalReDetail.id", (Object)this.getUIContext().get("EvalRelationDetail.id").toString());
            filter.getFilterItems().add(filterItem);
        }
        return filter;
    }

    public void onNewLoad() throws Exception {
        this.paperName.setText(null);
        this.PaperNumber.setText(null);
        this.PaperRank.setText(null);
        this.minGrade.setText("0.00");
        this.maxGrade.setText(null);
    }

    public void onLoad() throws Exception {
        Object obj;
        this.PaperRank.setText(null);
        this.maxGrade.setText(null);
        if (this.getUIContext().get("TestPaper.name") != null) {
            this.paperName.setText(this.getUIContext().get("TestPaper.name").toString());
            this.paperName.setToolTipText(this.getUIContext().get("TestPaper.name").toString());
        }
        if (this.getUIContext().get("TestPaper.number") != null) {
            this.PaperNumber.setText(this.getUIContext().get("TestPaper.number").toString());
        }
        if (this.getUIContext().get("GradeMode.name") != null) {
            this.PaperRank.setText(this.getUIContext().get("GradeMode.name").toString());
        }
        if ((obj = this.getUIContext().get("GradeMode.minGrade")) != null) {
            this.minGradeScore = new BigDecimal(obj.toString());
            this.minGrade.setText(PFVerifyUtils.formatBigDecimal(this.minGradeScore, 2));
        }
        if ((obj = this.getUIContext().get("GradeMode.maxGrade")) != null) {
            this.maxGradeScore = new BigDecimal(obj.toString());
            this.maxGrade.setText(PFVerifyUtils.formatBigDecimal(this.maxGradeScore, 2));
        }
        super.onLoad();
        this.paperName.setEnabled(false);
        this.PaperNumber.setEnabled(false);
        this.PaperRank.setEnabled(false);
        this.maxGrade.setEnabled(false);
        this.minGrade.setEnabled(false);
        this.addCol(this.getUIContext().get("TestPaper.id").toString());
        this.infoGol = (EvaluInfo)this.getUIContext().get("info");
        this.tblMain.getDataRequestManager().setPageRowCount(10000);
        this.setButtonState();
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        this.tblMain_doRequestRowSetForNoQueryPK(e);
    }

    public void onShow() throws Exception {
        super.onShow();
        String testMin = null;
        String testMax = null;
        if (this.getUIContext().get("testGradeModeMin") != null) {
            testMin = this.getUIContext().get("testGradeModeMin").toString();
        }
        if (this.getUIContext().get("testGradeModeMax") != null) {
            testMax = this.getUIContext().get("testGradeModeMax").toString();
        }
        this.fillTestPaperData(this.getUIContext().get("TestPaper.id").toString(), this.getUIContext().get("GradeMode.id").toString(), testMin, testMax);
    }

    private void addCol(String paperId) throws BOSException {
        int i;
        int collSize;
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("serial"));
        sic.add(new SelectorItemInfo("testPaper.id"));
        sic.add(new SelectorItemInfo("testQuestion.id"));
        sic.add(new SelectorItemInfo("testQuestion.content"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("testPaper.id", (Object)paperId, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("id"));
        sorter.add(new SorterItemInfo("serial"));
        sorter.add(new SorterItemInfo("testPaper.id"));
        sorter.add(new SorterItemInfo("testQuestion.id"));
        sorter.add(new SorterItemInfo("testQuestion.content"));
        PaperQuestionsCollection coll = PaperQuestionsFactory.getRemoteInstance().getPaperQuestionsCollection(viewInfo);
        if (coll == null || coll.size() <= 0) {
            return;
        }
        this.fzColumn = collSize = coll.size();
        TreeMap<Integer, PaperQuestionsInfo> map = new TreeMap<Integer, PaperQuestionsInfo>();
        for (i = 0; i < collSize; ++i) {
            map.put(new Integer(coll.get(i).getSerial()), coll.get(i));
        }
        coll.clear();
        for (i = 1; i <= collSize; ++i) {
            coll.add((PaperQuestionsInfo)map.get(new Integer(i)));
        }
        if (coll == null) {
            return;
        }
        IRow row0 = this.tblMain.getHeadRow(0);
        IRow row1 = this.tblMain.getHeadRow(1);
        IColumn column = null;
        if (coll != null && coll.size() > 0) {
            int n = coll.size();
            for (int i2 = 0; i2 < n; ++i2) {
                column = this.tblMain.addColumn();
                column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                column.getStyleAttributes().setNumberFormat("0.00");
                this.tblMain.getColumn(9 + i2).setWidth(80);
                ICell cell = row0.getCell(9 + i2);
                cell.setValue((Object)testPagerScore);
                ICell cell2 = row1.getCell(9 + i2);
                cell2.setValue((Object)coll.get(i2).getTestQuestion().getContent());
            }
        }
    }

    private void addQuestCol(String paperId) throws BOSException {
        int columnSize;
        int i;
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("serial"));
        sic.add(new SelectorItemInfo("testPaper.id"));
        sic.add(new SelectorItemInfo("testQuestion.id"));
        sic.add(new SelectorItemInfo("testQuestion.content"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("testPaper.id", (Object)paperId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("testPaper.id", (Object)paperId, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("id"));
        sorter.add(new SorterItemInfo("serial"));
        sorter.add(new SorterItemInfo("testPaper.id"));
        sorter.add(new SorterItemInfo("testQuestion.id"));
        sorter.add(new SorterItemInfo("testQuestion.content"));
        PaperQuestionsCollection coll = PaperQuestionsFactory.getRemoteInstance().getPaperQuestionsCollection(viewInfo);
        if (coll == null || coll.size() <= 0) {
            return;
        }
        int collSize = coll.size();
        this.questColumn = collSize + this.questColumn;
        TreeMap<Integer, PaperQuestionsInfo> map = new TreeMap<Integer, PaperQuestionsInfo>();
        for (i = 0; i < collSize; ++i) {
            map.put(new Integer(coll.get(i).getSerial()), coll.get(i));
        }
        coll.clear();
        for (i = 1; i <= collSize; ++i) {
            coll.add((PaperQuestionsInfo)map.get(new Integer(i)));
        }
        if (coll == null) {
            return;
        }
        IRow row0 = this.tblMain.getHeadRow(0);
        IRow row1 = this.tblMain.getHeadRow(1);
        IColumn column = null;
        this.tableColumn = columnSize = this.tblMain.getColumnCount();
        if (coll != null && coll.size() > 0) {
            int n = coll.size();
            for (int i2 = 0; i2 < n; ++i2) {
                column = this.tblMain.addColumn();
                column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                column.getStyleAttributes().setNumberFormat("0.00");
                this.tblMain.getColumn(columnSize + i2).setWidth(80);
                ICell cell = row0.getCell(columnSize + i2);
                cell.setValue((Object)EASResource.getString((String)resourcePath, (String)"testQuestPagerscore"));
                ICell cell2 = row1.getCell(columnSize + i2);
                cell2.setValue((Object)coll.get(i2).getTestQuestion().getContent());
            }
        }
    }

    private int getTestQuestSize(String paperId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("serial"));
        sic.add(new SelectorItemInfo("testPaper.id"));
        sic.add(new SelectorItemInfo("testQuestion.id"));
        sic.add(new SelectorItemInfo("testQuestion.content"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("testPaper.id", (Object)paperId, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("id"));
        sorter.add(new SorterItemInfo("serial"));
        sorter.add(new SorterItemInfo("testPaper.id"));
        sorter.add(new SorterItemInfo("testQuestion.id"));
        sorter.add(new SorterItemInfo("testQuestion.content"));
        PaperQuestionsCollection coll = PaperQuestionsFactory.getRemoteInstance().getPaperQuestionsCollection(viewInfo);
        if (coll == null || coll.size() <= 0) {
            return 0;
        }
        return coll.size();
    }

    private BigDecimal getScore(IRowSet rowSet, boolean isRank) throws Exception {
        if (isRank) {
            return rowSet.getBigDecimal("rank.grade");
        }
        return rowSet.getBigDecimal("paperQueDetail.score");
    }

    private void fillTestPaperData(String testPaperID, String gradeModeId, String fromMin, String fromMax) throws Exception {
        boolean isRank = false;
        if (this.getUIContext().get("isScore") != null) {
            isRank = (Boolean)this.getUIContext().get("isScore") == false;
        }
        String solutionperiod = this.getUIContext().get("solutionperiod").toString();
        String mdObjectid = this.getUIContext().get("mdObjectid").toString();
        String evaluRelationID = this.getUIContext().get("evaluRelationID").toString();
        if (this.evalRelutionId != null) {
            evaluRelationID = this.evalRelutionId;
        }
        EntityViewInfo viInfo = new EntityViewInfo();
        FilterInfo fiInfo = new FilterInfo();
        SelectorItemCollection sicQuest = new SelectorItemCollection();
        sicQuest.add(new SelectorItemInfo("paperQuest"));
        sicQuest.add(new SelectorItemInfo("evalPerson"));
        SorterItemCollection sort = new SorterItemCollection("order by paperQuest");
        viInfo.setSorter(sort);
        viInfo.setSelector(sicQuest);
        fiInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod", (Object)solutionperiod, CompareType.INCLUDE));
        fiInfo.getFilterItems().add(new FilterItemInfo("evaluRelation", (Object)evaluRelationID, CompareType.INCLUDE));
        fiInfo.getFilterItems().add(new FilterItemInfo("multiDimentionObject", (Object)mdObjectid, CompareType.INCLUDE));
        viInfo.setFilter(fiInfo);
        EvaluRelationDetailQuestCollection questColl = EvaluRelationDetailQuestFactory.getRemoteInstance().getEvaluRelationDetailQuestCollection(viInfo);
        this.testQuestPagetID = new HashSet();
        this.evalPersonandQuestID = new HashMap();
        int size = questColl.size();
        for (int i = 0; i < size; ++i) {
            this.testQuestPagetID.add(questColl.get(i).getPaperQuest().getId().toString());
            this.evalPersonandQuestID.put("questID" + i, questColl.get(i).getPaperQuest().getId().toString() + ":" + questColl.get(i).getEvalPerson().getId().toString());
        }
        if (this.testQuestPagetID.size() > 0) {
            Iterator it = this.testQuestPagetID.iterator();
            while (it.hasNext()) {
                this.addQuestCol(it.next().toString());
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        BigDecimal avg = null;
        if (testPaperID != null) {
            int j;
            IRow row;
            HashSet<String> evalPersonSet = new HashSet<String>();
            int n = this.tblMain.getRowCount();
            for (int i = 0; i < n; ++i) {
                evalPersonSet.add(this.tblMain.getRow(i).getCell("id").getValue().toString());
            }
            Set<String> testQuestID = new HashSet<String>();
            if (this.testQuestPagetID != null && this.testQuestPagetID.size() > 0) {
                testQuestID = this.testQuestPagetID;
                testQuestID.add(testPaperID);
            } else {
                testQuestID.add(testPaperID);
            }
            filter.getFilterItems().add(new FilterItemInfo("testPaper.id", testQuestID, CompareType.INCLUDE));
            if (evalPersonSet.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("evalPerson.id", evalPersonSet, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("evalPerson.id", (Object)"%noeas%"));
            }
            viewInfo.setFilter(filter);
            SorterItemCollection sorter = viewInfo.getSorter();
            SorterItemInfo item = new SorterItemInfo("paperQue.serial");
            sorter.add(item);
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "TestPaperFormScoreQuery");
            IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)queryPK, viewInfo);
            IRowSet rowSet = exec.executeQuery();
            BigDecimal score = null;
            int tableSumColun = this.tblMain.getColumnCount();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                row = this.tblMain.getRow(i);
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    if (!row.getCell("id").getValue().toString().equals(rowSet.getString("evalPerson.id"))) continue;
                    for (j = 9; j < this.tblMain.getColumnCount(); ++j) {
                        String evalValue;
                        String testQuestValue;
                        String value;
                        Object key;
                        int column;
                        boolean isSetValue;
                        ICell cell = row.getCell(j);
                        if (Integer.parseInt(rowSet.getString("paperQue.serial")) != j - 8) continue;
                        if (rowSet.getString("GradeMode.id").equals(gradeModeId)) {
                            if (this.getScore(rowSet, isRank) != null) {
                                isSetValue = false;
                                column = 0;
                                for (Map.Entry entry : this.evalPersonandQuestID.entrySet()) {
                                    key = entry.getKey();
                                    value = entry.getValue().toString();
                                    testQuestValue = value.substring(0, value.indexOf(":"));
                                    evalValue = value.substring(value.indexOf(":") + 1, value.length());
                                    if (!evalValue.equals(rowSet.getString("evalPerson.id").toString()) || !testQuestValue.equals(rowSet.getString("TESTPAPER.ID").toString())) continue;
                                    isSetValue = true;
                                    column = this.getTestQuestSize(testPaperID);
                                }
                                if (isSetValue) {
                                    cell = row.getCell(j + column);
                                    cell.setValue((Object)this.getScore(rowSet, isRank));
                                } else {
                                    cell.setValue((Object)this.getScore(rowSet, isRank));
                                }
                            } else {
                                cell.setValue(null);
                            }
                        } else {
                            score = rowSet.getString("GradeMode.minGrade") != null ? this.changeGrade(rowSet.getBigDecimal("GradeMode.minGrade"), rowSet.getBigDecimal("GradeMode.maxGrade"), new BigDecimal(this.minGrade.getText()), new BigDecimal(this.maxGrade.getText()), this.getScore(rowSet, isRank)) : this.changeGrade(new BigDecimal("0"), rowSet.getBigDecimal("GradeMode.maxGrade"), new BigDecimal(this.minGrade.getText()), new BigDecimal(this.maxGrade.getText()), this.getScore(rowSet, isRank));
                            if (score != null) {
                                isSetValue = false;
                                column = 0;
                                for (Map.Entry entry : this.evalPersonandQuestID.entrySet()) {
                                    key = entry.getKey();
                                    value = entry.getValue().toString();
                                    testQuestValue = value.substring(0, value.indexOf(":"));
                                    evalValue = value.substring(value.indexOf(":") + 1, value.length());
                                    if (!evalValue.equals(rowSet.getString("evalPerson.id").toString()) || !testQuestValue.equals(rowSet.getString("TESTPAPER.ID").toString())) continue;
                                    isSetValue = true;
                                    column = this.getTestQuestSize(testPaperID);
                                }
                                if (isSetValue) {
                                    cell = row.getCell(j + column);
                                    cell.setValue((Object)score);
                                } else {
                                    cell.setValue((Object)score);
                                }
                            }
                        }
                        score = null;
                    }
                }
                score = null;
                rowSet.beforeFirst();
            }
            if (fromMin == null) {
                fromMin = "0.00";
            }
            if (fromMax == null) {
                fromMax = "0.00";
            }
            KDTMergeManager mm2 = this.tblMain.getMergeManager();
            row = this.tblMain.addRow();
            row.getCell("person.number").setValue((Object)EASResource.getString((String)resourcePath, (String)"avgScore"));
            for (j = 8; j < this.tblMain.getColumnCount(); ++j) {
                avg = this.colData(j);
                if (avg != null) {
                    row.getCell(j).setValue((Object)avg.toString());
                }
                row.getStyleAttributes().setBackground(new Color(252, 255, 206));
            }
            KDTMergeManager mm = this.tblMain.getHeadMergeManager();
            int startCol = 9 + this.fzColumn;
            mm.mergeBlock(0, 9, 0, startCol - 1, 4);
            mm.mergeBlock(0, startCol, 0, this.tblMain.getColumnCount() - 1, 4);
            mm2.mergeBlock(this.tblMain.getRowCount(), 0, this.tblMain.getRowCount(), 5);
        }
    }

    private void setQuestValue(IRowSet rowSet, IRow row, ICell cell, int j, String testPaperID) throws BOSException, SQLException {
        boolean isSetValue = false;
        int column = 0;
        for (Map.Entry entry : this.evalPersonandQuestID.entrySet()) {
            Object key = entry.getKey();
            String value = entry.getValue().toString();
            String testQuestValue = value.substring(0, value.indexOf(":"));
            String evalValue = value.substring(value.indexOf(":") + 1, value.length());
            if (!evalValue.equals(rowSet.getString("evalPerson.id").toString()) || !testQuestValue.equals(rowSet.getString("TESTPAPER.ID").toString())) continue;
            isSetValue = true;
            column = this.getTestQuestSize(testPaperID);
        }
        if (isSetValue) {
            // empty if block
        }
    }

    protected String getKeyFieldName() {
        return "id";
    }

    private BigDecimal changeGrade(BigDecimal fromMin, BigDecimal fromMax, BigDecimal toMin, BigDecimal toMax, BigDecimal score) {
        if (score == null) {
            return null;
        }
        BigDecimal zero = new BigDecimal("0.000000");
        BigDecimal changeScore = null;
        BigDecimal score1 = zero.add(score).subtract(fromMin);
        BigDecimal score3 = toMax.subtract(toMin);
        BigDecimal score2 = score1.multiply(score3).add(toMin);
        changeScore = score2.divide(fromMax.subtract(fromMin), 2, 4);
        return changeScore;
    }

    private BigDecimal colData(int col) {
        if (this.tblMain.getRowCount() == 0) {
            return null;
        }
        BigDecimal avg = new BigDecimal("0.00");
        BigDecimal avg1 = null;
        for (int colNum = 0; colNum < this.tblMain.getRowCount(); ++colNum) {
            IRow row = this.tblMain.getRow(colNum);
            ICell cell = row.getCell(col);
            if (cell.getValue() == null) {
                return null;
            }
            avg1 = new BigDecimal(cell.getValue().toString());
            avg = avg.add(avg1);
        }
        avg = avg.divide(new BigDecimal(String.valueOf(this.tblMain.getRowCount())), 2, 4);
        return avg;
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            BigDecimal solutionScore = null;
            BigDecimal score = null;
            BigDecimal paperMinScore = null;
            BigDecimal paperMaxScore = null;
            String nameTestPaper = this.getUIContext().get("TestPaper.name").toString();
            String numberTestPaper = this.getUIContext().get("TestPaper.number").toString();
            rowSet.beforeFirst();
            while (rowSet.next()) {
                this.set.add(rowSet.getString("id"));
                score = rowSet.getBigDecimal("TestPageForm.score");
                String name = rowSet.getString("TestPaper.name");
                String number = rowSet.getString("TestPaper.number");
                rowSet.updateString("TestPaper.number", numberTestPaper);
                rowSet.updateString("TestPaper.name", nameTestPaper);
                paperMinScore = rowSet.getBigDecimal("GradeMode.minGrade");
                paperMaxScore = rowSet.getBigDecimal("GradeMode.maxGrade");
                if (number != null) {
                    rowSet.updateString("TestPaper.number", number);
                }
                if (name != null) {
                    rowSet.updateString("TestPaper.name", name);
                }
                if (paperMinScore == null && paperMaxScore == null || score == null) continue;
                solutionScore = this.changeGrade(paperMinScore, paperMaxScore, this.minGradeScore, this.maxGradeScore, score);
                rowSet.updateBigDecimal("TestPageForm.score", solutionScore);
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        super.onGetRowSet(rowSet);
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        Vector list = new Vector();
        this.infoGol = new EvaluInfo();
        TestPaperInfo testPaperInfo = null;
        HashMap hash = (HashMap)this.getUIContext().get("infoList");
        list = (Vector)hash.get("selectPersonId");
        EvaluInfo info = new EvaluInfo();
        info = (EvaluInfo)list.get(0);
        this.infoGol.setId(info.getId());
        this.infoGol.setEvalRelationDetailId(info.getEvalRelationDetailId());
        this.infoGol.setGradeModeId(info.getGradeModeId());
        this.infoGol.setGradeModeMax(info.getGradeModeMax());
        if (info.getGradeModeMin() == null) {
            this.infoGol.setGradeModeMin("0.00");
        } else {
            this.infoGol.setGradeModeMin(info.getGradeModeMin());
        }
        this.infoGol.setGradeModeName(info.getGradeModeName());
        this.infoGol.setTestPaperID(info.getTestPaperID());
        this.infoGol.setTestPaperName(info.getTestPaperName());
        this.infoGol.setTestPaperNumber(info.getTestPaperNumber());
        info = (EvaluInfo)list.get(0);
        this.onNewLoad();
        this.paperName.setText(info.getTestPaperName());
        this.PaperNumber.setText(info.getTestPaperNumber());
        this.PaperRank.setText(info.getGradeModeName());
        this.maxGrade.setText(info.getGradeModeMax());
        if (info.getGradeModeMin() != null) {
            this.minGrade.setText(info.getGradeModeMin());
        } else {
            this.minGrade.setText("0.00");
        }
        this.tblMain.removeRows();
        for (int k = this.tblMain.getColumnCount(); k > 8; --k) {
            this.tblMain.removeColumn(k);
        }
        String testPaperID = info.getTestPaperID();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("gradeMode.id"));
        sic.add(new SelectorItemInfo("gradeMode.minGrade"));
        sic.add(new SelectorItemInfo("gradeMode.maxGrade"));
        if (testPaperID != null) {
            testPaperInfo = TestPaperFactory.getRemoteInstance().getTestPaperInfo((IObjectPK)new ObjectUuidPK(testPaperID), sic);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalReDetail.id", (Object)info.getEvalRelationDetailId(), CompareType.EQUALS));
        evi.setFilter(filter);
        this.setDataObject((IObjectValue)evi);
        this.execQuery();
        this.addCol(info.getTestPaperID());
        this.getEvalRelationId(info.getEvalRelationDetailId());
        if (testPaperInfo.getGradeMode().getMinGrade() != null) {
            this.fillTestPaperData(info.getTestPaperID(), info.getGradeModeId(), testPaperInfo.getGradeMode().getMinGrade().toString(), testPaperInfo.getGradeMode().getMaxGrade().toString());
        } else {
            this.fillTestPaperData(info.getTestPaperID(), info.getGradeModeId(), "0.00", testPaperInfo.getGradeMode().getMaxGrade().toString());
        }
        info = null;
        this.setButtonState();
    }

    private void getEvalRelationId(String evalDetailID) throws Exception {
        SelectorItemCollection questSic = new SelectorItemCollection();
        questSic.add(new SelectorItemInfo("id"));
        questSic.add(new SelectorItemInfo("evalRelation.id"));
        EvalRelationDetailInfo evaluDetail = EvalRelationDetailFactory.getRemoteInstance().getEvalRelationDetailInfo((IObjectPK)new ObjectUuidPK(evalDetailID), questSic);
        this.evalRelutionId = evaluDetail.getEvalRelation().getId().toString();
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        Vector list = new Vector();
        this.infoGol = new EvaluInfo();
        HashMap hash = (HashMap)this.getUIContext().get("infoList");
        list = (Vector)hash.get("selectPersonId");
        EvaluInfo info = new EvaluInfo();
        info = (EvaluInfo)list.get(list.size() - 1);
        this.infoGol.setId(info.getId());
        this.infoGol.setEvalRelationDetailId(info.getEvalRelationDetailId());
        this.infoGol.setGradeModeId(info.getGradeModeId());
        this.infoGol.setGradeModeMax(info.getGradeModeMax());
        TestPaperInfo testPaperInfo = null;
        if (info.getGradeModeMin() == null) {
            this.infoGol.setGradeModeMin("0.00");
        } else {
            this.infoGol.setGradeModeMin(info.getGradeModeMin());
        }
        this.infoGol.setGradeModeName(info.getGradeModeName());
        this.infoGol.setTestPaperID(info.getTestPaperID());
        this.infoGol.setTestPaperName(info.getTestPaperName());
        this.infoGol.setTestPaperNumber(info.getTestPaperNumber());
        this.onNewLoad();
        this.paperName.setText(info.getTestPaperName());
        this.PaperNumber.setText(info.getTestPaperNumber());
        this.PaperRank.setText(info.getGradeModeName());
        this.maxGrade.setText(info.getGradeModeMax());
        if (info.getGradeModeMin() != null) {
            this.minGrade.setText(info.getGradeModeMin());
        } else {
            this.minGrade.setText("0.00");
        }
        this.tblMain.removeRows();
        for (int k = this.tblMain.getColumnCount(); k > 8; --k) {
            this.tblMain.removeColumn(k);
        }
        String testPaperID = info.getTestPaperID();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("gradeMode.id"));
        sic.add(new SelectorItemInfo("gradeMode.minGrade"));
        sic.add(new SelectorItemInfo("gradeMode.maxGrade"));
        if (testPaperID != null) {
            testPaperInfo = TestPaperFactory.getRemoteInstance().getTestPaperInfo((IObjectPK)new ObjectUuidPK(testPaperID), sic);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalReDetail.id", (Object)info.getEvalRelationDetailId(), CompareType.EQUALS));
        evi.setFilter(filter);
        this.setDataObject((IObjectValue)evi);
        this.execQuery();
        this.addCol(info.getTestPaperID());
        this.getEvalRelationId(info.getEvalRelationDetailId());
        if (testPaperInfo.getGradeMode().getMinGrade() != null) {
            this.fillTestPaperData(info.getTestPaperID(), info.getGradeModeId(), testPaperInfo.getGradeMode().getMinGrade().toString(), testPaperInfo.getGradeMode().getMaxGrade().toString());
        } else {
            this.fillTestPaperData(info.getTestPaperID(), info.getGradeModeId(), "0.00", testPaperInfo.getGradeMode().getMaxGrade().toString());
        }
        info = null;
        this.setButtonState();
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        Vector list = new Vector();
        HashMap hash = (HashMap)this.getUIContext().get("infoList");
        list = (Vector)hash.get("selectPersonId");
        EvaluInfo infoLast = new EvaluInfo();
        EvaluInfo infoNext = new EvaluInfo();
        EvaluInfo infoNow = new EvaluInfo();
        TestPaperInfo testPaperInfo = null;
        int countList = list.size();
        int listNumber = 0;
        infoLast = (EvaluInfo)list.get(countList - 1);
        String eidLast = infoLast.getEvalRelationDetailId();
        String idLast = infoLast.getId();
        for (int j = 0; j < countList; ++j) {
            infoNow = (EvaluInfo)list.get(j);
            this.infoGol.getId();
            this.infoGol.getEvalRelationDetailId();
            if (!infoNow.getId().equals(this.infoGol.getId()) || !infoNow.getEvalRelationDetailId().equals(this.infoGol.getEvalRelationDetailId())) continue;
            infoNow = (EvaluInfo)list.get(j);
            listNumber = j;
            break;
        }
        infoNow.getId();
        infoNow.getEvalRelationDetailId();
        if (infoNow.getId() != idLast && infoNow.getEvalRelationDetailId() != eidLast) {
            infoNext = (EvaluInfo)list.get(listNumber + 1);
            infoNext.getId();
            infoNext.getEvalRelationDetailId();
            this.infoGol.setId(infoNext.getId());
            this.infoGol.setEvalRelationDetailId(infoNext.getEvalRelationDetailId());
            this.infoGol.setGradeModeId(infoNext.getGradeModeId());
            this.infoGol.setGradeModeMax(infoNext.getGradeModeMax());
            this.infoGol.setGradeModeMin(infoNext.getGradeModeMin());
            this.infoGol.setGradeModeName(infoNext.getGradeModeName());
            this.infoGol.setTestPaperID(infoNext.getTestPaperID());
            this.infoGol.setTestPaperName(infoNext.getTestPaperName());
            this.infoGol.setTestPaperNumber(infoNext.getTestPaperNumber());
            this.onNewLoad();
            this.paperName.setText(infoNext.getTestPaperName());
            this.PaperNumber.setText(infoNext.getTestPaperNumber());
            String testPaperID = infoNext.getTestPaperID();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("gradeMode.id"));
            sic.add(new SelectorItemInfo("gradeMode.minGrade"));
            sic.add(new SelectorItemInfo("gradeMode.maxGrade"));
            if (testPaperID != null) {
                testPaperInfo = TestPaperFactory.getRemoteInstance().getTestPaperInfo((IObjectPK)new ObjectUuidPK(testPaperID), sic);
            }
            this.PaperRank.setText(infoNext.getGradeModeName());
            this.maxGrade.setText(infoNext.getGradeModeMax());
            if (infoNext.getGradeModeMin() != null) {
                this.minGrade.setText(infoNext.getGradeModeMin());
            } else {
                this.minGrade.setText("0.00");
            }
            this.tblMain.removeRows();
            this.tblMain.getDataRequestManager().setPageRowCount(10000);
            for (int k = this.tblMain.getColumnCount(); k > 8; --k) {
                this.tblMain.removeColumn(k);
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evalReDetail.id", (Object)infoNext.getEvalRelationDetailId(), CompareType.EQUALS));
            evi.setFilter(filter);
            this.setDataObject((IObjectValue)evi);
            this.execQuery();
            this.addCol(infoNext.getTestPaperID());
            this.getEvalRelationId(infoNext.getEvalRelationDetailId());
            if (testPaperInfo.getGradeMode().getMinGrade() != null) {
                this.fillTestPaperData(infoNext.getTestPaperID(), infoNext.getGradeModeId(), testPaperInfo.getGradeMode().getMinGrade().toString(), testPaperInfo.getGradeMode().getMaxGrade().toString());
            } else {
                this.fillTestPaperData(infoNext.getTestPaperID(), infoNext.getGradeModeId(), "0.00", testPaperInfo.getGradeMode().getMaxGrade().toString());
            }
        } else {
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.btnFirst.setEnabled(true);
            this.btnPre.setEnabled(true);
            return;
        }
        this.btnLast.setEnabled(true);
        this.btnNext.setEnabled(true);
        this.btnFirst.setEnabled(true);
        this.btnPre.setEnabled(true);
        infoLast = null;
        infoNext = null;
        infoNow = null;
        eidLast = null;
        idLast = null;
        this.setButtonState();
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        Vector list = new Vector();
        HashMap hash = (HashMap)this.getUIContext().get("infoList");
        list = (Vector)hash.get("selectPersonId");
        EvaluInfo infoFirst = new EvaluInfo();
        EvaluInfo infoPre = new EvaluInfo();
        EvaluInfo infoNow = new EvaluInfo();
        TestPaperInfo testPaperInfo = null;
        int countList = list.size();
        int listNumber = 0;
        infoFirst = (EvaluInfo)list.get(0);
        String eidFirst = infoFirst.getEvalRelationDetailId();
        String idFirst = infoFirst.getId();
        for (int j = 0; j < countList; ++j) {
            infoNow = (EvaluInfo)list.get(j);
            this.infoGol.getEvalRelationDetailId();
            this.infoGol.getId();
            if (!infoNow.getId().equals(this.infoGol.getId()) || !infoNow.getEvalRelationDetailId().equals(this.infoGol.getEvalRelationDetailId())) continue;
            infoNow = (EvaluInfo)list.get(j);
            listNumber = j;
            break;
        }
        infoNow.getId();
        infoNow.getEvalRelationDetailId();
        if (infoNow.getId() != idFirst && infoNow.getEvalRelationDetailId() != eidFirst) {
            infoPre = (EvaluInfo)list.get(listNumber - 1);
            infoPre.getId();
            infoPre.getEvalRelationDetailId();
            this.infoGol.setId(infoPre.getId());
            this.infoGol.setEvalRelationDetailId(infoPre.getEvalRelationDetailId());
            this.infoGol.setGradeModeId(infoPre.getGradeModeId());
            this.infoGol.setGradeModeMax(infoPre.getGradeModeMax());
            this.infoGol.setGradeModeMin(infoPre.getGradeModeMin());
            this.infoGol.setGradeModeName(infoPre.getGradeModeName());
            this.infoGol.setTestPaperID(infoPre.getTestPaperID());
            this.infoGol.setTestPaperName(infoPre.getTestPaperName());
            this.infoGol.setTestPaperNumber(infoPre.getTestPaperNumber());
            this.onNewLoad();
            this.paperName.setText(infoPre.getTestPaperName());
            this.PaperNumber.setText(infoPre.getTestPaperNumber());
            this.PaperRank.setText(infoPre.getGradeModeName());
            this.maxGrade.setText(infoPre.getGradeModeMax());
            if (infoPre.getGradeModeMin() != null) {
                this.minGrade.setText(infoPre.getGradeModeMin());
            } else {
                this.minGrade.setText("0.00");
            }
            this.tblMain.removeRows();
            for (int k = this.tblMain.getColumnCount(); k > 8; --k) {
                this.tblMain.removeColumn(k);
            }
            String testPaperID = infoPre.getTestPaperID();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("gradeMode.id"));
            sic.add(new SelectorItemInfo("gradeMode.minGrade"));
            sic.add(new SelectorItemInfo("gradeMode.maxGrade"));
            if (testPaperID != null) {
                testPaperInfo = TestPaperFactory.getRemoteInstance().getTestPaperInfo((IObjectPK)new ObjectUuidPK(testPaperID), sic);
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evalReDetail.id", (Object)infoPre.getEvalRelationDetailId(), CompareType.EQUALS));
            evi.setFilter(filter);
            this.setDataObject((IObjectValue)evi);
            this.execQuery();
            this.addCol(infoPre.getTestPaperID());
            this.getEvalRelationId(infoPre.getEvalRelationDetailId());
            if (testPaperInfo.getGradeMode().getMinGrade() != null) {
                this.fillTestPaperData(infoPre.getTestPaperID(), infoPre.getGradeModeId(), testPaperInfo.getGradeMode().getMinGrade().toString(), testPaperInfo.getGradeMode().getMaxGrade().toString());
            } else {
                this.fillTestPaperData(infoPre.getTestPaperID(), infoPre.getGradeModeId(), "0.00", testPaperInfo.getGradeMode().getMaxGrade().toString());
            }
        } else {
            this.btnNext.setEnabled(true);
            this.btnLast.setEnabled(true);
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            return;
        }
        this.btnNext.setEnabled(true);
        this.btnLast.setEnabled(true);
        this.btnFirst.setEnabled(true);
        this.btnPre.setEnabled(true);
        infoFirst = null;
        infoPre = null;
        infoNow = null;
        eidFirst = null;
        idFirst = null;
        this.setButtonState();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor iqec = super.getQueryExecutor(queryPK, viewInfo);
        iqec.option().isAutoIgnoreZero = false;
        return iqec;
    }

    private void setButtonState() {
        this.btnFirst.setEnabled(false);
        this.btnPre.setEnabled(false);
        this.btnLast.setEnabled(false);
        this.btnNext.setEnabled(false);
        HashMap hash = (HashMap)this.getUIContext().get("infoList");
        Vector list = (Vector)hash.get("selectPersonId");
        if (list != null && list.size() > 0) {
            int currentIndex = this.getCurrentIndex(list);
            if (currentIndex == -1) {
                return;
            }
            if (currentIndex > 0) {
                this.btnFirst.setEnabled(true);
                this.btnPre.setEnabled(true);
            }
            if (currentIndex < list.size() - 1) {
                this.btnLast.setEnabled(true);
                this.btnNext.setEnabled(true);
            }
        }
    }

    private int getCurrentIndex(Vector list) {
        EvaluInfo infoNow = null;
        int curIndex = -1;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            infoNow = (EvaluInfo)list.get(i);
            if (!infoNow.getId().equals(this.infoGol.getId()) || !infoNow.getEvalRelationDetailId().equals(this.infoGol.getEvalRelationDetailId())) continue;
            curIndex = i;
            break;
        }
        return curIndex;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        RequestContext req = new RequestContext();
        req.put("TestPaper.id", this.getUIContext().get("TestPaper.id"));
        String testMin = null;
        String testMax = null;
        String gradeModeID = null;
        if (this.getUIContext().get("testGradeModeMin") != null) {
            testMin = this.getUIContext().get("testGradeModeMin").toString();
        }
        if (this.getUIContext().get("testGradeModeMax") != null) {
            testMax = this.getUIContext().get("testGradeModeMax").toString();
        }
        if (this.getUIContext().get("GradeMode.id") != null) {
            gradeModeID = this.getUIContext().get("GradeMode.id").toString();
        }
        Boolean isScore = (Boolean)this.getUIContext().get("isScore");
        req.put("testMin", (Object)testMin);
        req.put("testMax", (Object)testMax);
        req.put("gradeModeID", (Object)gradeModeID);
        req.put("isScore", (Object)isScore);
        req.put("relationDetailId", this.getUIContext().get("EvalRelationDetail.id"));
        postman.setRequestContext((Serializable)req);
        return postman;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public IUIActionPostman prepareQuery(RequestRowSetEvent e) {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("relationDetailId", this.getUIContext().get("EvalRelationDetail.id"));
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

