/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.IMailPerson;
import com.kingdee.eas.hr.perf.MailPersonFactory;
import com.kingdee.eas.hr.perf.MailPersonInfo;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.PlanFreqTypeException;
import com.kingdee.eas.hr.perf.client.AbstractEvalSendMailListUI;
import com.kingdee.eas.hr.perf.client.KDTableUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;

public class EvalSendMailListUI
extends AbstractEvalSendMailListUI {
    private static final long serialVersionUID = 1233234345320242L;
    private String resClass = "com.kingdee.eas.hr.perf.client.PlanFreqTypeResource.";
    private PersonInfo curPerson = null;
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private String solutionPeriodID = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddSendAddress.setIcon(EASResource.getIcon((String)"imgTbtn_recieversetting"));
        this.btnDelSendAddress.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnSendMail.setIcon(EASResource.getIcon((String)"imgTbtn_messagetopicedit"));
    }

    public void onLoad() throws Exception {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        this.curPerson = userInfo.getPerson();
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.removeRows();
        this.solutionPeriodID = (String)this.getUIContext().get("solutionPeriodID");
    }

    @Override
    public void actionSendMail_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"atleastOneEmailAddr"));
            SysUtil.abort();
        }
        StringBuffer to = new StringBuffer();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                to.append(",");
            }
            to.append(this.tblMain.getRow(i).getCell("email").getValue());
        }
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("id"));
            MultiDimentionSolutionPeriodInfo solutionPeriodInfo = (MultiDimentionSolutionPeriodInfo)MultiDimentionSolutionPeriodFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.solutionPeriodID), sic);
            String evaluObjectName = (String)this.getUIContext().get("evaluObjectName");
            Object[] variables = new Object[]{evaluObjectName, solutionPeriodInfo.getName()};
            String subject = EASResource.getString((String)RES, (String)"mailSubject");
            String content = EASResource.getString((String)RES, (String)"mailContent");
            MultiDimEvaluatorFactory.getRemoteInstance().sendMail(this.curPerson.getId().toString(), to.toString(), MessageFormat.format(subject, variables), MessageFormat.format(content, variables));
        }
        catch (Exception err) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "SENDMAIL_FAIL")), (Throwable)err);
            SysUtil.abort();
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "SENDMAIL_SUCCESS")));
    }

    @Override
    public void addSendAddress_actionPerformed(ActionEvent e) throws Exception {
        super.addSendAddress_actionPerformed(e);
        KDPromptBox pmt = new KDPromptBox();
        EmployeeMultiF7PromptBox mBox = new EmployeeMultiF7PromptBox((IUIObject)this);
        mBox.setIsSingleSelect(false);
        mBox.showNoPositionPerson(true);
        pmt.setSelector((KDPromptSelector)mBox);
        pmt.setDataBySelector();
        if (pmt.getData() != null) {
            Object[] obj = (Object[])pmt.getData();
            PersonInfo pInfo = null;
            IMailPerson iMP = MailPersonFactory.getRemoteInstance();
            MailPersonInfo mpInfo = null;
            Object[] param = new Object[1];
            int size = obj.length;
            for (int i = 0; i < size; ++i) {
                pInfo = (PersonInfo)obj[i];
                if (pInfo.getEmail() == null || StringUtils.isEmpty((String)pInfo.getEmail()) || pInfo.getEmail().indexOf("@") < 0) {
                    param[0] = pInfo.getName();
                    throw new PlanFreqTypeException(PlanFreqTypeException.PLAN_SEND_ADDRESS_ERROR, param);
                }
                mpInfo = new MailPersonInfo();
                mpInfo.setPerson(this.curPerson);
                mpInfo.setToPerson(pInfo);
                iMP.addnew(mpInfo);
            }
        }
        this.refresh(null);
    }

    @Override
    public void delSendAddress_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows(this.tblMain);
        if (indexs.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            IMailPerson iMP = MailPersonFactory.getRemoteInstance();
            String id = null;
            String oql = null;
            for (int i = 0; i < indexs.length; ++i) {
                id = this.tblMain.getRow(indexs[i]).getCell("id").getValue().toString();
                oql = "where person='" + this.curPerson.getId() + "' and toPerson='" + id + "'";
                if (!iMP.exists(oql)) {
                    return;
                }
                MailPersonInfo info = iMP.getMailPersonInfo(oql);
                iMP.delete((IObjectPK)new ObjectUuidPK(info.getId()));
            }
            this.refresh(null);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (this.curPerson != null) {
            filter.getFilterItems().add(new FilterItemInfo("Person2.id", (Object)this.curPerson.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("Person2.id", null));
        }
        return filter;
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        String noPos = EASResource.getString((String)RES, (String)"noPositionPerson");
        String org = null;
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                org = rowSet.getString("AdminOrgUnit.displayName");
                if (org != null && !"".equals(org.trim())) continue;
                rowSet.updateString("AdminOrgUnit.displayName", noPos);
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
    }
}

