/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.UIConfigUtility;
import com.kingdee.eas.hr.perf.EvalWorkFlowCollection;
import com.kingdee.eas.hr.perf.EvalWorkFlowFactory;
import com.kingdee.eas.hr.perf.EvalWorkFlowInfo;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.SolutionPeriodCollection;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.AbstractEvaluFlowSpectUI;
import com.kingdee.eas.hr.perf.client.EvalWorkFlowToString;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.WorkFlowControlPersonUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EvaluFlowSpectUI
extends AbstractEvaluFlowSpectUI {
    public static final long serialVersionUID = -61166L;
    private static final String MACHINE = "0";
    private static final String USER = "1";

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnHasten.setIcon(EASResource.getIcon((String)"imgTbtn_press"));
        this.initSolutionPeriod();
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    private void initSolutionPeriod() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(101)));
        filter.getFilterItems().add(new FilterItemInfo("evaluSolution.solutionType", (Object)new Integer(100)));
        filter.getFilterItems().add(new FilterItemInfo("evaluSolution.hrOrgUnit", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("evaluSolution.deliverMode", (Object)new Integer(102), CompareType.NOTEQUALS));
        viewInfo.setFilter(filter);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("evaluEndDate");
        sorterItemInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        SolutionPeriodCollection coll = SolutionPeriodFactory.getRemoteInstance().getSolutionPeriodCollection(viewInfo);
        this.comboSolutionPeriod.setActionCommand(MACHINE);
        this.comboSolutionPeriod.addItems(coll.toArray());
        this.comboSolutionPeriod.setActionCommand(USER);
        if (coll.size() > 0) {
            this.comboSolutionPeriod.setSelectedIndex(0);
        }
    }

    @Override
    protected void comboSolutionPeriod_actionPerformed(ActionEvent e) throws Exception {
        if (MACHINE.equals(e.getActionCommand())) {
            return;
        }
        Object obj = this.comboSolutionPeriod.getSelectedItem();
        if (obj == null) {
            return;
        }
        this.comboSolutionPeriod.setToolTipText(obj.toString());
        this.comboFlow.removeAllItems();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("evaluNodes.*"));
        sic.add(new SelectorItemInfo("concurArgs.*"));
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)((SolutionPeriodInfo)obj).getId().toString()));
        viewInfo.setFilter(filter);
        EvalWorkFlowCollection coll = EvalWorkFlowFactory.getRemoteInstance().getEvalWorkFlowCollection(viewInfo);
        this.comboFlow.setActionCommand(MACHINE);
        this.comboFlow.addItems(coll.toArray());
        this.comboFlow.setActionCommand(USER);
        if (coll.size() > 0) {
            this.comboFlow.setSelectedIndex(0);
        }
    }

    @Override
    protected void comboFlow_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.comboFlow.getSelectedItem();
        if (obj != null) {
            this.comboFlow.setToolTipText(obj.toString());
        }
        this.mainQuery = super.getEntityViewInfo(new EntityViewInfo());
        this.refresh(e);
        this.setFlowGraph();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        Object obj = this.comboFlow.getSelectedItem();
        if (obj != null) {
            filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.id", (Object)((EvalWorkFlowInfo)obj).getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"zero"));
        }
        filter.getFilterItems().add(PerfUtils.getAdminRangeFilterItemInfo(null, "AdminOrgUnit.id"));
        filter.getFilterItems().add(new FilterItemInfo("ActInst.state", (Object)"open.running"));
        filter.getFilterItems().add(new FilterItemInfo("ActInst.state", (Object)"open.not_running.not_started"));
        filter.getFilterItems().add(new FilterItemInfo("ActInst.state", (Object)"open.not_running.blocked"));
        filter.setMaskString("#0 and #1 and (#2 or #3 or #4)");
        return filter;
    }

    private void setFlowGraph() {
        Dimension dimension;
        Object obj = this.comboFlow.getSelectedItem();
        if (obj == null) {
            this.txtFlow.setText(null);
            return;
        }
        EvalWorkFlowInfo evalWorkFlowInfo = (EvalWorkFlowInfo)obj;
        StringBuffer[] stringBuffers = EvalWorkFlowToString.convertEvalWorkFlowToStringForTextArea(evalWorkFlowInfo);
        int width = 7 * stringBuffers[0].toString().getBytes().length;
        int height = 20 * stringBuffers.length;
        if (this.txtFlow.getPreferredSize().width < width || this.txtFlow.getPreferredSize().height < height) {
            if (this.txtFlow.getPreferredSize().width > width) {
                width = this.txtFlow.getPreferredSize().width;
            }
            if (this.txtFlow.getPreferredSize().height > height) {
                height = this.txtFlow.getPreferredSize().height;
            }
            dimension = new Dimension(width, height);
            this.txtFlow.setPreferredSize(dimension);
            this.txtFlow.setSize(dimension);
        } else {
            dimension = new Dimension(width, height);
            this.txtFlow.setPreferredSize(dimension);
            this.txtFlow.setSize(dimension);
        }
        StringBuffer strBuffer = new StringBuffer();
        int m = stringBuffers.length;
        for (int j = 0; j < m; ++j) {
            strBuffer.append(stringBuffers[j].toString());
            if (j >= m - 1) continue;
            strBuffer.append("\n");
        }
        this.txtFlow.setFont(new Font("Monospaced", 0, 14));
        this.txtFlow.setText(strBuffer.toString());
        this.txtFlow.setEditable(false);
        this.txtFlow.setLineWrap(false);
        this.txtFlow.revalidate();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }

    @Override
    public void actionHasten_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.SelectHasten();
    }

    private void SelectHasten() throws UIException {
        String solutionPeriodId = ((SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getId().toString();
        HashSet<String> evaluObjectSet = new HashSet<String>();
        HashMap<String, String> evaluObjectMap = new HashMap<String, String>();
        HashMap<String, String> evaluOperatorMap = new HashMap<String, String>();
        HashMap<String, String> evaluOperNameMap = new HashMap<String, String>();
        List rowIndexs = PFUtils.getSelectedRows(this.tblMain);
        if (rowIndexs != null && !rowIndexs.isEmpty()) {
            for (int i = 0; i < rowIndexs.size(); ++i) {
                Integer rowIndex = (Integer)rowIndexs.get(i);
                IRow row = this.tblMain.getRow(rowIndex.intValue());
                String evaluObjectId = (String)row.getCell("objectID").getValue();
                String evaluObjectName = (String)row.getCell("Person.name").getValue();
                String operatorID = (String)row.getCell("empID").getValue();
                String operatorName = (String)row.getCell("Assign.personEmpName").getValue();
                evaluObjectSet.add(evaluObjectId);
                evaluObjectMap.put(evaluObjectId, evaluObjectName);
                evaluOperatorMap.put(evaluObjectId, operatorID);
                evaluOperNameMap.put(evaluObjectId, operatorName);
            }
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriodID", (Object)solutionPeriodId);
        uiContext.put((Object)"evaluObjectMap", evaluObjectMap);
        uiContext.put((Object)"evaluObjectIDs", evaluObjectSet);
        uiContext.put((Object)"evaluOperatorMap", evaluOperatorMap);
        uiContext.put((Object)"evaluOperNameMap", evaluOperNameMap);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(WorkFlowControlPersonUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    private String getSelectedValueOf(String colName) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            Object keyValue;
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(colName);
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    protected String getEditUIModal() {
        String openModel = UIConfigUtility.getOpenModel();
        if (openModel != null) {
            return openModel;
        }
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        int n = this.tblMain.getColumnIndex("AdminOrgUnit.displayName");
        for (int i = 0; i <= n; ++i) {
            this.tblMain.getColumn(i).setGroup(true);
        }
        this.tblMain.getGroupManager().group();
    }
}

