/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryFactory;
import com.kingdee.eas.hr.perf.EvaluFormSolutionFactory;
import com.kingdee.eas.hr.perf.EvaluFormSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionMultiTableCollection;
import com.kingdee.eas.hr.perf.EvaluFormSolutionMultiTableInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionStateEnum;
import com.kingdee.eas.hr.perf.IEvaluFormSolutionEntry;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.client.AbstractEvaluFormSolutionBaseEditUI;
import com.kingdee.eas.hr.perf.client.BEMultiCommUI;
import com.kingdee.eas.hr.perf.client.DescriptionCommUI;
import com.kingdee.eas.hr.perf.client.IEvaluFormSolutionUI;
import com.kingdee.eas.hr.perf.client.KDTableUtil;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class EvaluFormSolutionBaseEditUI
extends AbstractEvaluFormSolutionBaseEditUI
implements IEvaluFormSolutionUI {
    private static final Logger logger = CoreUIObject.getLogger(EvaluFormSolutionBaseEditUI.class);
    private String id;
    private boolean isUseNumberRule = false;
    private String solutionState;
    private static final int multiTableCount = 5;
    private static final String RES = "com.kingdee.eas.hr.perf.PERFAutoGenerateResource";

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.id = (String)this.getUIContext().get("ID");
        this.editData = this.id == null ? (EvaluFormSolutionInfo)this.createNewData() : EvaluFormSolutionFactory.getRemoteInstance().getEvaluFormSolutionInfo((IObjectPK)new ObjectUuidPK(this.id));
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
        if (this.editData.getSolutionState() != null && 1 == this.editData.getSolutionState().getValue() && OprtState.EDIT.equals(this.getOprtState())) {
            this.setOprtState(OprtState.VIEW);
        }
        boolean isView = !OprtState.VIEW.equals(this.getOprtState());
        this.txtName.setEnabled(isView);
        if (this.txtNumber.isEnabled()) {
            this.txtNumber.setEnabled(isView);
        }
        this.txtDesc.setEnabled(isView);
        this.txtMemo.setEnabled(isView);
        this.initUI();
        this.initWorkButton();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                EvaluFormSolutionBaseEditUI.this.actionTableClicked(e);
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.id != null && this.isMultiTableModify()) {
            EvaluFormSolutionMultiTableCollection collection = this.editData.getMultiTable();
            collection.clear();
            EvaluFormSolutionMultiTableCollection tableCollection = (EvaluFormSolutionMultiTableCollection)((Object)this.tblMain.getUserObject());
            int size = tableCollection.size();
            for (int c = 0; c < size; ++c) {
                collection.add(tableCollection.get(c));
            }
        }
    }

    @Override
    public void loadFields() {
        try {
            this.isUseNumberRule = PerfUtils.setAutoNumberByOrg("ControlUnit", this.createNewData(), (IObjectValue)this.editData, this.txtNumber);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.initOldData();
        super.loadFields();
    }

    protected IObjectValue createNewData() {
        EvaluFormSolutionInfo info = new EvaluFormSolutionInfo();
        info.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        info.setSolutionState(EvaluFormSolutionStateEnum.NO_START_USING);
        EvaluFormSolutionMultiTableInfo multiTableInfo = new EvaluFormSolutionMultiTableInfo();
        multiTableInfo.setName(EASResource.getString((String)RES, (String)"101_EvaluFormSolutionBaseEditUI"));
        multiTableInfo.setPartTableDesShow(false);
        multiTableInfo.setCalSumScore(false);
        multiTableInfo.setCompute(true);
        multiTableInfo.setEvaluFormSolution(info);
        info.getMultiTable().add(multiTableInfo);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EvaluFormSolutionFactory.getRemoteInstance();
    }

    @Override
    public void secondLoad() throws Exception {
    }

    public void reset() {
        this.editData.resetValue();
        this.loadFields();
    }

    @Override
    public void submit() throws Exception {
        if (this.id != null) {
            this.editData = EvaluFormSolutionFactory.getRemoteInstance().getEvaluFormSolutionInfo((IObjectPK)new ObjectUuidPK(this.id));
        }
        this.verifyInput();
        this.setDataObject((IObjectValue)this.editData);
        this.storeFields();
        this.id = this.getBizInterface().submit((CoreBaseInfo)this.editData).toString();
        this.editData = EvaluFormSolutionFactory.getRemoteInstance().getEvaluFormSolutionInfo((IObjectPK)new ObjectUuidPK(this.id));
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
        this.txtNumber.setText(this.editData.getNumber());
    }

    @Override
    public void verifyInput() throws Exception {
        if (this.txtNumber.isEnabled()) {
            PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        }
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        boolean computeIsNotNull = false;
        int j = this.tblMain.getRowCount();
        for (int i = 0; i < j; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("name").getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"98_EvaluFormSolutionBaseEditUI"));
                SysUtil.abort();
            }
            if (!row.getCell("compute").getValue().equals(Boolean.TRUE)) continue;
            computeIsNotNull = true;
        }
        if (!computeIsNotNull) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"119_ComputeNotNull"));
            SysUtil.abort();
        }
    }

    public String getId() {
        return this.id;
    }

    protected boolean checkBeforeWindowClosing() {
        boolean returnResult = false;
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    this.submit();
                }
                catch (Exception e) {
                    super.handleException(e);
                    return false;
                }
                returnResult = true;
            } else {
                returnResult = result == 1;
            }
        } else {
            returnResult = true;
        }
        return returnResult;
    }

    @Override
    public boolean isModify() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            super.handleException((Exception)e);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        try {
            this.storeFields();
            this.editData.setSyncOldValue(false);
        }
        catch (Exception exc) {
            return false;
        }
        EvaluFormSolutionInfo objectValue = this.editData;
        boolean baseIsModify = objectValue.isValueChange();
        if (this.id == null && this.txtNumber.getText().trim().equals("") && this.txtName.getSelectedItem().toString().trim().equals("") && this.editData.getMultiTable().size() == 1) {
            return false;
        }
        return baseIsModify;
    }

    private boolean isMultiTableModify() {
        EvaluFormSolutionMultiTableCollection oldColl = this.editData.getMultiTable();
        if (oldColl.size() != this.tblMain.getRowCount()) {
            return true;
        }
        boolean isModify = false;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            EvaluFormSolutionMultiTableInfo oldInfo = oldColl.get(i);
            IRow row = this.tblMain.getRow(i);
            boolean b = false;
            Object name = row.getCell("name").getValue();
            if (name == null && oldInfo.getName() != null || name != null && oldInfo.getName() == null) {
                isModify = true;
                break;
            }
            if (name != null && oldInfo.getName() != null && !oldInfo.getName().equals(name)) {
                isModify = true;
                break;
            }
            Object partTableDes = row.getCell("partTableDes").getValue();
            if (partTableDes == null && oldInfo.getPartTableDes() != null || partTableDes != null && oldInfo.getPartTableDes() == null) {
                isModify = true;
                break;
            }
            if (partTableDes != null && oldInfo.getPartTableDes() != null && !partTableDes.equals(oldInfo.getPartTableDes())) {
                isModify = true;
                break;
            }
            b = row.getCell("partTableDesShow").getValue() == null ? false : (Boolean)row.getCell("partTableDesShow").getValue();
            if (b != oldInfo.isPartTableDesShow()) {
                isModify = true;
                break;
            }
            b = row.getCell("calSumScore").getValue() == null ? false : (Boolean)row.getCell("calSumScore").getValue();
            if (b != oldInfo.isCalSumScore()) {
                isModify = true;
                break;
            }
            b = row.getCell("compute").getValue() == null ? false : (Boolean)row.getCell("compute").getValue();
            if (b != oldInfo.isCompute()) {
                isModify = true;
                break;
            }
            Object description = row.getCell("description").getValue();
            if (description == null && oldInfo.getDescription() != null || description != null && oldInfo.getDescription() == null) {
                if (description != null && description.toString().trim().equals("")) {
                    isModify = false;
                } else {
                    isModify = true;
                    break;
                }
            }
            if (description == null || oldInfo.getDescription() == null || oldInfo.getDescription().equals(description)) continue;
            isModify = true;
            break;
        }
        return isModify;
    }

    protected void initOldData() {
        EvaluFormSolutionInfo objectValue = this.editData;
        objectValue.copyNewToOld();
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.btn_addLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.contMultiTable.addButton((JButton)this.btn_addLine);
        this.btn_insertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.contMultiTable.addButton((JButton)this.btn_insertLine);
        this.btn_delLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.contMultiTable.addButton((JButton)this.btn_delLine);
        boolean flag = OprtState.VIEW.equals(this.getOprtState());
        this.btn_addLine.setEnabled(!flag);
        this.btn_delLine.setEnabled(!flag);
        this.btn_insertLine.setEnabled(!flag);
        if (flag) {
            this.tblMain.getStyleAttributes().setLocked(true);
        }
    }

    @Override
    protected void btn_addLine_actionPerformed(ActionEvent e) throws Exception {
        super.btn_addLine_actionPerformed(e);
        if (this.tblMain.getRowCount() < 5) {
            IRow row = null;
            row = this.tblMain.addRow();
            row.getCell("partTableDesShow").setValue((Object)Boolean.FALSE);
            row.getCell("calSumScore").setValue((Object)Boolean.FALSE);
            row.getCell("compute").setValue((Object)Boolean.TRUE);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"99_EvaluFormSolutionBaseEditUI"));
        }
    }

    protected IEvaluFormSolutionEntry getBizEntryInterface() throws Exception {
        return EvaluFormSolutionEntryFactory.getRemoteInstance();
    }

    @Override
    protected void btn_delLine_actionPerformed(ActionEvent e) throws Exception {
        super.btn_delLine_actionPerformed(e);
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int[] rowID = KDTableUtil.getSelectedRows(this.tblMain);
        for (int i = rowID.length - 1; i >= 0; --i) {
            if (this.tblMain.getRowCount() > 1) {
                this.tblMain.removeRow(rowID[i]);
                continue;
            }
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"100_EvaluFormSolutionBaseEditUI"));
        }
    }

    @Override
    protected void btn_insertLine_actionPerformed(ActionEvent e) throws Exception {
        super.btn_insertLine_actionPerformed(e);
        if (this.tblMain.getRowCount() < 5) {
            IRow row = null;
            row = this.tblMain.getRowCount() != 0 && this.tblMain.getSelectManager().getActiveRowIndex() != -1 ? this.tblMain.addRow(this.tblMain.getSelectManager().getActiveRowIndex()) : this.tblMain.addRow();
            row.getCell("partTableDesShow").setValue((Object)Boolean.FALSE);
            row.getCell("calSumScore").setValue((Object)Boolean.FALSE);
            row.getCell("compute").setValue((Object)Boolean.TRUE);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"99_EvaluFormSolutionBaseEditUI"));
        }
    }

    private void initUI() {
        KDCheckBox checkBox1 = new KDCheckBox();
        KDTDefaultCellEditor ckCellEditor1 = new KDTDefaultCellEditor((JCheckBox)checkBox1);
        this.tblMain.getColumn("partTableDesShow").setEditor((ICellEditor)ckCellEditor1);
        KDCheckBox checkBox2 = new KDCheckBox();
        KDTDefaultCellEditor ckCellEditor2 = new KDTDefaultCellEditor((JCheckBox)checkBox2);
        this.tblMain.getColumn("calSumScore").setEditor((ICellEditor)ckCellEditor2);
        KDCheckBox checkBox3 = new KDCheckBox();
        checkBox3.addActionListener((ActionListener)new ItemStateChange());
        KDTDefaultCellEditor ckCellEditor3 = new KDTDefaultCellEditor((JCheckBox)checkBox3);
        this.tblMain.getColumn("compute").setEditor((ICellEditor)ckCellEditor3);
        int[] leftRowID = new int[5];
        boolean j = false;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("compute").getValue().equals(Boolean.FALSE)) {
                row.getCell("calSumScore").setValue((Object)Boolean.FALSE);
                row.getCell("calSumScore").getStyleAttributes().setLocked(true);
                continue;
            }
            row.getCell("calSumScore").getStyleAttributes().setLocked(false);
        }
        if (j) {
            this.tblMain.getRow(leftRowID[0]).getCell("compute").getStyleAttributes().setLocked(true);
        }
        KDTextField txtName = new KDTextField();
        txtName.setMaxLength(20);
        KDTextField txtDescription = new KDTextField();
        txtDescription.setMaxLength(200);
        this.tblMain.getColumn("name").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtName));
        this.tblMain.getColumn("partTableDes").getStyleAttributes().setWrapText(true);
        this.tblMain.getColumn("partTableDes").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("description").getStyleAttributes().setWrapText(true);
        boolean state = OprtState.VIEW.equals(this.getOprtState());
        this.tblMain.setEnabled(!state);
        this.tblMain.getEditManager().setAllowBlankCharacter(false);
    }

    private void actionTableClicked(KDTMouseEvent e) {
        try {
            KDTable table = (KDTable)e.getSource();
            if (e.getType() == 0 || e.getClickCount() != 2 || e.getRowIndex() > table.getRowCount() - 1) {
                return;
            }
            if (e.getColIndex() != this.tblMain.getColumnIndex("partTableDes") && e.getColIndex() != this.tblMain.getColumnIndex("description")) {
                return;
            }
            if (e.getColIndex() == this.tblMain.getColumnIndex("partTableDes")) {
                UIContext uiContext = new UIContext((Object)this);
                Object obj = table.getRow(e.getRowIndex()).getCell("partTableDes").getValue();
                if (obj != null) {
                    uiContext.put((Object)"0", (Object)obj.toString());
                } else {
                    uiContext.put((Object)"0", null);
                }
                String oprtStateStr = null;
                oprtStateStr = !OprtState.VIEW.equals(this.getOprtState()) ? OprtState.EDIT : OprtState.VIEW;
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BEMultiCommUI.class.getName(), (Map)uiContext, null, oprtStateStr);
                uiWindow.show();
                if (OprtState.VIEW.equals(this.getOprtState())) {
                    return;
                }
                BEMultiCommUI ui = (BEMultiCommUI)uiWindow.getUIObject();
                String partTableDes = ui.getComment();
                if (partTableDes == null || "".equals(partTableDes.trim())) {
                    table.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue(null);
                } else {
                    table.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)partTableDes);
                }
            } else if (e.getColIndex() == this.tblMain.getColumnIndex("description")) {
                UIContext uiContext = new UIContext((Object)this);
                Object obj = table.getRow(e.getRowIndex()).getCell("description").getValue();
                if (obj != null) {
                    uiContext.put((Object)"0", (Object)obj.toString());
                } else {
                    uiContext.put((Object)"0", null);
                }
                String oprtStateStr = null;
                oprtStateStr = !OprtState.VIEW.equals(this.getOprtState()) ? OprtState.EDIT : OprtState.VIEW;
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DescriptionCommUI.class.getName(), (Map)uiContext, null, oprtStateStr);
                uiWindow.show();
                if (OprtState.VIEW.equals(this.getOprtState())) {
                    return;
                }
                DescriptionCommUI ui = (DescriptionCommUI)uiWindow.getUIObject();
                String description = ui.getComment();
                if (description == null || "".equals(description.trim())) {
                    table.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue(null);
                } else {
                    table.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)description);
                }
            }
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    private class ItemStateChange
    implements ActionListener {
        private ItemStateChange() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            KDCheckBox chkObj = (KDCheckBox)obj;
            int[] rowID = KDTableUtil.getSelectedRows(EvaluFormSolutionBaseEditUI.this.tblMain);
            if (chkObj.isSelected()) {
                EvaluFormSolutionBaseEditUI.this.tblMain.getRow(rowID[0]).getCell("calSumScore").getStyleAttributes().setLocked(false);
            } else {
                EvaluFormSolutionBaseEditUI.this.tblMain.getRow(rowID[0]).getCell("calSumScore").setValue((Object)Boolean.FALSE);
                EvaluFormSolutionBaseEditUI.this.tblMain.getRow(rowID[0]).getCell("calSumScore").getStyleAttributes().setLocked(true);
            }
        }
    }
}

