/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.hr.perf.EvaluFormSolutionContractTemplateCollection;
import com.kingdee.eas.hr.perf.EvaluFormSolutionContractTemplateFactory;
import com.kingdee.eas.hr.perf.EvaluFormSolutionContractTemplateInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryCollection;
import com.kingdee.eas.hr.perf.EvaluFormSolutionMultiTableCollection;
import com.kingdee.eas.hr.perf.EvaluFormSolutionMultiTableInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionStateEnum;
import com.kingdee.eas.hr.perf.FormulaInfo;
import com.kingdee.eas.hr.perf.IEvaluFormSolutionContractTemplate;
import com.kingdee.eas.hr.perf.KindEnum;
import com.kingdee.eas.hr.perf.PerfContractTemplateHelper;
import com.kingdee.eas.hr.perf.PerformTargetTypeInfo;
import com.kingdee.eas.hr.perf.PrecisionTypeEnum;
import com.kingdee.eas.hr.perf.ReportFrequencyEnum;
import com.kingdee.eas.hr.perf.client.AbstractEvaluFormSolutionContractTemplateEditUI;
import com.kingdee.eas.hr.perf.client.IEvaluFormSolutionUI;
import com.kingdee.eas.hr.perf.client.PerfContractTemplateClientHelper;
import com.kingdee.eas.hr.perf.client.PerfContractTemplateDrawTableHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class EvaluFormSolutionContractTemplateEditUI
extends AbstractEvaluFormSolutionContractTemplateEditUI
implements IEvaluFormSolutionUI {
    private static final Logger logger = CoreUIObject.getLogger(EvaluFormSolutionContractTemplateEditUI.class);
    private int style = 12;
    private ArrayList SingleTableViewList = new ArrayList();
    private Set multiTableIDset = new HashSet();
    private Map historyPerfContractTemplateInfoMap = new HashMap();
    private EvaluFormSolutionContractTemplateCollection submitPerfContractTemplateInfoColl = new EvaluFormSolutionContractTemplateCollection();
    private String curSolutionId = null;
    private Set WickedlyColumnSet = null;
    private final BigDecimal percent = new BigDecimal("0.01");

    public void onLoad() throws Exception, BOSException, EASBizException {
        String solutionState;
        this.WickedlyColumnSet = PerfContractTemplateDrawTableHelper.getWickedlyColumnSet_ContractTemplate();
        this.curSolutionId = (String)this.getUIContext().get("ID");
        this.drawTableView();
        this.fillDataIntoTableView(PerfContractTemplateHelper.getPerfContractTemplateInfoBySolutionID(null, this.curSolutionId));
        this.bakHistoryPerfContractTemplateInfo();
        if (this.getUIContext().get("solutionState") != null && (solutionState = this.getUIContext().get("solutionState").toString()).equals(EvaluFormSolutionStateEnum.START_USING.getAlias()) && OprtState.EDIT.equals(this.getOprtState())) {
            this.setOprtState(OprtState.VIEW);
        }
        this.setComponentDisenabled();
    }

    private void drawTableView() throws Exception, BOSException, EASBizException {
        int X = 10;
        int Y = 10;
        int space = 10;
        int tableViewWidth = 570;
        int tableViewHight = 180;
        EvaluFormSolutionMultiTableCollection MultiTableColl = PerfContractTemplateHelper.getMultiTableCollection(null, this.curSolutionId);
        this.pnlMain.setPreferredSize(new Dimension(tableViewWidth, MultiTableColl.size() * (space + tableViewHight)));
        for (int i = 0; i < MultiTableColl.size(); ++i) {
            EvaluFormSolutionMultiTableInfo currMultiTableInfo = MultiTableColl.get(i);
            EvaluFormSolutionEntryCollection evaluFormSolutionEntryColl = PerfContractTemplateHelper.getSingleTableSetInfo(this.curSolutionId, currMultiTableInfo.getId().toString());
            this.SingleTableViewList.add(PerfContractTemplateDrawTableHelper.getSingleTableView(currMultiTableInfo, evaluFormSolutionEntryColl, this.WickedlyColumnSet));
            this.pnlMain.add((Component)((KDContainer)this.SingleTableViewList.get(i)), (Object)new KDLayout.Constraints(X, Y + (space + tableViewHight) * i, tableViewWidth, tableViewHight, this.style));
        }
    }

    private void fillDataIntoTableView(EvaluFormSolutionContractTemplateCollection contractTemplateColl) throws Exception, BOSException, EASBizException {
        if (contractTemplateColl == null) {
            return;
        }
        KDTable table = null;
        EvaluFormSolutionContractTemplateCollection tempColl = null;
        String curMultiTableID = null;
        for (int i = 0; i < this.SingleTableViewList.size(); ++i) {
            table = PerfContractTemplateDrawTableHelper.findATable((Component)((KDContainer)this.SingleTableViewList.get(i)));
            table.removeRows();
            curMultiTableID = ((EvaluFormSolutionMultiTableInfo)table.getUserObject()).getId().toString();
            tempColl = new EvaluFormSolutionContractTemplateCollection();
            for (int j = 0; j < contractTemplateColl.size(); ++j) {
                if (!contractTemplateColl.get(j).getMultiTable().getId().toString().equals(curMultiTableID)) continue;
                tempColl.add(contractTemplateColl.get(j));
            }
            Object[] tempArray = tempColl.toArray();
            Arrays.sort(tempArray, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    EvaluFormSolutionContractTemplateInfo a = (EvaluFormSolutionContractTemplateInfo)arg0;
                    EvaluFormSolutionContractTemplateInfo b = (EvaluFormSolutionContractTemplateInfo)arg1;
                    return a.getSeq() - b.getSeq();
                }
            });
            tempColl.clear();
            for (int m = 0; m < tempArray.length; ++m) {
                tempColl.add((EvaluFormSolutionContractTemplateInfo)tempArray[m]);
            }
            PerfContractTemplateClientHelper.fillTableByPerfContractTemplateInfo(table, tempColl);
        }
    }

    public void setOldData() throws EASBizException, BOSException, Exception {
        EvaluFormSolutionContractTemplateCollection coll = new EvaluFormSolutionContractTemplateCollection();
        Iterator iter = this.historyPerfContractTemplateInfoMap.keySet().iterator();
        for (int i = 0; i < this.historyPerfContractTemplateInfoMap.size(); ++i) {
            coll.add((EvaluFormSolutionContractTemplateInfo)this.historyPerfContractTemplateInfoMap.get(iter.next().toString()));
        }
        this.fillDataIntoTableView(coll);
    }

    private void setComponentDisenabled() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            for (int i = 0; i < this.SingleTableViewList.size(); ++i) {
                KDTable currTable = PerfContractTemplateDrawTableHelper.findATable((Component)((KDContainer)this.SingleTableViewList.get(i)));
                currTable.setEditable(false);
                Component[] comp = ((JPanel)((KDContainer)this.SingleTableViewList.get(i)).getComponent(0)).getComponents();
                for (int k = 0; k < comp.length; ++k) {
                    comp[k].setEnabled(false);
                }
            }
        }
    }

    @Override
    public void submit() throws Exception {
        this.verifyInput();
        if (this.submitPerfContractTemplateInfoColl == null || this.submitPerfContractTemplateInfoColl.size() <= 0) {
            this.submitPerfContractTemplateInfoColl = this.getPerfContractTemplateByMining(this.SingleTableViewList);
        }
        IEvaluFormSolutionContractTemplate iContractTemplate = EvaluFormSolutionContractTemplateFactory.getRemoteInstance();
        iContractTemplate.submitBatchContractTemplate(this.submitPerfContractTemplateInfoColl, this.curSolutionId);
        this.submitPerfContractTemplateInfoColl.clear();
        this.fillDataIntoTableView(PerfContractTemplateHelper.getPerfContractTemplateInfoBySolutionID(null, this.curSolutionId));
        this.bakHistoryPerfContractTemplateInfo();
    }

    private void bakHistoryPerfContractTemplateInfo() {
        this.historyPerfContractTemplateInfoMap.clear();
        EvaluFormSolutionContractTemplateCollection efsctc = this.getPerfContractTemplateByMining(this.SingleTableViewList);
        for (int k = 0; k < efsctc.size(); ++k) {
            EvaluFormSolutionContractTemplateInfo info = efsctc.get(k);
            this.historyPerfContractTemplateInfoMap.put(info.getMultiTable().getId().toString() + info.getSeq(), info);
        }
    }

    private EvaluFormSolutionContractTemplateCollection getPerfContractTemplateByMining(ArrayList SingleTableViewList) {
        EvaluFormSolutionContractTemplateCollection returnColl = new EvaluFormSolutionContractTemplateCollection();
        KDTable currTable = null;
        for (int i = 0; i < SingleTableViewList.size(); ++i) {
            currTable = PerfContractTemplateDrawTableHelper.findATable((Component)((KDContainer)SingleTableViewList.get(i)));
            returnColl.addCollection(this.getPerfContractTemplateFromTable(currTable));
        }
        return returnColl;
    }

    private EvaluFormSolutionContractTemplateCollection getPerfContractTemplateFromTable(KDTable currTable) {
        EvaluFormSolutionContractTemplateCollection returnColl = new EvaluFormSolutionContractTemplateCollection();
        EvaluFormSolutionMultiTableInfo multiTableInfo = (EvaluFormSolutionMultiTableInfo)currTable.getUserObject();
        int rowCount = currTable.getRowCount();
        if (rowCount <= 0) {
            return returnColl;
        }
        IRow irow = null;
        EvaluFormSolutionContractTemplateInfo contractTemplateInfo = null;
        for (int i = 0; i < rowCount; ++i) {
            irow = currTable.getRow(i);
            contractTemplateInfo = new EvaluFormSolutionContractTemplateInfo();
            contractTemplateInfo.setMultiTable(multiTableInfo);
            if (irow.getCell("id") != null && irow.getCell("id").getValue() != null) {
                contractTemplateInfo.setId(BOSUuid.read((String)irow.getCell("id").getValue().toString()));
            }
            if (irow.getCell("PerformTargetItemFid") != null && irow.getCell("PerformTargetItemFid").getValue() != null) {
                contractTemplateInfo.setTargetItem(BOSUuid.read((String)irow.getCell("PerformTargetItemFid").getValue().toString()));
            }
            if (irow.getCell("seq") != null && irow.getCell("seq").getValue() != null) {
                contractTemplateInfo.setSeq(i + 1);
            }
            if (irow.getCell("content") != null) {
                contractTemplateInfo.setName(irow.getCell("content").getValue() != null ? irow.getCell("content").getValue().toString() : null);
            }
            if (irow.getCell("number") != null) {
                contractTemplateInfo.setNumber(irow.getCell("number").getValue() != null ? irow.getCell("number").getValue().toString() : null);
            }
            if (irow.getCell("description") != null) {
                contractTemplateInfo.setDescription(irow.getCell("description").getValue() != null ? irow.getCell("description").getValue().toString() : null);
            }
            if (irow.getCell("firstLevelTargetTypeWeight") != null) {
                contractTemplateInfo.setFirstTypeWeight(irow.getCell("firstLevelTargetTypeWeight").getValue() != null ? ((BigDecimal)irow.getCell("firstLevelTargetTypeWeight").getValue()).setScale(2, 4) : null);
            }
            if (irow.getCell("firstLevelTargetTypeScore") != null) {
                contractTemplateInfo.setFirstTypeScore(irow.getCell("firstLevelTargetTypeScore") != null ? (BigDecimal)irow.getCell("firstLevelTargetTypeScore").getValue() : null);
            }
            if (irow.getCell("secondLevelTargetTypeWeight") != null) {
                contractTemplateInfo.setSecondTypeWeight(irow.getCell("secondLevelTargetTypeWeight").getValue() != null ? (BigDecimal)irow.getCell("secondLevelTargetTypeWeight").getValue() : null);
            }
            if (irow.getCell("secondLevelTargetTypeScore") != null) {
                contractTemplateInfo.setSecondTypeScore(irow.getCell("secondLevelTargetTypeScore").getValue() != null ? (BigDecimal)irow.getCell("secondLevelTargetTypeScore").getValue() : null);
            }
            if (irow.getCell("standard") != null) {
                contractTemplateInfo.setStandard(irow.getCell("standard").getValue() != null ? irow.getCell("standard").getValue().toString() : null);
            }
            if (irow.getCell("weight") != null) {
                contractTemplateInfo.setWeight(irow.getCell("weight").getValue() != null ? (BigDecimal)irow.getCell("weight").getValue() : null);
            }
            if (irow.getCell("values") != null) {
                contractTemplateInfo.setValues(irow.getCell("values").getValue() != null ? (BigDecimal)irow.getCell("values").getValue() : null);
            }
            if (irow.getCell("kind") != null) {
                contractTemplateInfo.setKind(irow.getCell("kind").getValue() != null ? (KindEnum)((Object)irow.getCell("kind").getValue()) : null);
            }
            if (irow.getCell("dataPrecision") != null) {
                contractTemplateInfo.setDataPrecision(irow.getCell("dataPrecision").getValue() != null ? new Integer(irow.getCell("dataPrecision").getValue().toString()) : 2);
            } else {
                contractTemplateInfo.setDataPrecision(2);
            }
            if (irow.getCell("precisionType") != null) {
                contractTemplateInfo.setPrecisionType(irow.getCell("precisionType").getValue() != null ? (PrecisionTypeEnum)((Object)irow.getCell("precisionType").getValue()) : PrecisionTypeEnum.ROUND);
            } else {
                contractTemplateInfo.setPrecisionType(PrecisionTypeEnum.ROUND);
            }
            if (irow.getCell("thresholdValue") != null) {
                if (contractTemplateInfo.getKind() != null && contractTemplateInfo.getKind().getValue() == 22) {
                    contractTemplateInfo.setThresholdValue(irow.getCell("thresholdValue").getValue() != null ? ((BigDecimal)irow.getCell("thresholdValue").getValue()).multiply(this.percent) : null);
                } else {
                    contractTemplateInfo.setThresholdValue(irow.getCell("thresholdValue").getValue() != null ? (BigDecimal)irow.getCell("thresholdValue").getValue() : null);
                }
            }
            if (irow.getCell("standardValue") != null) {
                if (contractTemplateInfo.getKind() != null && contractTemplateInfo.getKind().getValue() == 22) {
                    contractTemplateInfo.setStandardValue(irow.getCell("standardValue").getValue() != null ? ((BigDecimal)irow.getCell("standardValue").getValue()).multiply(this.percent) : null);
                } else {
                    contractTemplateInfo.setStandardValue(irow.getCell("standardValue").getValue() != null ? (BigDecimal)irow.getCell("standardValue").getValue() : null);
                }
            }
            if (irow.getCell("challengeValue") != null) {
                if (contractTemplateInfo.getKind() != null && contractTemplateInfo.getKind().getValue() == 22) {
                    contractTemplateInfo.setChallengeValue(irow.getCell("challengeValue").getValue() != null ? ((BigDecimal)irow.getCell("challengeValue").getValue()).multiply(this.percent) : null);
                } else {
                    contractTemplateInfo.setChallengeValue(irow.getCell("challengeValue").getValue() != null ? (BigDecimal)irow.getCell("challengeValue").getValue() : null);
                }
            }
            if (irow.getCell("unit") != null) {
                contractTemplateInfo.setUnit(irow.getCell("unit").getValue() != null ? irow.getCell("unit").getValue().toString() : null);
            }
            if (irow.getCell("reportFrequency") != null) {
                contractTemplateInfo.setReportFrequency(irow.getCell("reportFrequency").getValue() != null ? (ReportFrequencyEnum)((Object)irow.getCell("reportFrequency").getValue()) : null);
            }
            if (irow.getCell("scoringMethod") != null) {
                contractTemplateInfo.setScoringMethod(irow.getCell("scoringMethod").getValue() != null ? irow.getCell("scoringMethod").getValue().toString() : null);
            }
            if (irow.getCell("evaluationSide") != null) {
                contractTemplateInfo.setEvaluationSide(irow.getCell("evaluationSide").getValue() != null ? irow.getCell("evaluationSide").getValue().toString() : null);
            }
            if (irow.getCell("reservedField1") != null) {
                contractTemplateInfo.setReservedFieldText1(irow.getCell("reservedField1").getValue() != null ? irow.getCell("reservedField1").getValue().toString() : null);
            }
            if (irow.getCell("reservedField2") != null) {
                contractTemplateInfo.setReservedFieldText2(irow.getCell("reservedField2").getValue() != null ? irow.getCell("reservedField2").getValue().toString() : null);
            }
            if (irow.getCell("reservedField3") != null) {
                contractTemplateInfo.setReservedFieldText3(irow.getCell("reservedField3").getValue() != null ? irow.getCell("reservedField3").getValue().toString() : null);
            }
            if (irow.getCell("reservedField4") != null) {
                contractTemplateInfo.setReservedFieldText4(irow.getCell("reservedField4").getValue() != null ? irow.getCell("reservedField4").getValue().toString() : null);
            }
            if (irow.getCell("reservedField5") != null) {
                contractTemplateInfo.setReservedFieldText5(irow.getCell("reservedField5").getValue() != null ? irow.getCell("reservedField5").getValue().toString() : null);
            }
            if (irow.getCell("reservedField6") != null) {
                contractTemplateInfo.setReservedFieldText6(irow.getCell("reservedField6").getValue() != null ? irow.getCell("reservedField6").getValue().toString() : null);
            }
            if (irow.getCell("reservedFieldNumber") != null) {
                if (contractTemplateInfo.getKind() != null && contractTemplateInfo.getKind().getValue() == 22) {
                    contractTemplateInfo.setReservedFieldNumber(irow.getCell("reservedFieldNumber").getValue() != null ? ((BigDecimal)irow.getCell("reservedFieldNumber").getValue()).multiply(this.percent) : null);
                } else {
                    contractTemplateInfo.setReservedFieldNumber(irow.getCell("reservedFieldNumber").getValue() != null ? (BigDecimal)irow.getCell("reservedFieldNumber").getValue() : null);
                }
            }
            if (irow.getCell("calFormula") != null) {
                contractTemplateInfo.setFormula(irow.getCell("calFormula").getValue() != null ? (FormulaInfo)irow.getCell("calFormula").getValue() : null);
            }
            if (irow.getCell("type") != null) {
                contractTemplateInfo.setFirstType(irow.getCell("type").getValue() != null ? (PerformTargetTypeInfo)irow.getCell("type").getValue() : null);
            }
            if (irow.getCell("secondLevelTargetType") != null) {
                contractTemplateInfo.setSecondType(irow.getCell("secondLevelTargetType").getValue() != null ? (PerformTargetTypeInfo)irow.getCell("secondLevelTargetType").getValue() : null);
            }
            returnColl.add(contractTemplateInfo);
        }
        return returnColl;
    }

    @Override
    public boolean isModify() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            super.handleException((Exception)e);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        this.submitPerfContractTemplateInfoColl = this.getPerfContractTemplateByMining(this.SingleTableViewList);
        if (this.submitPerfContractTemplateInfoColl.size() != this.historyPerfContractTemplateInfoMap.size()) {
            return true;
        }
        if (this.submitPerfContractTemplateInfoColl.size() == 0) {
            return false;
        }
        EvaluFormSolutionContractTemplateInfo info = null;
        for (int i = 0; i < this.submitPerfContractTemplateInfoColl.size(); ++i) {
            info = this.submitPerfContractTemplateInfoColl.get(i);
            if (ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)info, (AbstractObjectValue)((AbstractObjectValue)this.historyPerfContractTemplateInfoMap.get(info.getMultiTable().getId().toString() + info.getSeq())))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void secondLoad() throws Exception {
        this.SingleTableViewList.clear();
        this.multiTableIDset.clear();
        this.historyPerfContractTemplateInfoMap.clear();
        this.submitPerfContractTemplateInfoColl.clear();
        this.pnlMain.removeAll();
        this.drawTableView();
        this.fillDataIntoTableView(PerfContractTemplateHelper.getPerfContractTemplateInfoBySolutionID(null, this.curSolutionId));
        this.bakHistoryPerfContractTemplateInfo();
        this.setComponentDisenabled();
    }

    @Override
    public void verifyInput() {
        KDTable currTable = null;
        int rowCount = 0;
        IRow irow = null;
        HashMap<String, String> firstTypeMap = new HashMap<String, String>();
        HashMap<String, String> multiTableNameMap = new HashMap<String, String>();
        for (int k = 0; k < this.SingleTableViewList.size(); ++k) {
            currTable = PerfContractTemplateDrawTableHelper.findATable((Component)((KDContainer)this.SingleTableViewList.get(k)));
            EvaluFormSolutionMultiTableInfo curMultiTableInfo = (EvaluFormSolutionMultiTableInfo)currTable.getUserObject();
            String curMultiTableId = curMultiTableInfo.getId().toString();
            boolean isCompute = curMultiTableInfo.isCompute();
            multiTableNameMap.put(curMultiTableId, ((KDContainer)this.SingleTableViewList.get(k)).getTitle());
            rowCount = currTable.getRowCount();
            if (rowCount <= 0) continue;
            for (int i = 0; i < rowCount; ++i) {
                irow = currTable.getRow(i);
                if (irow.getCell("type").getValue() == null) {
                    currTable.getEditManager().editCellAt(i, currTable.getColumnIndex("type"));
                    MsgBox.showInfo((String)(currTable.getHeadRow(0).getCell("type").getValue().toString() + EASResource.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"103_EvaluFormSolutionContractTemplateEditUI")));
                    SysUtil.abort();
                }
                if (!isCompute) continue;
                String firstTypeId = ((PerformTargetTypeInfo)irow.getCell("type").getValue()).getId().toString();
                if (firstTypeMap.get(firstTypeId) == null) {
                    firstTypeMap.put(firstTypeId, curMultiTableId);
                    continue;
                }
                if (curMultiTableId.equals(firstTypeMap.get(firstTypeId).toString())) continue;
                String message = EASResource.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"118_EvaluFormSolutionContractTemplateEditUI");
                Object[] variables = new Object[]{multiTableNameMap.get(firstTypeMap.get(firstTypeId).toString()), multiTableNameMap.get(curMultiTableId), currTable.getHeadRow(0).getCell("type").getValue().toString()};
                message = MessageFormat.format(message, variables);
                MsgBox.showInfo((String)message);
                SysUtil.abort();
            }
        }
    }
}

