/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.EvaluFormSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionSumCollection;
import com.kingdee.eas.hr.perf.EvaluFormSolutionSumFactory;
import com.kingdee.eas.hr.perf.EvaluFormSolutionSumInfo;
import com.kingdee.eas.hr.perf.PerfModeEnum;
import com.kingdee.eas.hr.perf.RefPerfResultEnum;
import com.kingdee.eas.hr.perf.client.AbstractEvaluFormSolutionSumUI;
import com.kingdee.eas.hr.perf.client.IEvaluFormSolutionUI;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.train.client.TableActionHandler;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class EvaluFormSolutionSumUI
extends AbstractEvaluFormSolutionSumUI
implements IEvaluFormSolutionUI {
    private static final Logger logger = CoreUIObject.getLogger(EvaluFormSolutionSumUI.class);
    private KDComboBox box;
    private KDBizPromptBox prmtSp;
    private KDBizPromptBox prmtObj;
    private TablePropertyChangeListener propChangeListener;
    private String efsId;

    public void onLoad() throws Exception {
        this.efsId = this.getUIContext().get("ID").toString();
        this.propChangeListener = new TablePropertyChangeListener();
        this.kdtData.checkParsed();
        this.kdtScore.checkParsed();
        this.initUI();
        super.onLoad();
        this.setCellState();
    }

    private void initUI() {
        TrainUtils.addButtonsToMutilTable((KDContainer)this.contData, (KDTable)this.kdtData, (TableActionHandler)new TableAction());
        TrainUtils.addButtonsToMutilTable((KDContainer)this.contScore, (KDTable)this.kdtScore);
        this.box = new KDComboBox();
        this.box.addItems(RefPerfResultEnum.getEnumList().toArray());
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)this.box);
        this.kdtData.getColumn("perfType").setEditor((ICellEditor)cellEditor);
        this.box.addActionListener((ActionListener)new PerfTypeSelectChangeListener());
        this.prmtSp = new KDBizPromptBox();
        this.prmtSp.addDataChangeListener((DataChangeListener)new PrmtSpChangeListener());
        KDTDefaultCellEditor prmtSp_cellEditor = new KDTDefaultCellEditor((IKDEditor)this.prmtSp);
        this.kdtData.getColumn("sp").setEditor((ICellEditor)prmtSp_cellEditor);
        this.prmtSp.setEditable(false);
        this.prmtObj = new KDBizPromptBox();
        KDTDefaultCellEditor prmtObj_cellEditor = new KDTDefaultCellEditor((IKDEditor)this.prmtObj);
        this.kdtData.getColumn("obj").setEditor((ICellEditor)prmtObj_cellEditor);
        this.prmtObj.setEditable(false);
        PerfClientUtils.setCellNumberEditor(this.kdtData, "weight", 0, 0, 0, 100);
        PerfClientUtils.setCellTextEditor(this.kdtData, "title", 0, 200);
        PerfClientUtils.setCellTextEditor(this.kdtScore, "name", 0, 200);
        this.prmtPer.setQueryInfo("com.kingdee.eas.hr.perf.app.AssessPeriodQuery");
        this.prmtPer.setEditable(false);
        this.kdtData.addKDTPropertyChangeListener((KDTPropertyChangeListener)this.propChangeListener);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.kdtData.removeKDTPropertyChangeListener((KDTPropertyChangeListener)this.propChangeListener);
        int j = this.kdtData.getRowCount();
        for (int i = 0; i < j; ++i) {
            this.kdtData.getCell(i, "sp").setValue(this.kdtData.getCell(i, "spName").getValue());
            this.kdtData.getCell(i, "obj").setValue(this.kdtData.getCell(i, "objName").getValue());
        }
        this.kdtData.addKDTPropertyChangeListener((KDTPropertyChangeListener)this.propChangeListener);
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("efSolution.id", (Object)this.efsId));
        evi.setSelector(this.getMergedSelector());
        evi.setFilter(fi);
        EvaluFormSolutionSumCollection coll = EvaluFormSolutionSumFactory.getRemoteInstance().getEvaluFormSolutionSumCollection(evi);
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return this.createNewData();
    }

    @Override
    public void secondLoad() throws Exception {
    }

    @Override
    public void submit() throws Exception {
        ActionEvent evt = new ActionEvent(this.btnSubmit, 0, "Double Clicked");
        ItemAction actSmt = this.getActionFromActionEvent(evt);
        actSmt.actionPerformed(evt);
        this.getUIContext().put("ID", this.efsId);
    }

    @Override
    public void verifyInput() throws Exception {
    }

    private void prmtSp_dataChanged(DataChangeEvent e) {
        if (!(this.prmtSp.getValue() instanceof CoreBaseInfo) || this.prmtSp.getValue() == null) {
            return;
        }
        CoreBaseInfo value = (CoreBaseInfo)this.prmtSp.getValue();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        RefPerfResultEnum pm = (RefPerfResultEnum)((Object)this.box.getSelectedItem());
        String spId = value.getId().toString();
        if (PerfModeEnum.personTarget.equals((Object)pm)) {
            fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)spId));
        } else if (PerfModeEnum.personMulti.equals((Object)pm)) {
            this.prmtObj.setEntityViewInfo(null);
            fi.getFilterItems().add(new FilterItemInfo("MDSolutionPeriod.id", (Object)spId));
        } else if (PerfModeEnum.orgTarget.equals((Object)pm)) {
            fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)spId));
        } else if (PerfModeEnum.complex.equals((Object)pm)) {
            fi.getFilterItems().add(new FilterItemInfo("synSolutionPeriod.id", (Object)spId));
        }
        this.prmtObj.setEntityViewInfo(evi);
    }

    private void setCellState() {
        int j = this.kdtData.getRowCount();
        for (int i = 0; i < j; ++i) {
            IRow row = this.kdtData.getRow(i);
            Object perfType = row.getCell("perfType").getValue();
            row.getCell("sp").getStyleAttributes().setLocked(perfType == null);
            row.getCell("obj").getStyleAttributes().setLocked(perfType == null);
            if (perfType == null) continue;
            Object sp = row.getCell("sp").getValue();
            row.getCell("obj").getStyleAttributes().setLocked(sp == null);
        }
    }

    private void kdtData_propertyChange(KDTPropertyChangeEvent evt) {
        int row_idx = evt.getRowIndex();
        int col_idx = evt.getColIndex();
        IColumn col = this.kdtData.getColumn(col_idx);
        if ("perfType".equals(col.getKey())) {
            Object perfType = this.kdtData.getCell(row_idx, "perfType").getValue();
            Object sp = this.kdtData.getCell(row_idx, "sp").getValue();
            this.kdtData.getCell(row_idx, "sp").getStyleAttributes().setLocked(perfType == null);
            this.kdtData.getCell(row_idx, "obj").getStyleAttributes().setLocked(sp == null);
            this.box.setSelectedItem(perfType);
            this.kdtData.getCell(row_idx, "sp").setValue(null);
            this.kdtData.getCell(row_idx, "obj").setValue(null);
        } else if ("sp".equals(col.getKey())) {
            Object sp = this.kdtData.getCell(row_idx, "sp").getValue();
            this.kdtData.getCell(row_idx, "obj").getStyleAttributes().setLocked(sp == null);
            if (sp != null) {
                if (sp instanceof CoreBaseInfo) {
                    CoreBaseInfo ci = (CoreBaseInfo)sp;
                    this.kdtData.getCell(row_idx, "spId").setValue((Object)ci.getId().toString());
                    this.kdtData.getCell(row_idx, "spName").setValue(ci.get("name"));
                    this.kdtData.getCell(row_idx, "obj").setValue(null);
                }
            } else {
                this.kdtData.getCell(row_idx, "spId").setValue(null);
            }
        } else if ("obj".equals(col.getKey())) {
            Object obj = this.kdtData.getCell(row_idx, "obj").getValue();
            if (obj != null) {
                if (obj instanceof CoreBaseInfo) {
                    CoreBaseInfo ci = (CoreBaseInfo)obj;
                    this.kdtData.getCell(row_idx, "objId").setValue((Object)ci.getId().toString());
                    this.kdtData.getCell(row_idx, "objName").setValue(ci.get("name"));
                }
            } else {
                this.kdtData.getCell(row_idx, "objId").setValue(null);
            }
        }
    }

    protected IObjectValue createNewData() {
        EvaluFormSolutionSumInfo info = new EvaluFormSolutionSumInfo();
        String efsId = this.getUIContext().get("ID").toString();
        EvaluFormSolutionInfo sInfo = new EvaluFormSolutionInfo();
        sInfo.setId(BOSUuid.read((String)efsId));
        info.setEfSolution(sInfo);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EvaluFormSolutionSumFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("efSolution.id"));
        sic.add(new SelectorItemInfo("perfResultEntry.*"));
        sic.add(new SelectorItemInfo("leaderEntry.*"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("period.name"));
        return sic;
    }

    private class TablePropertyChangeListener
    implements KDTPropertyChangeListener {
        private TablePropertyChangeListener() {
        }

        public void propertyChange(KDTPropertyChangeEvent evt) {
            EvaluFormSolutionSumUI.this.kdtData_propertyChange(evt);
        }
    }

    private class TableAction
    implements TableActionHandler {
        public IRow afterAddLine(IRow row) {
            if (row != null) {
                row.getCell("sp").getStyleAttributes().setLocked(true);
                row.getCell("obj").getStyleAttributes().setLocked(true);
            }
            return row;
        }

        public IRow afterInsertLine(IRow row) {
            if (row != null) {
                row.getCell("sp").getStyleAttributes().setLocked(true);
                row.getCell("obj").getStyleAttributes().setLocked(true);
            }
            return row;
        }
    }

    private class PrmtSpChangeListener
    implements DataChangeListener {
        private PrmtSpChangeListener() {
        }

        public void dataChanged(DataChangeEvent e) {
            try {
                EvaluFormSolutionSumUI.this.prmtSp_dataChanged(e);
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
        }
    }

    private class PerfTypeSelectChangeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            RefPerfResultEnum type = (RefPerfResultEnum)((Object)EvaluFormSolutionSumUI.this.box.getSelectedItem());
            if (type == null) {
                return;
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            switch (type.getValue()) {
                case 4: {
                    EvaluFormSolutionSumUI.this.prmtSp.setEntityViewInfo(null);
                    EvaluFormSolutionSumUI.this.prmtSp.setQueryInfo("com.kingdee.eas.hr.perf.app.SynSolutionPeriodF7Query");
                    fi.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(102)));
                    evi.setFilter(fi);
                    EvaluFormSolutionSumUI.this.prmtSp.setEntityViewInfo(evi);
                    EvaluFormSolutionSumUI.this.prmtObj.setQueryInfo("com.kingdee.eas.hr.perf.app.SynObjectSPQuery");
                    EvaluFormSolutionSumUI.this.prmtObj.setDisplayFormat("$person.name$");
                    break;
                }
                case 3: {
                    EvaluFormSolutionSumUI.this.prmtSp.setEntityViewInfo(null);
                    EvaluFormSolutionSumUI.this.prmtSp.setQueryInfo("com.kingdee.eas.hr.perf.app.SolutionPeriodOverForOrgQuery");
                    EvaluFormSolutionSumUI.this.prmtObj.setQueryInfo("com.kingdee.eas.hr.perf.app.EvaluObjectOrgResultSPQuery");
                    EvaluFormSolutionSumUI.this.prmtObj.setDisplayFormat("$name$");
                    break;
                }
                case 2: {
                    EvaluFormSolutionSumUI.this.prmtObj.setSelector(null);
                    EvaluFormSolutionSumUI.this.prmtSp.setEntityViewInfo(null);
                    EvaluFormSolutionSumUI.this.prmtSp.setQueryInfo("com.kingdee.eas.hr.perf.app.MDSolutionPeriodF7Query");
                    fi.getFilterItems().add(new FilterItemInfo("SPStatuEnum", (Object)new Integer(102)));
                    evi.setFilter(fi);
                    EvaluFormSolutionSumUI.this.prmtSp.setEntityViewInfo(evi);
                    EvaluFormSolutionSumUI.this.prmtObj.setQueryInfo("com.kingdee.eas.hr.perf.app.MDObjectSPQuery");
                    EvaluFormSolutionSumUI.this.prmtObj.setDisplayFormat("$person.name$");
                    break;
                }
                case 1: {
                    EvaluFormSolutionSumUI.this.prmtSp.setQueryInfo("com.kingdee.eas.hr.perf.app.SolutionPeriodOverForPersonQuery");
                    fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
                    evi.setFilter(fi);
                    EvaluFormSolutionSumUI.this.prmtSp.setEntityViewInfo(evi);
                    EvaluFormSolutionSumUI.this.prmtObj.setQueryInfo("com.kingdee.eas.hr.perf.app.EvaluObjectPersonResultSPQuery");
                    EvaluFormSolutionSumUI.this.prmtObj.setDisplayFormat("$name$");
                    break;
                }
            }
        }
    }
}

