/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.EvaluGroupInfo;
import com.kingdee.eas.hr.perf.EvaluGroupObjectCollection;
import com.kingdee.eas.hr.perf.EvaluGroupObjectFactory;
import com.kingdee.eas.hr.perf.EvaluGroupObjectInfo;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.IEvaluGroupObject;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.client.AbstractEvaluGroupObjectOrgUnitUI;
import com.kingdee.eas.hr.perf.client.EvaluObjectOrgUnitListUI;
import com.kingdee.eas.hr.perf.client.IEvaluSolutionUI;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.ProgDialog;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class EvaluGroupObjectOrgUnitUI
extends AbstractEvaluGroupObjectOrgUnitUI
implements IEvaluSolutionUI {
    private static final long serialVersionUID = 1L;
    private String evaluGroupId;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblObject.checkParsed();
        this.tblObject.getSelectManager().setSelectMode(10);
        PerfUtils.setKDTableSortable(this.tblObject);
        this.evaluGroupId = (String)this.getUIContext().get("EvaluGroupID");
        this.loadData(this.evaluGroupId);
    }

    private void loadData(String id) throws Exception {
        if (id == null) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)id));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("evaluObject.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluObject.objectID"));
        evi.getSelector().add(new SelectorItemInfo("evaluObject.number"));
        evi.getSelector().add(new SelectorItemInfo("evaluObject.name"));
        evi.getSelector().add(new SelectorItemInfo("evaluObject.simpleName"));
        evi.getSelector().add(new SelectorItemInfo("evaluObject.responser.name"));
        EvaluGroupObjectCollection coll = EvaluGroupObjectFactory.getRemoteInstance().getEvaluGroupObjectCollection(evi);
        this.tblObject.removeRows();
        this.fillTable(coll);
    }

    @Override
    public void secondLoad() throws Exception {
    }

    public void addObject() throws Exception {
        String solutionPeriodId;
        String evaluGroupId;
        String evaluSolutionId = (String)this.getUIContext().get("ID");
        final List idList = EvaluObjectOrgUnitListUI.showDialogWindows((IUIObject)this, evaluSolutionId, evaluGroupId = (String)this.getUIContext().get("EvaluGroupID"), solutionPeriodId = (String)this.getUIContext().get("SolutionPeriodID"));
        if (idList == null) {
            return;
        }
        if (idList.size() > 80) {
            IProgTask prog = new IProgTask(){

                @Override
                public Object exec() throws Exception {
                    EvaluGroupObjectOrgUnitUI.this.dealAddObject(idList);
                    return "";
                }

                @Override
                public void afterExec(Object result) throws Exception {
                }
            };
            ProgDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new ProgDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new ProgDialog((Dialog)win);
            }
            dialog.setLongTimeTask(prog);
            dialog.show();
        } else {
            this.dealAddObject(idList);
        }
    }

    private void dealAddObject(List idList) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < idList.size(); ++i) {
            String id = (String)idList.get(i);
            boolean isRefered = false;
            for (int j = 0; j < this.tblObject.getRowCount(); ++j) {
                String objectId = this.tblObject.getRow(j).getCell("objectId").getValue().toString();
                if (!id.equals(objectId)) continue;
                isRefered = true;
                break;
            }
            if (isRefered) continue;
            idSet.add(id);
        }
        if (idSet.size() != 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)((String)this.getUIContext().get("ID"))));
            EvaluGroupObjectCollection coll = this.getEvaluGroupObjectCollection(this.getRowSet(fi));
            this.fillTable(coll);
            this.submit();
        }
    }

    private EvaluGroupObjectCollection getEvaluGroupObjectCollection(IRowSet rowSet) throws Exception {
        EvaluGroupObjectCollection coll = new EvaluGroupObjectCollection();
        EvaluGroupObjectInfo info = null;
        EvaluObjectInfo evaluObjectInfo = null;
        EvaluGroupInfo evaluGroupInfo = new EvaluGroupInfo();
        evaluGroupInfo.setId(BOSUuid.read((String)this.evaluGroupId));
        while (rowSet.next()) {
            info = new EvaluGroupObjectInfo();
            evaluObjectInfo = new EvaluObjectInfo();
            evaluObjectInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
            evaluObjectInfo.setNumber(rowSet.getString("number"));
            evaluObjectInfo.setName(rowSet.getString("name"));
            PersonInfo personInfo = new PersonInfo();
            personInfo.setName(rowSet.getString("responser.name"));
            evaluObjectInfo.setResponser(personInfo);
            evaluObjectInfo.setSimpleName(rowSet.getString("simpleName"));
            info.setEvaluObject(evaluObjectInfo);
            info.setEvaluGroup(evaluGroupInfo);
            coll.add(info);
        }
        return coll;
    }

    private IRowSet getRowSet(FilterInfo fi) throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "EvaluGroupObjectOrgUnitQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    private void fillTable(EvaluGroupObjectCollection coll) throws Exception {
        EvaluGroupObjectInfo info = null;
        EvaluObjectInfo evaluObjectInfo = null;
        IRow row = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            evaluObjectInfo = info.getEvaluObject();
            row = this.tblObject.addRow();
            row.setUserObject((Object)info);
            if (info.getId() != null) {
                row.getCell("id").setValue((Object)info.getId().toString());
            }
            row.getCell("objectId").setValue((Object)evaluObjectInfo.getId().toString());
            row.getCell("number").setValue((Object)evaluObjectInfo.getNumber());
            row.getCell("name").setValue((Object)evaluObjectInfo.getName());
            row.getCell("longName").setValue((Object)evaluObjectInfo.getSimpleName());
            if (evaluObjectInfo.getResponser() == null) continue;
            row.getCell("responser").setValue((Object)evaluObjectInfo.getResponser().getName());
        }
    }

    public void delObject() throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblObject);
        if (this.confirmRemove()) {
            final List rowIndexList = PFUtils.getSelectedRows(this.tblObject);
            Arrays.sort(rowIndexList.toArray());
            if (rowIndexList.size() > 80) {
                IProgTask prog = new IProgTask(){

                    @Override
                    public Object exec() throws Exception {
                        EvaluGroupObjectOrgUnitUI.this.dealDelObject(rowIndexList);
                        return "";
                    }

                    @Override
                    public void afterExec(Object result) throws Exception {
                    }
                };
                ProgDialog dialog = null;
                Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
                if (win instanceof Frame) {
                    dialog = new ProgDialog((Frame)win);
                } else if (win instanceof Dialog) {
                    dialog = new ProgDialog((Dialog)win);
                }
                dialog.setLongTimeTask(prog);
                dialog.show();
            } else {
                this.dealDelObject(rowIndexList);
            }
        }
    }

    private void dealDelObject(List rowIndexList) throws BOSException, EASBizException {
        IRow row = null;
        HashMap<String, String> map = null;
        ArrayList idList = new ArrayList();
        for (int i = rowIndexList.size() - 1; i >= 0; --i) {
            int selectedRow = (Integer)rowIndexList.get(i);
            row = this.tblObject.getRow(selectedRow);
            String id = (String)row.getCell("id").getValue();
            this.tblObject.removeRow(selectedRow);
            if (id == null) continue;
            String solutionPeriodId = (String)this.getUIContext().get("SolutionPeriodID");
            String evaluObjectId = ((EvaluGroupObjectInfo)row.getUserObject()).getEvaluObject().getId().toString();
            if (solutionPeriodId == null || evaluObjectId == null) continue;
            map = new HashMap<String, String>();
            map.put("SPID", solutionPeriodId);
            map.put("EOID", evaluObjectId);
            map.put("EGOID", id);
            idList.add(map);
        }
        if (idList.size() != 0) {
            IEvaluGroupObject object = EvaluGroupObjectFactory.getRemoteInstance();
            object.delete(idList);
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    @Override
    public void submit() throws Exception {
        IEvaluGroupObject evaluGroupObject = EvaluGroupObjectFactory.getRemoteInstance();
        EvaluGroupObjectCollection coll = new EvaluGroupObjectCollection();
        IRow row = null;
        int size = this.tblObject.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblObject.getRow(i);
            if (row.getCell("id").getValue() != null) continue;
            EvaluGroupObjectInfo info = (EvaluGroupObjectInfo)row.getUserObject();
            EvaluGroupInfo evaluGroupInfo = new EvaluGroupInfo();
            evaluGroupInfo.setId(BOSUuid.read((String)this.evaluGroupId));
            info.setEvaluGroup(evaluGroupInfo);
            coll.add(info);
        }
        if (coll.size() == 0) {
            return;
        }
        Map idMap = evaluGroupObject.submitBatchGroupObject(coll);
        int size2 = this.tblObject.getRowCount();
        for (int i = 0; i < size2; ++i) {
            row = this.tblObject.getRow(i);
            String objectId = (String)row.getCell("objectId").getValue();
            if (idMap.get(objectId) == null) continue;
            row.getCell("id").setValue(idMap.get(objectId));
        }
    }

    @Override
    public void verifyInput() throws Exception {
    }

    public KDTable getTable() {
        return this.tblObject;
    }
}

