/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.EvaluGroupInfo;
import com.kingdee.eas.hr.perf.EvaluGroupObjectCollection;
import com.kingdee.eas.hr.perf.EvaluGroupObjectFactory;
import com.kingdee.eas.hr.perf.EvaluGroupObjectInfo;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.IEvaluGroupObject;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.client.AbstractEvaluGroupObjectUI;
import com.kingdee.eas.hr.perf.client.EvaluObjectListUI;
import com.kingdee.eas.hr.perf.client.IEvaluSolutionUI;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.ProgDialog;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class EvaluGroupObjectUI
extends AbstractEvaluGroupObjectUI
implements IEvaluSolutionUI {
    private static final long serialVersionUID = 1L;
    private String evaluGroupId;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblObject.checkParsed();
        this.tblObject.getSelectManager().setSelectMode(10);
        PerfUtils.setKDTableSortable(this.tblObject);
        this.evaluGroupId = (String)this.getUIContext().get("EvaluGroupID");
        this.loadData(this.evaluGroupId);
    }

    private void loadData(String id) throws Exception {
        if (id == null) {
            return;
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "EvaluGroupPersonQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        CacheServiceFactory.getInstance().discardQuery((IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        evi.setFilter(fi);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        EvaluGroupObjectCollection coll = new EvaluGroupObjectCollection();
        EvaluGroupObjectInfo info = null;
        EvaluObjectInfo oInfo = null;
        AdminOrgUnitInfo admin = null;
        PositionInfo position = null;
        String positionId = null;
        String adminUnitId = null;
        while (rowSet.next()) {
            info = new EvaluGroupObjectInfo();
            info.setId(BOSUuid.read((String)rowSet.getString("EvaluGroupObject.id")));
            oInfo = new EvaluObjectInfo();
            oInfo.setId(BOSUuid.read((String)rowSet.getString("EvaluObject.id")));
            oInfo.setName(rowSet.getString("Person.name"));
            oInfo.setNumber(rowSet.getString("Person.number"));
            info.setEvaluObject(oInfo);
            position = new PositionInfo();
            positionId = rowSet.getString("position.id");
            if (positionId != null) {
                position.setId(BOSUuid.read((String)positionId));
                position.setName(rowSet.getString("position.name"));
            }
            oInfo.setPosition(position);
            admin = new AdminOrgUnitInfo();
            adminUnitId = rowSet.getString("adminOrgUnit.id");
            if (adminUnitId != null) {
                admin.setId(BOSUuid.read((String)adminUnitId));
                admin.setName(rowSet.getString("adminOrgUnit.name"));
                admin.setDisplayName(rowSet.getString("adminOrgUnit.displayName"));
            }
            position.setAdminOrgUnit(admin);
            coll.add(info);
        }
        this.tblObject.removeRows();
        this.fillTable(coll, true);
    }

    @Override
    public void secondLoad() throws Exception {
    }

    public void addObject() throws Exception {
        String solutionPeriodId;
        String evaluGroupId;
        String evaluSolutionId = (String)this.getUIContext().get("ID");
        final List idList = EvaluObjectListUI.showDialogWindows((IUIObject)this, evaluSolutionId, evaluGroupId = (String)this.getUIContext().get("EvaluGroupID"), solutionPeriodId = (String)this.getUIContext().get("SolutionPeriodID"));
        if (idList == null) {
            return;
        }
        if (idList.size() > 80) {
            IProgTask prog = new IProgTask(){

                @Override
                public Object exec() throws Exception {
                    EvaluGroupObjectUI.this.dealAddObject(idList);
                    return "";
                }

                @Override
                public void afterExec(Object result) throws Exception {
                }
            };
            ProgDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new ProgDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new ProgDialog((Dialog)win);
            }
            dialog.setLongTimeTask(prog);
            dialog.show();
        } else {
            this.dealAddObject(idList);
        }
    }

    private void dealAddObject(List idList) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            String id = (String)idList.get(i);
            boolean isRefered = false;
            for (int j = 0; j < this.tblObject.getRowCount(); ++j) {
                String objectId = this.tblObject.getRow(j).getCell("objectId").getValue().toString();
                if (!id.equals(objectId)) continue;
                isRefered = true;
                break;
            }
            if (isRefered) continue;
            idSet.add(id);
        }
        if (idSet.size() != 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("deleted", (Object)Boolean.FALSE));
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)((String)this.getUIContext().get("ID"))));
            EvaluGroupObjectCollection coll = this.getEvaluGroupObjectCollection(this.getRowSet(fi));
            this.fillTable(coll, false);
            this.submit();
        }
    }

    private EvaluGroupObjectCollection getEvaluGroupObjectCollection(IRowSet rowSet) throws Exception {
        EvaluGroupObjectCollection coll = new EvaluGroupObjectCollection();
        EvaluGroupObjectInfo info = null;
        EvaluObjectInfo evaluObjectInfo = null;
        EvaluGroupInfo evaluGroupInfo = new EvaluGroupInfo();
        evaluGroupInfo.setId(BOSUuid.read((String)this.evaluGroupId));
        while (rowSet.next()) {
            info = new EvaluGroupObjectInfo();
            evaluObjectInfo = new EvaluObjectInfo();
            evaluObjectInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
            evaluObjectInfo.setNumber(rowSet.getString("number"));
            evaluObjectInfo.setName(rowSet.getString("name"));
            PositionInfo positionInfo = new PositionInfo();
            positionInfo.setName(rowSet.getString("position.name"));
            evaluObjectInfo.setPosition(positionInfo);
            info.setEvaluObject(evaluObjectInfo);
            info.setEvaluGroup(evaluGroupInfo);
            info.setDescription(rowSet.getString("orgUnit.name"));
            coll.add(info);
        }
        return coll;
    }

    private IRowSet getRowSet(FilterInfo fi) throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "EvaluGroupObjectQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    private void fillTable(EvaluGroupObjectCollection coll, boolean isLoad) throws Exception {
        EvaluGroupObjectInfo info = null;
        EvaluObjectInfo evaluObjectInfo = null;
        IRow row = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            evaluObjectInfo = info.getEvaluObject();
            row = this.tblObject.addRow();
            row.setUserObject((Object)info);
            if (info.getId() != null) {
                row.getCell("id").setValue((Object)info.getId().toString());
            }
            row.getCell("objectId").setValue((Object)evaluObjectInfo.getId().toString());
            row.getCell("number").setValue((Object)evaluObjectInfo.getNumber());
            row.getCell("name").setValue((Object)evaluObjectInfo.getName());
            PositionInfo positionInfo = evaluObjectInfo.getPosition();
            if (positionInfo != null) {
                row.getCell("position").setValue((Object)positionInfo.getName());
                AdminOrgUnitInfo orgUnitInfo = positionInfo.getAdminOrgUnit();
                if (orgUnitInfo != null) {
                    row.getCell("orgUnit").setValue((Object)orgUnitInfo.getName());
                }
            }
            if (isLoad) continue;
            row.getCell("orgUnit").setValue((Object)info.getDescription());
        }
    }

    public void delObject() throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblObject);
        if (this.confirmRemove()) {
            final List rowIndexList = PFUtils.getSelectedRows(this.tblObject);
            Arrays.sort(rowIndexList.toArray());
            if (rowIndexList.size() > 80) {
                IProgTask prog = new IProgTask(){

                    @Override
                    public Object exec() throws Exception {
                        EvaluGroupObjectUI.this.dealDelObject(rowIndexList);
                        return "";
                    }

                    @Override
                    public void afterExec(Object result) throws Exception {
                    }
                };
                ProgDialog dialog = null;
                Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
                if (win instanceof Frame) {
                    dialog = new ProgDialog((Frame)win);
                } else if (win instanceof Dialog) {
                    dialog = new ProgDialog((Dialog)win);
                }
                dialog.setLongTimeTask(prog);
                dialog.show();
            } else {
                this.dealDelObject(rowIndexList);
            }
        }
    }

    private void dealDelObject(List rowIndexList) throws BOSException, EASBizException {
        IRow row = null;
        HashMap<String, String> map = null;
        ArrayList idList = new ArrayList();
        for (int i = rowIndexList.size() - 1; i >= 0; --i) {
            int selectedRow = (Integer)rowIndexList.get(i);
            row = this.tblObject.getRow(selectedRow);
            String id = (String)row.getCell("id").getValue();
            this.tblObject.removeRow(selectedRow);
            if (id == null) continue;
            String solutionPeriodId = (String)this.getUIContext().get("SolutionPeriodID");
            String evaluObjectId = ((EvaluGroupObjectInfo)row.getUserObject()).getEvaluObject().getId().toString();
            if (solutionPeriodId == null || evaluObjectId == null) continue;
            map = new HashMap<String, String>();
            map.put("SPID", solutionPeriodId);
            map.put("EOID", evaluObjectId);
            map.put("EGOID", id);
            idList.add(map);
        }
        if (idList.size() != 0) {
            IEvaluGroupObject object = EvaluGroupObjectFactory.getRemoteInstance();
            object.delete(idList);
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    @Override
    public void submit() throws Exception {
        IEvaluGroupObject evaluGroupObject = EvaluGroupObjectFactory.getRemoteInstance();
        EvaluGroupObjectCollection coll = new EvaluGroupObjectCollection();
        IRow row = null;
        int size = this.tblObject.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblObject.getRow(i);
            if (row.getCell("id").getValue() != null) continue;
            EvaluGroupObjectInfo info = (EvaluGroupObjectInfo)row.getUserObject();
            EvaluGroupInfo evaluGroupInfo = new EvaluGroupInfo();
            evaluGroupInfo.setId(BOSUuid.read((String)this.evaluGroupId));
            info.setEvaluGroup(evaluGroupInfo);
            coll.add(info);
        }
        if (coll.size() == 0) {
            return;
        }
        Map idMap = evaluGroupObject.submitBatchGroupObject(coll);
        int size2 = this.tblObject.getRowCount();
        for (int i = 0; i < size2; ++i) {
            row = this.tblObject.getRow(i);
            String objectId = (String)row.getCell("objectId").getValue();
            if (idMap.get(objectId) == null) continue;
            row.getCell("id").setValue(idMap.get(objectId));
        }
    }

    @Override
    public void verifyInput() throws Exception {
    }

    public KDTable getTable() {
        return this.tblObject;
    }
}

