/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.perf.EvaluGroupTargetCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetInfo;
import com.kingdee.eas.hr.perf.EvaluTargetInfo;
import com.kingdee.eas.hr.perf.client.AbstractEvaluGroupSetTargetWeightUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class EvaluGroupSetTargetWeightUI
extends AbstractEvaluGroupSetTargetWeightUI {
    private static final long serialVersionUID = 1L;
    private String resourcePath = "com.kingdee.eas.hr.perf.EvaluSolutionResource";
    private Map weightMap;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getColumn("weight").getStyleAttributes().setLocked(false);
        PFUtils.setTableCellEditorByFormattedTextField(this.tblMain, "weight", 2);
        PFUtils.setTableNumberFormat(this.tblMain, "weight", 2);
        this.fillTable();
        if (this.tblMain.getRowCount() != 0) {
            this.tblMain.getEditManager().editCellAt(0, this.tblMain.getColumnIndex("weight"));
        }
    }

    private void fillTable() {
        EvaluGroupTargetCollection groupTargetColl = (EvaluGroupTargetCollection)((Object)this.getUIContext().get("TargetCollection"));
        EvaluGroupTargetInfo groupTargetInfo = null;
        EvaluTargetInfo targetInfo = null;
        int size = groupTargetColl.size();
        for (int i = 0; i < size; ++i) {
            groupTargetInfo = groupTargetColl.get(i);
            targetInfo = groupTargetInfo.getEvaluTarget();
            IRow row = this.tblMain.addRow();
            row.getCell("targetId").setValue((Object)targetInfo.getTargetID().toString());
            row.getCell("number").setValue((Object)targetInfo.getNumber());
            row.getCell("content").setValue((Object)targetInfo.getContent());
            row.getCell("standard").setValue((Object)targetInfo.getStandard());
            row.getCell("weight").setValue((Object)groupTargetInfo.getWeight());
        }
    }

    public Map getWeightMap() {
        return this.weightMap;
    }

    public void setWeightMap(Map weightMap) {
        this.weightMap = weightMap;
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        super.btnConfirm_actionPerformed(e);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            String key = (String)row.getCell("targetId").getValue();
            BigDecimal value = (BigDecimal)row.getCell("weight").getValue();
            if (key == null) continue;
            map.put(key, value);
        }
        this.setWeightMap(map);
        this.disposeUIWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    public static Map showDialogWindows(IUIObject ui, EvaluGroupTargetCollection targetColl) throws Exception {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"TargetCollection", (Object)targetColl);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EvaluGroupSetTargetWeightUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        EvaluGroupSetTargetWeightUI tableUI = (EvaluGroupSetTargetWeightUI)uiWindow.getUIObject();
        return tableUI.getWeightMap();
    }

    private void verifyInput() {
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            BigDecimal weight = (BigDecimal)row.getCell("weight").getValue();
            if (weight.compareTo(new BigDecimal("100")) != 1 && weight.compareTo(new BigDecimal("0")) != -1) continue;
            this.tblMain.getEditManager().editCellAt(row.getRowIndex(), this.tblMain.getColumnIndex("weight"));
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"WeightOutOfScope"));
            SysUtil.abort();
        }
    }
}

