/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.perf.AssessPeriodInfo;
import com.kingdee.eas.hr.perf.EvaluGroupInfo;
import com.kingdee.eas.hr.perf.EvaluGroupTargetCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetInfo;
import com.kingdee.eas.hr.perf.EvaluGroupTargetTypeCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetTypeInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluTargetInfo;
import com.kingdee.eas.hr.perf.IEvaluGroupTarget;
import com.kingdee.eas.hr.perf.IEvaluGroupTargetType;
import com.kingdee.eas.hr.perf.PerformTargetTypeInfo;
import com.kingdee.eas.hr.perf.client.AbstractEvaluGroupTargetCopyUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;

public class EvaluGroupTargetCopyUI
extends AbstractEvaluGroupTargetCopyUI {
    private static final long serialVersionUID = 1L;
    private Map map;
    private EvaluGroupTargetTypeCollection typeColl;
    private EvaluGroupTargetCollection targetColl;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblType.checkParsed();
        this.tblTarget.checkParsed();
        EvaluSolutionHelper.initAssessPeriod(this.comboAssessPeriod);
    }

    @Override
    protected void comboEvaluSolution_actionPerformed(ActionEvent e) throws Exception {
        super.comboEvaluSolution_actionPerformed(e);
        this.comboEvaluGroup.removeAllItems();
        if (this.comboAssessPeriod.getSelectedItem() != null && this.comboEvaluSolution.getSelectedItem() != null) {
            this.comboEvaluGroup.setEnabled(true);
            String assessPeriodId = ((AssessPeriodInfo)this.comboAssessPeriod.getSelectedItem()).getId().toString();
            EvaluSolutionInfo solutionInfo = (EvaluSolutionInfo)this.comboEvaluSolution.getSelectedItem();
            String evaluSolutionId = solutionInfo.getId().toString();
            EvaluSolutionHelper.initEvaluGroup(this.comboEvaluGroup, evaluSolutionId, assessPeriodId);
            this.tblType.getColumn("weight").getStyleAttributes().setHided(solutionInfo.getAllocateTarget() == 1);
            this.tblTarget.getColumn("weight").getStyleAttributes().setHided(solutionInfo.getAllocateTarget() == 1);
        } else {
            this.tblType.getColumn("weight").getStyleAttributes().setHided(true);
            this.tblTarget.getColumn("weight").getStyleAttributes().setHided(true);
        }
        this.fillTable();
    }

    @Override
    protected void comboEvaluGroup_actionPerformed(ActionEvent e) throws Exception {
        super.comboEvaluGroup_actionPerformed(e);
        if (this.comboEvaluGroup.getSelectedItem() == null) {
            return;
        }
        this.fillTable();
    }

    private void fillTable() throws Exception {
        this.tblType.removeRows();
        this.tblTarget.removeRows();
        if (this.comboEvaluGroup.getSelectedItem() == null) {
            return;
        }
        String evaluGroupId = ((EvaluGroupInfo)this.comboEvaluGroup.getSelectedItem()).getId().toString();
        IEvaluGroupTargetType type = EvaluSolutionHelper.getEvaluGroupTargetType();
        IEvaluGroupTarget target = EvaluSolutionHelper.getEvaluGroupTarget();
        this.typeColl = type.getEvaluGroupTargetTypeCollection(this.getTargetTypeEntityViewInfo(evaluGroupId));
        this.targetColl = target.getEvaluGroupTargetCollection(this.getTargetEntityViewInfo(evaluGroupId));
        this.fillTable(this.typeColl);
        this.fillTable(this.targetColl);
    }

    private EntityViewInfo getTargetTypeEntityViewInfo(String evaluGroupId) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)evaluGroupId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("weight"));
        evi.getSelector().add(new SelectorItemInfo("performTargetType.id"));
        evi.getSelector().add(new SelectorItemInfo("performTargetType.parent.id"));
        evi.getSelector().add(new SelectorItemInfo("performTargetType.parent.name"));
        evi.getSelector().add(new SelectorItemInfo("performTargetType.number"));
        evi.getSelector().add(new SelectorItemInfo("performTargetType.name"));
        evi.getSelector().add(new SelectorItemInfo("performTargetType.createTime"));
        evi.getSelector().add(new SelectorItemInfo("performTargetType.longNumber"));
        return evi;
    }

    private EntityViewInfo getTargetEntityViewInfo(String evaluGroupId) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)evaluGroupId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("weight"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.targetID"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.number"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.content"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.standard"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.description"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.kind"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.thresholdValue"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.standardValue"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.challengeValue"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.unit"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.reportFrequency"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.scoringMethod"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.evaluationSide"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.reservedField1"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.reservedField2"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.type.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.type.name"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.type.longNumber"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.formula.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.formula.name"));
        return evi;
    }

    private void fillTable(EvaluGroupTargetCollection targetColl) {
        EvaluGroupTargetInfo evaluGroupTargetInfo = null;
        IRow row = null;
        int size = targetColl.size();
        for (int i = 0; i < size; ++i) {
            evaluGroupTargetInfo = targetColl.get(i);
            EvaluTargetInfo evaluTargetInfo = evaluGroupTargetInfo.getEvaluTarget();
            row = this.tblTarget.addRow();
            row.getCell("number").setValue((Object)evaluTargetInfo.getNumber());
            row.getCell("type").setValue((Object)evaluTargetInfo.getType());
            row.getCell("content").setValue((Object)evaluTargetInfo.getContent());
            row.getCell("standard").setValue((Object)evaluTargetInfo.getStandard());
            if (evaluGroupTargetInfo.getWeight() != null) {
                row.getCell("weight").setValue((Object)EvaluSolutionHelper.bigDecimal2PercentString(evaluGroupTargetInfo.getWeight()));
            }
            evaluTargetInfo.setId(null);
        }
    }

    private void fillTable(EvaluGroupTargetTypeCollection typeColl) {
        EvaluGroupTargetTypeInfo evaluGroupTargetTypeInfo = null;
        IRow row = null;
        int size = typeColl.size();
        for (int i = 0; i < size; ++i) {
            evaluGroupTargetTypeInfo = typeColl.get(i);
            PerformTargetTypeInfo performTargetTypeInfo = evaluGroupTargetTypeInfo.getPerformTargetType();
            row = this.tblType.addRow();
            row.getCell("number").setValue((Object)performTargetTypeInfo.getNumber());
            row.getCell("name").setValue((Object)performTargetTypeInfo.getName());
            if (evaluGroupTargetTypeInfo.getWeight() == null) continue;
            row.getCell("weight").setValue((Object)EvaluSolutionHelper.bigDecimal2PercentString(evaluGroupTargetTypeInfo.getWeight()));
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblTarget.getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource.noCopyTarget"));
            this.comboAssessPeriod.requestFocus();
            return;
        }
        super.btnConfirm_actionPerformed(e);
        this.map = new HashMap();
        this.map.put("TargetType", this.typeColl);
        this.map.put("Target", this.targetColl);
        this.disposeUIWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.map = null;
        this.disposeUIWindow();
    }

    public static Map showDialogWindows(IUIObject ui) throws Exception {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"EvaluSolutionType", ui.getUIContext().get("EvaluSolutionType"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EvaluGroupTargetCopyUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        EvaluGroupTargetCopyUI copyUI = (EvaluGroupTargetCopyUI)uiWindow.getUIObject();
        return copyUI.map;
    }
}

