/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.hr.perf.DeliverModeEnum;
import com.kingdee.eas.hr.perf.EvaluGroupInfo;
import com.kingdee.eas.hr.perf.EvaluGroupTargetCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetTypeCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetTypeFactory;
import com.kingdee.eas.hr.perf.EvaluGroupTargetTypeInfo;
import com.kingdee.eas.hr.perf.IEvaluGroupTargetType;
import com.kingdee.eas.hr.perf.IPerformTargetType;
import com.kingdee.eas.hr.perf.PerformTargetTypeCollection;
import com.kingdee.eas.hr.perf.PerformTargetTypeFactory;
import com.kingdee.eas.hr.perf.PerformTargetTypeInfo;
import com.kingdee.eas.hr.perf.client.AbstractEvaluGroupTargetTypeUI;
import com.kingdee.eas.hr.perf.client.EvaluGroupSetTargetTypeWeightUI;
import com.kingdee.eas.hr.perf.client.EvaluGroupTargetTypeTreeUI;
import com.kingdee.eas.hr.perf.client.EvaluGroupTargetUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.EvaluTargetOrderHelper;
import com.kingdee.eas.hr.perf.client.IEvaluSolutionUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;

public class EvaluGroupTargetTypeUI
extends AbstractEvaluGroupTargetTypeUI
implements IEvaluSolutionUI {
    private static final long serialVersionUID = 1L;
    private String evaluGroupId;
    private EvaluGroupTargetTypeCollection oldEvaluGroupTargetTypeCollection;
    private boolean isAllocateTarget = false;
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblType.checkParsed();
        this.tHelper.getDisabledTables().add(this.tblType);
        this.addCommonMenusToTable(this.tblType);
        this.tblType.getSelectManager().setSelectMode(10);
        this.evaluGroupId = (String)this.getUIContext().get("EvaluGroupID");
        this.isAllocateTarget = (Boolean)this.getUIContext().get("isAllocateTarget");
        PFUtils.setTableNumberFormat(this.tblType, "weight", 2);
        this.loadData(this.evaluGroupId);
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setMinimumValue((Comparable)new BigDecimal("0.00"));
        Boolean isControlWeight = (Boolean)this.getUIContext().get("isControlWeight");
        if (isControlWeight != null && isControlWeight.booleanValue()) {
            formattedTextField.setMaximumValue((Comparable)new BigDecimal("10000.00"));
        } else {
            formattedTextField.setMaximumValue((Comparable)new BigDecimal("100.00"));
        }
        formattedTextField.setDataVerifierType(12);
        PFUtils.setTableCellEditorByFormattedTextField(this.tblType, formattedTextField, "weight", 2);
        PFUtils.setTableNumberFormat(this.tblType, "weight", 2);
        if (this.isAllocateTarget && !DeliverModeEnum.TARGETTEMPLATEMODE.equals(this.getUIContext().get("deliverMode"))) {
            this.tblType.getColumn("weight").getStyleAttributes().setHided(true);
        }
        this.setQueryPreference(true);
    }

    private void loadData(String id) throws Exception {
        if (id == null) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)id));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("weight"));
        evi.getSelector().add(new SelectorItemInfo("performTargetType.id"));
        evi.getSelector().add(new SelectorItemInfo("performTargetType.number"));
        evi.getSelector().add(new SelectorItemInfo("performTargetType.name"));
        evi.getSelector().add(new SelectorItemInfo("performTargetType.parent.id"));
        evi.getSelector().add(new SelectorItemInfo("performTargetType.parent.name"));
        evi.getSelector().add(new SelectorItemInfo("isLeaf"));
        evi.getSelector().add(new SelectorItemInfo("performTargetType.longNumber"));
        evi.getSelector().add(new SelectorItemInfo("seqNumber"));
        evi.getSorter().add(new SorterItemInfo("seqNumber"));
        evi.getSorter().add(new SorterItemInfo("performTargetType.longNumber"));
        EvaluGroupTargetTypeCollection evaluGroupTargetTypeCollection = EvaluGroupTargetTypeFactory.getRemoteInstance().getEvaluGroupTargetTypeCollection(evi);
        this.oldEvaluGroupTargetTypeCollection = (EvaluGroupTargetTypeCollection)((Object)evaluGroupTargetTypeCollection.clone());
        this.tblType.removeRows();
        this.fillTable(evaluGroupTargetTypeCollection, true);
    }

    public void fillTable(EvaluGroupTargetTypeCollection evaluGroupTargetTypeCollection, boolean isLoad) throws Exception {
        this.dealTotalRow();
        EvaluGroupTargetTypeInfo evaluGroupTargetTypeInfo = null;
        IRow row = null;
        IPerformTargetType targetType = null;
        int size = evaluGroupTargetTypeCollection.size();
        for (int i = 0; i < size; ++i) {
            evaluGroupTargetTypeInfo = evaluGroupTargetTypeCollection.get(i);
            if (this.checkIfRefered(evaluGroupTargetTypeInfo)) continue;
            PerformTargetTypeInfo performTargetTypeInfo = evaluGroupTargetTypeInfo.getPerformTargetType();
            row = this.tblType.addRow();
            if (!OprtState.VIEW.equals(this.getOprtState())) {
                row.getCell("weight").getStyleAttributes().setLocked(false);
            }
            row.setUserObject((Object)evaluGroupTargetTypeInfo);
            if (evaluGroupTargetTypeInfo.getId() != null) {
                row.getCell("id").setValue((Object)evaluGroupTargetTypeInfo.getId().toString());
            }
            row.getCell("seqNumber").setValue((Object)new Integer(evaluGroupTargetTypeInfo.getSeqNumber()));
            row.getCell("typeId").setValue((Object)performTargetTypeInfo.getId().toString());
            if (performTargetTypeInfo.getParent() != null) {
                row.getCell("parentId").setValue((Object)performTargetTypeInfo.getParent().getId().toString());
            }
            row.getCell("number").setValue((Object)performTargetTypeInfo.getNumber());
            if (targetType == null) {
                targetType = PerformTargetTypeFactory.getRemoteInstance();
            }
            row.getCell("name").setValue((Object)(this.getTargettypeName(targetType, new StringBuffer(), performTargetTypeInfo) + performTargetTypeInfo.getName()));
            if (evaluGroupTargetTypeInfo.getWeight() != null) {
                row.getCell("weight").setValue((Object)evaluGroupTargetTypeInfo.getWeight());
            }
            if (isLoad || evaluGroupTargetTypeInfo.getId() != null) continue;
            this.submit(row, false, false);
        }
        if (this.tblType.getRowCount() != 0) {
            if (!this.isAllocateTarget) {
                this.addTotalRow();
            }
            this.setParentTypeStyle();
            this.calculateTotalWeight();
        }
    }

    private String getTargettypeName(IPerformTargetType targetType, StringBuffer sb, PerformTargetTypeInfo info) throws Exception {
        PerformTargetTypeInfo targetTypeParentInfo = EvaluSolutionHelper.getTargetTypeParentInfo(targetType, info);
        if (targetTypeParentInfo == null) {
            return sb.toString();
        }
        String parentId = targetTypeParentInfo.getId().toString();
        if (this.isHaveParentTarget(parentId)) {
            for (int i = 0; i < targetTypeParentInfo.getName().getBytes().length; ++i) {
                sb.append(" ");
            }
        }
        this.getTargettypeName(targetType, sb, targetTypeParentInfo);
        return sb.toString();
    }

    private void setParentTypeStyle() {
        if (this.tblType.getRowCount() != 0) {
            IRow row = null;
            for (int i = 0; i < this.tblType.getRowCount(); ++i) {
                String typeId;
                row = this.tblType.getRow(i);
                if (this.isTotalRow(row) || !this.isHaveChildTarget(typeId = (String)row.getCell("typeId").getValue())) continue;
                row.getCell("weight").getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(EvaluSolutionHelper.PARENT_TYPE_COLOR);
            }
        }
    }

    public void removeAllRows() {
        this.tblType.removeRows();
    }

    private EvaluGroupTargetTypeCollection sortByID(EvaluGroupTargetTypeCollection evaluGroupTargetTypeCollection) {
        Object[] objs = evaluGroupTargetTypeCollection.toArray();
        Arrays.sort(objs, new TargetTypeIDComparator());
        EvaluGroupTargetTypeCollection coll = new EvaluGroupTargetTypeCollection();
        for (int i = 0; i < objs.length; ++i) {
            coll.add((EvaluGroupTargetTypeInfo)objs[i]);
        }
        return coll;
    }

    private void dealTotalRow() {
        IRow row = null;
        int size = this.tblType.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblType.getRow(i);
            if (row.getCell("typeId").getValue() == null || !row.getCell("typeId").getValue().toString().equals("Total")) continue;
            this.tblType.removeRow(i);
            break;
        }
    }

    private boolean checkIfRefered(EvaluGroupTargetTypeInfo evaluGroupTargetTypeInfo) {
        IRow row = null;
        int size = this.tblType.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblType.getRow(i);
            String typeId = (String)row.getCell("typeId").getValue();
            if (!evaluGroupTargetTypeInfo.getPerformTargetType().getId().toString().equals(typeId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void referType() throws Exception {
        PerformTargetTypeCollection typeCollection = EvaluGroupTargetTypeTreeUI.showDialogWindows((IUIObject)this);
        if (typeCollection == null) {
            return;
        }
        EvaluGroupTargetTypeCollection targetTypeCollection = new EvaluGroupTargetTypeCollection();
        EvaluGroupTargetTypeInfo targetTypeInfo = null;
        PerformTargetTypeInfo typeInfo = null;
        int size = typeCollection.size();
        for (int i = 0; i < size; ++i) {
            typeInfo = typeCollection.get(i);
            targetTypeInfo = new EvaluGroupTargetTypeInfo();
            targetTypeInfo.setWeight(new BigDecimal("0.00"));
            targetTypeInfo.setPerformTargetType(typeInfo);
            targetTypeCollection.add(targetTypeInfo);
        }
        this.mergeTypeCollection(targetTypeCollection, this.getEvaluGroupTargetTypeCollection());
        this.tblType.removeRows();
        this.fillTable(targetTypeCollection, false);
        this.updateOldData();
        if (this.tblType.getRowCount() != 0) {
            this.tblType.getEditManager().editCellAt(0, this.tblType.getColumnIndex("weight"));
        }
    }

    public void mergeTypeCollection(EvaluGroupTargetTypeCollection typeColl, EvaluGroupTargetTypeCollection typeColl2) {
        int size = typeColl2.size();
        block0: for (int i = 0; i < size; ++i) {
            String typeId = typeColl2.get(i).getPerformTargetType().getId().toString();
            int size2 = typeColl.size();
            for (int j = 0; j < size2; ++j) {
                String typeId2 = typeColl.get(j).getPerformTargetType().getId().toString();
                if (!typeId.equals(typeId2)) continue;
                typeColl.removeObject(j);
                continue block0;
            }
        }
        typeColl.addCollection(typeColl2);
    }

    private void addTotalRow() {
        IRow row = this.tblType.addRow();
        row.getCell("typeId").setValue((Object)"Total");
        row.getCell("number").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.perf.EvaluSolutionResource", (String)"Total"));
        row.getCell("weight").getStyleAttributes().setLocked(true);
        row.getStyleAttributes().setBackground(EvaluSolutionHelper.KDTABLE_TOTAL_BG_COLOR);
    }

    public void setWeight() throws Exception {
        EvaluGroupTargetTypeCollection typeColl = this.getEvaluGroupTargetTypeCollection();
        Map weightMap = EvaluGroupSetTargetTypeWeightUI.showDialogWindows((IUIObject)this, typeColl);
        if (weightMap == null) {
            return;
        }
        IRow row = null;
        int size = this.tblType.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblType.getRow(i);
            String key = (String)row.getCell("typeId").getValue();
            String weight = weightMap.get(key).toString();
            row.getCell("weight").setValue((Object)weight);
            EvaluGroupTargetTypeInfo evaluGroupTargetTypeInfo = (EvaluGroupTargetTypeInfo)row.getUserObject();
            evaluGroupTargetTypeInfo.setWeight((BigDecimal)weightMap.get(key));
        }
    }

    private void calculateTotalWeight() {
        if (this.tblType.getRowCount() != 0) {
            BigDecimal totalWeight = new BigDecimal("0.00");
            IRow row = null;
            int size = this.tblType.getRowCount();
            for (int i = 0; i < size; ++i) {
                String parentId;
                row = this.tblType.getRow(i);
                if (this.isTotalRow(row) || (parentId = (String)row.getCell("parentId").getValue()) != null && this.isHaveParentTarget(parentId) || row.getCell("weight").getValue() == null) continue;
                totalWeight = totalWeight.add((BigDecimal)row.getCell("weight").getValue());
            }
            row = this.getTotalRow();
            if (row != null) {
                row.getCell("weight").setValue((Object)totalWeight);
            }
        }
    }

    private IRow getTotalRow() {
        IRow row = null;
        int size = this.tblType.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblType.getRow(i);
            if (!"Total".equals((String)row.getCell("typeId").getValue())) continue;
            return row;
        }
        return null;
    }

    private boolean isHaveParentTarget(String parentId) {
        IRow row = null;
        int size = this.tblType.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblType.getRow(i);
            String typeId = (String)row.getCell("typeId").getValue();
            if (typeId == null || !typeId.equals(parentId)) continue;
            return true;
        }
        return false;
    }

    private boolean isHaveChildTarget(String typeId) {
        IRow row = null;
        int size = this.tblType.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblType.getRow(i);
            String parentId = (String)row.getCell("parentId").getValue();
            if (parentId == null || !parentId.equals(typeId)) continue;
            return true;
        }
        return false;
    }

    public EvaluGroupTargetTypeCollection getEvaluGroupTargetTypeCollection() {
        EvaluGroupTargetTypeCollection typeColl = new EvaluGroupTargetTypeCollection();
        IRow row = null;
        int size = this.tblType.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblType.getRow(i);
            if (this.isTotalRow(row)) continue;
            typeColl.add((EvaluGroupTargetTypeInfo)this.tblType.getRow(i).getUserObject());
        }
        return typeColl;
    }

    private boolean isTotalRow(IRow row) {
        return "Total".equals((String)row.getCell("typeId").getValue());
    }

    public void delType() throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblType);
        if (this.confirmRemove()) {
            EvaluGroupTargetUI targetUI;
            List rowIndexList = PFUtils.getSelectedRows(this.tblType);
            Arrays.sort(rowIndexList.toArray());
            IRow row = null;
            HashSet<String> idSet = new HashSet<String>();
            ArrayList<String> typeIdList = new ArrayList<String>();
            StringBuffer sb = new StringBuffer();
            int size = rowIndexList.size();
            for (int i = size - 1; i >= 0; --i) {
                int selectedRow = (Integer)rowIndexList.get(i);
                row = this.tblType.getRow(selectedRow);
                if (this.isTotalRow(row)) {
                    if (size != 1) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.EvaluSolutionResource", (String)"CanNotDelTotalRow"));
                    continue;
                }
                String typeId = (String)row.getCell("typeId").getValue();
                if (this.isExistChildTargetInUnSelectedRows(rowIndexList, typeId)) {
                    sb.append(row.getCell("name").getValue());
                    sb.append(",");
                    continue;
                }
                String id = (String)row.getCell("id").getValue();
                if (id == null) continue;
                idSet.add(id);
                typeIdList.add((String)row.getCell("typeId").getValue());
            }
            if (sb.length() != 0 && sb.charAt(sb.length() - 1) == ',') {
                String tempMsg = sb.substring(0, sb.length() - 1);
                tempMsg = "\u3010 " + tempMsg + " \u3011 ";
                String msg = EASResource.getString((String)"com.kingdee.eas.hr.perf.EvaluSolutionResource", (String)"CanNotDelTotalRowOnHaveChild");
                msg = msg.replaceAll("#0", tempMsg);
                MsgBox.showInfo((Component)((Object)this), (String)msg);
            }
            if (idSet.size() != 0) {
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                IEvaluGroupTargetType evaluGroupTargetType = EvaluGroupTargetTypeFactory.getRemoteInstance();
                evaluGroupTargetType.delete(fi);
                this.loadData(this.evaluGroupId);
            }
            if ((targetUI = (EvaluGroupTargetUI)EvaluSolutionHelper.getMainUIContext((CoreUIObject)this).get(EvaluGroupTargetUI.class.getName())) != null) {
                targetUI.delTarget(typeIdList);
            }
        }
    }

    private boolean isExistChildTargetInUnSelectedRows(List rowIndexList, String typeId) {
        IRow row = null;
        int size = this.tblType.getRowCount();
        for (int i = 0; i < size; ++i) {
            String parentId;
            if (rowIndexList.contains(new Integer(i)) || (parentId = (String)(row = this.tblType.getRow(i)).getCell("parentId").getValue()) == null || !parentId.equals(typeId)) continue;
            return true;
        }
        return false;
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.EvaluSolutionResource", (String)"DelTypeWillDelTarget")));
    }

    public void clearWeight() {
        IRow row = null;
        int size = this.tblType.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblType.getRow(i);
            if (this.isTotalRow(row)) continue;
            row.getCell("weight").setValue((Object)PerfClientUtils.ZERO);
        }
        this.calculateTotalWeight();
    }

    @Override
    public void secondLoad() throws Exception {
        this.loadData(this.evaluGroupId);
    }

    public void submit(boolean isVerify) throws Exception {
        if (isVerify) {
            this.verifyInput();
        }
        IRow row = null;
        int size = this.tblType.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblType.getRow(i);
            if (this.isTotalRow(row)) continue;
            this.submit(row, false, false);
        }
        this.updateOldData();
    }

    public void submit(IRow row, boolean isVerify, boolean isUpdateOldData) throws Exception {
        if (isVerify) {
            this.verifyInput();
        }
        if (this.isTotalRow(row)) {
            return;
        }
        EvaluGroupTargetTypeInfo evaluGroupTargetTypeInfo = (EvaluGroupTargetTypeInfo)row.getUserObject();
        evaluGroupTargetTypeInfo.setSeqNumber(row.getRowIndex());
        EvaluGroupInfo groupInfo = new EvaluGroupInfo();
        groupInfo.setId(BOSUuid.read((String)this.evaluGroupId));
        evaluGroupTargetTypeInfo.setEvaluGroup(groupInfo);
        if (!row.getCell("weight").getStyleAttributes().isHided()) {
            evaluGroupTargetTypeInfo.setWeight((BigDecimal)row.getCell("weight").getValue());
        }
        String id = EvaluGroupTargetTypeFactory.getRemoteInstance().submit((CoreBaseInfo)evaluGroupTargetTypeInfo).toString();
        evaluGroupTargetTypeInfo.setId(BOSUuid.read((String)id));
        row.getCell("id").setValue((Object)id);
        if (isUpdateOldData) {
            this.updateOldData();
        }
    }

    @Override
    public void submit() throws Exception {
        this.submit(true);
        this.upDateTargetTypeWeight();
        this.updateSeq();
    }

    private void upDateTargetTypeWeight() throws Exception {
        EvaluGroupTargetUI targetUI = (EvaluGroupTargetUI)EvaluSolutionHelper.getMainUIContext((CoreUIObject)this).get(EvaluGroupTargetUI.class.getName());
        KDTabbedPane tbpMain = (KDTabbedPane)this.getUIContext().get("TBPMainGroup");
        if (targetUI == null) {
            return;
        }
        targetUI.updateTargetTypeWeight();
    }

    private void updateSeq() throws Exception {
        EvaluGroupTargetUI targetUI = (EvaluGroupTargetUI)EvaluSolutionHelper.getMainUIContext((CoreUIObject)this).get(EvaluGroupTargetUI.class.getName());
        EvaluGroupTargetCollection coll = targetUI.getEvaluGroupTargetCollection();
        coll = targetUI.sortByType(coll);
        targetUI.tblTarget.removeRows();
        targetUI.fillTable(coll, false);
    }

    @Override
    public void verifyInput() throws Exception {
        if (this.isAllocateTarget) {
            return;
        }
        try {
            PFVerifyUtils.verifyInput((CoreUIObject)this, this.tblType, "weight");
            IRow row = null;
            int size = this.tblType.getRowCount();
            for (int i = 0; i < size; ++i) {
                BigDecimal weight;
                row = this.tblType.getRow(i);
                String typeId = (String)row.getCell("typeId").getValue();
                if (typeId.equals("Total") || this.isChildWeightEqualParent(typeId, weight = (BigDecimal)row.getCell("weight").getValue())) continue;
                this.tblType.getSelectManager().select(row.getRowIndex(), this.tblType.getColumnIndex("weight"));
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.EvaluSolutionResource", (String)"ClildWeightNotEqualParent"));
                SysUtil.abort();
            }
        }
        catch (Exception e) {
            KDTabbedPane tbpMain = (KDTabbedPane)this.getUIContext().get("TBPMainGroup");
            tbpMain.setSelectedIndex(((Integer)this.getUIContext().get("CurrentIndex")).intValue());
            SysUtil.abort();
        }
    }

    private boolean isChildWeightEqualParent(String typeId, BigDecimal weight) {
        IRow row = null;
        BigDecimal childWeight = new BigDecimal("0");
        BigDecimal tempWeight = null;
        int childCount = 0;
        int size = this.tblType.getRowCount();
        for (int i = 0; i < size; ++i) {
            String parentId;
            row = this.tblType.getRow(i);
            if (this.isTotalRow(row) || (parentId = (String)row.getCell("parentId").getValue()) == null || !parentId.equals(typeId)) continue;
            tempWeight = (BigDecimal)row.getCell("weight").getValue();
            if (tempWeight != null) {
                childWeight = childWeight.add(tempWeight);
            }
            ++childCount;
        }
        return childWeight.compareTo(weight) == 0 || childCount == 0;
    }

    public BigDecimal getWeightByTypeID(String typeId) {
        if (typeId == null) {
            return new BigDecimal("0");
        }
        IRow row = null;
        int size = this.tblType.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblType.getRow(i);
            if (this.isTotalRow(row) || !typeId.equals((String)row.getCell("typeId").getValue())) continue;
            BigDecimal weight = (BigDecimal)row.getCell("weight").getValue();
            return weight == null ? new BigDecimal("0") : weight;
        }
        return new BigDecimal("0");
    }

    @Override
    protected void tblType_editStopped(KDTEditEvent e) throws Exception {
        if (this.tblType.getColumn("weight").getStyleAttributes().isHided()) {
            return;
        }
        IRow row = this.tblType.getRow(e.getRowIndex());
        int colIndex = e.getColIndex();
        if (colIndex == this.tblType.getColumn("weight").getColumnIndex()) {
            BigDecimal value = (BigDecimal)e.getValue() == null ? new BigDecimal("0") : (BigDecimal)e.getValue();
            BigDecimal oldValue = (BigDecimal)e.getOldValue() == null ? new BigDecimal("0") : (BigDecimal)e.getOldValue();
            this.updateParentTypeWeight(row, value.subtract(oldValue));
            this.calculateTotalWeight();
        }
        EvaluGroupTargetTypeInfo evaluGroupTargetTypeInfo = (EvaluGroupTargetTypeInfo)row.getUserObject();
        evaluGroupTargetTypeInfo.setWeight((BigDecimal)row.getCell("weight").getValue());
    }

    private void updateParentTypeWeight(IRow row, BigDecimal weight) {
        String parentId = (String)row.getCell("parentId").getValue();
        if (parentId == null) {
            return;
        }
        IRow tempRow = null;
        int size = this.tblType.getRowCount();
        for (int i = 0; i < size; ++i) {
            tempRow = this.tblType.getRow(i);
            String typeId = (String)tempRow.getCell("typeId").getValue();
            if (typeId == null || !typeId.equals(parentId)) continue;
            BigDecimal tempWeight = (BigDecimal)tempRow.getCell("weight").getValue();
            if (tempWeight == null) {
                tempWeight = new BigDecimal("0");
            }
            tempRow.getCell("weight").setValue((Object)tempWeight.add(weight));
            EvaluGroupTargetTypeInfo evaluGroupTargetTypeInfo = (EvaluGroupTargetTypeInfo)tempRow.getUserObject();
            evaluGroupTargetTypeInfo.setWeight((BigDecimal)tempRow.getCell("weight").getValue());
            this.updateParentTypeWeight(tempRow, weight);
            break;
        }
    }

    public boolean isDataModified() {
        EvaluGroupTargetTypeCollection evaluGroupTargetTypeCollection = this.getEvaluGroupTargetTypeCollection();
        if (evaluGroupTargetTypeCollection.size() != this.oldEvaluGroupTargetTypeCollection.size()) {
            return true;
        }
        int size = evaluGroupTargetTypeCollection.size();
        for (int i = 0; i < size; ++i) {
            if (ObjectValueUtil.objectValueEquals((AbstractObjectValue)this.oldEvaluGroupTargetTypeCollection.get(i), (AbstractObjectValue)evaluGroupTargetTypeCollection.get(i))) continue;
            return true;
        }
        return false;
    }

    public void updateOldData() throws Exception {
        this.oldEvaluGroupTargetTypeCollection = (EvaluGroupTargetTypeCollection)((Object)this.getEvaluGroupTargetTypeCollection().clone());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        JButton button = null;
        button = this.contEvaluGroupTargetType.add((Action)((Object)this.actionMoveTop));
        button.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        button.setText(null);
        button = this.contEvaluGroupTargetType.add((Action)((Object)this.actionMoveUp));
        button.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        button.setText(null);
        button = this.contEvaluGroupTargetType.add((Action)((Object)this.actionMoveDown));
        button.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        button.setText(null);
        button = this.contEvaluGroupTargetType.add((Action)((Object)this.ActionMoveBottom));
        button.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        button.setText(null);
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        EvaluTargetOrderHelper.moveTop(this.tblType, !this.isAllocateTarget);
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        EvaluTargetOrderHelper.moveUp(this.tblType, !this.isAllocateTarget);
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        EvaluTargetOrderHelper.moveDown(this.tblType, !this.isAllocateTarget);
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        EvaluTargetOrderHelper.moveBottom(this.tblType, !this.isAllocateTarget);
    }

    private class TargetTypeIDComparator
    implements Comparator {
        private TargetTypeIDComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof EvaluGroupTargetTypeInfo) || !(o2 instanceof EvaluGroupTargetTypeInfo)) {
                return -1;
            }
            EvaluGroupTargetTypeInfo info1 = (EvaluGroupTargetTypeInfo)o1;
            EvaluGroupTargetTypeInfo info2 = (EvaluGroupTargetTypeInfo)o2;
            String longNumber1 = info1.getPerformTargetType().getLongNumber();
            String longNumber2 = info2.getPerformTargetType().getLongNumber();
            return longNumber1.compareTo(longNumber2);
        }
    }
}

