/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.hr.perf.AchieveDataHelper;
import com.kingdee.eas.hr.perf.DeliverModeEnum;
import com.kingdee.eas.hr.perf.EvaluGroupInfo;
import com.kingdee.eas.hr.perf.EvaluGroupTargetCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetFactory;
import com.kingdee.eas.hr.perf.EvaluGroupTargetInfo;
import com.kingdee.eas.hr.perf.EvaluGroupTargetTypeCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetTypeInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluTargetFactory;
import com.kingdee.eas.hr.perf.EvaluTargetInfo;
import com.kingdee.eas.hr.perf.EvaluTargetTypeEnum;
import com.kingdee.eas.hr.perf.FormulaInfo;
import com.kingdee.eas.hr.perf.IEvaluGroupTarget;
import com.kingdee.eas.hr.perf.KindEnum;
import com.kingdee.eas.hr.perf.PerformTargetItemInfo;
import com.kingdee.eas.hr.perf.PerformTargetTypeCollection;
import com.kingdee.eas.hr.perf.ReportFrequencyEnum;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.AbstractEvaluGroupTargetUI;
import com.kingdee.eas.hr.perf.client.EvaluFormSolutionUIHelper;
import com.kingdee.eas.hr.perf.client.EvaluGroupSetTargetWeightUI;
import com.kingdee.eas.hr.perf.client.EvaluGroupTargetCopyUI;
import com.kingdee.eas.hr.perf.client.EvaluGroupTargetTypeUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.FormulaPromptBox;
import com.kingdee.eas.hr.perf.client.IEvaluSolutionUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.PercentRender;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.PerformItemHelper;
import com.kingdee.eas.hr.perf.client.PerformanceTargetPromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class EvaluGroupTargetUI
extends AbstractEvaluGroupTargetUI
implements IEvaluSolutionUI {
    private static final Logger logger = CoreUIObject.getLogger(EvaluGroupTargetUI.class);
    private String evaluGroupId;
    private EvaluGroupTargetCollection oldEvaluGroupTargetCollection;
    private boolean isAllocateTarget = false;
    private EvaluSolutionInfo solutionInfo;
    private String evaluSolutionId;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tHelper.getDisabledTables().add(this.tblTarget);
        this.addCommonMenusToTable(this.tblTarget);
        this.tblTarget.checkParsed();
        this.tblTarget.getActionMap().remove("Delete");
        this.tblTarget.getColumn("content").getStyleAttributes().setWrapText(true);
        this.tblTarget.getColumn("standard").getStyleAttributes().setWrapText(true);
        this.tblTarget.getColumn("description").getStyleAttributes().setWrapText(true);
        this.tblTarget.getColumn("reservedField1").getStyleAttributes().setWrapText(true);
        this.tblTarget.getColumn("evaluationSide").getStyleAttributes().setWrapText(true);
        FormulaPromptBox formulaF7 = new FormulaPromptBox((IUIObject)this);
        formulaF7.setFormulaType(2);
        PerfClientUtils.setTableCellEditorByF7Selector(this.tblTarget, (KDPromptSelector)formulaF7, "calFormula");
        this.tblTarget.getColumn("scoringMethod").getStyleAttributes().setWrapText(true);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.tblTarget.getStyleAttributes().setLocked(true);
        } else {
            this.tblTarget.getStyleAttributes().setLocked(false);
            this.tblTarget.getColumn("type").getStyleAttributes().setLocked(true);
            this.tblTarget.getColumn("number").getStyleAttributes().setLocked(true);
            this.tblTarget.getColumn("kind").getStyleAttributes().setLocked(true);
        }
        PerfClientUtils.setTableCellEditorByComboBox(this.tblTarget, "reportFrequency", "com.kingdee.eas.hr.perf.ReportFrequencyEnum");
        PFUtils.setTableCellEditorByFormattedTextFieldWithNegative(this.tblTarget, "thresholdValue", 4, true);
        PFUtils.setTableCellEditorByFormattedTextFieldWithNegative(this.tblTarget, "standardValue", 4, true);
        PFUtils.setTableCellEditorByFormattedTextFieldWithNegative(this.tblTarget, "challengeValue", 4, true);
        PFUtils.setTableCellEditorByFormattedTextFieldWithNegative(this.tblTarget, "reservedField2", 4, true);
        PFUtils.setTableCellEditorByFormattedTextField(this.tblTarget, "weight", 4, true);
        this.evaluGroupId = (String)this.getUIContext().get("EvaluGroupID");
        this.isAllocateTarget = (Boolean)this.getUIContext().get("isAllocateTarget");
        this.loadData(this.evaluGroupId);
        PerfClientUtils.setTableCellEditorByTextArea(this.tblTarget, "content", 150);
        PerfClientUtils.setTableCellEditorByTextArea(this.tblTarget, "standard", 150);
        PerfClientUtils.setTableCellEditorByTextArea(this.tblTarget, "description", 150);
        PerfClientUtils.setTableCellEditorByTextArea(this.tblTarget, "scoringMethod", 100);
        PerfClientUtils.setTableCellEditorByTextArea(this.tblTarget, "evaluationSide", 225);
        PerfClientUtils.setTableCellEditorByTextArea(this.tblTarget, "unit", 225);
        PerfClientUtils.setTableCellEditorByTextArea(this.tblTarget, "reservedField1", 150);
        if (!this.isAllocateTarget || DeliverModeEnum.TARGETTEMPLATEMODE.equals(this.getUIContext().get("deliverMode"))) {
            KDFormattedTextField formattedTextField = new KDFormattedTextField();
            formattedTextField.setDataType(1);
            formattedTextField.setMinimumValue((Comparable)new BigDecimal("0.00"));
            Boolean isControlWeight = (Boolean)this.getUIContext().get("isControlWeight");
            if (isControlWeight != null && isControlWeight.booleanValue()) {
                formattedTextField.setMaximumValue((Comparable)new BigDecimal("10000.00"));
            } else {
                formattedTextField.setMaximumValue((Comparable)new BigDecimal("100.00"));
            }
            formattedTextField.setDataVerifierType(12);
            PFUtils.setTableCellEditorByFormattedTextField(this.tblTarget, formattedTextField, "weight", 2);
            PFUtils.setTableNumberFormat(this.tblTarget, "weight", 2);
        }
        this.setQueryPreference(true);
        this.tblTarget.setColumnMoveable(true);
        String spID = (String)this.getUIContext().get("SolutionPeriodID");
        this.tblTarget.getColumn("number").setRequired(true);
        this.tblTarget.getColumn("kind").setRequired(true);
        this.tblTarget.getColumn("weight").setRequired(true);
        this.tblTarget.getColumn("dataPrecision").getStyleAttributes().setLocked(true);
        this.tblTarget.getColumn("precisionType").getStyleAttributes().setLocked(true);
        this.initKDTInterviewColumnHeight(this.tblTarget);
    }

    private void initKDTInterviewColumnHeight(KDTable table) {
        int rowCount = table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.setColumnAutoHeight(table, i);
        }
    }

    private boolean setColumnAutoHeight(KDTable table, int index) {
        int rowCount = table.getRowCount();
        if (rowCount > 0 && index < rowCount) {
            return KDTableHelper.autoFitRowHeight((KDTable)table, (int)index);
        }
        return false;
    }

    private void loadData(String id) throws Exception {
        this.evaluSolutionId = (String)this.getUIContext().get("ID");
        this.solutionInfo = EvaluSolutionHelper.getEvaluSolutionInfo(this.evaluSolutionId);
        if (id == null) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)id));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("weight"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.targetID"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.number"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.content"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.standard"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.description"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.kind"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.thresholdValue"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.standardValue"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.challengeValue"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.unit"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.reportFrequency"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.scoringMethod"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.evaluationSide"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.reservedField1"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.reservedField2"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.type.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.type.name"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.type.longNumber"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.formula.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.formula.name"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.dataPrecision"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.precisionType"));
        evi.getSelector().add(new SelectorItemInfo("evaluTarget.seqNumber"));
        evi.getSorter().add(new SorterItemInfo("evaluTarget.seqNumber"));
        EvaluGroupTargetCollection evaluGroupTargetCollection = EvaluGroupTargetFactory.getRemoteInstance().getEvaluGroupTargetCollection(evi);
        evaluGroupTargetCollection = this.sortByType(evaluGroupTargetCollection);
        this.oldEvaluGroupTargetCollection = (EvaluGroupTargetCollection)((Object)evaluGroupTargetCollection.clone());
        this.tblTarget.removeRows();
        this.fillTable(evaluGroupTargetCollection, true);
    }

    protected EvaluGroupTargetCollection sortByType(EvaluGroupTargetCollection evaluGroupTargetCollection) {
        EvaluGroupTargetTypeUI typeUI = (EvaluGroupTargetTypeUI)this.getUIContext().get(EvaluGroupTargetTypeUI.class.getName());
        EvaluGroupTargetTypeCollection evaluGroupTypeColl = typeUI.getEvaluGroupTargetTypeCollection();
        Object[] objs = evaluGroupTargetCollection.toArray();
        Arrays.sort(objs, new TargetTypeComparator(evaluGroupTypeColl));
        EvaluGroupTargetCollection coll = new EvaluGroupTargetCollection();
        for (int i = 0; i < objs.length; ++i) {
            coll.add((EvaluGroupTargetInfo)objs[i]);
        }
        return coll;
    }

    protected void fillTable(EvaluGroupTargetCollection evaluGroupTargetCollection, boolean isLoad) throws Exception {
        EvaluGroupTargetCollection needSaveCollection = new EvaluGroupTargetCollection();
        this.dealTotalRow();
        evaluGroupTargetCollection = this.sortByType(evaluGroupTargetCollection);
        EvaluGroupTargetTypeUI typeUI = (EvaluGroupTargetTypeUI)this.getUIContext().get(EvaluGroupTargetTypeUI.class.getName());
        EvaluGroupTargetInfo evaluGroupTargetInfo = null;
        IRow row = null;
        EvaluTargetInfo evaluTargetInfo = null;
        int size = evaluGroupTargetCollection.size();
        for (int i = 0; i < size; ++i) {
            evaluGroupTargetInfo = evaluGroupTargetCollection.get(i);
            if (this.checkIfRefered(evaluGroupTargetInfo)) continue;
            evaluTargetInfo = evaluGroupTargetInfo.getEvaluTarget();
            row = this.tblTarget.addRow();
            if (!OprtState.VIEW.equals(this.getOprtState())) {
                row.getCell("weight").getStyleAttributes().setLocked(false);
            }
            row.setUserObject((Object)evaluGroupTargetInfo);
            if (evaluGroupTargetInfo.getId() != null) {
                row.getCell("id").setValue((Object)evaluGroupTargetInfo.getId().toString());
            }
            row.getCell("seqNumber").setValue((Object)new Integer(evaluTargetInfo.getSeqNumber()));
            row.getCell("targetId").setValue((Object)evaluTargetInfo.getTargetID().toString());
            row.getCell("number").setValue((Object)evaluTargetInfo.getNumber());
            String typeId = evaluTargetInfo.getType().getId().toString();
            row.getCell("typeId").setValue((Object)typeId);
            StringBuffer typeName = new StringBuffer(evaluTargetInfo.getType().getName());
            if (!this.isAllocateTarget || DeliverModeEnum.TARGETTEMPLATEMODE.equals(this.getUIContext().get("deliverMode"))) {
                typeName.append("(");
                typeName.append(EvaluSolutionHelper.bigDecimal2PercentString(typeUI.getWeightByTypeID(typeId)));
                typeName.append(")");
            }
            row.getCell("type").setValue((Object)typeName.toString());
            row.getCell("content").setValue((Object)evaluTargetInfo.getContent());
            row.getCell("standard").setValue((Object)evaluTargetInfo.getStandard());
            row.getCell("kind").setValue((Object)evaluTargetInfo.getKind());
            row.getCell("dataPrecision").setValue((Object)new Integer(evaluTargetInfo.getDataPrecision()));
            row.getCell("precisionType").setValue((Object)evaluTargetInfo.getPrecisionType());
            int dataPrecision = evaluTargetInfo.getDataPrecision();
            String precision = PFUtils.getNumberFormat(dataPrecision);
            DecimalFormat df = new DecimalFormat(precision);
            if (KindEnum.QUANTITATIVE2.equals((Object)evaluTargetInfo.getKind())) {
                BigDecimal per = new BigDecimal("100.00");
                if (evaluTargetInfo.getThresholdValue() != null) {
                    row.getCell("thresholdValue").setValue((Object)df.format(evaluTargetInfo.getThresholdValue().multiply(per)));
                }
                if (evaluTargetInfo.getStandardValue() != null) {
                    row.getCell("standardValue").setValue((Object)df.format(evaluTargetInfo.getStandardValue().multiply(per)));
                }
                if (evaluTargetInfo.getChallengeValue() != null) {
                    row.getCell("challengeValue").setValue((Object)df.format(evaluTargetInfo.getChallengeValue().multiply(per)));
                }
                if (evaluTargetInfo.getReservedField2() != null) {
                    row.getCell("reservedField2").setValue((Object)df.format(evaluTargetInfo.getReservedField2().multiply(per)));
                }
                String[] columnName = new String[]{"thresholdValue", "standardValue", "challengeValue", "reservedField2"};
                PerformItemHelper.setRender(row, columnName, new PercentRender());
            } else {
                if (evaluTargetInfo.getThresholdValue() != null) {
                    row.getCell("thresholdValue").setValue((Object)df.format(evaluTargetInfo.getThresholdValue()));
                }
                if (evaluTargetInfo.getStandardValue() != null) {
                    row.getCell("standardValue").setValue((Object)df.format(evaluTargetInfo.getStandardValue()));
                }
                if (evaluTargetInfo.getChallengeValue() != null) {
                    row.getCell("challengeValue").setValue((Object)df.format(evaluTargetInfo.getChallengeValue()));
                }
                if (evaluTargetInfo.getReservedField2() != null) {
                    row.getCell("reservedField2").setValue((Object)df.format(evaluTargetInfo.getReservedField2()));
                }
            }
            row.getCell("description").setValue((Object)evaluTargetInfo.getDescription());
            row.getCell("unit").setValue((Object)evaluTargetInfo.getUnit());
            row.getCell("reportFrequency").setValue((Object)evaluTargetInfo.getReportFrequency());
            row.getCell("scoringMethod").setValue((Object)evaluTargetInfo.getScoringMethod());
            row.getCell("evaluationSide").setValue((Object)evaluTargetInfo.getEvaluationSide());
            row.getCell("reservedField1").setValue((Object)evaluTargetInfo.getReservedField1());
            if (evaluTargetInfo.getFormula() != null) {
                row.getCell("calFormula").setValue((Object)evaluTargetInfo.getFormula());
            }
            if (evaluGroupTargetInfo.getWeight() != null) {
                row.getCell("weight").setValue((Object)evaluGroupTargetInfo.getWeight());
            }
            if (isLoad || evaluGroupTargetInfo.getId() != null) continue;
            needSaveCollection.add(evaluGroupTargetInfo);
        }
        if (this.tblTarget.getRowCount() != 0 && !this.isAllocateTarget) {
            this.addTotalRow();
            this.calculateTotalWeight();
        }
        this.mergeTable();
        if (needSaveCollection.size() != 0) {
            this.submit(needSaveCollection);
        }
    }

    private void mergeTable() {
        this.tblTarget.getColumn("type").setGroup(true);
        this.tblTarget.getGroupManager().group();
    }

    private void addTotalRow() {
        IRow row = this.tblTarget.addRow();
        row.getCell("targetId").setValue((Object)"Total");
        int index = 0;
        int count = this.tblTarget.getColumnCount();
        for (int i = 0; i < count; ++i) {
            if (this.tblTarget.getColumn(i).getStyleAttributes().isHided()) continue;
            index = i;
            break;
        }
        row.getCell(index).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.perf.EvaluSolutionResource", (String)"Total"));
        row.getStyleAttributes().setBackground(EvaluSolutionHelper.KDTABLE_TOTAL_BG_COLOR);
        row.getStyleAttributes().setLocked(true);
    }

    private void calculateTotalWeight() {
        if (this.tblTarget.getRowCount() != 0) {
            BigDecimal totalWeight = new BigDecimal("0.00");
            IRow row = null;
            int size = this.tblTarget.getRowCount();
            for (int i = 0; i < size; ++i) {
                row = this.tblTarget.getRow(i);
                if (this.isTotalRow(row) || row.getCell("weight").getValue() == null) continue;
                totalWeight = row.getCell("weight").getValue() instanceof BigDecimal ? totalWeight.add((BigDecimal)row.getCell("weight").getValue()) : totalWeight.add(new BigDecimal(row.getCell("weight").getValue().toString()));
            }
            row = this.getTotalRow();
            if (row != null) {
                row.getCell("weight").setValue((Object)totalWeight);
            }
        }
    }

    private IRow getTotalRow() {
        IRow row = null;
        int size = this.tblTarget.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblTarget.getRow(i);
            if (!"Total".equals((String)row.getCell("targetId").getValue())) continue;
            return row;
        }
        return null;
    }

    private void dealTotalRow() {
        IRow row = null;
        int count = this.tblTarget.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblTarget.getRow(i);
            if (row.getCell("targetId").getValue() == null || !row.getCell("targetId").getValue().toString().equals("Total")) continue;
            this.tblTarget.removeRow(i);
            break;
        }
    }

    private boolean isTotalRow(IRow row) {
        return "Total".equals((String)row.getCell("targetId").getValue());
    }

    private boolean checkIfRefered(EvaluGroupTargetInfo evaluGroupTargetInfo) {
        IRow row = null;
        String targetId = null;
        int size = this.tblTarget.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblTarget.getRow(i);
            targetId = (String)row.getCell("targetId").getValue();
            if (!String.valueOf(evaluGroupTargetInfo.getEvaluTarget().getTargetID()).equals(targetId)) continue;
            return true;
        }
        return false;
    }

    public void submit(boolean isVerify) throws Exception {
        if (isVerify) {
            this.verifyInput();
        }
        IRow row = null;
        SolutionPeriodInfo solutionPeriodInfo = new SolutionPeriodInfo();
        solutionPeriodInfo.setId(BOSUuid.read((String)((String)this.getUIContext().get("SolutionPeriodID"))));
        int size = this.tblTarget.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblTarget.getRow(i);
            if (this.isTotalRow(row)) continue;
            this.submit(row, false, false);
        }
        this.updateOldData();
    }

    public void submit(IRow row, boolean isVerify, boolean isUpdateOldData) throws Exception {
        if (isVerify) {
            this.verifyInput();
        }
        if (this.isTotalRow(row)) {
            return;
        }
        SolutionPeriodInfo solutionPeriodInfo = new SolutionPeriodInfo();
        solutionPeriodInfo.setId(BOSUuid.read((String)((String)this.getUIContext().get("SolutionPeriodID"))));
        EvaluGroupTargetInfo evaluGroupTargetInfo = (EvaluGroupTargetInfo)row.getUserObject();
        EvaluGroupInfo groupInfo = new EvaluGroupInfo();
        groupInfo.setId(BOSUuid.read((String)this.evaluGroupId));
        evaluGroupTargetInfo.setEvaluGroup(groupInfo);
        evaluGroupTargetInfo.getEvaluTarget().setSolutionPeriod(solutionPeriodInfo);
        evaluGroupTargetInfo.getEvaluTarget().setTargetType(EvaluTargetTypeEnum.PERFORM);
        evaluGroupTargetInfo.setWeight((BigDecimal)row.getCell("weight").getValue());
        String[] ids = EvaluGroupTargetFactory.getRemoteInstance().submitGroupTarget(evaluGroupTargetInfo);
        if (ids != null) {
            evaluGroupTargetInfo.getEvaluTarget().setId(BOSUuid.read((String)ids[0]));
            evaluGroupTargetInfo.setId(BOSUuid.read((String)ids[1]));
            row.getCell("id").setValue((Object)ids[1]);
        }
        if (isUpdateOldData) {
            this.updateOldData();
        }
    }

    @Override
    public void submit() throws Exception {
        this.verifyInput();
        this.updateContentAndStandard();
        if (this.tblTarget.getColumn("weight").getStyleAttributes().isHided()) {
            return;
        }
        this.updateWeight();
    }

    private void updateWeight() throws Exception {
        IRow row = null;
        EvaluGroupTargetInfo targetInfo = null;
        HashMap<String, BigDecimal> weightMap = new HashMap<String, BigDecimal>();
        int count = this.tblTarget.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblTarget.getRow(i);
            if (this.isTotalRow(row)) continue;
            targetInfo = (EvaluGroupTargetInfo)row.getUserObject();
            weightMap.put(targetInfo.getEvaluTarget().getId().toString(), (BigDecimal)row.getCell("weight").getValue());
        }
        EvaluGroupTargetFactory.getRemoteInstance().updateWeight(weightMap);
    }

    private void updateContentAndStandard() throws Exception {
        IRow row = null;
        EvaluGroupTargetInfo gTargetInfo = null;
        ArrayList<EvaluTargetInfo> targetInfos = new ArrayList<EvaluTargetInfo>();
        int count = this.tblTarget.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblTarget.getRow(i);
            if (this.isTotalRow(row) || (gTargetInfo = (EvaluGroupTargetInfo)row.getUserObject()) == null || gTargetInfo.getEvaluTarget() == null) continue;
            EvaluTargetInfo tInfo = gTargetInfo.getEvaluTarget();
            tInfo.setSeqNumber(row.getRowIndex());
            PFVerifyUtils.verifyInput((CoreUIObject)this, this.tblTarget, row, "content");
            tInfo.setContent(row.getCell("content").getValue().toString());
            if (row.getCell("standard").getValue() != null) {
                tInfo.setStandard(row.getCell("standard").getValue().toString());
            } else {
                tInfo.setStandard(null);
            }
            if (row.getCell("description").getValue() != null) {
                tInfo.setDescription(row.getCell("description").getValue().toString());
            } else {
                tInfo.setDescription(null);
            }
            boolean isPercent = false;
            BigDecimal per = new BigDecimal("0.01");
            if (row.getCell("kind").getValue() != null) {
                tInfo.setKind((KindEnum)((Object)row.getCell("kind").getValue()));
                if (((KindEnum)((Object)row.getCell("kind").getValue())).equals((Object)KindEnum.QUANTITATIVE2)) {
                    isPercent = true;
                }
            } else {
                tInfo.setKind(null);
            }
            if (row.getCell("thresholdValue").getValue() != null) {
                if (isPercent) {
                    tInfo.setThresholdValue(new BigDecimal(row.getCell("thresholdValue").getValue().toString()).multiply(per));
                } else {
                    tInfo.setThresholdValue(new BigDecimal(row.getCell("thresholdValue").getValue().toString()));
                }
            } else {
                tInfo.setThresholdValue(null);
            }
            if (row.getCell("standardValue").getValue() != null) {
                if (isPercent) {
                    tInfo.setStandardValue(new BigDecimal(row.getCell("standardValue").getValue().toString()).multiply(per));
                } else {
                    tInfo.setStandardValue(new BigDecimal(row.getCell("standardValue").getValue().toString()));
                }
            } else {
                tInfo.setStandardValue(null);
            }
            if (row.getCell("challengeValue").getValue() != null) {
                if (isPercent) {
                    tInfo.setChallengeValue(new BigDecimal(row.getCell("challengeValue").getValue().toString()).multiply(per));
                } else {
                    tInfo.setChallengeValue(new BigDecimal(row.getCell("challengeValue").getValue().toString()));
                }
            } else {
                tInfo.setChallengeValue(null);
            }
            if (row.getCell("unit").getValue() != null) {
                tInfo.setUnit(row.getCell("unit").getValue().toString());
            } else {
                tInfo.setUnit(null);
            }
            if (row.getCell("reportFrequency").getValue() != null) {
                tInfo.setReportFrequency((ReportFrequencyEnum)((Object)row.getCell("reportFrequency").getValue()));
            } else {
                tInfo.setReportFrequency(null);
            }
            if (row.getCell("scoringMethod").getValue() != null) {
                tInfo.setScoringMethod(row.getCell("scoringMethod").getValue().toString());
            } else {
                tInfo.setScoringMethod(null);
            }
            if (row.getCell("evaluationSide").getValue() != null) {
                tInfo.setEvaluationSide(row.getCell("evaluationSide").getValue().toString());
            } else {
                tInfo.setEvaluationSide(null);
            }
            if (row.getCell("reservedField1").getValue() != null) {
                tInfo.setReservedField1(row.getCell("reservedField1").getValue().toString());
            } else {
                tInfo.setEvaluationSide(null);
            }
            if (row.getCell("reservedField2").getValue() != null) {
                if (isPercent) {
                    tInfo.setReservedField2(new BigDecimal(row.getCell("reservedField2").getValue().toString()).multiply(per));
                } else {
                    tInfo.setReservedField2(new BigDecimal(row.getCell("reservedField2").getValue().toString()));
                }
            } else {
                tInfo.setReservedField2(null);
            }
            if (row.getCell("calFormula").getValue() != null) {
                tInfo.setFormula((FormulaInfo)row.getCell("calFormula").getValue());
            } else {
                tInfo.setFormula(null);
            }
            targetInfos.add(tInfo);
        }
        if (targetInfos.size() > 0) {
            EvaluTargetFactory.getRemoteInstance().batchUpdate(targetInfos);
        }
    }

    public void submit(EvaluGroupTargetCollection groupTargetColl) throws Exception {
        EvaluGroupTargetInfo groupTargetInfo = null;
        int size = groupTargetColl.size();
        for (int i = 0; i < size; ++i) {
            groupTargetInfo = groupTargetColl.get(i);
            SolutionPeriodInfo solutionPeriodInfo = new SolutionPeriodInfo();
            solutionPeriodInfo.setId(BOSUuid.read((String)((String)this.getUIContext().get("SolutionPeriodID"))));
            EvaluGroupInfo groupInfo = new EvaluGroupInfo();
            groupInfo.setId(BOSUuid.read((String)this.evaluGroupId));
            groupTargetInfo.setEvaluGroup(groupInfo);
            groupTargetInfo.getEvaluTarget().setSolutionPeriod(solutionPeriodInfo);
            groupTargetInfo.getEvaluTarget().setTargetType(EvaluTargetTypeEnum.PERFORM);
        }
        Map idMap = EvaluGroupTargetFactory.getRemoteInstance().submitBatchGroupTarget(groupTargetColl);
        Map targetIDMap = (Map)idMap.get("TargetID");
        Map groupTargetIDMap = (Map)idMap.get("GroupTargetID");
        IRow row = null;
        int count = this.tblTarget.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblTarget.getRow(i);
            if (this.isTotalRow(row) || !groupTargetColl.contains(groupTargetInfo = (EvaluGroupTargetInfo)row.getUserObject())) continue;
            String id = (String)groupTargetIDMap.get(groupTargetInfo.getEvaluTarget().getTargetID());
            String targetId = (String)targetIDMap.get(groupTargetInfo.getEvaluTarget().getTargetID());
            row.getCell("id").setValue((Object)id);
            groupTargetInfo.getEvaluTarget().setId(BOSUuid.read((String)targetId));
            groupTargetInfo.setId(BOSUuid.read((String)id));
        }
        this.updateOldData();
    }

    public void copyTarget() throws Exception {
        int i;
        Map map = EvaluGroupTargetCopyUI.showDialogWindows((IUIObject)this);
        if (map == null || map.get("Target") == null || map.get("TargetType") == null) {
            return;
        }
        EvaluGroupTargetCollection targetColl = (EvaluGroupTargetCollection)((Object)map.get("Target"));
        EvaluGroupTargetTypeCollection typeColl = (EvaluGroupTargetTypeCollection)((Object)map.get("TargetType"));
        int size = targetColl.size();
        for (i = 0; i < size; ++i) {
            targetColl.get(i).setId(null);
        }
        size = typeColl.size();
        for (i = 0; i < size; ++i) {
            typeColl.get(i).setId(null);
        }
        EvaluGroupTargetTypeUI typeUI = (EvaluGroupTargetTypeUI)this.getUIContext().get(EvaluGroupTargetTypeUI.class.getName());
        typeUI.mergeTypeCollection(typeColl, typeUI.getEvaluGroupTargetTypeCollection());
        typeUI.removeAllRows();
        typeUI.fillTable(typeColl, false);
        this.mergeTargetCollection(targetColl, this.getEvaluGroupTargetCollection());
        this.tblTarget.removeRows();
        this.fillTable(targetColl, false);
        if (this.isAllocateTarget) {
            this.clearWeight(typeUI);
        }
        typeUI.updateOldData();
        this.updateOldData();
        typeUI.submit(false);
        this.submit(false);
    }

    private void mergeTargetCollection(EvaluGroupTargetCollection targetColl, EvaluGroupTargetCollection targetColl2) {
        String targetId = null;
        String targetId2 = null;
        int size = targetColl2.size();
        block0: for (int i = 0; i < size; ++i) {
            targetId = targetColl2.get(i).getEvaluTarget().getTargetID().toString();
            int size2 = targetColl.size();
            for (int j = 0; j < size2; ++j) {
                targetId2 = targetColl.get(j).getEvaluTarget().getTargetID().toString();
                if (!targetId.equals(targetId2)) continue;
                targetColl.removeObject(j);
                continue block0;
            }
        }
        targetColl.addCollection(targetColl2);
    }

    private void clearWeight(EvaluGroupTargetTypeUI typeUI) {
        typeUI.clearWeight();
        IRow row = null;
        EvaluGroupTargetInfo evaluGroupTargetInfo = null;
        String typeName = null;
        int size = this.tblTarget.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblTarget.getRow(i);
            if (this.isTotalRow(row)) continue;
            row.getCell("weight").setValue((Object)PerfClientUtils.ZERO);
            evaluGroupTargetInfo = (EvaluGroupTargetInfo)row.getUserObject();
            EvaluTargetInfo evaluTargetInfo = evaluGroupTargetInfo.getEvaluTarget();
            typeName = evaluTargetInfo.getType().getName();
            if (!this.isAllocateTarget) {
                typeName = typeName + "(" + EvaluSolutionHelper.bigDecimal2PercentString(PerfClientUtils.ZERO) + ")";
            }
            row.getCell("type").setValue((Object)typeName);
        }
        this.calculateTotalWeight();
    }

    public boolean updateTargetTypeWeight() throws Exception {
        if (this.tblTarget.getColumn("weight").getStyleAttributes().isHided()) {
            return false;
        }
        boolean isChanged = false;
        IRow row = null;
        EvaluGroupTargetInfo evaluGroupTargetInfo = null;
        EvaluTargetInfo evaluTargetInfo = null;
        String typeId2 = null;
        StringBuffer typeName = null;
        BigDecimal oldWeight = null;
        BigDecimal weight = null;
        BigDecimal targetWeight = null;
        EvaluGroupTargetTypeUI typeUI = (EvaluGroupTargetTypeUI)this.getUIContext().get(EvaluGroupTargetTypeUI.class.getName());
        HashMap<String, BigDecimal> weightMap = new HashMap<String, BigDecimal>();
        int size = this.tblTarget.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblTarget.getRow(i);
            if (this.isTotalRow(row)) continue;
            evaluGroupTargetInfo = (EvaluGroupTargetInfo)row.getUserObject();
            evaluTargetInfo = evaluGroupTargetInfo.getEvaluTarget();
            typeId2 = evaluTargetInfo.getType().getId().toString();
            oldWeight = (BigDecimal)row.getCell("weight").getValue();
            if (oldWeight == null) {
                oldWeight = new BigDecimal("0");
            }
            weight = typeUI.getWeightByTypeID(typeId2);
            typeName = new StringBuffer(evaluTargetInfo.getType().getName());
            if (!this.isAllocateTarget) {
                typeName.append("(");
                typeName.append(EvaluSolutionHelper.bigDecimal2PercentString(weight));
                typeName.append(")");
            }
            row.getCell("type").setValue((Object)typeName.toString());
            targetWeight = (BigDecimal)weightMap.get(typeId2);
            if (targetWeight == null) {
                targetWeight = new BigDecimal("0");
                weightMap.put(typeId2, targetWeight);
            }
            targetWeight = targetWeight.add(oldWeight);
            weightMap.put(typeId2, targetWeight);
        }
        for (String typeId2 : weightMap.keySet()) {
            BigDecimal newWeight;
            oldWeight = (BigDecimal)weightMap.get(typeId2);
            if (oldWeight.compareTo(new BigDecimal("0")) == 0 || oldWeight.compareTo(newWeight = typeUI.getWeightByTypeID(typeId2)) == 0) continue;
            isChanged = true;
        }
        if (isChanged) {
            this.submit();
        }
        return isChanged;
    }

    public void referTarget() throws Exception {
        PerformanceTargetPromptBox promptBox = new PerformanceTargetPromptBox((IUIObject)this);
        FilterInfo fi = new FilterInfo();
        PerformTargetTypeCollection typeColl = EvaluSolutionHelper.getPerformTargetTypeCollection(this.evaluGroupId);
        if (typeColl.size() != 0) {
            HashSet<String> set = new HashSet<String>();
            int size = typeColl.size();
            for (int i = 0; i < size; ++i) {
                set.add(typeColl.get(i).getId().toString());
            }
            fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            promptBox.setTargetTypeFilterInfo(fi);
            FilterInfo targetItemFilter = new FilterInfo();
            targetItemFilter.getFilterItems().add(new FilterItemInfo("type.id", set, CompareType.INCLUDE));
            promptBox.setTargetItemFilterInfo(targetItemFilter);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.EvaluSolutionResource", (String)"NotTargetTypeSelected"));
            SysUtil.abort();
        }
        promptBox.show();
        Object[] targets = (Object[])promptBox.getData();
        if (targets == null || targets.length == 0) {
            return;
        }
        EvaluGroupTargetCollection targetColl = new EvaluGroupTargetCollection();
        EvaluGroupTargetInfo groupTargetInfo = null;
        EvaluTargetInfo targetInfo = null;
        PerformTargetItemInfo itemInfo = null;
        String targetId = null;
        for (int i = 0; i < targets.length; ++i) {
            boolean isRefered = false;
            itemInfo = (PerformTargetItemInfo)targets[i];
            int size = this.tblTarget.getRowCount();
            for (int j = 0; j < size; ++j) {
                targetId = this.tblTarget.getRow(j).getCell("targetId").getValue().toString();
                if (!itemInfo.getId().toString().equals(targetId)) continue;
                isRefered = true;
                break;
            }
            if (isRefered) continue;
            groupTargetInfo = new EvaluGroupTargetInfo();
            groupTargetInfo.setWeight(new BigDecimal("0.00"));
            targetInfo = new EvaluTargetInfo();
            targetInfo.setTargetID(itemInfo.getId());
            targetInfo.setNumber(itemInfo.getNumber());
            targetInfo.setContent(itemInfo.getContent());
            targetInfo.setDescription(itemInfo.getDescription());
            targetInfo.setStandard(itemInfo.getStandard());
            targetInfo.setType(itemInfo.getType());
            targetInfo.setKind(itemInfo.getKind());
            targetInfo.setThresholdValue(itemInfo.getThresholdValue());
            targetInfo.setStandardValue(itemInfo.getStandardValue());
            targetInfo.setChallengeValue(itemInfo.getChallengeValue());
            targetInfo.setUnit(itemInfo.getUnit());
            targetInfo.setReportFrequency(itemInfo.getReportFrequency());
            targetInfo.setScoringMethod(itemInfo.getScoringMethod());
            targetInfo.setEvaluationSide(itemInfo.getEvaluationSide());
            targetInfo.setReservedField1(itemInfo.getReservedField1());
            targetInfo.setReservedField2(itemInfo.getReservedField2());
            targetInfo.setDataPrecision(itemInfo.getDataPrecision());
            targetInfo.setPrecisionType(itemInfo.getPrecisionType());
            targetInfo.setFormula(itemInfo.getFormula());
            groupTargetInfo.setEvaluTarget(targetInfo);
            targetColl.add(groupTargetInfo);
        }
        this.mergeTargetCollection(targetColl, this.getEvaluGroupTargetCollection());
        this.tblTarget.removeRows();
        this.fillTable(targetColl, false);
        this.updateOldData();
        if (this.tblTarget.getRowCount() != 0) {
            this.tblTarget.getEditManager().editCellAt(0, this.tblTarget.getColumnIndex("weight"));
        }
    }

    public void delTarget(List idList) throws Exception {
        IRow row = null;
        String typeId = null;
        ArrayList<Integer> rowIndexList = new ArrayList<Integer>();
        int count = this.tblTarget.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblTarget.getRow(i);
            if (this.isTotalRow(row) || !idList.contains(typeId = (String)row.getCell("typeId").getValue())) continue;
            rowIndexList.add(new Integer(row.getRowIndex()));
        }
        this.delTargetByRowIndex(rowIndexList);
    }

    private void delTargetByRowIndex(List rowIndexList) throws Exception {
        Arrays.sort(rowIndexList.toArray());
        IRow row = null;
        HashMap<String, String> map = null;
        String id = null;
        String solutionPeriodId = null;
        String evaluTargetId = null;
        ArrayList idList = new ArrayList();
        for (int i = rowIndexList.size() - 1; i >= 0; --i) {
            int selectedRow = (Integer)rowIndexList.get(i);
            row = this.tblTarget.getRow(selectedRow);
            if (this.isTotalRow(row)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.EvaluSolutionResource", (String)"CanNotDelTotalRow"));
                continue;
            }
            id = (String)row.getCell("id").getValue();
            if (id == null) continue;
            solutionPeriodId = (String)this.getUIContext().get("SolutionPeriodID");
            evaluTargetId = ((EvaluGroupTargetInfo)row.getUserObject()).getEvaluTarget().getId().toString();
            if (solutionPeriodId == null || evaluTargetId == null) continue;
            map = new HashMap<String, String>();
            map.put("SPID", solutionPeriodId);
            map.put("ETID", evaluTargetId);
            map.put("EGTID", id);
            idList.add(map);
        }
        if (idList.size() != 0) {
            IEvaluGroupTarget groupTarget = EvaluGroupTargetFactory.getRemoteInstance();
            groupTarget.delete(idList);
            this.loadData(this.evaluGroupId);
        }
    }

    public void delTarget() throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblTarget);
        if (this.confirmRemove()) {
            List rowIndexList = PFUtils.getSelectedRows(this.tblTarget);
            this.delTargetByRowIndex(rowIndexList);
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    public void setWeight() throws Exception {
        EvaluGroupTargetCollection targetColl = this.getEvaluGroupTargetCollection();
        Map weightMap = EvaluGroupSetTargetWeightUI.showDialogWindows((IUIObject)this, targetColl);
        if (weightMap == null) {
            return;
        }
        IRow row = null;
        String key = null;
        String weight = null;
        int size = this.tblTarget.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblTarget.getRow(i);
            key = (String)row.getCell("targetId").getValue();
            weight = weightMap.get(key).toString();
            row.getCell("weight").setValue((Object)weight);
            EvaluGroupTargetInfo evaluGroupTargetInfo = (EvaluGroupTargetInfo)row.getUserObject();
            evaluGroupTargetInfo.setWeight((BigDecimal)weightMap.get(key));
        }
    }

    protected EvaluGroupTargetCollection getEvaluGroupTargetCollection() {
        EvaluGroupTargetCollection targetColl = new EvaluGroupTargetCollection();
        IRow row = null;
        int size = this.tblTarget.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblTarget.getRow(i);
            if (this.isTotalRow(row)) continue;
            targetColl.add((EvaluGroupTargetInfo)row.getUserObject());
        }
        return targetColl;
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    @Override
    public void secondLoad() throws Exception {
        this.loadData(this.evaluGroupId);
    }

    @Override
    public void verifyInput() throws Exception {
        ArrayList<String> formulaIds = new ArrayList<String>();
        int size = this.tblTarget.getRowCount();
        for (int i = 0; i < size; ++i) {
            FormulaInfo fInfo = (FormulaInfo)this.tblTarget.getCell(i, "calFormula").getValue();
            if (fInfo == null) continue;
            formulaIds.add(fInfo.getId().toString());
        }
        boolean b = AchieveDataHelper.verifyFormulaOnSaveTarget(null, formulaIds, (String)this.getUIContext().get("SolutionPeriodID"));
        if (!b) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.EvaluSolutionResource", (String)"formula_entry_period_error"));
            SysUtil.abort();
        }
        if (this.isAllocateTarget) {
            return;
        }
        try {
            EvaluGroupTargetTypeUI typeUI = (EvaluGroupTargetTypeUI)this.getUIContext().get(EvaluGroupTargetTypeUI.class.getName());
            IRow row = null;
            String typeId = null;
            BigDecimal typeTotalWeight = null;
            int size2 = this.tblTarget.getRowCount();
            for (int i = 0; i < size2; ++i) {
                BigDecimal totalWeight;
                row = this.tblTarget.getRow(i);
                if (this.isTotalRow(row) || (typeId = (String)row.getCell("typeId").getValue()) == null) continue;
                typeTotalWeight = typeUI.getWeightByTypeID(typeId);
                if (typeId == null || (totalWeight = this.getWeightByTypeID(typeId)).compareTo(typeTotalWeight) != 1) continue;
                this.tblTarget.getSelectManager().select(row.getRowIndex(), this.tblTarget.getColumnIndex("weight"));
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.EvaluSolutionResource", (String)"TargetWeightBigThanTypeWeight"));
                SysUtil.abort();
            }
        }
        catch (Exception e) {
            KDTabbedPane tbpMain = (KDTabbedPane)this.getUIContext().get("TBPMainGroup");
            tbpMain.setSelectedIndex(((Integer)this.getUIContext().get("CurrentIndex")).intValue());
            SysUtil.abort();
        }
    }

    public void setFocus() throws Exception {
        IRow row = null;
        int count = this.tblTarget.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblTarget.getRow(i);
            if (this.isTotalRow(row) || row.getCell("weight").getValue() != null) continue;
            this.tblTarget.getEditManager().editCellAt(row.getRowIndex(), this.tblTarget.getColumnIndex("weight"));
            break;
        }
    }

    private BigDecimal getWeightByTypeID(String typeId) {
        IRow row = null;
        String tempTypeId = null;
        BigDecimal weight = new BigDecimal("0");
        int size = this.tblTarget.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblTarget.getRow(i);
            if (this.isTotalRow(row) || (tempTypeId = (String)row.getCell("typeId").getValue()) == null || !tempTypeId.equals(typeId) || row.getCell("weight").getValue() == null) continue;
            weight = weight.add((BigDecimal)row.getCell("weight").getValue());
        }
        return weight;
    }

    @Override
    protected void tblTarget_editStopped(KDTEditEvent e) throws Exception {
        this.initKDTInterviewColumnHeight(this.tblTarget);
        if (this.isAllocateTarget) {
            return;
        }
        if (this.tblTarget.getColumn("weight").getStyleAttributes().isHided()) {
            return;
        }
        int colIndex = e.getColIndex();
        IRow row = this.tblTarget.getRow(e.getRowIndex());
        if (!(row.getCell("weight").getValue() instanceof BigDecimal)) {
            return;
        }
        if (colIndex == this.tblTarget.getColumn("weight").getColumnIndex()) {
            this.calculateTotalWeight();
        }
        EvaluGroupTargetInfo evaluGroupTargetInfo = (EvaluGroupTargetInfo)row.getUserObject();
        evaluGroupTargetInfo.setWeight((BigDecimal)row.getCell("weight").getValue());
    }

    public boolean isDataModified() {
        EvaluGroupTargetCollection evaluGroupTargetCollection = this.getEvaluGroupTargetCollection();
        if (evaluGroupTargetCollection.size() != this.oldEvaluGroupTargetCollection.size()) {
            return true;
        }
        int size = evaluGroupTargetCollection.size();
        for (int i = 0; i < size; ++i) {
            if (ObjectValueUtil.objectValueEquals((AbstractObjectValue)this.oldEvaluGroupTargetCollection.get(i), (AbstractObjectValue)evaluGroupTargetCollection.get(i))) continue;
            return true;
        }
        return false;
    }

    public void updateOldData() throws Exception {
        this.oldEvaluGroupTargetCollection = (EvaluGroupTargetCollection)((Object)this.getEvaluGroupTargetCollection().clone());
    }

    protected void initUserConfig() {
        super.initUserConfig();
    }

    public void onShow() throws Exception {
        super.onShow();
        String spID = (String)this.getUIContext().get("SolutionPeriodID");
        EvaluFormSolutionUIHelper.setTableDisplay(this.tblTarget, spID, true);
        if (this.isAllocateTarget && !DeliverModeEnum.TARGETTEMPLATEMODE.equals(this.getUIContext().get("deliverMode"))) {
            this.tblTarget.getColumn("weight").setWidth(-1);
            this.tblTarget.getColumn("weight").getStyleAttributes().setHided(true);
        } else {
            this.tblTarget.getColumn("weight").setWidth(-1);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        JButton button = null;
        button = this.contEvaluGroupTarget.add((Action)((Object)this.actionMoveUp));
        button.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        button.setText(null);
        button = this.contEvaluGroupTarget.add((Action)((Object)this.actionMoveDown));
        button.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        button.setText(null);
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int from = KDTableUtil.getSelectedRow((KDTable)this.tblTarget).getRowIndex();
        int to = from - 1;
        if (this.canMove(from, to)) {
            this.tblTarget.moveRow(from, to);
            this.tblTarget.getSelectManager().removeAll();
            this.tblTarget.getSelectManager().add(to, 0);
        }
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int from = KDTableUtil.getSelectedRow((KDTable)this.tblTarget).getRowIndex();
        int to = from + 1;
        if (this.canMove(from, to)) {
            this.tblTarget.moveRow(from, to);
            this.tblTarget.getSelectManager().removeAll();
            this.tblTarget.getSelectManager().add(to, 0);
        }
    }

    private boolean canMove(int from, int to) {
        int lastRowIndex = this.tblTarget.getRowCount() - 1;
        if (!(this.isAllocateTarget || from != lastRowIndex && to != lastRowIndex)) {
            return false;
        }
        if (from < 0 || to < 0 || from == to || from > lastRowIndex || to > lastRowIndex) {
            return false;
        }
        IRow fromRow = this.tblTarget.getRow(from);
        IRow toRow = this.tblTarget.getRow(to);
        return fromRow.getCell("typeId").getValue().equals(toRow.getCell("typeId").getValue());
    }

    private void checkSelected() throws Exception {
        if (this.tblTarget.getRowCount() == 0 || this.tblTarget.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private class TargetTypeComparator
    implements Comparator {
        private EvaluGroupTargetTypeCollection coll;

        public TargetTypeComparator(EvaluGroupTargetTypeCollection coll) {
            this.coll = coll;
        }

        public int compare(Object o1, Object o2) {
            String targetTypeId;
            if (!(o1 instanceof EvaluGroupTargetInfo) || !(o2 instanceof EvaluGroupTargetInfo)) {
                return -1;
            }
            EvaluGroupTargetInfo source = (EvaluGroupTargetInfo)o1;
            EvaluGroupTargetInfo target = (EvaluGroupTargetInfo)o2;
            String sourceTypeId = source.getEvaluTarget().getType().getId().toString();
            if (sourceTypeId.equals(targetTypeId = target.getEvaluTarget().getType().getId().toString())) {
                int targetSeq;
                int sourceSeq;
                int value = source.getEvaluTarget().getSeqNumber() - target.getEvaluTarget().getSeqNumber();
                if (value == 0 && (value = (sourceSeq = source.getEvaluTarget().getSeqNumber()) - (targetSeq = target.getEvaluTarget().getSeqNumber())) == 0) {
                    String number1 = source.getEvaluTarget().getNumber();
                    String number2 = target.getEvaluTarget().getNumber();
                    value = number1.compareTo(number2);
                }
                return value;
            }
            EvaluGroupTargetTypeInfo typeInfo = null;
            int src = 0;
            int tar = 0;
            String groupTypeId = null;
            int j = this.coll.size();
            for (int i = 0; i < j; ++i) {
                typeInfo = this.coll.get(i);
                groupTypeId = typeInfo.getPerformTargetType().getId().toString();
                if (groupTypeId.equals(sourceTypeId)) {
                    src = typeInfo.getSeqNumber();
                    continue;
                }
                if (!groupTypeId.equals(targetTypeId)) continue;
                tar = typeInfo.getSeqNumber();
            }
            int result = src - tar;
            if (src - tar == 0) {
                String sourceNum = source.getEvaluTarget().getType().getLongNumber();
                String targetNum = target.getEvaluTarget().getType().getLongNumber();
                result = sourceNum.compareTo(targetNum);
            }
            return result;
        }
    }
}

