/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.EvaluResultAuditBillFactory;
import com.kingdee.eas.hr.perf.EvaluResultAuditBillInfo;
import com.kingdee.eas.hr.perf.client.AbstractEvaluResultAuditReceiverUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class EvaluResultAuditReceiverUI
extends AbstractEvaluResultAuditReceiverUI {
    private static final Logger logger = CoreUIObject.getLogger(EvaluResultAuditReceiverUI.class);
    private EvaluResultAuditBillInfo editData = null;

    public void onLoad() throws Exception {
        super.onLoad();
        EmployeeMultiF7PromptBox personF7 = new EmployeeMultiF7PromptBox((IUIObject)this);
        personF7.setIsSingleSelect(false);
        personF7.showOnlyPayPerson(true);
        this.prmtPerson.setSelector((KDPromptSelector)personF7);
        this.prmtPerson.setEditable(false);
        this.actionCancelOP.setEnabled(true);
        this.loadFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.editData = (EvaluResultAuditBillInfo)this.getUIContext().get("InitDataObject");
        this.prmtPerson.setValue((Object)this.editData.getReceiver());
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtPerson);
        boolean isSynOldValue = this.editData.isSyncOldValue();
        if (!isSynOldValue) {
            this.editData.setSyncOldValue(true);
        }
        this.editData.setReceiver((PersonInfo)this.prmtPerson.getValue());
        if (!isSynOldValue) {
            this.editData.setSyncOldValue(isSynOldValue);
        }
        if (!OprtState.VIEW.equals(this.getOprtState()) && this.editData.getId() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("receiver"));
            EvaluResultAuditBillFactory.getRemoteInstance().updatePartial((CoreBaseInfo)this.editData, sic);
        }
        this.uiWindow.close();
    }

    @Override
    public void actionCancelOP_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelOP_actionPerformed(e);
        this.uiWindow.close();
    }

    @Override
    protected void prmtPerson_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPerson_dataChanged(e);
        PersonInfo personInfo = (PersonInfo)this.prmtPerson.getValue();
        this.loadData(personInfo);
    }

    private void loadData(PersonInfo personInfo) throws EASBizException, BOSException {
        if (personInfo == null) {
            return;
        }
        this.txtNumber.setText(personInfo.getNumber());
        PositionInfo positionInfo = PersonFactory.getRemoteInstance().getPrimaryPosition(personInfo.getId());
        if (positionInfo != null) {
            this.txtPosition.setText(positionInfo.getName());
            this.txtOrgUnit.setText(positionInfo.getAdminOrgUnit().getName());
            this.txtOrgUnit.setToolTipText(positionInfo.getAdminOrgUnit().getDisplayName());
        }
    }
}

