/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.perf.EvaluResultFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.IEvaluResult;
import com.kingdee.eas.hr.perf.IEvaluResultFacade;
import com.kingdee.eas.hr.perf.NDFacadeFactory;
import com.kingdee.eas.hr.perf.NodeProcesserFactory;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.PrecisionMaintainInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.AbstractEvaluResultListUI;
import com.kingdee.eas.hr.perf.client.EvaluResultOrgModifyEditUI;
import com.kingdee.eas.hr.perf.client.EvaluResultQueryUI;
import com.kingdee.eas.hr.perf.client.KDTableUtil;
import com.kingdee.eas.hr.perf.client.NDBaseUI;
import com.kingdee.eas.hr.perf.client.NDCalculatorUI;
import com.kingdee.eas.hr.perf.client.NDCheckUI;
import com.kingdee.eas.hr.perf.client.NodeProcesserInputUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.RankConvertStartUI;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;

public abstract class EvaluResultListUI
extends AbstractEvaluResultListUI {
    private static final long serialVersionUID = -61166L;
    protected static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    protected static final CompareType PERSON = CompareType.EQUALS;
    protected static final CompareType ORGUNIT = CompareType.NOTEQUALS;
    private IEvaluResult iEvaluResult = null;
    private String oldCmpPeriodID = null;
    private CommonQueryDialog queryDlg;

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.isSelectedAudited()) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"auditedLock"));
            return;
        }
        if (this.isSelectedReferenced()) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"referedLock"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        int[] selected = KDTableUtil.getSelectedRows(this.tblMain);
        if (selected.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noItemForAntiAudit"));
            return;
        }
        IRow row = null;
        Arrays.sort(selected);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = selected.length - 1; i >= 0; --i) {
            row = this.tblMain.getRow(selected[i]);
            if (!((Boolean)row.getCell("isApproved").getValue()).booleanValue() || ((Boolean)row.getCell("isReferenced").getValue()).booleanValue()) continue;
            list.add(row.getCell("id").getValue().toString());
        }
        if (list.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noItemSuitebaleForAntiAudit"));
            return;
        }
        String[] idList = new String[list.size()];
        for (int i = 0; i < idList.length; ++i) {
            idList[i] = (String)list.get(i);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)RES, (String)"selectedItems"));
        sb.append(idList.length);
        sb.append(EASResource.getString((String)RES, (String)"antiAuditConfirm"));
        if (MsgBox.showConfirm2((String)sb.toString()) != 0) {
            return;
        }
        IEvaluResultFacade facade = EvaluResultFacadeFactory.getRemoteInstance();
        facade.antiAuditBill(idList);
        this.execQuery();
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"antiAuditSuccess"));
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        int[] selected = KDTableUtil.getSelectedRows(this.tblMain);
        if (selected.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noItemForAudit"));
            return;
        }
        IRow row = null;
        Arrays.sort(selected);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = selected.length - 1; i >= 0; --i) {
            row = this.tblMain.getRow(selected[i]);
            if (((Boolean)row.getCell("isApproved").getValue()).booleanValue()) continue;
            list.add(row.getCell("id").getValue().toString());
        }
        if (list.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noItemSuitebaleForAudit"));
            return;
        }
        String[] idList = new String[list.size()];
        for (int i = 0; i < idList.length; ++i) {
            idList[i] = (String)list.get(i);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)RES, (String)"selectedItems"));
        sb.append(idList.length);
        sb.append(EASResource.getString((String)RES, (String)"auditConfirm"));
        if (MsgBox.showConfirm2((String)sb.toString()) != 0) {
            return;
        }
        IEvaluResultFacade facade = EvaluResultFacadeFactory.getRemoteInstance();
        facade.auditBill(idList);
        this.execQuery();
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"auditSuccess"));
    }

    @Override
    public void actionShow_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selected = KDTableUtil.getSelectedRows(this.tblMain);
        IRow row = null;
        Arrays.sort(selected);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < selected.length; ++i) {
            row = this.tblMain.getRow(selected[i]);
            if (!this.isAudit(row)) {
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"existUnAudit"));
                return;
            }
            if (this.isShow(row)) continue;
            list.add(row.getCell("id").getValue().toString());
        }
        if (list.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"alreadyShow"));
            return;
        }
        String[] idList = new String[list.size()];
        for (int i = 0; i < idList.length; ++i) {
            idList[i] = (String)list.get(i);
        }
        IEvaluResultFacade facade = EvaluResultFacadeFactory.getRemoteInstance();
        facade.showBill(idList);
        this.execQuery();
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"showSuccess"));
    }

    private boolean isAudit(IRow row) {
        return (Boolean)row.getCell("isApproved").getValue();
    }

    private boolean isShow(IRow row) {
        return (Boolean)row.getCell("isShow").getValue();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionQuery.setEnabled(true);
        this.btnQuery.setEnabled(true);
        this.btnQuery.setVisible(true);
        this.menuItemQuery.setEnabled(true);
        this.menuItemQuery.setVisible(true);
        this.tblMain.setColumnMoveable(true);
        this.initButtons();
        this.tblMain.getColumn("cmpPeriod.name").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("cmpPeriod.name").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.getCmpPeriodEditor()));
        this.setSolutionOPeriodF7Filter();
        this.prmptSolutionPeriod.setEditable(false);
    }

    private void setSolutionOPeriodF7Filter() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluSolution.hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        viewInfo.setFilter(filter);
        this.prmptSolutionPeriod.setEntityViewInfo(viewInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("evaluSolution.id"));
        sic.add(new SelectorItemInfo("evaluSolution.name"));
        sic.add(new SelectorItemInfo("evaluSolution.gradeMode.id"));
        sic.add(new SelectorItemInfo("evaluSolution.gradeMode.name"));
        sic.add(new SelectorItemInfo("evaluSolution.gradeMode.maxGrade"));
        sic.add(new SelectorItemInfo("evaluSolution.gradeMode.minGrade"));
        sic.add(new SelectorItemInfo("evaluSolution.keyEvent"));
        sic.add(new SelectorItemInfo("evaluSolution.workflow"));
        sic.add(new SelectorItemInfo("evaluSolution.targetGradeMode"));
        sic.add(new SelectorItemInfo("assessPeriod.id"));
        sic.add(new SelectorItemInfo("assessPeriod.name"));
        sic.add(new SelectorItemInfo("assessPeriod.startDate"));
        sic.add(new SelectorItemInfo("assessPeriod.endDate"));
        sic.add(new SelectorItemInfo("keyEventPeriod.startDate"));
        sic.add(new SelectorItemInfo("keyEventPeriod.endDate"));
        this.prmptSolutionPeriod.setSelectorCollection(sic);
    }

    private void initButtons() {
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnPerfSummary.setIcon(EASResource.getIcon((String)"imgTbtn_subjectsetting"));
        this.btnConvert.setIcon(EASResource.getIcon((String)"imgTbtn_gradeconversion"));
        this.btnRemove.setVisible(false);
        this.btnLocate.setVisible(false);
        this.btnVerdictAllCmpPeriod.setIcon(EASResource.getIcon((String)"imgTbtn_electcopy"));
        this.btnViewNodeProcess.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnEdit.setTextIconDisStyle((short)3);
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_emend"));
        this.btnNDCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_messageexpressionedit"));
        this.btnNDCheck.setIcon(EASResource.getIcon((String)"imgTbtn_advancedsetting"));
        this.menuItemEdit.setIcon(EASResource.getIcon((String)"imgTbtn_emend"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemAnitAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuItemPerfSummary.setIcon(EASResource.getIcon((String)"imgTbtn_subjectsetting"));
        this.menuItemRankConvert.setIcon(EASResource.getIcon((String)"imgTbtn_gradeconversion"));
        this.menuItemCopyColumn.setIcon(EASResource.getIcon((String)"imgTbtn_electcopy"));
        this.menuItemNodeProcess.setIcon(EASResource.getIcon((String)"imgTbtn_seequestionnaire"));
        this.menuItemNDCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_messageexpressionedit"));
        this.menuItemNDCheck.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionNDCheck), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.menuItemNDCheck.setIcon(EASResource.getIcon((String)"imgTbtn_advancedsetting"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnAuditBill.setIcon(EASResource.getIcon((String)"imgTbtn_assistantaccountdetail"));
    }

    protected boolean isSelectedAudited() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        int rowIndex = selectBlock.getTop();
        IRow row = this.tblMain.getRow(rowIndex);
        ICell cell = row.getCell("isApproved");
        if (cell.getValue() == null) {
            return false;
        }
        return (Boolean)cell.getValue();
    }

    protected boolean isSelectedReferenced() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        int rowIndex = selectBlock.getTop();
        IRow row = this.tblMain.getRow(rowIndex);
        ICell cell = row.getCell("isReferenced");
        if (cell.getValue() == null) {
            return false;
        }
        return (Boolean)cell.getValue();
    }

    @Override
    public void actionConvert_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        String id = this.getSelectedSolutionPeriodID();
        if (id == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"sp", (Object)id);
        String[] idList = this.getSelectedIDListForConvert();
        if (idList.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noEvaluResultSutiableForConvert"));
            return;
        }
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)("" + idList.length + EASResource.getString((String)RES, (String)"confirmConvert"))))) {
            return;
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RankConvertStartUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        RankConvertStartUI userUI = (RankConvertStartUI)uiWindow.getUIObject();
        if (!userUI.isCanceled()) {
            IEvaluResultFacade facade = EvaluResultFacadeFactory.getRemoteInstance();
            if (userUI.getScoreType() == 0) {
                facade.convertTotalScoreToRank(this.getSelectedIDListForConvert(), userUI.getSelectedRule().getId());
            } else {
                facade.convertModfiedSocreToRank(this.getSelectedIDListForConvert(), userUI.getSelectedRule().getId());
            }
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"convertSuccessful"));
            this.execQuery();
        }
    }

    private String getSelectedSolutionPeriodID() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("SolutionPeriod.id");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    private String[] getSelectedIDListForConvert() {
        int[] selected = KDTableUtil.getSelectedRows(this.tblMain);
        if (selected.length == 0) {
            return null;
        }
        IRow row = null;
        Arrays.sort(selected);
        ArrayList<String> list = new ArrayList<String>();
        Object obj = null;
        for (int i = selected.length - 1; i >= 0; --i) {
            row = this.tblMain.getRow(selected[i]);
            obj = row.getCell("isApproved").getValue();
            if (obj != null && ((Boolean)obj).booleanValue()) continue;
            list.add(row.getCell("id").getValue().toString());
        }
        String[] idList = new String[list.size()];
        for (int i = 0; i < idList.length; ++i) {
            idList[i] = (String)list.get(i);
        }
        return idList;
    }

    @Override
    protected void prmptSolutionPeriod_dataChanged(DataChangeEvent e) throws Exception {
        SolutionPeriodInfo info = (SolutionPeriodInfo)this.prmptSolutionPeriod.getValue();
        if (info != null) {
            this.txtGradeModeName.setText(info.getEvaluSolution().getGradeMode().getName());
            this.txtGradeFrom.setText(PFVerifyUtils.formatBigDecimal(info.getEvaluSolution().getGradeMode().getMinGrade(), 2));
            this.txtGradeTo.setText(PFVerifyUtils.formatBigDecimal(info.getEvaluSolution().getGradeMode().getMaxGrade(), 2));
            this.txtSolution.setText(info.getEvaluSolution().getName());
            this.txtAssessPeriod.setText(info.getAssessPeriod().getName());
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.txtStartDate.setText(format.format(info.getAssessPeriod().getStartDate()));
            this.txtEndDate.setText(format.format(info.getAssessPeriod().getEndDate()));
        } else {
            this.txtGradeFrom.setText(null);
            this.txtGradeTo.setText(null);
            this.txtGradeModeName.setText(null);
            this.txtSolution.setText(null);
            this.txtAssessPeriod.setText(null);
            this.txtStartDate.setText(null);
            this.txtEndDate.setText(null);
        }
        this.mainQuery = super.getEntityViewInfo(new EntityViewInfo());
        this.execQuery();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        String id = null;
        Object value = this.prmptSolutionPeriod.getValue();
        id = value != null ? ((SolutionPeriodInfo)value).getId().toString() : "%noeas%";
        filter.getFilterItems().add(new FilterItemInfo("SolutionPeriod.id", (Object)id, CompareType.EQUALS));
        filter.getFilterItems().add(PerfUtils.getAdminRangeFilterItemInfo(null, "AdminOrgUnit.id"));
        return filter;
    }

    private KDBizPromptBox getCmpPeriodEditor() throws Exception {
        KDBizPromptBox prmptCmpPeriod = new KDBizPromptBox();
        prmptCmpPeriod.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
        EntityViewInfo entityInfoCmpPeriod = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("enableState", (Object)Boolean.FALSE));
        filterInfo.mergeFilter(PFUtils.getHRFilter(), "and");
        entityInfoCmpPeriod.setFilter(filterInfo);
        prmptCmpPeriod.setEntityViewInfo(entityInfoCmpPeriod);
        prmptCmpPeriod.setDisplayFormat("$name$");
        prmptCmpPeriod.setEditFormat("$number$");
        return prmptCmpPeriod;
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        if (e.getColIndex() == this.tblMain.getColumnIndex("cmpPeriod.name")) {
            if (this.iEvaluResult == null) {
                this.iEvaluResult = EvaluResultFactory.getRemoteInstance();
            }
            String cmpPeriodID = null;
            Object obj = this.tblMain.getCell(e.getRowIndex(), e.getColIndex()).getValue();
            if (obj != null) {
                cmpPeriodID = obj instanceof CmpPeriodInfo ? ((CmpPeriodInfo)obj).getId().toString() : this.oldCmpPeriodID;
            }
            if (cmpPeriodID != null && this.oldCmpPeriodID != null && cmpPeriodID.equals(this.oldCmpPeriodID)) {
                return;
            }
            if (cmpPeriodID == this.oldCmpPeriodID) {
                return;
            }
            this.iEvaluResult.setCmpPeriod(this.getSelectedKeyValue(), cmpPeriodID);
            this.tblMain.getRow(e.getRowIndex()).getCell("cmpPeriod.id").setValue((Object)cmpPeriodID);
        }
    }

    @Override
    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        int colIndex = this.tblMain.getColumnIndex("cmpPeriod.name");
        if (e.getColIndex() == colIndex) {
            Object obj = this.tblMain.getRow(e.getRowIndex()).getCell("cmpPeriod.id").getValue();
            this.oldCmpPeriodID = obj != null ? obj.toString() : null;
        }
    }

    @Override
    public void actionVerdictAllCmpPeriod_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.prmptSolutionPeriod.getValue();
        if (obj == null) {
            return;
        }
        String solutionPeriodID = ((SolutionPeriodInfo)obj).getId().toString();
        String cmpPeriodID = this.getSelectedCmpPeriodID();
        if (this.iEvaluResult == null) {
            this.iEvaluResult = EvaluResultFactory.getRemoteInstance();
        }
        this.iEvaluResult.setAllCmpPeriod(solutionPeriodID, cmpPeriodID);
        this.execQuery();
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"verdictAllCmpPeriodSuccessful"));
    }

    private String getSelectedCmpPeriodID() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("cmpPeriod.id");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    @Override
    public RequestContext prepareActionViewNodeProcess(IItemAction itemAction) throws Exception {
        RequestContext req = super.prepareActionViewNodeProcess(itemAction);
        this.checkSelected();
        String solutionPeriodID = this.getSelectedEvaluSolutionID();
        String evaluObjectID = this.getCurrentEvaluObjectID();
        req.put("solutionPeriodID", (Object)solutionPeriodID);
        req.put("evaluObjectID", (Object)evaluObjectID);
        return req;
    }

    @Override
    public void actionViewNodeProcess_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String solutionPeriodID = this.getSelectedEvaluSolutionID();
        String evaluObjectID = this.getCurrentEvaluObjectID();
        String responserID = this.getCurrentResponserID();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.evaluObject.id", (Object)evaluObjectID));
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.solutionPeriod.id", (Object)solutionPeriodID));
        if (!NodeProcesserFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noNodeProcesser"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriod", (Object)solutionPeriodID);
        uiContext.put((Object)"evaluObject", (Object)evaluObjectID);
        uiContext.put((Object)"evaluPersonId", (Object)responserID);
        uiContext.put((Object)"type", (Object)"nodeProcesser");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(NodeProcesserInputUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getSelectedEvaluSolutionID() {
        if (this.tblMain.getRowCount() <= 0) {
            return null;
        }
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("SolutionPeriod.id");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    protected String getCurrentEvaluObjectID() {
        if (this.tblMain.getRowCount() <= 0) {
            return null;
        }
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("evaluObject.id");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    protected String getCurrentResponserID() {
        if (this.tblMain.getRowCount() <= 0) {
            return null;
        }
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("Person.id");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.queryDlg != null) {
            return this.queryDlg;
        }
        this.queryDlg = new CommonQueryDialog();
        this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
        this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.queryDlg.setQueryObjectPK(this.mainQueryPK);
        this.queryDlg.setShowSorter(false);
        this.queryDlg.setUiObject((IUIObject)this);
        this.queryDlg.setHeight(350);
        this.queryDlg.setWidth(450);
        try {
            EvaluResultQueryUI evaluResultQueryUI = new EvaluResultQueryUI();
            evaluResultQueryUI.setSolutionPeriodType(this.getSolutionType());
            this.queryDlg.addUserPanel((KDPanel)evaluResultQueryUI);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (EvaluResultOrgModifyEditUI.class.getName().equals(this.getEditUIName())) {
            this.queryDlg.setTitle(EASResource.getString((String)RES, (String)"orgEvaluResultQueryTitle"));
        } else {
            this.queryDlg.setTitle(EASResource.getString((String)RES, (String)"personEvaluResultQueryTitle"));
        }
        return this.queryDlg;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    @Override
    public void actionNDCalculate_actionPerformed(ActionEvent e) throws Exception {
        String actionName = EASResource.getString((String)RES, (String)"ndCalculate");
        if (!this.checkNDCondition(actionName) || this.checkResultAudited()) {
            return;
        }
        this.showNDWindow(NDCalculatorUI.class, OprtState.EDIT, actionName);
    }

    @Override
    public void actionNDCheck_actionPerformed(ActionEvent e) throws Exception {
        String actionName = EASResource.getString((String)RES, (String)"ndCheck");
        if (!this.checkNDCondition(actionName) || this.checkResultRankEmpty()) {
            return;
        }
        this.showNDWindow(NDCheckUI.class, OprtState.VIEW, actionName);
    }

    private void showNDWindow(Class uiClass, String state, String actionName) throws BOSException, EASBizException, UIException {
        SolutionPeriodInfo info = (SolutionPeriodInfo)this.prmptSolutionPeriod.getValue();
        String ruleId = NDFacadeFactory.getRemoteInstance().getNDRuleID(info.getId().toString());
        if (ruleId == null) {
            String message = MessageFormat.format(EASResource.getString((String)RES, (String)"solutionPeriodNoMatchRule"), actionName);
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)ruleId);
        uiContext.put((Object)"solutionPeriod", (Object)info);
        uiContext.put((Object)"totalAmount", (Object)new Integer(this.getRowCount()));
        uiContext.put((Object)"queryPk", (Object)this.mainQueryPK);
        uiContext.put((Object)"condition", (Object)this.mainQuery.getFilter());
        uiContext.put((Object)"type", (Object)new Integer(this.getNDType()));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass.getName(), (Map)uiContext, null, state);
        uiWindow.show();
        NDBaseUI uiObject = (NDBaseUI)uiWindow.getUIObject();
        if (!uiObject.isCanceled()) {
            this.execQuery();
        }
    }

    private boolean checkNDCondition(String actionName) throws BOSException {
        boolean result = true;
        int amount = 10;
        int curRowCount = this.getRowCount();
        if (curRowCount <= 0) {
            String message = MessageFormat.format(EASResource.getString((String)RES, (String)"evaluResultIsNull"), actionName);
            MsgBox.showInfo((Component)((Object)this), (String)message);
            result = false;
        } else if (curRowCount < amount) {
            String message = MessageFormat.format((String)this.getResourceMap().get("resultIsLittle"), String.valueOf(amount), actionName);
            MsgBox.showInfo((Component)((Object)this), (String)message);
            result = false;
        }
        return result;
    }

    protected Map getResourceMap() {
        return null;
    }

    private boolean checkResultAudited() throws BOSException {
        boolean result = false;
        result = this.getRowCount() <= 100 ? this.checkResultAuditedByClient() : this.checkResultAuditedByServer();
        if (result) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"resultAudited"));
        }
        return result;
    }

    private boolean checkResultAuditedByServer() throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isApproved", (Object)new Integer(1)));
        return this.hasData(filterInfo);
    }

    private boolean hasData(FilterInfo filterInfo) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.mainQueryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        filterInfo.mergeFilter(this.mainQuery.getFilter(), "AND");
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        exec.setObjectView(viewInfo);
        IRowSet rowSet = exec.executeQuery();
        return rowSet.size() > 0;
    }

    private boolean checkResultAuditedByClient() {
        Object value = null;
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            value = this.tblMain.getRow(i).getCell("isApproved").getValue();
            if (!Boolean.TRUE.equals(value)) continue;
            return true;
        }
        return false;
    }

    private boolean checkResultRankEmpty() throws BOSException {
        boolean result = false;
        result = this.getRowCount() <= 100 ? this.checkResultRankEmptyByClient() : this.checkResultRankEmptyByServer();
        if (result) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"resultRankEmpty"));
        }
        return result;
    }

    private boolean checkResultRankEmptyByServer() throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("perfRank.id", null, CompareType.EQUALS));
        return this.hasData(filterInfo);
    }

    private boolean checkResultRankEmptyByClient() {
        Object value = null;
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            value = this.tblMain.getRow(i).getCell("perfRank.name").getValue();
            if (!TrainCommonUtils.isEmpty((String)((String)value))) continue;
            return true;
        }
        return false;
    }

    protected EvaluSolutionTypeEnum getSolutionType() {
        return EvaluSolutionTypeEnum.PERSON;
    }

    protected abstract int getNDType();

    @Override
    public boolean isPrepareActionViewNodeProcess() {
        return true;
    }

    @Override
    public boolean isPrepareActionQuery() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    protected void handleSumScorePrecesion(Map mapcoll) throws Exception {
        PrecisionMaintainInfo pmInfo;
        EvaluSolutionInfo evaluSolution = null;
        if (this.prmptSolutionPeriod.getValue() != null) {
            evaluSolution = ((SolutionPeriodInfo)this.prmptSolutionPeriod.getValue()).getEvaluSolution();
        }
        if ((pmInfo = PFUtils.getPrecisionMaintainInfo(evaluSolution)) == null) {
            pmInfo = PFUtils.getDefaultPrecisionMaintainInfo();
        }
        Map entry = null;
        BigDecimal sumScore = null;
        Iterator it = mapcoll.keySet().iterator();
        while (it.hasNext()) {
            entry = (Map)mapcoll.get(it.next());
            sumScore = (BigDecimal)entry.get("sumScore");
            if (sumScore == null) continue;
            switch (pmInfo.getTotalPrecisionType().getValue()) {
                case 10: {
                    sumScore = sumScore.setScale(pmInfo.getTotalPrecision(), 4);
                    break;
                }
                case 20: {
                    sumScore = sumScore.setScale(pmInfo.getTotalPrecision(), 0);
                    break;
                }
                case 30: {
                    sumScore = sumScore.setScale(pmInfo.getTotalPrecision(), 1);
                }
            }
            entry.put("sumScore", sumScore);
        }
    }
}

