/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.AssessPeriodInfo;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluResultInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.GradeModeFactory;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.IRank;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.AbstractEvaluResultPersonModifyEditUI;
import com.kingdee.eas.hr.perf.client.KDFormattedTextField1;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class EvaluResultPersonModifyEditUI
extends AbstractEvaluResultPersonModifyEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EvaluResultPersonModifyEditUI.class);
    private BigDecimal maxGrade = null;
    private BigDecimal minGrade = null;
    private boolean isOutGradeMode = false;
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private EvaluResultInfo oldResult = null;
    private KDFormattedTextField1 txtTargetEvaluScore1 = new KDFormattedTextField1();
    private KDFormattedTextField1 txtModifiedScore1 = new KDFormattedTextField1();

    public EvaluResultPersonModifyEditUI() throws Exception {
        this.dataBinder.registerBinding("targetEvaluScore", BigDecimal.class, (Component)((Object)this.txtTargetEvaluScore1), "value");
        this.dataBinder.registerBinding("modifiedScore", BigDecimal.class, (Component)((Object)this.txtModifiedScore1), "value");
    }

    protected IObjectValue createNewData() {
        EvaluResultInfo ret = new EvaluResultInfo();
        return ret;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EvaluResultFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtModifiedScore.setRemoveingZeroInDispaly(false);
        this.txtModifiedScore.setRemoveingZeroInEdit(false);
        this.txtTargetEvaluScore.setRemoveingZeroInDispaly(false);
        this.txtTargetEvaluScore.setVisible(false);
        this.txtTargetEvaluScore1.setEnabled(false);
        this.contTargetEvaluScore.setBoundEditor((JComponent)((Object)this.txtTargetEvaluScore1));
        this.txtModifiedScore.setVisible(false);
        this.contModifiedScore.setBoundEditor((JComponent)((Object)this.txtModifiedScore1));
        this.initPrecision();
    }

    private void setPerfRankComboBox(String groupID) throws Exception {
        IRank iRank = RankFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo("group.id", (Object)groupID, CompareType.EQUALS);
        filter.getFilterItems().add(item);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SorterItemCollection sorter = viewInfo.getSorter();
        SorterItemInfo sorterItem = new SorterItemInfo("serial");
        sorterItem.setSortType(SortType.ASCEND);
        sorter.add(sorterItem);
        CoreBaseCollection coll = iRank.getCollection(viewInfo);
        this.comboModifiedPerfRank.removeAllItems();
        RankInfo rankInfo = new RankInfo();
        rankInfo.setId(null);
        rankInfo.setName(null);
        this.comboModifiedPerfRank.addItem((Object)rankInfo);
        if (coll != null && coll.size() > 0) {
            this.comboModifiedPerfRank.addItems(coll.toArray());
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("solutionPeriod.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.assessPeriod.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.assessPeriod.name"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.name"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.outGradeMode"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.gradeMode.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.gradeMode.name"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.gradeMode.maxGrade"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.gradeMode.minGrade"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.rankGroup.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.rankGroup.name"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.keyEvent"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.targetGradeModeLink"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("perfRank.id"));
        sic.add(new SelectorItemInfo("perfRank.name"));
        sic.add(new SelectorItemInfo("evaluObject.id"));
        sic.add(new SelectorItemInfo("evaluObject.objectID"));
        sic.add(new SelectorItemInfo("evaluObject.name"));
        sic.add(new SelectorItemInfo("evaluObject.number"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("isApproved"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("ranking"));
        return sic;
    }

    private void prepareData() throws Exception {
        SolutionPeriodInfo solutionPeriodInfo = this.editData.getSolutionPeriod();
        EvaluSolutionInfo evaluSolution = solutionPeriodInfo.getEvaluSolution();
        this.maxGrade = evaluSolution.getGradeMode().getMaxGrade();
        this.minGrade = evaluSolution.getGradeMode().getMinGrade();
        this.isOutGradeMode = evaluSolution.isOutGradeMode();
        if (evaluSolution.isKeyEvent()) {
            this.isOutGradeMode = true;
        }
        AssessPeriodInfo assessPeriodInfo = solutionPeriodInfo.getAssessPeriod();
        this.bizPromptAssessPeriod.setValue((Object)assessPeriodInfo);
        this.bizPromtEvaluSolution.setValue((Object)evaluSolution);
        this.setPerfRankComboBox(evaluSolution.getRankGroup().getId().toString());
        GradeModeInfo gradeModeInfo = evaluSolution.getTargetGradeModeLink();
        if (gradeModeInfo != null) {
            gradeModeInfo = (GradeModeInfo)GradeModeFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(gradeModeInfo.getId().toString()));
        }
        this.bizPromptGradeMode.setValue((Object)gradeModeInfo);
        RankInfo rankInfo = this.editData.getPerfRank();
        if (rankInfo != null) {
            int n = this.comboModifiedPerfRank.getItemCount();
            for (int i = 0; i < n; ++i) {
                if (!rankInfo.getId().equals((Object)((RankInfo)this.comboModifiedPerfRank.getItemAt(i)).getId())) continue;
                this.comboModifiedPerfRank.setSelectedIndex(i);
                break;
            }
        } else {
            this.comboModifiedPerfRank.setSelectedItem(null);
        }
        EvaluObjectInfo evaluObject = this.editData.getEvaluObject();
        this.txtPersonNumber.setText(evaluObject.getNumber());
        this.txtPersonName.setText(evaluObject.getName());
        if (this.editData.getPosition() != null) {
            this.txtPersonPosition.setText(this.editData.getPosition().getName());
        }
        this.pkModifyDate.setValue((Object)new Date());
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.prmtModifier.setValue((Object)this.editData.getModifier());
            this.pkModifyDate.setValue((Object)this.editData.getModifyDate());
        } else {
            this.prmtModifier.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
            this.pkModifyDate.setValue((Object)new Date());
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.prepareData();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        if (OprtState.VIEW.equals(this.getOprtState()) || this.isApproved()) {
            this.setUIEnabled(false);
        } else {
            this.setUIEnabled(true);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        BigDecimal grade = this.txtModifiedScore1.getBigDecimalValue();
        if (grade != null && !this.isOutGradeMode) {
            if (grade.compareTo(this.maxGrade) > 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)RES, (String)"tooLarger") + ":" + PFVerifyUtils.formatBigDecimal(this.maxGrade, 2)));
                SysUtil.abort();
            }
            if (grade.compareTo(this.minGrade) < 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)RES, (String)"tooLess") + ":" + PFVerifyUtils.formatBigDecimal(this.minGrade, 2)));
                SysUtil.abort();
            }
        }
        this.editData.setIsModified(true);
    }

    public boolean isModify() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        try {
            this.storeFields();
        }
        catch (Exception exc) {
            return false;
        }
        if (this.oldResult.getModifiedScore() != null && this.editData.getModifiedScore() != null ? this.oldResult.getModifiedScore().compareTo(this.editData.getModifiedScore()) != 0 : this.oldResult.getModifiedScore() != this.editData.getModifiedScore()) {
            return true;
        }
        if (this.oldResult.getPerfRank() != null && this.editData.getPerfRank() != null ? !this.oldResult.getPerfRank().getId().toString().equals(this.editData.getPerfRank().getId().toString()) : this.oldResult.getPerfRank() != this.editData.getPerfRank()) {
            return true;
        }
        return !this.causeEquals(this.oldResult.getModifyCause(), this.editData.getModifyCause());
    }

    protected void initOldData(IObjectValue dataObject) {
        super.initOldData(dataObject);
        this.oldResult = (EvaluResultInfo)((EvaluResultInfo)dataObject).clone();
    }

    private void setUIEnabled(boolean status) {
        this.txtModifiedScore.setEnabled(status);
        this.comboModifiedPerfRank.setEnabled(status);
        this.txtModifiedScore.setEnabled(status);
        this.btnSubmit.setEnabled(status);
    }

    private boolean isApproved() {
        if (this.editData.getId() == null) {
            return false;
        }
        return this.editData.isIsApproved();
    }

    private boolean causeEquals(String str1, String str2) {
        if (str1 != null) {
            return str1.equals(str2);
        }
        return StringUtils.isEmpty((String)str2);
    }

    public IObjectPK runSave() throws Exception {
        Date date = this.editData.getModifyDate();
        if (date != null) {
            date = DateTimeUtils.truncateDate((Date)date);
            this.editData.setModifyDate(date);
        }
        return super.runSave();
    }

    public IObjectPK runSubmit() throws Exception {
        Date date = this.editData.getModifyDate();
        if (date != null) {
            date = DateTimeUtils.truncateDate((Date)date);
            this.editData.setModifyDate(date);
        }
        return super.runSubmit();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    private void initPrecision() throws Exception {
        SolutionPeriodInfo solutionPeriodInfo = this.editData.getSolutionPeriod();
        EvaluSolutionInfo evaluSolution = solutionPeriodInfo.getEvaluSolution();
        PFUtils.setDataPrecision(evaluSolution, (KDFormattedTextField)this.txtTargetEvaluScore1, 3);
        PFUtils.setDataPrecision(evaluSolution, (KDFormattedTextField)this.txtModifiedScore1, 3);
    }
}

