/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.perf.AssessPeriodInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.ISolutionPeriod;
import com.kingdee.eas.hr.perf.SolutionPeriodCollection;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.client.AbstractEvaluResultPersonOrgQueryPanel;
import com.kingdee.eas.hr.perf.client.EvaluSolutionF7Helper;
import com.kingdee.eas.hr.perf.client.FilterUIUtil;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class EvaluResultPersonOrgQueryPanel
extends AbstractEvaluResultPersonOrgQueryPanel {
    private static final Logger logger = CoreUIObject.getLogger(EvaluResultPersonOrgQueryPanel.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.EvaluResultReportResource";
    private static final String AND = " AND ";
    private static final String OR = " OR ";
    HashSet orgSet;

    public EvaluResultPersonOrgQueryPanel() throws Exception {
    }

    public EvaluResultPersonOrgQueryPanel(HashSet orgSet) throws Exception {
        this.orgSet = orgSet;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        this.bizPromptAssessPeriod.setData(null);
        this.bizPromptEvaluSolution.setData(null);
        this.bizPromptOrgUnit.setData(null);
    }

    public CustomerParams getCustomerParams() {
        return FilterUIUtil.saveAllData(this);
    }

    public void setCustomerParams(CustomerParams param) {
        FilterUIUtil.retriveAllData(param, this);
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = this.filterInfo.getFilterItems();
        FilterItemInfo item = null;
        HashSet<String> set = null;
        int index = 0;
        StringBuffer maskString = new StringBuffer();
        if (this.bizPromptAssessPeriod.getValue() != null) {
            item = new FilterItemInfo("AssessPeriod.id", (Object)((AssessPeriodInfo)this.bizPromptAssessPeriod.getValue()).getId().toString(), CompareType.EQUALS);
            itemCollection.add(item);
            PFVerifyUtils.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (this.bizPromptEvaluSolution.getValue() != null) {
            item = new FilterItemInfo("EvaluSolution.id", (Object)((EvaluSolutionInfo)this.bizPromptEvaluSolution.getValue()).getId().toString(), CompareType.EQUALS);
            itemCollection.add(item);
            PFVerifyUtils.makeMaskString(maskString, index, AND);
            ++index;
        }
        set = new HashSet<String>();
        if (this.bizPromptOrgUnit.getValue() != null && ((Object[])this.bizPromptOrgUnit.getValue()).length > 0 && ((Object[])this.bizPromptOrgUnit.getValue())[0] != null) {
            Object[] objs = (Object[])this.bizPromptOrgUnit.getValue();
            int n = objs.length;
            for (int i = 0; i < n; ++i) {
                AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)objs[i];
                set.add(adminInfo.getId().toString());
            }
            if (set.size() > 0) {
                item = new FilterItemInfo("AdminOrgUnit.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
                PFVerifyUtils.makeMaskString(maskString, index, AND);
                ++index;
            }
        }
        if (this.orgSet == null || this.orgSet.size() == 0) {
            item = new FilterItemInfo("AdminOrgUnit.id", (Object)"--------------------------1-1-1-1-1-1-1-1-1-1-1-1", CompareType.EQUALS);
            itemCollection.add(item);
            PFVerifyUtils.makeMaskString(maskString, index, AND);
            ++index;
        } else if (this.orgSet.size() > 0) {
            item = new FilterItemInfo("AdminOrgUnit.id", (Object)this.orgSet, CompareType.INCLUDE);
            itemCollection.add(item);
            PFVerifyUtils.makeMaskString(maskString, index, AND);
            ++index;
        }
        this.filterInfo.setMaskString(maskString.toString());
        return this.filterInfo;
    }

    public void onLoad() throws Exception {
        if (PFVerifyUtils.objectIsNull(SysContext.getSysContext().getCurrentUserInfo().getPerson())) {
            this.showErrorMessage("userNoPerson");
        }
        super.onLoad();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionStatus", (Object)new Integer(101), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionStatus", (Object)new Integer(102), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionType", (Object)new Integer(101), CompareType.EQUALS));
        String sql = "select distinct s.fid from t_pf_evalusolution s inner join t_pf_evaluobject o on o.fevalusolutionid = s.fid";
        sql = sql + " where o.fobjectid in (" + TrainCommonUtils.collectionToStrings((Collection)this.orgSet) + ")";
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        filterInfo.setMaskString("( #0 OR #1 ) AND #2 AND #3 ");
        viewInfo.setFilter(filterInfo);
        this.bizPromptEvaluSolution.setQueryInfo("com.kingdee.eas.hr.perf.app.EvaluSolutionQuery");
        this.bizPromptEvaluSolution.setEntityViewInfo(viewInfo);
        EvaluSolutionF7Helper.initOrgUnit(this.bizPromptOrgUnit, (IUIObject)this);
        this.initialAssessPeriod();
    }

    private void showErrorMessage(String message) {
        String s = EASResource.getString((String)RES, (String)message);
        MsgBox.showError((Component)((Object)this), (String)s);
        SysUtil.abort();
    }

    @Override
    protected void bizPromptEvaluSolution_dataChanged(DataChangeEvent e) throws Exception {
        super.bizPromptEvaluSolution_dataChanged(e);
        Object obj = this.bizPromptEvaluSolution.getValue();
        if (obj != null) {
            EvaluSolutionInfo evaluSolution = (EvaluSolutionInfo)obj;
            this.setAssessPeriodViewInfoByEvaluSolution(evaluSolution);
        } else {
            this.initialAssessPeriod();
        }
    }

    private void setAssessPeriodViewInfoByEvaluSolution(EvaluSolutionInfo evaluSolution) throws BOSException {
        ISolutionPeriod iSolutionPeriod = SolutionPeriodFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)evaluSolution.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaluSolution.id"));
        sic.add(new SelectorItemInfo("assessPeriod.id"));
        SolutionPeriodCollection coll = iSolutionPeriod.getSolutionPeriodCollection(viewInfo);
        HashSet<String> set = new HashSet<String>();
        if (coll != null && coll.size() > 0) {
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                set.add(coll.get(i).getAssessPeriod().getId().toString());
            }
        }
        this.setEntiyViewInfoForAssessPeriod(set);
    }

    private void initialAssessPeriod() throws Exception {
        ISolutionPeriod iSolutionPeriod = SolutionPeriodFactory.getRemoteInstance();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct s.fid from t_pf_evalusolution s inner join t_pf_evaluobject o on o.fevalusolutionid = s.fid");
        sql.append(" where o.fobjectid in (");
        sql.append(TrainCommonUtils.collectionToStrings((Collection)this.orgSet));
        sql.append(")");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)sql.toString(), CompareType.INNER));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaluSolution.id"));
        sic.add(new SelectorItemInfo("assessPeriod.id"));
        SolutionPeriodCollection coll = iSolutionPeriod.getSolutionPeriodCollection(viewInfo);
        HashSet<String> set = new HashSet<String>();
        if (coll != null && coll.size() > 0) {
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                set.add(coll.get(i).getAssessPeriod().getId().toString());
            }
        }
        this.setEntiyViewInfoForAssessPeriod(set);
    }

    private void setEntiyViewInfoForAssessPeriod(HashSet idSet) {
        EntityViewInfo assessViewInfo = new EntityViewInfo();
        FilterInfo assessFilter = new FilterInfo();
        if (idSet.size() > 0) {
            assessFilter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        } else {
            assessFilter.getFilterItems().add(new FilterItemInfo("id", (Object)"%noeas%", CompareType.EQUALS));
        }
        assessViewInfo.setFilter(assessFilter);
        this.bizPromptAssessPeriod.setEntityViewInfo(assessViewInfo);
    }

    public static final class ConditionSearchParam
    implements Serializable {
        public static final String ASSESSPERIOD = "assessPeriod";
        public static final String EVALUSOLUTION = "evaluSolution";
        public static final String ORGUNIT = "orgUnit";
    }
}

