/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.hr.perf.EvaluSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.client.AbstractEvaluSolutionListUI;
import com.kingdee.eas.hr.perf.client.CopySolutionUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionFilterUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.EvaluSolutionUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class EvaluSolutionListUI
extends AbstractEvaluSolutionListUI {
    private static final Logger logger = CoreUIObject.getLogger(EvaluSolutionListUI.class);
    private String resourcePath = "com.kingdee.eas.hr.perf.EvaluSolutionResource";
    private CommonQueryDialog queryDlg;
    private EvaluSolutionFilterUI filterUI;
    private WindowListener listenerForEditWindow = null;

    public void onLoad() throws Exception {
        HROrgUnitInfo currentHROrgUnit = PFUtils.getCurrentHROrgUnit();
        if (currentHROrgUnit == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"NotExistCurrentHROrgUnit"));
            return;
        }
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCloseEvaluSolution.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.menuItemCloseEvaluSolution.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnCopySolution.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.menuItemCopySolution.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected String getEditUIName() {
        return EvaluSolutionUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EvaluSolutionFactory.getRemoteInstance();
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            LinkedHashSet<String> idSet = new LinkedHashSet<String>();
            while (rowSet.next()) {
                idSet.add(rowSet.getString("id"));
            }
            rowSet.beforeFirst();
            Map map = EvaluSolutionFacadeFactory.getRemoteInstance().getAssessPeriodNames(idSet);
            while (rowSet.next()) {
                rowSet.updateString("assessPeriod", (String)map.get(rowSet.getString("id")));
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        try {
            if (this.queryDlg != null) {
                return this.queryDlg;
            }
            this.queryDlg = new CommonQueryDialog();
            this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.queryDlg.setQueryObjectPK(this.mainQueryPK);
            this.queryDlg.setHeight(350);
            this.queryDlg.setWidth(450);
            this.queryDlg.addUserPanel((KDPanel)this.getFilterUI());
            this.queryDlg.setTitle(EASResource.getString((String)this.resourcePath, (String)"EvaluSolutionQuery"));
            this.queryDlg.setShowSorter(false);
            this.queryDlg.setUiObject((IUIObject)this);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return this.queryDlg;
    }

    @Override
    public void actionCloseEvaluSolution_actionPerformed(ActionEvent e) throws Exception {
        if (this.confirmCloseEvaluSolution()) {
            super.actionCloseEvaluSolution_actionPerformed(e);
            PFUtils.checkSelected((Component)((Object)this), this.tblMain);
            int selectedRow = PFUtils.getSelectedRow(this.tblMain);
            BizEnumValueInfo status = (BizEnumValueInfo)this.tblMain.getRow(selectedRow).getCell("solutionStatus").getValue();
            if (status.getInt() == 100 || status.getInt() == 102) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotCloseSolution"));
                SysUtil.abort();
            }
            if (this.checkIfHaveSolutionPeriodOnEvalued()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"HaveSolutionPeriodOnEvalued"));
                SysUtil.abort();
            }
            if (this.checkIfHaveEvaluResultUnChecked()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"HaveEvaluResultUnChecked"));
                SysUtil.abort();
            }
            EvaluSolutionHelper.closeEvaluSolution(this.getSelectedKeyValue());
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CloseSuccess"));
            this.refreshTable(e);
        }
    }

    private boolean checkIfHaveEvaluResultUnChecked() throws Exception {
        String evaluSolutionId = this.getSelectedKeyValue();
        return EvaluSolutionHelper.checkIfHaveEvaluResultUnChecked(evaluSolutionId);
    }

    private boolean confirmCloseEvaluSolution() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmCloseEvaluSolution")));
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        IRow row = this.tblMain.getRow(selectedRow);
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("solutionStatus").getValue();
        if (status.getInt() == 102) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotEditSolution"));
            SysUtil.abort();
        }
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.refreshTable(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void refreshTable(ActionEvent e) throws Exception {
        this.prepareQuery(null).callHandler();
        this.refresh(e);
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        IRow row = this.tblMain.getRow(selectedRow);
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("solutionStatus").getValue();
        if (status.getInt() != 100) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotDelSolution"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    private boolean checkIfHaveSolutionPeriodOnEvalued() throws Exception {
        String evaluSolutionId = this.getSelectedKeyValue();
        return EvaluSolutionHelper.checkIfHaveSolutionPeriodOnEvalued(evaluSolutionId);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"EvaluSolutionType", (Object)EvaluSolutionTypeEnum.PERSON);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshTable(e);
    }

    protected final boolean isRefresh(IUIWindow uiWindow) {
        if (this.getEditUIModal().equals("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory")) {
            return !(uiWindow.getUIObject() instanceof EditUI) || ((EditUI)uiWindow.getUIObject()).isSave();
        }
        Window window = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        if (this.listenerForEditWindow == null) {
            this.listenerForEditWindow = new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent event) {
                    try {
                        if (SysContext.getSysContext().getSessionID() != null) {
                            EvaluSolutionListUI.this.refresh(null);
                        }
                    }
                    catch (Exception e) {
                        EvaluSolutionListUI.this.handleException(e);
                    }
                }
            };
        }
        window.removeWindowListener(this.listenerForEditWindow);
        window.addWindowListener(this.listenerForEditWindow);
        return false;
    }

    @Override
    public void actionCopySolution_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        String id = this.getSelectedKeyValue();
        if (id == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"noSelected"));
            return;
        }
        EvaluSolutionInfo solution = EvaluSolutionFactory.getRemoteInstance().getEvaluSolutionInfo((IObjectPK)new ObjectUuidPK(id));
        if (!solution.getSolutionStatus().equals((Object)SolutionStatusEnum.ONUSED)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"noOnusedConntCopy"));
            return;
        }
        uiContext.put((Object)"ID", (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CopySolutionUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.refreshList();
    }

    public EvaluSolutionFilterUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new EvaluSolutionFilterUI(EvaluSolutionTypeEnum.PERSON);
        }
        return this.filterUI;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return PFUtils.getHRAndAdminRangeFilterInfo("hrOrgUnit.id", "orgUnit.id");
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public boolean isPrepareActionRefresh() {
        return true;
    }

    public boolean isPrepareActionView() {
        return true;
    }
}

